/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmExternalObject;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmValue
implements Iterable<XdmItem> {
    private Sequence value;

    protected XdmValue() {
    }

    public XdmValue(Iterable<? extends XdmItem> items) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem xdmItem : items) {
            values.add((Item)xdmItem.getUnderlyingValue());
        }
        this.value = new SequenceExtent(values);
    }

    public XdmValue(XdmSequenceIterator iterator) throws SaxonApiException {
        try {
            ArrayList<Item> values = new ArrayList<Item>();
            while (iterator.hasNext()) {
                values.add((Item)iterator.next().getUnderlyingValue());
            }
            this.value = new SequenceExtent(values);
        }
        catch (SaxonApiUncheckedException e) {
            throw new SaxonApiException(e.getCause());
        }
    }

    protected XdmValue(Sequence value) {
        this.setValue(value);
    }

    protected void setValue(Sequence value) {
        this.value = value;
    }

    public static XdmValue wrap(Sequence value) {
        GroundedValue gv;
        if (value == null) {
            return XdmEmptySequence.getInstance();
        }
        try {
            gv = SequenceTool.toGroundedValue(value);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
        if (gv.getLength() == 0) {
            return XdmEmptySequence.getInstance();
        }
        if (gv.getLength() == 1) {
            Item first = gv.head();
            if (first instanceof NodeInfo) {
                return new XdmNode((NodeInfo)first);
            }
            if (first instanceof AtomicValue) {
                return new XdmAtomicValue((AtomicValue)first);
            }
            if (first instanceof FunctionItem) {
                return new XdmFunctionItem((FunctionItem)first);
            }
            return new XdmExternalObject(((ObjectValue)first).getObject());
        }
        return new XdmValue(gv);
    }

    public XdmValue append(XdmValue otherValue) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem item : this) {
            values.add((Item)item.getUnderlyingValue());
        }
        for (XdmItem item : otherValue) {
            values.add((Item)item.getUnderlyingValue());
        }
        return new XdmValue(new SequenceExtent(values));
    }

    public int size() {
        try {
            return SequenceTool.getLength(this.value);
        }
        catch (XPathException err) {
            throw new SaxonApiUncheckedException(err);
        }
    }

    public XdmItem itemAt(int n) throws IndexOutOfBoundsException, SaxonApiUncheckedException {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("" + n);
        }
        try {
            Item item = SequenceTool.itemAt(this.value, n);
            return (XdmItem)XdmItem.wrap(item);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public XdmSequenceIterator iterator() throws SaxonApiUncheckedException {
        try {
            Sequence v = this.getUnderlyingValue();
            return new XdmSequenceIterator(v.iterate());
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public Sequence getUnderlyingValue() {
        return this.value;
    }
}

