/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabysk";
        final String metaValue_bo = "Tibetaansk";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebreeuwsk";
        final String metaValue_ja = "Japans";
        final String metaValue_jv = "Javaansk";
        final String metaValue_ka = "Georgysk";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaansk";
        final String metaValue_la = "Latyn";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongools";
        final String metaValue_or = "Odia";
        final String metaValue_sd = "Sindhi";
        final String metaValue_su = "Soendaneesk";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thais";
        final String metaValue_tl = "Tagalog";
        final String metaValue_ban = "Balineesk";
        final String metaValue_bax = "Bamoun";
        final String metaValue_bug = "Bugineesk";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptysk";
        final String metaValue_got = "Gothysk";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_peo = "Aldperzysk";
        final String metaValue_ssy = "Saho";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blissymbolen";
        final Object[][] data = new Object[][] {
            { "ksh", "K\u00f6lsch" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandees" },
            { "Zsym", "Symbolen" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "Tagb", "Tagbanwa" },
            { "%%NJIVA", "Gniva/Njiva-dialekt" },
            { "egy", "Aldegyptysk" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension" },
            { "rar", "Rarotongan" },
            { "tet", "Tetun" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabyske Emiraten" },
            { "nl_BE", "Vlaams" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua en Barbuda" },
            { "type.ca.ethiopic", "Ethiopyske kalinder" },
            { "AI", "Anguilla" },
            { "key.tz", "Tijdzone" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentini\u00eb" },
            { "Prti", "Inscriptioneel Parthysk" },
            { "AS", "Amerikaansk Samoa" },
            { "AT", "Eastenryk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "en_US", "Amerikaansk Ingelsk" },
            { "AX", "\u00c5l\u00e2n" },
            { "mye", "Myene" },
            { "AZ", "Azerbeidzjan" },
            { "%%AREVELA", "East-Armeensk" },
            { "BA", "Bosni\u00eb en Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Koemuks" },
            { "BE", "Belgi\u00eb" },
            { "gmh", "Middelheechd\u00fatsk" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarije" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzja" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibysk Nederl\u00e2n" },
            { "BR", "Brazili\u00eb" },
            { "BS", "Bahama\u2019s" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouveteil\u00e2n" },
            { "BW", "Botswana" },
            { "BY", "Wit-Rusl\u00e2n" },
            { "BZ", "Belize" },
            { "Visp", "Sichtbere spraak" },
            { "type.ca.persian", "Perzyske kalinder" },
            { "type.nu.hebr", "Hebreeuwse sifers" },
            { "CA", "Canada" },
            { "CC", "Kokosilanen" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Sintraal-Afrikaanske Republyk" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Switserl\u00e2n" },
            { "CI", "Ivoorkust" },
            { "CK", "Cookeilannen" },
            { "CL", "Chili" },
            { "Kthi", "Kaithi" },
            { "CM", "Kameroen" },
            { "CN", "Sina" },
            { "CO", "Kolombia" },
            { "CP", "Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kaapverdi\u00eb" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Krysteilan" },
            { "CY", "Syprus" },
            { "type.nu.bali", "Balinese sifers" },
            { "CZ", "Tsjechje" },
            { "eka", "Ekajuk" },
            { "%%RIGIK", "Klassiek Volap\u00fck" },
            { "DE", "D\u00fatsl\u00e2n" },
            { "goh", "Alsheechd\u00fatsk" },
            { "ace", "Atjeesk" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Devanagari sifers" },
            { "DJ", "Djibouti" },
            { "DK", "Denemarken" },
            { "ach", "Akoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Kleine Armeense sifers" },
            { "DO", "Dominikaanske Republyk" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "Meitei" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algerije" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Halve breedte" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta en Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiaments" },
            { "ada", "Adangme" },
            { "EE", "Estl\u00e2n" },
            { "tiv", "Tiv" },
            { "EG", "Egypte" },
            { "EH", "Westelijke Sahara" },
            { "chg", "Chagatai" },
            { "pau", "Palauaansk" },
            { "chk", "Chuukeesk" },
            { "chn", "Chinook-jargon" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopi\u00eb" },
            { "EU", "Europeeske Unie" },
            { "elx", "Elamitysk" },
            { "type.ca.gregorian", "Gregoriaanske kalinder" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Gujarati sifers" },
            { "Inds", "Indus" },
            { "ady", "Adyghe" },
            { "FI", "Finl\u00e2n" },
            { "FJ", "Fiji" },
            { "FK", "Falkl\u00e2neilannen" },
            { "FM", "Micronesi\u00eb" },
            { "key.va", "Landvariant" },
            { "FO", "Faer\u00f6er" },
            { "Taml", metaValue_ta },
            { "FR", "Frankrijk" },
            { "Kpel", metaValue_kpe },
            { "tkl", "Tokelaus" },
            { "grb", "Grebo" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "type.ca.indian", "Indiase natjonale kalinder" },
            { "grc", "Aldgryks" },
            { "GA", "Gabon" },
            { "vot", "Votysk" },
            { "GB", "Verenigd Koninkrijk" },
            { "GD", "Grenada" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Grienl\u00e2n" },
            { "enm", "Middelingelsk" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatoriaal-Guinea" },
            { "GR", "Grikel\u00e2n" },
            { "GS", "S\u00fbd-Georgia en S\u00fbdlike Sandwicheilannen" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinee-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "Nij Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Soran\u00ee" },
            { "zxx", "Gjin lingu\u00efstyske ynh\u00e2ld" },
            { "Jurc", "Jurchen" },
            { "de_AT", "Eastenryks D\u00fatsk" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong SAR van Sina" },
            { "HM", "Heard- en McDonaldeilannen" },
            { "HN", "Honduras" },
            { "HR", "Kroati\u00eb" },
            { "agq", "Aghem" },
            { "gsw", "Switsers D\u00fatsk" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongarije" },
            { "tmh", "Tamashek" },
            { "IC", "Kanaryske Eil\u00e2nnen" },
            { "peo", metaValue_peo },
            { "ID", "Yndonesi\u00eb" },
            { "IE", "Ierl\u00e2n" },
            { "nap", "Napolitaansk" },
            { "%%NDYUKA", "Ndyuka" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Isra\u00ebl" },
            { "Nbat", "Nabateaansk" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Britse Gebieden yn de Indyske Oseaan" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Ysl\u00e2n" },
            { "IT", "Itali\u00eb" },
            { "Zmth", "Wiskundige notatie" },
            { "type.nu.thai", "Thaise sifers" },
            { "%%POSIX", "Computer" },
            { "type.nu.beng", "Bengaalse sifers" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamityske kalinder" },
            { "JM", "Jamaica" },
            { "Beng", "Bengalees" },
            { "JO", "Jordani\u00eb" },
            { "JP", "Japan" },
            { "%%1606NICT", "Let Middelfr\u00e2nske oant 1606" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "Kannada sifers" },
            { "Kali", "Kayah Li" },
            { "de_CH", "Switsersk Heechd\u00fatsk" },
            { "type.co.phonetic", "Fonetyske sortearfolgorde" },
            { "type.ca.buddhist", "Boeddhistyske kalinder" },
            { "KE", "Kenia" },
            { "419", "Latynsk-Amearika" },
            { "KG", "Kirgizi\u00eb" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoren" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts en Nevis" },
            { "Zinh", "Oerge\u00ebrfd" },
            { "fr_CA", "Kanadeesk Fr\u00e2nsk" },
            { "KP", "Noard-Korea" },
            { "KR", "S\u00fbd-Korea" },
            { "Plrd", "Pollard-fonetysk" },
            { "fr_CH", "Switserse Fr\u00e2nsk" },
            { "KW", "Koeweit" },
            { "tpi", "Tok Pisin" },
            { "KY", "Caymaneilannen" },
            { "KZ", "Kazachstan" },
            { "Cyrl", "Syrillysk" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "phn", "Foenisysk" },
            { "Cyrs", "Aldkerkslavysk Syrillysk" },
            { "gwi", "Gwich\u02bcin" },
            { "%%LUNA1918", "Luna1918" },
            { "nds", "Laagduits" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadysk" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "Phlv", "Boek Pahlavi" },
            { "LT", "Litouwen" },
            { "LU", "Luxemburg" },
            { "LV", "Letl\u00e2n" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libi\u00eb" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "%%LAUKIKA", "Laukika" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldavi\u00eb" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "Lamba" },
            { "MG", "Madeiaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshalleilannen" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Vai-sifers" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongoli\u00eb" },
            { "new", "Newari" },
            { "MO", "Macao SAR van Sina" },
            { "MP", "Noardlike Marianeneilannen" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "Mauritius" },
            { "alt", "S\u00fbd-Alta\u00efsk" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Japanske kalinder" },
            { "MY", "Maleisi\u00eb" },
            { "MZ", "Mozambique" },
            { "Phli", "Inscriptioneel Pahlavi" },
            { "NA", "Namibi\u00eb" },
            { "type.ca.hebrew", "Hebreeuwse kalinder" },
            { "type.co.dictionary", "Wurdboeksortearfolgorde" },
            { "NC", "Nij-Caledoni\u00eb" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "%%UCRCOR", "Ienfoarmige stavering (hersjoen)" },
            { "NE", "Niger" },
            { "NF", "Norfolkeil\u00e2n" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Psalmen Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Nederl\u00e2n" },
            { "NO", "Noarwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "Foenicysk" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Nij-Seel\u00e2n" },
            { "Merc", "Meroitysk cursief" },
            { "rom", "Romani" },
            { "Mero", "Mero\u00eftysk" },
            { "crh", "Krim-Tataarsk" },
            { "ang", "\u00e2ldingelsk" },
            { "OM", "Oman" },
            { "%%PETR1708", "Petr1708" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamityske kalinder (cyclysk)" },
            { "csb", "Kasjoebysk" },
            { "en_GB", "Britsk Ingelsk" },
            { "PE", "Peru" },
            { "PF", "Frans-Polynesi\u00eb" },
            { "PG", "Papoea-Nij-Guinea" },
            { "PH", "Filipijnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "Ewondo" },
            { "PM", "Saint-Pierre en Miquelon" },
            { "PN", "Pitcairneilannen" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestynske gebieten" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Kleine Griekse sifers" },
            { "PY", "Paraguay" },
            { "tum", "Toemboeka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Schots standert-Engels" },
            { "niu", "Niueaansk" },
            { "QO", "Oerig Oceani\u00eb" },
            { "lez", "Lezgysk" },
            { "%%FONUPA", "Oeralysk Fonetysk Alfabet" },
            { "tvl", "Tuvaluaansk" },
            { "Tavt", "Tai Viet" },
            { "001", "Wr\u00e2ld" },
            { "002", "Afrika" },
            { "003", "Noard-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00fbd-Amerika" },
            { "jbo", "Lojban" },
            { "Rjng", "Rejang" },
            { "009", "Oceani\u00eb" },
            { "%%SURSILV", "Sursilvan" },
            { "RO", "Roemeni\u00eb" },
            { "RS", "Servi\u00eb" },
            { "Mroo", "Mro" },
            { "RU", "Rusl\u00e2n" },
            { "RW", "Rwanda" },
            { "Mani", "Manicheaansk" },
            { "Ugar", "Ugaritysk" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "pon", "Pohnpeiaansk" },
            { "Mand", "Mandaeans" },
            { "SB", "Salomonseilannen" },
            { "twq", "Tasawaq" },
            { "011", "West-Afrika" },
            { "SC", "Seychellen" },
            { "SD", "Soedan" },
            { "013", "Midden-Amerika" },
            { "SE", "Zweden" },
            { "014", "East-Afrika" },
            { "arc", "Arameesk" },
            { "Loma", "Loma" },
            { "015", "Noard-Afrika" },
            { "SG", "Singapore" },
            { "SH", "Sint-Helena" },
            { "017", "Sintraal-Afrika" },
            { "SI", "Sloveni\u00eb" },
            { "018", "S\u00fbdelijk Afrika" },
            { "SJ", "Spitsbergen en Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Amerika" },
            { "SK", "Slowakije" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali\u00eb" },
            { "arn", "Araukaansk" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Tradisjonele Tamil sifers" },
            { "SR", "Suriname" },
            { "SS", "S\u00fbd-Soedan" },
            { "ST", "Sao Tom\u00e9 en Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Syri\u00eb" },
            { "yao", "Yao" },
            { "SZ", "Swazil\u00e2n" },
            { "arw", "Arawak" },
            { "yap", "Yapees" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "021", "Noardlik Amerika" },
            { "TC", "Turks- en Caicoseilannen" },
            { "yav", "Yangben" },
            { "TD", "Tsjaad" },
            { "TF", "Franse Gebieden in de zuidelijke Indyske Oseaan" },
            { "TG", "Togo" },
            { "TH", "Thail\u00e2n" },
            { "TJ", "Tadzjikistan" },
            { "029", "Karibysk gebiet" },
            { "TK", "Tokelau" },
            { "TL", "East-Timor" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Sykje op earste Hangul-medeklinker" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunesi\u00eb" },
            { "TO", "Tonga" },
            { "%%NULIK", "Modern Volap\u00fck" },
            { "TR", "Turkije" },
            { "TT", "Trinidad en Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturysk" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Ngumba" },
            { "Zzzz", "Onbekend schriftsysteem" },
            { "Sind", metaValue_sd },
            { "UA", "Oekra\u00efne" },
            { "rup", "Aromaniaansk" },
            { "030", "East-Azi\u00eb" },
            { "tyv", "Tuvinysk" },
            { "sw_CD", "Congo Swahili" },
            { "034", "S\u00fbd-Azi\u00eb" },
            { "hai", "Haida" },
            { "035", "S\u00fbdoost-Azi\u00eb" },
            { "UG", "Oeganda" },
            { "type.co.pinyin", "Pinyinvolgorde" },
            { "039", "S\u00fbd-Europa" },
            { "Sinh", "Sinhala" },
            { "UM", "Lyts \u00f4flizzen eilannen fan de Ferienigde Staten" },
            { "US", "Ferienigde Staten" },
            { "haw", "Hawa\u00efaansk" },
            { "%%1959ACAD", "Akademysk" },
            { "type.co.gb2312han", "Ferienf\u00e2ldigde-Sineeske sortearfolgorde - GB2312" },
            { "UY", "Uruguay" },
            { "UZ", "Oezbekistan" },
            { "tzm", "Tamazight (Sintraal-Marokko)" },
            { "type.co.stroke", "Streeksortearfolgorde" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vaticaanst\u00ead" },
            { "pro", "Aldproven\u00e7aals" },
            { "VC", "Saint Vincent en de Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagdeneilannen" },
            { "VI", "Amerikaanske Maagdeneilannen" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Aldnoarsk" },
            { "053", "Australazi\u00eb" },
            { "%%AREVMDA", "West-Armeensk" },
            { "054", "Melanesi\u00eb" },
            { "WF", "Wallis en Futuna" },
            { "type.co.traditional", "Tradisjonele sortearfolgorde" },
            { "057", "Micronesyske regio" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Finansjele sifers" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "wal", "Walamo" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesi\u00eb" },
            { "%%KSCOR", "Standert stavering" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Ongeschreven" },
            { "Olck", "Ol Chiki" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", "N\u2019ko" },
            { "type.co.standard", "standert sortearfolgorde" },
            { "fan", "Fang" },
            { "%%ROZAJ", "Resiaansk" },
            { "%%SUTSILV", "Sutsilvan" },
            { "fat", "Fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00fbd-Afrika" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgyske sifers" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Unbekend gebiet" },
            { "Runr", "Runic" },
            { "lol", "Mongo" },
            { "nso", "Noard-Sotho" },
            { "type.nu.telu", "Telugu sifers" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "jmc", "Machame" },
            { "type.nu.hansfin", "Ferienf\u00e2ldigde Sineeske finansjele sifers" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Utwreide Arabysk-Indyske sifers" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "sifers met volledige breedte" },
            { "hit", "Hettitysk" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Mayahi\u00ebrogliefen" },
            { "Copt", metaValue_cop },
            { "nwc", "Klassiek Newari" },
            { "udm", "Oedmoerts" },
            { "Khmr", metaValue_km },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Romeinske sifers" },
            { "sah", "Jakoets" },
            { "sam", "Samaritaansk-Arameesk" },
            { "%%SCOUSE", "Liverpools (Scouse)" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "jpr", "Judeo-Perzysk" },
            { "type.d0.npinyin", "Numeriek" },
            { "type.nu.native", "Binnenl\u00e2nse sifers" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Aloekoe dialekt" },
            { "lua", "Luba-Lulua" },
            { "%%BISCAYAN", "Biskajaansk" },
            { "type.d0.fwidth", "Volledige breedte" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipynsk" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Lushai" },
            { "bal", "Baloetsjysk" },
            { "den", "Slave" },
            { "ban", metaValue_ban },
            { "uga", "Oegaritysk" },
            { "luy", "Luyia" },
            { "bas", "Basa" },
            { "bax", metaValue_bax },
            { "jrb", "Judeo-Arabysk" },
            { "es_ES", "Europeesk Spaansk" },
            { "nzi", "Nzima" },
            { "sco", "Schots" },
            { "scn", "Siciliaansk" },
            { "aa", "Afar" },
            { "ab", "Abchazysk" },
            { "ae", "Avestysk" },
            { "af", "Afrikaansk" },
            { "ak", "Akan" },
            { "bbj", "Ghomala\u2019" },
            { "am", "Amhaarsk" },
            { "Arab", metaValue_ar },
            { "an", "Aragoneesk" },
            { "%%SOLBA", "Stolvizza/Solbica-dialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana of Hiragana" },
            { "as", "Assameesk" },
            { "Lina", "Lineair A" },
            { "av", "Avarysk" },
            { "Linb", "Lineair B" },
            { "ay", "Aymara" },
            { "az", "Azerbeidzjaansk" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Oseacco/Osojane-dialekt" },
            { "ba", "Basjkiersk" },
            { "type.co.unihan", "Sortearfolgorde radicalen/strepen" },
            { "be", "Wyt-Russysk" },
            { "bg", "Bulgaarsk" },
            { "bi", "Bislama" },
            { "type.nu.java", "Javaanske sifers" },
            { "bm", "Bambara" },
            { "bn", "Bengaalsk" },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Bretonsk" },
            { "bs", "Bosnysk" },
            { "see", "Seneca" },
            { "Mymr", "Myanmar" },
            { "type.nu.laoo", "Laotiaanske sifers" },
            { "seh", "Sena" },
            { "Nkoo", "N\u2019Ko" },
            { "sel", "Selkup" },
            { "ca", "Katalaansk" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Tsjetsjeensk" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Wizige stavering" },
            { "co", "Korsikaansk" },
            { "Orya", metaValue_or },
            { "cr", "Cree" },
            { "cs", "Tsjechysk" },
            { "cu", "Kerkslavysk" },
            { "cv", "Tsjoevasjysk" },
            { "cy", "Welsk" },
            { "type.nu.ethi", "Ethiopyske sifers" },
            { "Yiii", "Yi" },
            { "da", "Deensk" },
            { "pt_PT", "Europees Portugees" },
            { "de", "D\u00fatsk" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Aldyrsk" },
            { "type.nu.mong", "Mongoolse sifers" },
            { "dv", "Divehi" },
            { "es_419", "Latynsk-Amerikaansk Spaansk" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Sineeske kalinder" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Griekse sifers" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "ro_MD", "Moldavysk" },
            { "el", "Gryks" },
            { "en", "Ingelsk" },
            { "eo", "Esperanto" },
            { "type.co.big5han", "Tradisjonele-Sineeske soartear oarder - Big5" },
            { "es", "Spaansk" },
            { "et", "Estl\u00e2nsk" },
            { "eu", "Baskysk" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritaansk" },
            { "shi", "Tashelhiyt" },
            { "hsb", "Oppersorbysk" },
            { "Hani", "Han" },
            { "%%ULSTER", "Ulster" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Perzysk" },
            { "Hans", "Ferienf\u00e2ldigd" },
            { "type.nu.latn", "Westerse sifers" },
            { "Hant", "Traditjoneel" },
            { "ff", "Fulah" },
            { "shu", "Tsjadysk Arabysk" },
            { "fi", "Finsk" },
            { "fj", "Fijysk" },
            { "fon", "Fon" },
            { "yue", "Kantoneesk" },
            { "fo", "Faer\u00f6ersk" },
            { "type.m0.bgn", "BGN" },
            { "umb", "Umbundu" },
            { "fr", "Fr\u00e2nsk" },
            { "sid", "Sidamo" },
            { "fy", "Frysk" },
            { "ga", "Iersk" },
            { "gd", "Schotsk Gaelic" },
            { "gl", "Galisysk" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhojpuri" },
            { "und", "Onbekende taal" },
            { "type.ca.ethiopic-amete-alem", "Ethiopyske Amete Alem-kalinder" },
            { "gu", metaValue_gu },
            { "gv", "Manks" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroatysk" },
            { "ht", "Ha\u00eftiaansk" },
            { "hu", "Hongaarsk" },
            { "hy", "Armeensk" },
            { "hz", "Herero" },
            { "%%FONIPA", "Internationaal Fonetysk Alfabet" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Yndonezysk" },
            { "type.nu.tibt", "Tibetaanske sifers" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "frm", "Middelfr\u00e2nsk" },
            { "%%RUMGR", "Rumgr" },
            { "ik", "Inupiaq" },
            { "fro", "Aldfr\u00e2nsk" },
            { "io", "Ido" },
            { "frs", "East-Frysk" },
            { "frr", "Noard-Frysk" },
            { "is", "Ysl\u00e2ns" },
            { "it", "Italiaansk" },
            { "iu", "Inuktitut" },
            { "%%HOGNORSK", "Hoognoors" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Ald S\u00fbd-Arabysk" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "bkm", "Kom" },
            { "sma", "S\u00fbd-Samysk" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavian" },
            { "%%BAUDDHA", "Bauddha" },
            { "mad", "Madurees" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makassaars" },
            { "sms", "Skolt Sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazachs" },
            { "kl", "Grienl\u00e2ns" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmiri" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", "Avestaansk" },
            { "ku", "Koerdysk" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizysk" },
            { "snk", "Soninke" },
            { "la", metaValue_la },
            { "lb", "Luxemburgs" },
            { "type.nu.mlym", "Malayalam sifers" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgs" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulysk" },
            { "lo", "Laotiaansk" },
            { "lt", "Litouws" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letl\u00e2ns" },
            { "sog", "Sogdysk" },
            { "mg", "Malagasysk" },
            { "mh", "Marshallees" },
            { "type.co.ducet", "Standert Unikoade-sortearfolgorde" },
            { "mi", "Maori" },
            { "mk", "Macedonysk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", "Birmees" },
            { "Saur", "Saurashtra" },
            { "Armn", "Armeens" },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Nedersorbysk" },
            { "Armi", "Keizerlijk Aramees" },
            { "na", "Nauruaansk" },
            { "type.co.search", "Algemien sykje" },
            { "nb", "Noors - Bokm\u00e5l" },
            { "nd", "Noard-Ndbele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Nederl\u00e2nsk" },
            { "nn", "Noors - Nynorsk" },
            { "no", "Noors" },
            { "nr", "S\u00fbd-Ndbele" },
            { "nv", "Navajo" },
            { "kaa", "Karakalpaks" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "%%POLYTON", "Polytonaal" },
            { "oc", "Occitaansk" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Vroegmodern Engels" },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "type.nu.armn", "Armeense sifers" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "or", metaValue_or },
            { "os", "Ossetysk" },
            { "%%ALALC97", "Romanisering ALA-LC, editie 1997" },
            { "kbd", "Kabardysk" },
            { "mfe", "Morisyen" },
            { "srn", "Sranantongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Het Lipovaz-dialekt van het Resiaansk" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "pl", "Poalsk" },
            { "dum", "Middelnederl\u00e2nsk" },
            { "%%VALLADER", "Vallader" },
            { "ps", "Pasjtoe" },
            { "pt", "Portugeesk" },
            { "mga", "Middeliers" },
            { "key.co", "Sortearfolgorde" },
            { "pt_BR", "Brazyljaansk Portugees" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "bra", "Braj" },
            { "key.ca", "Kalender" },
            { "%%JAUER", "Jauer" },
            { "Laoo", "Lao" },
            { "%%SURMIRAN", "Surmiran" },
            { "mgo", "Meta\u2019" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "Myanmarese sifers" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "%%VAIDIKA", "Vaidika" },
            { "Ethi", "Ethiopysk" },
            { "%%JYUTPING", "Jyutping" },
            { "rm", "Reto-Romaansk" },
            { "rn", "Kirundi" },
            { "key.cu", "Valuta" },
            { "ro", "Roemeensk" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Oriya sifers" },
            { "type.nu.hanidec", "Sineeske desimale tallen" },
            { "ru", "Russysk" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kaapverdysk Creools" },
            { "mic", "Mi\u2019kmaq" },
            { "suk", "Sukuma" },
            { "en_AU", "Australysk Ingelsk" },
            { "Dupl", "Duployan snelschrift" },
            { "sa", "Sanskriet" },
            { "%%UCCOR", "Ienfoarmige stavering" },
            { "sc", "Sardinysk" },
            { "sus", "Soesoe" },
            { "sd", metaValue_sd },
            { "se", "Noard-Samysk" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Servokroatysk" },
            { "si", "Singalees" },
            { "sux", "Soemerysk" },
            { "sk", "Slowaaks" },
            { "sl", "Sloveensk" },
            { "Gran", "Grantha" },
            { "sm", "Samoaansk" },
            { "sn", "Shona" },
            { "so", "Somalysk" },
            { "type.nu.arab", "Arabysk-Indyske sifers" },
            { "sq", "Albaneesk" },
            { "sr", "Servysk" },
            { "ss", "Swazi" },
            { "Java", metaValue_jv },
            { "st", "S\u00fbd-Sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-dialekt" },
            { "sv", "Zweeds" },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Traditjonele Sineeske finansjele sifers" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Azi\u00eb" },
            { "bua", "Buriat" },
            { "143", "Sintraal-Azi\u00eb" },
            { "te", metaValue_te },
            { "145", "West-Azi\u00eb" },
            { "tg", "Tadzjieks" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "en_CA", "Kanadeesk Ingelsk" },
            { "tk", "Turkmeens" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaansk" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Japanske sifers" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "swb", "Shimaore" },
            { "Cakm", "Chakma" },
            { "tt", "Tataars" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahitysk" },
            { "%%BISKE", "San Giorgio/Bila-dialekt" },
            { "150", "Europa" },
            { "151", "East-Europa" },
            { "154", "Noard-Europa" },
            { "dzg", "Dazaga" },
            { "155", "West-Europa" },
            { "ug", "Oeigoers" },
            { "Kore", metaValue_ko },
            { "Ital", "Ald-italysk" },
            { "Zyyy", "Algemeen" },
            { "uk", "Oekra\u00efens" },
            { "type.ca.coptic", "Koptyske kalinder" },
            { "ur", "Urdu" },
            { "%%1994", "Standerdisearre Resiaansk stavering" },
            { "xal", "Kalmyk" },
            { "zen", "Zenaga" },
            { "uz", "Oezbeeks" },
            { "kha", "Khasi" },
            { "%%1996", "D\u00fatske stavering van 1996" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Kalinder fan de Sineeske Republyk" },
            { "vi", "Vietnamees" },
            { "kho", "Khotaneesk" },
            { "khq", "Koyra Chiini" },
            { "%%TARASK", "Taraskievica-stavering" },
            { "vo", "Volap\u00fck" },
            { "syc", "Klassiek Syrysk" },
            { "Osma", "Osmanya" },
            { "gaa", "Ga" },
            { "wa", "Waals" },
            { "syr", "Syrysk" },
            { "Grek", "Grieks" },
            { "Lydi", "Lydysk" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "wo", "Wolof" },
            { "zgh", "Standert Marokkaanske Tamazight" },
            { "ar_001", "Modern standert Arabysk" },
            { "Cans", "Verenigde Canadese Aboriginal-symbolen" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Mantsjoe" },
            { "Latf", "Gotysk Latyn" },
            { "Hluw", "Anatolyske hi\u00ebrogliefen" },
            { "gba", "Gbaya" },
            { "mni", "Manipoeri" },
            { "Latn", metaValue_la },
            { "Latg", "Gaelysk Latyn" },
            { "type.nu.hans", "Ferienf\u00e2ldigde Sineeske sifers" },
            { "type.nu.hant", "Traditjonele Sineeske sifers" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Lytse Romeinske sifers" },
            { "byn", "Blin" },
            { "%%PAMAKA", "Pamaka" },
            { "Lyci", "Lycysk" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Betiit modern Fr\u00e2ns" },
            { "yi", "Jiddysk" },
            { "mos", "Mossi" },
            { "Syrc", "Syriac" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Tradisjonele sifers" },
            { "es_MX", "Meksikaansk Spaansk" },
            { "Syrj", "West-Arameesk" },
            { "ota", "Ottomaansk-Turks" },
            { "Syre", "Estrangelo Arameesk" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Karysk" },
            { "kln", "Kalenjin" },
            { "zh", "Sineesk" },
            { "Afak", "Defaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Aldpermysk" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Telefoanboeksortearfolgorde" },
            { "%%MONOTON", "Monotonaal" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Japanske finansjele sifers" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "Syrn", "East-Arameesk" },
            { "Narb", "Ald Noard-Arabysk" },
            { "type.co.reformed", "Hersjoen sortearfolgorde" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egyptysk demotysk" },
            { "Egyh", "Egyptysk hi\u00ebratysk" },
            { "%%ITIHASA", "Itihasa" },
            { "Palm", "Palmyreens" },
            { "ebu", "Embu" },
            { "Egyp", "Egyptyske hi\u00ebrogliefen" },
            { "Geok", "Georgysk Khutsuri" },
            { "zh_Hans", "Ferienf\u00e2ldich Sineesk" },
            { "Hung", "Aldhongaars" },
            { "kok", "Konkani" },
            { "%%1901", "Tradisjonele D\u00fatske stavering" },
            { "kos", "Kosraeaansk" },
            { "zh_Hant", "Tradisjoneel Sineesk" },
            { "Sund", metaValue_su },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "Khmer sifers" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valenciaansk" },
            { "Cprt", "Syprysk" },
            { "%%BAKU1926", "Eenvormig Turkse Latynse alfabet" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi sifers" },
            { "mul", "Meardere talen" },
            { "%%PUTER", "Puter" },
            { "cad", "Kaddo" },
            { "mus", "Creek" },
            { "Glag", "Glagolitysk" },
            { "gil", "Gilberteesk" },
            { "%%KKCOR", "Algemiene stavering" },
            { "Cher", metaValue_chr },
            { "car", "Karibysk" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Tamil sifers" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingoesj" },
            { "krl", "Karelysk" },
            { "efi", "Efik" },
            { "key.nu", "Sifers" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
