// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package searchads360 provides access to the Search Ads 360 Reporting API.
//
// For product documentation, see: https://developers.google.com/search-ads/reporting
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/searchads360/v0"
//	...
//	ctx := context.Background()
//	searchads360Service, err := searchads360.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	searchads360Service, err := searchads360.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	searchads360Service, err := searchads360.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package searchads360 // import "google.golang.org/api/searchads360/v0"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "searchads360:v0"
const apiName = "searchads360"
const apiVersion = "v0"
const basePath = "https://searchads360.googleapis.com/"
const mtlsBasePath = "https://searchads360.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your advertising data in DoubleClick Search
	DoubleclicksearchScope = "https://www.googleapis.com/auth/doubleclicksearch"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/doubleclicksearch",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Customers = NewCustomersService(s)
	s.SearchAds360Fields = NewSearchAds360FieldsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService

	SearchAds360Fields *SearchAds360FieldsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.CustomColumns = NewCustomersCustomColumnsService(s)
	rs.SearchAds360 = NewCustomersSearchAds360Service(s)
	return rs
}

type CustomersService struct {
	s *Service

	CustomColumns *CustomersCustomColumnsService

	SearchAds360 *CustomersSearchAds360Service
}

func NewCustomersCustomColumnsService(s *Service) *CustomersCustomColumnsService {
	rs := &CustomersCustomColumnsService{s: s}
	return rs
}

type CustomersCustomColumnsService struct {
	s *Service
}

func NewCustomersSearchAds360Service(s *Service) *CustomersSearchAds360Service {
	rs := &CustomersSearchAds360Service{s: s}
	return rs
}

type CustomersSearchAds360Service struct {
	s *Service
}

func NewSearchAds360FieldsService(s *Service) *SearchAds360FieldsService {
	rs := &SearchAds360FieldsService{s: s}
	return rs
}

type SearchAds360FieldsService struct {
	s *Service
}

// GoogleAdsSearchads360V0Common__AdScheduleInfo: Represents an
// AdSchedule criterion. AdSchedule is specified as the day of the week
// and a time interval within which ads will be shown. No more than six
// AdSchedules can be added for the same day.
type GoogleAdsSearchads360V0Common__AdScheduleInfo struct {
	// DayOfWeek: Day of the week the schedule applies to. This field is
	// required for CREATE operations and is prohibited on UPDATE
	// operations.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "MONDAY" - Monday.
	//   "TUESDAY" - Tuesday.
	//   "WEDNESDAY" - Wednesday.
	//   "THURSDAY" - Thursday.
	//   "FRIDAY" - Friday.
	//   "SATURDAY" - Saturday.
	//   "SUNDAY" - Sunday.
	DayOfWeek string `json:"dayOfWeek,omitempty"`

	// EndHour: Ending hour in 24 hour time; 24 signifies end of the day.
	// This field must be between 0 and 24, inclusive. This field is
	// required for CREATE operations and is prohibited on UPDATE
	// operations.
	EndHour int64 `json:"endHour,omitempty"`

	// EndMinute: Minutes after the end hour at which this schedule ends.
	// The schedule is exclusive of the end minute. This field is required
	// for CREATE operations and is prohibited on UPDATE operations.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "ZERO" - Zero minutes past the hour.
	//   "FIFTEEN" - Fifteen minutes past the hour.
	//   "THIRTY" - Thirty minutes past the hour.
	//   "FORTY_FIVE" - Forty-five minutes past the hour.
	EndMinute string `json:"endMinute,omitempty"`

	// StartHour: Starting hour in 24 hour time. This field must be between
	// 0 and 23, inclusive. This field is required for CREATE operations and
	// is prohibited on UPDATE operations.
	StartHour int64 `json:"startHour,omitempty"`

	// StartMinute: Minutes after the start hour at which this schedule
	// starts. This field is required for CREATE operations and is
	// prohibited on UPDATE operations.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "ZERO" - Zero minutes past the hour.
	//   "FIFTEEN" - Fifteen minutes past the hour.
	//   "THIRTY" - Thirty minutes past the hour.
	//   "FORTY_FIVE" - Forty-five minutes past the hour.
	StartMinute string `json:"startMinute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DayOfWeek") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DayOfWeek") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__AdScheduleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__AdScheduleInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__AgeRangeInfo: An age range criterion.
type GoogleAdsSearchads360V0Common__AgeRangeInfo struct {
	// Type: Type of the age range.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "AGE_RANGE_18_24" - Between 18 and 24 years old.
	//   "AGE_RANGE_25_34" - Between 25 and 34 years old.
	//   "AGE_RANGE_35_44" - Between 35 and 44 years old.
	//   "AGE_RANGE_45_54" - Between 45 and 54 years old.
	//   "AGE_RANGE_55_64" - Between 55 and 64 years old.
	//   "AGE_RANGE_65_UP" - 65 years old and beyond.
	//   "AGE_RANGE_UNDETERMINED" - Undetermined age range.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__AgeRangeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__AgeRangeInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__AssetInteractionTarget: An
// AssetInteractionTarget segment.
type GoogleAdsSearchads360V0Common__AssetInteractionTarget struct {
	// Asset: The asset resource name.
	Asset string `json:"asset,omitempty"`

	// InteractionOnThisAsset: Only used with CustomerAsset, CampaignAsset
	// and AdGroupAsset metrics. Indicates whether the interaction metrics
	// occurred on the asset itself or a different asset or ad unit.
	InteractionOnThisAsset bool `json:"interactionOnThisAsset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__AssetInteractionTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__AssetInteractionTarget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__AssetUsage: Contains the usage
// information of the asset.
type GoogleAdsSearchads360V0Common__AssetUsage struct {
	// Asset: Resource name of the asset.
	Asset string `json:"asset,omitempty"`

	// ServedAssetFieldType: The served field type of the asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "HEADLINE_1" - The asset is used in headline 1.
	//   "HEADLINE_2" - The asset is used in headline 2.
	//   "HEADLINE_3" - The asset is used in headline 3.
	//   "DESCRIPTION_1" - The asset is used in description 1.
	//   "DESCRIPTION_2" - The asset is used in description 2.
	//   "HEADLINE" - The asset was used in a headline. Use this only if
	// there is only one headline in the ad. Otherwise, use the HEADLINE_1,
	// HEADLINE_2 or HEADLINE_3 enums
	//   "HEADLINE_IN_PORTRAIT" - The asset was used as a headline in
	// portrait image.
	//   "LONG_HEADLINE" - The asset was used in a long headline (used in
	// MultiAssetResponsiveAd).
	//   "DESCRIPTION" - The asset was used in a description. Use this only
	// if there is only one description in the ad. Otherwise, use the
	// DESCRIPTION_1 or DESCRIPTION_@ enums
	//   "DESCRIPTION_IN_PORTRAIT" - The asset was used as description in
	// portrait image.
	//   "BUSINESS_NAME_IN_PORTRAIT" - The asset was used as business name
	// in portrait image.
	//   "BUSINESS_NAME" - The asset was used as business name.
	//   "MARKETING_IMAGE" - The asset was used as a marketing image.
	//   "MARKETING_IMAGE_IN_PORTRAIT" - The asset was used as a marketing
	// image in portrait image.
	//   "SQUARE_MARKETING_IMAGE" - The asset was used as a square marketing
	// image.
	//   "PORTRAIT_MARKETING_IMAGE" - The asset was used as a portrait
	// marketing image.
	//   "LOGO" - The asset was used as a logo.
	//   "LANDSCAPE_LOGO" - The asset was used as a landscape logo.
	//   "CALL_TO_ACTION" - The asset was used as a call-to-action.
	//   "YOU_TUBE_VIDEO" - The asset was used as a YouTube video.
	//   "SITELINK" - This asset is used as a sitelink.
	//   "CALL" - This asset is used as a call.
	//   "MOBILE_APP" - This asset is used as a mobile app.
	//   "CALLOUT" - This asset is used as a callout.
	//   "STRUCTURED_SNIPPET" - This asset is used as a structured snippet.
	//   "PRICE" - This asset is used as a price.
	//   "PROMOTION" - This asset is used as a promotion.
	//   "AD_IMAGE" - This asset is used as an image.
	//   "LEAD_FORM" - The asset is used as a lead form.
	//   "BUSINESS_LOGO" - The asset is used as a business logo.
	ServedAssetFieldType string `json:"servedAssetFieldType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__AssetUsage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__AssetUsage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__AudienceInfo: An audience criterion.
type GoogleAdsSearchads360V0Common__AudienceInfo struct {
	// Audience: The Audience resource name.
	Audience string `json:"audience,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audience") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audience") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__AudienceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__AudienceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__BusinessProfileLocation: Business
// Profile location data synced from the linked Business Profile
// account.
type GoogleAdsSearchads360V0Common__BusinessProfileLocation struct {
	// Labels: Advertiser specified label for the location on the Business
	// Profile account. This is synced from the Business Profile account.
	Labels []string `json:"labels,omitempty"`

	// ListingId: Listing ID of this Business Profile location. This is
	// synced from the linked Business Profile account.
	ListingId int64 `json:"listingId,omitempty,string"`

	// StoreCode: Business Profile store code of this location. This is
	// synced from the Business Profile account.
	StoreCode string `json:"storeCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Labels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__BusinessProfileLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__BusinessProfileLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__CallToActionAsset: A call to action
// asset.
type GoogleAdsSearchads360V0Common__CallToActionAsset struct {
	// CallToAction: Call to action.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "LEARN_MORE" - The call to action type is learn more.
	//   "GET_QUOTE" - The call to action type is get quote.
	//   "APPLY_NOW" - The call to action type is apply now.
	//   "SIGN_UP" - The call to action type is sign up.
	//   "CONTACT_US" - The call to action type is contact us.
	//   "SUBSCRIBE" - The call to action type is subscribe.
	//   "DOWNLOAD" - The call to action type is download.
	//   "BOOK_NOW" - The call to action type is book now.
	//   "SHOP_NOW" - The call to action type is shop now.
	//   "BUY_NOW" - The call to action type is buy now.
	//   "DONATE_NOW" - The call to action type is donate now.
	//   "ORDER_NOW" - The call to action type is order now.
	//   "PLAY_NOW" - The call to action type is play now.
	//   "SEE_MORE" - The call to action type is see more.
	//   "START_NOW" - The call to action type is start now.
	//   "VISIT_SITE" - The call to action type is visit site.
	//   "WATCH_NOW" - The call to action type is watch now.
	CallToAction string `json:"callToAction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallToAction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallToAction") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__CallToActionAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__CallToActionAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__CustomParameter: A mapping that can be
// used by custom parameter tags in a `tracking_url_template`,
// `final_urls`, or `mobile_final_urls`.
type GoogleAdsSearchads360V0Common__CustomParameter struct {
	// Key: The key matching the parameter tag name.
	Key string `json:"key,omitempty"`

	// Value: The value to be substituted.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__CustomParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__CustomParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__DeviceInfo: A device criterion.
type GoogleAdsSearchads360V0Common__DeviceInfo struct {
	// Type: Type of the device.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "MOBILE" - Mobile devices with full browsers.
	//   "TABLET" - Tablets with full browsers.
	//   "DESKTOP" - Computers.
	//   "CONNECTED_TV" - Smart TVs and game consoles.
	//   "OTHER" - Other device types.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__DeviceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__DeviceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__EnhancedCpc: An automated bidding
// strategy that raises bids for clicks that seem more likely to lead to
// a conversion and lowers them for clicks where they seem less likely.
// This bidding strategy is deprecated and cannot be created anymore.
// Use ManualCpc with enhanced_cpc_enabled set to true for equivalent
// functionality.
type GoogleAdsSearchads360V0Common__EnhancedCpc struct {
}

// GoogleAdsSearchads360V0Common__FrequencyCapEntry: A rule specifying
// the maximum number of times an ad (or some set of ads) can be shown
// to a user over a particular time period.
type GoogleAdsSearchads360V0Common__FrequencyCapEntry struct {
}

// GoogleAdsSearchads360V0Common__GenderInfo: A gender criterion.
type GoogleAdsSearchads360V0Common__GenderInfo struct {
	// Type: Type of the gender.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "MALE" - Male.
	//   "FEMALE" - Female.
	//   "UNDETERMINED" - Undetermined gender.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__GenderInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__GenderInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__ImageAsset: An Image asset.
type GoogleAdsSearchads360V0Common__ImageAsset struct {
	// FileSize: File size of the image asset in bytes.
	FileSize int64 `json:"fileSize,omitempty,string"`

	// FullSize: Metadata for this image at its original size.
	FullSize *GoogleAdsSearchads360V0Common__ImageDimension `json:"fullSize,omitempty"`

	// MimeType: MIME type of the image asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - The mime type has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "IMAGE_JPEG" - MIME type of image/jpeg.
	//   "IMAGE_GIF" - MIME type of image/gif.
	//   "IMAGE_PNG" - MIME type of image/png.
	//   "FLASH" - MIME type of application/x-shockwave-flash.
	//   "TEXT_HTML" - MIME type of text/html.
	//   "PDF" - MIME type of application/pdf.
	//   "MSWORD" - MIME type of application/msword.
	//   "MSEXCEL" - MIME type of application/vnd.ms-excel.
	//   "RTF" - MIME type of application/rtf.
	//   "AUDIO_WAV" - MIME type of audio/wav.
	//   "AUDIO_MP3" - MIME type of audio/mp3.
	//   "HTML5_AD_ZIP" - MIME type of application/x-html5-ad-zip.
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__ImageAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__ImageAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__ImageDimension: Metadata for an image
// at a certain size, either original or resized.
type GoogleAdsSearchads360V0Common__ImageDimension struct {
	// HeightPixels: Height of the image.
	HeightPixels int64 `json:"heightPixels,omitempty,string"`

	// Url: A URL that returns the image with this height and width.
	Url string `json:"url,omitempty"`

	// WidthPixels: Width of the image.
	WidthPixels int64 `json:"widthPixels,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "HeightPixels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeightPixels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__ImageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__ImageDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__Keyword: A Keyword criterion segment.
type GoogleAdsSearchads360V0Common__Keyword struct {
	// AdGroupCriterion: The AdGroupCriterion resource name.
	AdGroupCriterion string `json:"adGroupCriterion,omitempty"`

	// Info: Keyword info.
	Info *GoogleAdsSearchads360V0Common__KeywordInfo `json:"info,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroupCriterion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroupCriterion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__Keyword) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__Keyword
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__KeywordInfo: A keyword criterion.
type GoogleAdsSearchads360V0Common__KeywordInfo struct {
	// MatchType: The match type of the keyword.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "EXACT" - Exact match.
	//   "PHRASE" - Phrase match.
	//   "BROAD" - Broad match.
	MatchType string `json:"matchType,omitempty"`

	// Text: The text of the keyword (at most 80 characters and 10 words).
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__KeywordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__KeywordInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__LanguageInfo: A language criterion.
type GoogleAdsSearchads360V0Common__LanguageInfo struct {
	// LanguageConstant: The language constant resource name.
	LanguageConstant string `json:"languageConstant,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageConstant") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageConstant") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__LanguageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__ListingGroupInfo: A listing group
// criterion.
type GoogleAdsSearchads360V0Common__ListingGroupInfo struct {
	// Type: Type of the listing group.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "SUBDIVISION" - Subdivision of products along some listing
	// dimension. These nodes are not used by serving to target listing
	// entries, but is purely to define the structure of the tree.
	//   "UNIT" - Listing group unit that defines a bid.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__ListingGroupInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__ListingGroupInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__LocationGroupInfo: A radius around a
// list of locations specified through a feed.
type GoogleAdsSearchads360V0Common__LocationGroupInfo struct {
	// FeedItemSets: FeedItemSets whose FeedItems are targeted. If multiple
	// IDs are specified, then all items that appear in at least one set are
	// targeted. This field cannot be used with geo_target_constants. This
	// is optional and can only be set in CREATE operations.
	FeedItemSets []string `json:"feedItemSets,omitempty"`

	// GeoTargetConstants: Geo target constant(s) restricting the scope of
	// the geographic area within the feed. Currently only one geo target
	// constant is allowed.
	GeoTargetConstants []string `json:"geoTargetConstants,omitempty"`

	// Radius: Distance in units specifying the radius around targeted
	// locations. This is required and must be set in CREATE operations.
	Radius int64 `json:"radius,omitempty,string"`

	// RadiusUnits: Unit of the radius. Miles and meters are supported for
	// geo target constants. Milli miles and meters are supported for feed
	// item sets. This is required and must be set in CREATE operations.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "METERS" - Meters
	//   "MILES" - Miles
	//   "MILLI_MILES" - Milli Miles
	RadiusUnits string `json:"radiusUnits,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FeedItemSets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FeedItemSets") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__LocationGroupInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__LocationGroupInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__LocationInfo: A location criterion.
type GoogleAdsSearchads360V0Common__LocationInfo struct {
	// GeoTargetConstant: The geo target constant resource name.
	GeoTargetConstant string `json:"geoTargetConstant,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GeoTargetConstant")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GeoTargetConstant") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__LocationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__LocationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__ManualCpa: Manual bidding strategy
// that allows advertiser to set the bid per advertiser-specified
// action.
type GoogleAdsSearchads360V0Common__ManualCpa struct {
}

// GoogleAdsSearchads360V0Common__ManualCpc: Manual click-based bidding
// where user pays per click.
type GoogleAdsSearchads360V0Common__ManualCpc struct {
	// EnhancedCpcEnabled: Whether bids are to be enhanced based on
	// conversion optimizer data.
	EnhancedCpcEnabled bool `json:"enhancedCpcEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnhancedCpcEnabled")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnhancedCpcEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__ManualCpc) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__ManualCpc
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__ManualCpm: Manual impression-based
// bidding where user pays per thousand impressions.
type GoogleAdsSearchads360V0Common__ManualCpm struct {
}

// GoogleAdsSearchads360V0Common__MaximizeConversionValue: An automated
// bidding strategy to help get the most conversion value for your
// campaigns while spending your budget.
type GoogleAdsSearchads360V0Common__MaximizeConversionValue struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// Mutable for portfolio bidding strategies only.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// CpcBidFloorMicros: Minimum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// Mutable for portfolio bidding strategies only.
	CpcBidFloorMicros int64 `json:"cpcBidFloorMicros,omitempty,string"`

	// TargetRoas: The target return on ad spend (ROAS) option. If set, the
	// bid strategy will maximize revenue while averaging the target return
	// on ad spend. If the target ROAS is high, the bid strategy may not be
	// able to spend the full budget. If the target ROAS is not set, the bid
	// strategy will aim to achieve the highest possible ROAS for the
	// budget.
	TargetRoas float64 `json:"targetRoas,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__MaximizeConversionValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__MaximizeConversionValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Common__MaximizeConversionValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Common__MaximizeConversionValue
	var s1 struct {
		TargetRoas gensupport.JSONFloat64 `json:"targetRoas"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetRoas = float64(s1.TargetRoas)
	return nil
}

// GoogleAdsSearchads360V0Common__MaximizeConversions: An automated
// bidding strategy to help get the most conversions for your campaigns
// while spending your budget.
type GoogleAdsSearchads360V0Common__MaximizeConversions struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// Mutable for portfolio bidding strategies only.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// CpcBidFloorMicros: Minimum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// Mutable for portfolio bidding strategies only.
	CpcBidFloorMicros int64 `json:"cpcBidFloorMicros,omitempty,string"`

	// TargetCpaMicros: The target cost-per-action (CPA) option. This is the
	// average amount that you would like to spend per conversion action
	// specified in micro units of the bidding strategy's currency. If set,
	// the bid strategy will get as many conversions as possible at or below
	// the target cost-per-action. If the target CPA is not set, the bid
	// strategy will aim to achieve the lowest possible CPA given the
	// budget.
	TargetCpaMicros int64 `json:"targetCpaMicros,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__MaximizeConversions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__MaximizeConversions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__Metrics: Metrics data.
type GoogleAdsSearchads360V0Common__Metrics struct {
	// AbsoluteTopImpressionPercentage: The percent of your ad impressions
	// that are shown as the very first ad above the organic search results.
	AbsoluteTopImpressionPercentage float64 `json:"absoluteTopImpressionPercentage,omitempty"`

	// AllConversions: The total number of conversions. This includes all
	// conversions regardless of the value of include_in_conversions_metric.
	AllConversions float64 `json:"allConversions,omitempty"`

	// AllConversionsByConversionDate: The total number of conversions. This
	// includes all conversions regardless of the value of
	// include_in_conversions_metric. When this column is selected with
	// date, the values in date column means the conversion date. Details
	// for the by_conversion_date columns are available at
	// https://support.google.com/sa360/answer/9250611.
	AllConversionsByConversionDate float64 `json:"allConversionsByConversionDate,omitempty"`

	// AllConversionsFromClickToCall: The number of times people clicked the
	// "Call" button to call a store during or after clicking an ad. This
	// number doesn't include whether or not calls were connected, or the
	// duration of any calls. This metric applies to feed items only.
	AllConversionsFromClickToCall float64 `json:"allConversionsFromClickToCall,omitempty"`

	// AllConversionsFromDirections: The number of times people clicked a
	// "Get directions" button to navigate to a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromDirections float64 `json:"allConversionsFromDirections,omitempty"`

	// AllConversionsFromInteractionsRate: All conversions from interactions
	// (as oppose to view through conversions) divided by the number of ad
	// interactions.
	AllConversionsFromInteractionsRate float64 `json:"allConversionsFromInteractionsRate,omitempty"`

	// AllConversionsFromInteractionsValuePerInteraction: The value of all
	// conversions from interactions divided by the total number of
	// interactions.
	AllConversionsFromInteractionsValuePerInteraction float64 `json:"allConversionsFromInteractionsValuePerInteraction,omitempty"`

	// AllConversionsFromMenu: The number of times people clicked a link to
	// view a store's menu after clicking an ad. This metric applies to feed
	// items only.
	AllConversionsFromMenu float64 `json:"allConversionsFromMenu,omitempty"`

	// AllConversionsFromOrder: The number of times people placed an order
	// at a store after clicking an ad. This metric applies to feed items
	// only.
	AllConversionsFromOrder float64 `json:"allConversionsFromOrder,omitempty"`

	// AllConversionsFromOtherEngagement: The number of other conversions
	// (for example, posting a review or saving a location for a store) that
	// occurred after people clicked an ad. This metric applies to feed
	// items only.
	AllConversionsFromOtherEngagement float64 `json:"allConversionsFromOtherEngagement,omitempty"`

	// AllConversionsFromStoreVisit: Estimated number of times people
	// visited a store after clicking an ad. This metric applies to feed
	// items only.
	AllConversionsFromStoreVisit float64 `json:"allConversionsFromStoreVisit,omitempty"`

	// AllConversionsFromStoreWebsite: The number of times that people were
	// taken to a store's URL after clicking an ad. This metric applies to
	// feed items only.
	AllConversionsFromStoreWebsite float64 `json:"allConversionsFromStoreWebsite,omitempty"`

	// AllConversionsValue: The value of all conversions.
	AllConversionsValue float64 `json:"allConversionsValue,omitempty"`

	// AllConversionsValueByConversionDate: The value of all conversions.
	// When this column is selected with date, the values in date column
	// means the conversion date. Details for the by_conversion_date columns
	// are available at https://support.google.com/sa360/answer/9250611.
	AllConversionsValueByConversionDate float64 `json:"allConversionsValueByConversionDate,omitempty"`

	// AllConversionsValuePerCost: The value of all conversions divided by
	// the total cost of ad interactions (such as clicks for text ads or
	// views for video ads).
	AllConversionsValuePerCost float64 `json:"allConversionsValuePerCost,omitempty"`

	// AverageCost: The average amount you pay per interaction. This amount
	// is the total cost of your ads divided by the total number of
	// interactions.
	AverageCost float64 `json:"averageCost,omitempty"`

	// AverageCpc: The total cost of all clicks divided by the total number
	// of clicks received. This metric is a monetary value and returned in
	// the customer's currency by default. See the metrics_currency
	// parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	AverageCpc float64 `json:"averageCpc,omitempty"`

	// AverageCpm: Average cost-per-thousand impressions (CPM). This metric
	// is a monetary value and returned in the customer's currency by
	// default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	AverageCpm float64 `json:"averageCpm,omitempty"`

	// Clicks: The number of clicks.
	Clicks int64 `json:"clicks,omitempty,string"`

	// ClientAccountConversions: The number of client account conversions.
	// This only includes conversion actions which
	// include_in_client_account_conversions_metric attribute is set to
	// true. If you use conversion-based bidding, your bid strategies will
	// optimize for these conversions.
	ClientAccountConversions float64 `json:"clientAccountConversions,omitempty"`

	// ClientAccountConversionsValue: The value of client account
	// conversions. This only includes conversion actions which
	// include_in_client_account_conversions_metric attribute is set to
	// true. If you use conversion-based bidding, your bid strategies will
	// optimize for these conversions.
	ClientAccountConversionsValue float64 `json:"clientAccountConversionsValue,omitempty"`

	// ClientAccountCrossSellCostOfGoodsSoldMicros: Client account
	// cross-sell cost of goods sold (COGS) is the total cost of products
	// sold as a result of advertising a different product. How it works:
	// You report conversions with cart data for completed purchases on your
	// website. If the ad that was interacted with before the purchase has
	// an associated product (see Shopping Ads) then this product is
	// considered the advertised product. Any product included in the order
	// the customer places is a sold product. If these products don't match
	// then this is considered cross-sell. Cross-sell cost of goods sold is
	// the total cost of the products sold that weren't advertised. Example:
	// Someone clicked on a Shopping ad for a hat then bought the same hat
	// and a shirt. The hat has a cost of goods sold value of $3, the shirt
	// has a cost of goods sold value of $5. The cross-sell cost of goods
	// sold for this order is $5. This metric is only available if you
	// report conversions with cart data. This metric is a monetary value
	// and returned in the customer's currency by default. See the
	// metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	ClientAccountCrossSellCostOfGoodsSoldMicros int64 `json:"clientAccountCrossSellCostOfGoodsSoldMicros,omitempty,string"`

	// ClientAccountCrossSellGrossProfitMicros: Client account cross-sell
	// gross profit is the profit you made from products sold as a result of
	// advertising a different product, minus cost of goods sold (COGS). How
	// it works: You report conversions with cart data for completed
	// purchases on your website. If the ad that was interacted with before
	// the purchase has an associated product (see Shopping Ads) then this
	// product is considered the advertised product. Any product included in
	// the purchase is a sold product. If these products don't match then
	// this is considered cross-sell. Cross-sell gross profit is the revenue
	// you made from cross-sell attributed to your ads minus the cost of the
	// goods sold. Example: Someone clicked on a Shopping ad for a hat then
	// bought the same hat and a shirt. The shirt is priced $20 and has a
	// cost of goods sold value of $5. The cross-sell gross profit of this
	// order is $15 = $20 - $5. This metric is only available if you report
	// conversions with cart data. This metric is a monetary value and
	// returned in the customer's currency by default. See the
	// metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	ClientAccountCrossSellGrossProfitMicros int64 `json:"clientAccountCrossSellGrossProfitMicros,omitempty,string"`

	// ClientAccountCrossSellRevenueMicros: Client account cross-sell
	// revenue is the total amount you made from products sold as a result
	// of advertising a different product. How it works: You report
	// conversions with cart data for completed purchases on your website.
	// If the ad that was interacted with before the purchase has an
	// associated product (see Shopping Ads) then this product is considered
	// the advertised product. Any product included in the order the
	// customer places is a sold product. If these products don't match then
	// this is considered cross-sell. Cross-sell revenue is the total value
	// you made from cross-sell attributed to your ads. Example: Someone
	// clicked on a Shopping ad for a hat then bought the same hat and a
	// shirt. The hat is priced $10 and the shirt is priced $20. The
	// cross-sell revenue of this order is $20. This metric is only
	// available if you report conversions with cart data. This metric is a
	// monetary value and returned in the customer's currency by default.
	// See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	ClientAccountCrossSellRevenueMicros int64 `json:"clientAccountCrossSellRevenueMicros,omitempty,string"`

	// ClientAccountCrossSellUnitsSold: Client account cross-sell units sold
	// is the total number of products sold as a result of advertising a
	// different product. How it works: You report conversions with cart
	// data for completed purchases on your website. If the ad that was
	// interacted with before the purchase has an associated product (see
	// Shopping Ads) then this product is considered the advertised product.
	// Any product included in the order the customer places is a sold
	// product. If these products don't match then this is considered
	// cross-sell. Cross-sell units sold is the total number of cross-sold
	// products from all orders attributed to your ads. Example: Someone
	// clicked on a Shopping ad for a hat then bought the same hat, a shirt
	// and a jacket. The cross-sell units sold in this order is 2. This
	// metric is only available if you report conversions with cart data.
	ClientAccountCrossSellUnitsSold float64 `json:"clientAccountCrossSellUnitsSold,omitempty"`

	// ClientAccountLeadCostOfGoodsSoldMicros: Client account lead cost of
	// goods sold (COGS) is the total cost of products sold as a result of
	// advertising the same product. How it works: You report conversions
	// with cart data for completed purchases on your website. If the ad
	// that was interacted with has an associated product (see Shopping Ads)
	// then this product is considered the advertised product. Any product
	// included in the order the customer places is a sold product. If the
	// advertised and sold products match, then the cost of these goods is
	// counted under lead cost of goods sold. Example: Someone clicked on a
	// Shopping ad for a hat then bought the same hat and a shirt. The hat
	// has a cost of goods sold value of $3, the shirt has a cost of goods
	// sold value of $5. The lead cost of goods sold for this order is $3.
	// This metric is only available if you report conversions with cart
	// data. This metric is a monetary value and returned in the customer's
	// currency by default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	ClientAccountLeadCostOfGoodsSoldMicros int64 `json:"clientAccountLeadCostOfGoodsSoldMicros,omitempty,string"`

	// ClientAccountLeadGrossProfitMicros: Client account lead gross profit
	// is the profit you made from products sold as a result of advertising
	// the same product, minus cost of goods sold (COGS). How it works: You
	// report conversions with cart data for completed purchases on your
	// website. If the ad that was interacted with before the purchase has
	// an associated product (see Shopping Ads) then this product is
	// considered the advertised product. Any product included in the order
	// the customer places is a sold product. If the advertised and sold
	// products match, then the revenue you made from these sales minus the
	// cost of goods sold is your lead gross profit. Example: Someone
	// clicked on a Shopping ad for a hat then bought the same hat and a
	// shirt. The hat is priced $10 and has a cost of goods sold value of
	// $3. The lead gross profit of this order is $7 = $10 - $3. This metric
	// is only available if you report conversions with cart data. This
	// metric is a monetary value and returned in the customer's currency by
	// default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	ClientAccountLeadGrossProfitMicros int64 `json:"clientAccountLeadGrossProfitMicros,omitempty,string"`

	// ClientAccountLeadRevenueMicros: Client account lead revenue is the
	// total amount you made from products sold as a result of advertising
	// the same product. How it works: You report conversions with cart data
	// for completed purchases on your website. If the ad that was
	// interacted with before the purchase has an associated product (see
	// Shopping Ads) then this product is considered the advertised product.
	// Any product included in the order the customer places is a sold
	// product. If the advertised and sold products match, then the total
	// value you made from the sales of these products is shown under lead
	// revenue. Example: Someone clicked on a Shopping ad for a hat then
	// bought the same hat and a shirt. The hat is priced $10 and the shirt
	// is priced $20. The lead revenue of this order is $10. This metric is
	// only available if you report conversions with cart data. This metric
	// is a monetary value and returned in the customer's currency by
	// default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	ClientAccountLeadRevenueMicros int64 `json:"clientAccountLeadRevenueMicros,omitempty,string"`

	// ClientAccountLeadUnitsSold: Client account lead units sold is the
	// total number of products sold as a result of advertising the same
	// product. How it works: You report conversions with cart data for
	// completed purchases on your website. If the ad that was interacted
	// with before the purchase has an associated product (see Shopping Ads)
	// then this product is considered the advertised product. Any product
	// included in the order the customer places is a sold product. If the
	// advertised and sold products match, then the total number of these
	// products sold is shown under lead units sold. Example: Someone
	// clicked on a Shopping ad for a hat then bought the same hat, a shirt
	// and a jacket. The lead units sold in this order is 1. This metric is
	// only available if you report conversions with cart data.
	ClientAccountLeadUnitsSold float64 `json:"clientAccountLeadUnitsSold,omitempty"`

	// ClientAccountViewThroughConversions: The total number of view-through
	// conversions. These happen when a customer sees an image or rich media
	// ad, then later completes a conversion on your site without
	// interacting with (for example, clicking on) another ad.
	ClientAccountViewThroughConversions int64 `json:"clientAccountViewThroughConversions,omitempty,string"`

	// ContentBudgetLostImpressionShare: The estimated percent of times that
	// your ad was eligible to show on the Display Network but didn't
	// because your budget was too low. Note: Content budget lost impression
	// share is reported in the range of 0 to 0.9. Any value above 0.9 is
	// reported as 0.9001.
	ContentBudgetLostImpressionShare float64 `json:"contentBudgetLostImpressionShare,omitempty"`

	// ContentImpressionShare: The impressions you've received on the
	// Display Network divided by the estimated number of impressions you
	// were eligible to receive. Note: Content impression share is reported
	// in the range of 0.1 to 1. Any value below 0.1 is reported as 0.0999.
	ContentImpressionShare float64 `json:"contentImpressionShare,omitempty"`

	// ContentRankLostImpressionShare: The estimated percentage of
	// impressions on the Display Network that your ads didn't receive due
	// to poor Ad Rank. Note: Content rank lost impression share is reported
	// in the range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentRankLostImpressionShare float64 `json:"contentRankLostImpressionShare,omitempty"`

	// Conversions: The number of conversions. This only includes conversion
	// actions which include_in_conversions_metric attribute is set to true.
	// If you use conversion-based bidding, your bid strategies will
	// optimize for these conversions.
	Conversions float64 `json:"conversions,omitempty"`

	// ConversionsByConversionDate: The sum of conversions by conversion
	// date for biddable conversion types. Can be fractional due to
	// attribution modeling. When this column is selected with date, the
	// values in date column means the conversion date.
	ConversionsByConversionDate float64 `json:"conversionsByConversionDate,omitempty"`

	// ConversionsFromInteractionsRate: Average biddable conversions (from
	// interaction) per conversion eligible interaction. Shows how often, on
	// average, an ad interaction leads to a biddable conversion.
	ConversionsFromInteractionsRate float64 `json:"conversionsFromInteractionsRate,omitempty"`

	// ConversionsFromInteractionsValuePerInteraction: The value of
	// conversions from interactions divided by the number of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true. If you use
	// conversion-based bidding, your bid strategies will optimize for these
	// conversions.
	ConversionsFromInteractionsValuePerInteraction float64 `json:"conversionsFromInteractionsValuePerInteraction,omitempty"`

	// ConversionsValue: The sum of conversion values for the conversions
	// included in the "conversions" field. This metric is useful only if
	// you entered a value for your conversion actions.
	ConversionsValue float64 `json:"conversionsValue,omitempty"`

	// ConversionsValueByConversionDate: The sum of biddable conversions
	// value by conversion date. When this column is selected with date, the
	// values in date column means the conversion date.
	ConversionsValueByConversionDate float64 `json:"conversionsValueByConversionDate,omitempty"`

	// ConversionsValuePerCost: The value of biddable conversion divided by
	// the total cost of conversion eligible interactions.
	ConversionsValuePerCost float64 `json:"conversionsValuePerCost,omitempty"`

	// CostMicros: The sum of your cost-per-click (CPC) and
	// cost-per-thousand impressions (CPM) costs during this period. This
	// metric is a monetary value and returned in the customer's currency by
	// default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	CostMicros int64 `json:"costMicros,omitempty,string"`

	// CostPerAllConversions: The cost of ad interactions divided by all
	// conversions.
	CostPerAllConversions float64 `json:"costPerAllConversions,omitempty"`

	// CostPerConversion: Average conversion eligible cost per biddable
	// conversion.
	CostPerConversion float64 `json:"costPerConversion,omitempty"`

	// CostPerCurrentModelAttributedConversion: The cost of ad interactions
	// divided by current model attributed conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is
	// set to true. If you use conversion-based bidding, your bid strategies
	// will optimize for these conversions.
	CostPerCurrentModelAttributedConversion float64 `json:"costPerCurrentModelAttributedConversion,omitempty"`

	// CrossDeviceConversions: Conversions from when a customer clicks on an
	// ad on one device, then converts on a different device or browser.
	// Cross-device conversions are already included in all_conversions.
	CrossDeviceConversions float64 `json:"crossDeviceConversions,omitempty"`

	// CrossDeviceConversionsValue: The sum of the value of cross-device
	// conversions.
	CrossDeviceConversionsValue float64 `json:"crossDeviceConversionsValue,omitempty"`

	// CrossSellCostOfGoodsSoldMicros: Cross-sell cost of goods sold (COGS)
	// is the total cost of products sold as a result of advertising a
	// different product. How it works: You report conversions with cart
	// data for completed purchases on your website. If the ad that was
	// interacted with before the purchase has an associated product (see
	// Shopping Ads) then this product is considered the advertised product.
	// Any product included in the order the customer places is a sold
	// product. If these products don't match then this is considered
	// cross-sell. Cross-sell cost of goods sold is the total cost of the
	// products sold that weren't advertised. Example: Someone clicked on a
	// Shopping ad for a hat then bought the same hat and a shirt. The hat
	// has a cost of goods sold value of $3, the shirt has a cost of goods
	// sold value of $5. The cross-sell cost of goods sold for this order is
	// $5. This metric is only available if you report conversions with cart
	// data. This metric is a monetary value and returned in the customer's
	// currency by default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	CrossSellCostOfGoodsSoldMicros int64 `json:"crossSellCostOfGoodsSoldMicros,omitempty,string"`

	// CrossSellGrossProfitMicros: Cross-sell gross profit is the profit you
	// made from products sold as a result of advertising a different
	// product, minus cost of goods sold (COGS). How it works: You report
	// conversions with cart data for completed purchases on your website.
	// If the ad that was interacted with before the purchase has an
	// associated product (see Shopping Ads) then this product is considered
	// the advertised product. Any product included in the purchase is a
	// sold product. If these products don't match then this is considered
	// cross-sell. Cross-sell gross profit is the revenue you made from
	// cross-sell attributed to your ads minus the cost of the goods sold.
	// Example: Someone clicked on a Shopping ad for a hat then bought the
	// same hat and a shirt. The shirt is priced $20 and has a cost of goods
	// sold value of $5. The cross-sell gross profit of this order is $15 =
	// $20 - $5. This metric is only available if you report conversions
	// with cart data. This metric is a monetary value and returned in the
	// customer's currency by default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	CrossSellGrossProfitMicros int64 `json:"crossSellGrossProfitMicros,omitempty,string"`

	// CrossSellRevenueMicros: Cross-sell revenue is the total amount you
	// made from products sold as a result of advertising a different
	// product. How it works: You report conversions with cart data for
	// completed purchases on your website. If the ad that was interacted
	// with before the purchase has an associated product (see Shopping Ads)
	// then this product is considered the advertised product. Any product
	// included in the order the customer places is a sold product. If these
	// products don't match then this is considered cross-sell. Cross-sell
	// revenue is the total value you made from cross-sell attributed to
	// your ads. Example: Someone clicked on a Shopping ad for a hat then
	// bought the same hat and a shirt. The hat is priced $10 and the shirt
	// is priced $20. The cross-sell revenue of this order is $20. This
	// metric is only available if you report conversions with cart data.
	// This metric is a monetary value and returned in the customer's
	// currency by default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	CrossSellRevenueMicros int64 `json:"crossSellRevenueMicros,omitempty,string"`

	// CrossSellUnitsSold: Cross-sell units sold is the total number of
	// products sold as a result of advertising a different product. How it
	// works: You report conversions with cart data for completed purchases
	// on your website. If the ad that was interacted with before the
	// purchase has an associated product (see Shopping Ads) then this
	// product is considered the advertised product. Any product included in
	// the order the customer places is a sold product. If these products
	// don't match then this is considered cross-sell. Cross-sell units sold
	// is the total number of cross-sold products from all orders attributed
	// to your ads. Example: Someone clicked on a Shopping ad for a hat then
	// bought the same hat, a shirt and a jacket. The cross-sell units sold
	// in this order is 2. This metric is only available if you report
	// conversions with cart data.
	CrossSellUnitsSold float64 `json:"crossSellUnitsSold,omitempty"`

	// Ctr: The number of clicks your ad receives (Clicks) divided by the
	// number of times your ad is shown (Impressions).
	Ctr float64 `json:"ctr,omitempty"`

	// HistoricalCreativeQualityScore: The creative historical quality
	// score.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "BELOW_AVERAGE" - Quality of the creative is below average.
	//   "AVERAGE" - Quality of the creative is average.
	//   "ABOVE_AVERAGE" - Quality of the creative is above average.
	HistoricalCreativeQualityScore string `json:"historicalCreativeQualityScore,omitempty"`

	// HistoricalLandingPageQualityScore: The quality of historical landing
	// page experience.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "BELOW_AVERAGE" - Quality of the creative is below average.
	//   "AVERAGE" - Quality of the creative is average.
	//   "ABOVE_AVERAGE" - Quality of the creative is above average.
	HistoricalLandingPageQualityScore string `json:"historicalLandingPageQualityScore,omitempty"`

	// HistoricalQualityScore: The historical quality score.
	HistoricalQualityScore int64 `json:"historicalQualityScore,omitempty,string"`

	// HistoricalSearchPredictedCtr: The historical search predicted click
	// through rate (CTR).
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "BELOW_AVERAGE" - Quality of the creative is below average.
	//   "AVERAGE" - Quality of the creative is average.
	//   "ABOVE_AVERAGE" - Quality of the creative is above average.
	HistoricalSearchPredictedCtr string `json:"historicalSearchPredictedCtr,omitempty"`

	// Impressions: Count of how often your ad has appeared on a search
	// results page or website on the Google Network.
	Impressions int64 `json:"impressions,omitempty,string"`

	// InteractionEventTypes: The types of payable and free interactions.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "CLICK" - Click to site. In most cases, this interaction navigates
	// to an external location, usually the advertiser's landing page. This
	// is also the default InteractionEventType for click events.
	//   "ENGAGEMENT" - The user's expressed intent to engage with the ad
	// in-place.
	//   "VIDEO_VIEW" - User viewed a video ad.
	//   "NONE" - The default InteractionEventType for ad conversion events.
	// This is used when an ad conversion row does NOT indicate that the
	// free interactions (for example, the ad conversions) should be
	// 'promoted' and reported as part of the core metrics. These are simply
	// other (ad) conversions.
	InteractionEventTypes []string `json:"interactionEventTypes,omitempty"`

	// InteractionRate: How often people interact with your ad after it is
	// shown to them. This is the number of interactions divided by the
	// number of times your ad is shown.
	InteractionRate float64 `json:"interactionRate,omitempty"`

	// Interactions: The number of interactions. An interaction is the main
	// user action associated with an ad format-clicks for text and shopping
	// ads, views for video ads, and so on.
	Interactions int64 `json:"interactions,omitempty,string"`

	// InvalidClickRate: The percentage of clicks filtered out of your total
	// number of clicks (filtered + non-filtered clicks) during the
	// reporting period.
	InvalidClickRate float64 `json:"invalidClickRate,omitempty"`

	// InvalidClicks: Number of clicks Google considers illegitimate and
	// doesn't charge you for.
	InvalidClicks int64 `json:"invalidClicks,omitempty,string"`

	// LeadCostOfGoodsSoldMicros: Lead cost of goods sold (COGS) is the
	// total cost of products sold as a result of advertising the same
	// product. How it works: You report conversions with cart data for
	// completed purchases on your website. If the ad that was interacted
	// with has an associated product (see Shopping Ads) then this product
	// is considered the advertised product. Any product included in the
	// order the customer places is a sold product. If the advertised and
	// sold products match, then the cost of these goods is counted under
	// lead cost of goods sold. Example: Someone clicked on a Shopping ad
	// for a hat then bought the same hat and a shirt. The hat has a cost of
	// goods sold value of $3, the shirt has a cost of goods sold value of
	// $5. The lead cost of goods sold for this order is $3. This metric is
	// only available if you report conversions with cart data. This metric
	// is a monetary value and returned in the customer's currency by
	// default. See the metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	LeadCostOfGoodsSoldMicros int64 `json:"leadCostOfGoodsSoldMicros,omitempty,string"`

	// LeadGrossProfitMicros: Lead gross profit is the profit you made from
	// products sold as a result of advertising the same product, minus cost
	// of goods sold (COGS). How it works: You report conversions with cart
	// data for completed purchases on your website. If the ad that was
	// interacted with before the purchase has an associated product (see
	// Shopping Ads) then this product is considered the advertised product.
	// Any product included in the order the customer places is a sold
	// product. If the advertised and sold products match, then the revenue
	// you made from these sales minus the cost of goods sold is your lead
	// gross profit. Example: Someone clicked on a Shopping ad for a hat
	// then bought the same hat and a shirt. The hat is priced $10 and has a
	// cost of goods sold value of $3. The lead gross profit of this order
	// is $7 = $10 - $3. This metric is only available if you report
	// conversions with cart data. This metric is a monetary value and
	// returned in the customer's currency by default. See the
	// metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	LeadGrossProfitMicros int64 `json:"leadGrossProfitMicros,omitempty,string"`

	// LeadRevenueMicros: Lead revenue is the total amount you made from
	// products sold as a result of advertising the same product. How it
	// works: You report conversions with cart data for completed purchases
	// on your website. If the ad that was interacted with before the
	// purchase has an associated product (see Shopping Ads) then this
	// product is considered the advertised product. Any product included in
	// the order the customer places is a sold product. If the advertised
	// and sold products match, then the total value you made from the sales
	// of these products is shown under lead revenue. Example: Someone
	// clicked on a Shopping ad for a hat then bought the same hat and a
	// shirt. The hat is priced $10 and the shirt is priced $20. The lead
	// revenue of this order is $10. This metric is only available if you
	// report conversions with cart data. This metric is a monetary value
	// and returned in the customer's currency by default. See the
	// metrics_currency parameter at
	// https://developers.google.com/search-ads/reporting/query/query-structure#parameters_clause
	LeadRevenueMicros int64 `json:"leadRevenueMicros,omitempty,string"`

	// LeadUnitsSold: Lead units sold is the total number of products sold
	// as a result of advertising the same product. How it works: You report
	// conversions with cart data for completed purchases on your website.
	// If the ad that was interacted with before the purchase has an
	// associated product (see Shopping Ads) then this product is considered
	// the advertised product. Any product included in the order the
	// customer places is a sold product. If the advertised and sold
	// products match, then the total number of these products sold is shown
	// under lead units sold. Example: Someone clicked on a Shopping ad for
	// a hat then bought the same hat, a shirt and a jacket. The lead units
	// sold in this order is 1. This metric is only available if you report
	// conversions with cart data.
	LeadUnitsSold float64 `json:"leadUnitsSold,omitempty"`

	// MobileFriendlyClicksPercentage: The percentage of mobile clicks that
	// go to a mobile-friendly page.
	MobileFriendlyClicksPercentage float64 `json:"mobileFriendlyClicksPercentage,omitempty"`

	// SearchAbsoluteTopImpressionShare: The percentage of the customer's
	// Shopping or Search ad impressions that are shown in the most
	// prominent Shopping position. See
	// https://support.google.com/sa360/answer/9566729 for details. Any
	// value below 0.1 is reported as 0.0999.
	SearchAbsoluteTopImpressionShare float64 `json:"searchAbsoluteTopImpressionShare,omitempty"`

	// SearchBudgetLostAbsoluteTopImpressionShare: The number estimating how
	// often your ad wasn't the very first ad above the organic search
	// results due to a low budget. Note: Search budget lost absolute top
	// impression share is reported in the range of 0 to 0.9. Any value
	// above 0.9 is reported as 0.9001.
	SearchBudgetLostAbsoluteTopImpressionShare float64 `json:"searchBudgetLostAbsoluteTopImpressionShare,omitempty"`

	// SearchBudgetLostImpressionShare: The estimated percent of times that
	// your ad was eligible to show on the Search Network but didn't because
	// your budget was too low. Note: Search budget lost impression share is
	// reported in the range of 0 to 0.9. Any value above 0.9 is reported as
	// 0.9001.
	SearchBudgetLostImpressionShare float64 `json:"searchBudgetLostImpressionShare,omitempty"`

	// SearchBudgetLostTopImpressionShare: The number estimating how often
	// your ad didn't show anywhere above the organic search results due to
	// a low budget. Note: Search budget lost top impression share is
	// reported in the range of 0 to 0.9. Any value above 0.9 is reported as
	// 0.9001.
	SearchBudgetLostTopImpressionShare float64 `json:"searchBudgetLostTopImpressionShare,omitempty"`

	// SearchClickShare: The number of clicks you've received on the Search
	// Network divided by the estimated number of clicks you were eligible
	// to receive. Note: Search click share is reported in the range of 0.1
	// to 1. Any value below 0.1 is reported as 0.0999.
	SearchClickShare float64 `json:"searchClickShare,omitempty"`

	// SearchExactMatchImpressionShare: The impressions you've received
	// divided by the estimated number of impressions you were eligible to
	// receive on the Search Network for search terms that matched your
	// keywords exactly (or were close variants of your keyword), regardless
	// of your keyword match types. Note: Search exact match impression
	// share is reported in the range of 0.1 to 1. Any value below 0.1 is
	// reported as 0.0999.
	SearchExactMatchImpressionShare float64 `json:"searchExactMatchImpressionShare,omitempty"`

	// SearchImpressionShare: The impressions you've received on the Search
	// Network divided by the estimated number of impressions you were
	// eligible to receive. Note: Search impression share is reported in the
	// range of 0.1 to 1. Any value below 0.1 is reported as 0.0999.
	SearchImpressionShare float64 `json:"searchImpressionShare,omitempty"`

	// SearchRankLostAbsoluteTopImpressionShare: The number estimating how
	// often your ad wasn't the very first ad above the organic search
	// results due to poor Ad Rank. Note: Search rank lost absolute top
	// impression share is reported in the range of 0 to 0.9. Any value
	// above 0.9 is reported as 0.9001.
	SearchRankLostAbsoluteTopImpressionShare float64 `json:"searchRankLostAbsoluteTopImpressionShare,omitempty"`

	// SearchRankLostImpressionShare: The estimated percentage of
	// impressions on the Search Network that your ads didn't receive due to
	// poor Ad Rank. Note: Search rank lost impression share is reported in
	// the range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostImpressionShare float64 `json:"searchRankLostImpressionShare,omitempty"`

	// SearchRankLostTopImpressionShare: The number estimating how often
	// your ad didn't show anywhere above the organic search results due to
	// poor Ad Rank. Note: Search rank lost top impression share is reported
	// in the range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostTopImpressionShare float64 `json:"searchRankLostTopImpressionShare,omitempty"`

	// SearchTopImpressionShare: The impressions you've received in the top
	// location (anywhere above the organic search results) compared to the
	// estimated number of impressions you were eligible to receive in the
	// top location. Note: Search top impression share is reported in the
	// range of 0.1 to 1. Any value below 0.1 is reported as 0.0999.
	SearchTopImpressionShare float64 `json:"searchTopImpressionShare,omitempty"`

	// TopImpressionPercentage: The percent of your ad impressions that are
	// shown anywhere above the organic search results.
	TopImpressionPercentage float64 `json:"topImpressionPercentage,omitempty"`

	// ValuePerAllConversions: The value of all conversions divided by the
	// number of all conversions.
	ValuePerAllConversions float64 `json:"valuePerAllConversions,omitempty"`

	// ValuePerAllConversionsByConversionDate: The value of all conversions
	// divided by the number of all conversions. When this column is
	// selected with date, the values in date column means the conversion
	// date. Details for the by_conversion_date columns are available at
	// https://support.google.com/sa360/answer/9250611.
	ValuePerAllConversionsByConversionDate float64 `json:"valuePerAllConversionsByConversionDate,omitempty"`

	// ValuePerConversion: The value of biddable conversion divided by the
	// number of biddable conversions. Shows how much, on average, each of
	// the biddable conversions is worth.
	ValuePerConversion float64 `json:"valuePerConversion,omitempty"`

	// ValuePerConversionsByConversionDate: Biddable conversions value by
	// conversion date divided by biddable conversions by conversion date.
	// Shows how much, on average, each of the biddable conversions is worth
	// (by conversion date). When this column is selected with date, the
	// values in date column means the conversion date.
	ValuePerConversionsByConversionDate float64 `json:"valuePerConversionsByConversionDate,omitempty"`

	// Visits: Clicks that Search Ads 360 has successfully recorded and
	// forwarded to an advertiser's landing page.
	Visits float64 `json:"visits,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AbsoluteTopImpressionPercentage") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AbsoluteTopImpressionPercentage") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__Metrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__Metrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Common__Metrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Common__Metrics
	var s1 struct {
		AbsoluteTopImpressionPercentage                   gensupport.JSONFloat64 `json:"absoluteTopImpressionPercentage"`
		AllConversions                                    gensupport.JSONFloat64 `json:"allConversions"`
		AllConversionsByConversionDate                    gensupport.JSONFloat64 `json:"allConversionsByConversionDate"`
		AllConversionsFromClickToCall                     gensupport.JSONFloat64 `json:"allConversionsFromClickToCall"`
		AllConversionsFromDirections                      gensupport.JSONFloat64 `json:"allConversionsFromDirections"`
		AllConversionsFromInteractionsRate                gensupport.JSONFloat64 `json:"allConversionsFromInteractionsRate"`
		AllConversionsFromInteractionsValuePerInteraction gensupport.JSONFloat64 `json:"allConversionsFromInteractionsValuePerInteraction"`
		AllConversionsFromMenu                            gensupport.JSONFloat64 `json:"allConversionsFromMenu"`
		AllConversionsFromOrder                           gensupport.JSONFloat64 `json:"allConversionsFromOrder"`
		AllConversionsFromOtherEngagement                 gensupport.JSONFloat64 `json:"allConversionsFromOtherEngagement"`
		AllConversionsFromStoreVisit                      gensupport.JSONFloat64 `json:"allConversionsFromStoreVisit"`
		AllConversionsFromStoreWebsite                    gensupport.JSONFloat64 `json:"allConversionsFromStoreWebsite"`
		AllConversionsValue                               gensupport.JSONFloat64 `json:"allConversionsValue"`
		AllConversionsValueByConversionDate               gensupport.JSONFloat64 `json:"allConversionsValueByConversionDate"`
		AllConversionsValuePerCost                        gensupport.JSONFloat64 `json:"allConversionsValuePerCost"`
		AverageCost                                       gensupport.JSONFloat64 `json:"averageCost"`
		AverageCpc                                        gensupport.JSONFloat64 `json:"averageCpc"`
		AverageCpm                                        gensupport.JSONFloat64 `json:"averageCpm"`
		ClientAccountConversions                          gensupport.JSONFloat64 `json:"clientAccountConversions"`
		ClientAccountConversionsValue                     gensupport.JSONFloat64 `json:"clientAccountConversionsValue"`
		ClientAccountCrossSellUnitsSold                   gensupport.JSONFloat64 `json:"clientAccountCrossSellUnitsSold"`
		ClientAccountLeadUnitsSold                        gensupport.JSONFloat64 `json:"clientAccountLeadUnitsSold"`
		ContentBudgetLostImpressionShare                  gensupport.JSONFloat64 `json:"contentBudgetLostImpressionShare"`
		ContentImpressionShare                            gensupport.JSONFloat64 `json:"contentImpressionShare"`
		ContentRankLostImpressionShare                    gensupport.JSONFloat64 `json:"contentRankLostImpressionShare"`
		Conversions                                       gensupport.JSONFloat64 `json:"conversions"`
		ConversionsByConversionDate                       gensupport.JSONFloat64 `json:"conversionsByConversionDate"`
		ConversionsFromInteractionsRate                   gensupport.JSONFloat64 `json:"conversionsFromInteractionsRate"`
		ConversionsFromInteractionsValuePerInteraction    gensupport.JSONFloat64 `json:"conversionsFromInteractionsValuePerInteraction"`
		ConversionsValue                                  gensupport.JSONFloat64 `json:"conversionsValue"`
		ConversionsValueByConversionDate                  gensupport.JSONFloat64 `json:"conversionsValueByConversionDate"`
		ConversionsValuePerCost                           gensupport.JSONFloat64 `json:"conversionsValuePerCost"`
		CostPerAllConversions                             gensupport.JSONFloat64 `json:"costPerAllConversions"`
		CostPerConversion                                 gensupport.JSONFloat64 `json:"costPerConversion"`
		CostPerCurrentModelAttributedConversion           gensupport.JSONFloat64 `json:"costPerCurrentModelAttributedConversion"`
		CrossDeviceConversions                            gensupport.JSONFloat64 `json:"crossDeviceConversions"`
		CrossDeviceConversionsValue                       gensupport.JSONFloat64 `json:"crossDeviceConversionsValue"`
		CrossSellUnitsSold                                gensupport.JSONFloat64 `json:"crossSellUnitsSold"`
		Ctr                                               gensupport.JSONFloat64 `json:"ctr"`
		InteractionRate                                   gensupport.JSONFloat64 `json:"interactionRate"`
		InvalidClickRate                                  gensupport.JSONFloat64 `json:"invalidClickRate"`
		LeadUnitsSold                                     gensupport.JSONFloat64 `json:"leadUnitsSold"`
		MobileFriendlyClicksPercentage                    gensupport.JSONFloat64 `json:"mobileFriendlyClicksPercentage"`
		SearchAbsoluteTopImpressionShare                  gensupport.JSONFloat64 `json:"searchAbsoluteTopImpressionShare"`
		SearchBudgetLostAbsoluteTopImpressionShare        gensupport.JSONFloat64 `json:"searchBudgetLostAbsoluteTopImpressionShare"`
		SearchBudgetLostImpressionShare                   gensupport.JSONFloat64 `json:"searchBudgetLostImpressionShare"`
		SearchBudgetLostTopImpressionShare                gensupport.JSONFloat64 `json:"searchBudgetLostTopImpressionShare"`
		SearchClickShare                                  gensupport.JSONFloat64 `json:"searchClickShare"`
		SearchExactMatchImpressionShare                   gensupport.JSONFloat64 `json:"searchExactMatchImpressionShare"`
		SearchImpressionShare                             gensupport.JSONFloat64 `json:"searchImpressionShare"`
		SearchRankLostAbsoluteTopImpressionShare          gensupport.JSONFloat64 `json:"searchRankLostAbsoluteTopImpressionShare"`
		SearchRankLostImpressionShare                     gensupport.JSONFloat64 `json:"searchRankLostImpressionShare"`
		SearchRankLostTopImpressionShare                  gensupport.JSONFloat64 `json:"searchRankLostTopImpressionShare"`
		SearchTopImpressionShare                          gensupport.JSONFloat64 `json:"searchTopImpressionShare"`
		TopImpressionPercentage                           gensupport.JSONFloat64 `json:"topImpressionPercentage"`
		ValuePerAllConversions                            gensupport.JSONFloat64 `json:"valuePerAllConversions"`
		ValuePerAllConversionsByConversionDate            gensupport.JSONFloat64 `json:"valuePerAllConversionsByConversionDate"`
		ValuePerConversion                                gensupport.JSONFloat64 `json:"valuePerConversion"`
		ValuePerConversionsByConversionDate               gensupport.JSONFloat64 `json:"valuePerConversionsByConversionDate"`
		Visits                                            gensupport.JSONFloat64 `json:"visits"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AbsoluteTopImpressionPercentage = float64(s1.AbsoluteTopImpressionPercentage)
	s.AllConversions = float64(s1.AllConversions)
	s.AllConversionsByConversionDate = float64(s1.AllConversionsByConversionDate)
	s.AllConversionsFromClickToCall = float64(s1.AllConversionsFromClickToCall)
	s.AllConversionsFromDirections = float64(s1.AllConversionsFromDirections)
	s.AllConversionsFromInteractionsRate = float64(s1.AllConversionsFromInteractionsRate)
	s.AllConversionsFromInteractionsValuePerInteraction = float64(s1.AllConversionsFromInteractionsValuePerInteraction)
	s.AllConversionsFromMenu = float64(s1.AllConversionsFromMenu)
	s.AllConversionsFromOrder = float64(s1.AllConversionsFromOrder)
	s.AllConversionsFromOtherEngagement = float64(s1.AllConversionsFromOtherEngagement)
	s.AllConversionsFromStoreVisit = float64(s1.AllConversionsFromStoreVisit)
	s.AllConversionsFromStoreWebsite = float64(s1.AllConversionsFromStoreWebsite)
	s.AllConversionsValue = float64(s1.AllConversionsValue)
	s.AllConversionsValueByConversionDate = float64(s1.AllConversionsValueByConversionDate)
	s.AllConversionsValuePerCost = float64(s1.AllConversionsValuePerCost)
	s.AverageCost = float64(s1.AverageCost)
	s.AverageCpc = float64(s1.AverageCpc)
	s.AverageCpm = float64(s1.AverageCpm)
	s.ClientAccountConversions = float64(s1.ClientAccountConversions)
	s.ClientAccountConversionsValue = float64(s1.ClientAccountConversionsValue)
	s.ClientAccountCrossSellUnitsSold = float64(s1.ClientAccountCrossSellUnitsSold)
	s.ClientAccountLeadUnitsSold = float64(s1.ClientAccountLeadUnitsSold)
	s.ContentBudgetLostImpressionShare = float64(s1.ContentBudgetLostImpressionShare)
	s.ContentImpressionShare = float64(s1.ContentImpressionShare)
	s.ContentRankLostImpressionShare = float64(s1.ContentRankLostImpressionShare)
	s.Conversions = float64(s1.Conversions)
	s.ConversionsByConversionDate = float64(s1.ConversionsByConversionDate)
	s.ConversionsFromInteractionsRate = float64(s1.ConversionsFromInteractionsRate)
	s.ConversionsFromInteractionsValuePerInteraction = float64(s1.ConversionsFromInteractionsValuePerInteraction)
	s.ConversionsValue = float64(s1.ConversionsValue)
	s.ConversionsValueByConversionDate = float64(s1.ConversionsValueByConversionDate)
	s.ConversionsValuePerCost = float64(s1.ConversionsValuePerCost)
	s.CostPerAllConversions = float64(s1.CostPerAllConversions)
	s.CostPerConversion = float64(s1.CostPerConversion)
	s.CostPerCurrentModelAttributedConversion = float64(s1.CostPerCurrentModelAttributedConversion)
	s.CrossDeviceConversions = float64(s1.CrossDeviceConversions)
	s.CrossDeviceConversionsValue = float64(s1.CrossDeviceConversionsValue)
	s.CrossSellUnitsSold = float64(s1.CrossSellUnitsSold)
	s.Ctr = float64(s1.Ctr)
	s.InteractionRate = float64(s1.InteractionRate)
	s.InvalidClickRate = float64(s1.InvalidClickRate)
	s.LeadUnitsSold = float64(s1.LeadUnitsSold)
	s.MobileFriendlyClicksPercentage = float64(s1.MobileFriendlyClicksPercentage)
	s.SearchAbsoluteTopImpressionShare = float64(s1.SearchAbsoluteTopImpressionShare)
	s.SearchBudgetLostAbsoluteTopImpressionShare = float64(s1.SearchBudgetLostAbsoluteTopImpressionShare)
	s.SearchBudgetLostImpressionShare = float64(s1.SearchBudgetLostImpressionShare)
	s.SearchBudgetLostTopImpressionShare = float64(s1.SearchBudgetLostTopImpressionShare)
	s.SearchClickShare = float64(s1.SearchClickShare)
	s.SearchExactMatchImpressionShare = float64(s1.SearchExactMatchImpressionShare)
	s.SearchImpressionShare = float64(s1.SearchImpressionShare)
	s.SearchRankLostAbsoluteTopImpressionShare = float64(s1.SearchRankLostAbsoluteTopImpressionShare)
	s.SearchRankLostImpressionShare = float64(s1.SearchRankLostImpressionShare)
	s.SearchRankLostTopImpressionShare = float64(s1.SearchRankLostTopImpressionShare)
	s.SearchTopImpressionShare = float64(s1.SearchTopImpressionShare)
	s.TopImpressionPercentage = float64(s1.TopImpressionPercentage)
	s.ValuePerAllConversions = float64(s1.ValuePerAllConversions)
	s.ValuePerAllConversionsByConversionDate = float64(s1.ValuePerAllConversionsByConversionDate)
	s.ValuePerConversion = float64(s1.ValuePerConversion)
	s.ValuePerConversionsByConversionDate = float64(s1.ValuePerConversionsByConversionDate)
	s.Visits = float64(s1.Visits)
	return nil
}

// GoogleAdsSearchads360V0Common__MobileAppAsset: An asset representing
// a mobile app.
type GoogleAdsSearchads360V0Common__MobileAppAsset struct {
	// AppId: Required. A string that uniquely identifies a mobile
	// application. It should just contain the platform native id, like
	// "com.android.ebay" for Android or "12345689" for iOS.
	AppId string `json:"appId,omitempty"`

	// AppStore: Required. The application store that distributes this
	// specific app.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "APPLE_APP_STORE" - Mobile app vendor for Apple app store.
	//   "GOOGLE_APP_STORE" - Mobile app vendor for Google app store.
	AppStore string `json:"appStore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__MobileAppAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__MobileAppAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__PercentCpc: A bidding strategy where
// bids are a fraction of the advertised price for some good or service.
type GoogleAdsSearchads360V0Common__PercentCpc struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. This is an optional field entered by the advertiser and
	// specified in local micros. Note: A zero value is interpreted in the
	// same way as having bid_ceiling undefined.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// EnhancedCpcEnabled: Adjusts the bid for each auction upward or
	// downward, depending on the likelihood of a conversion. Individual
	// bids may exceed cpc_bid_ceiling_micros, but the average bid amount
	// for a campaign should not.
	EnhancedCpcEnabled bool `json:"enhancedCpcEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__PercentCpc) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__PercentCpc
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__RealTimeBiddingSetting: Settings for
// Real-Time Bidding, a feature only available for campaigns targeting
// the Ad Exchange network.
type GoogleAdsSearchads360V0Common__RealTimeBiddingSetting struct {
	// OptIn: Whether the campaign is opted in to real-time bidding.
	OptIn bool `json:"optIn,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OptIn") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptIn") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__RealTimeBiddingSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__RealTimeBiddingSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__SearchAds360ExpandedDynamicSearchAdInfo
// : An expanded dynamic search ad.
type GoogleAdsSearchads360V0Common__SearchAds360ExpandedDynamicSearchAdInfo struct {
	// AdTrackingId: The tracking id of the ad.
	AdTrackingId int64 `json:"adTrackingId,omitempty,string"`

	// Description1: The first line of the ad's description.
	Description1 string `json:"description1,omitempty"`

	// Description2: The second line of the ad's description.
	Description2 string `json:"description2,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdTrackingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdTrackingId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__SearchAds360ExpandedDynamicSearchAdInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__SearchAds360ExpandedDynamicSearchAdInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__SearchAds360ExpandedTextAdInfo: A
// Search Ads 360 expanded text ad.
type GoogleAdsSearchads360V0Common__SearchAds360ExpandedTextAdInfo struct {
	// AdTrackingId: The tracking id of the ad.
	AdTrackingId int64 `json:"adTrackingId,omitempty,string"`

	// Description1: The first line of the ad's description.
	Description1 string `json:"description1,omitempty"`

	// Description2: The second line of the ad's description.
	Description2 string `json:"description2,omitempty"`

	// Headline: The headline of the ad.
	Headline string `json:"headline,omitempty"`

	// Headline2: The second headline of the ad.
	Headline2 string `json:"headline2,omitempty"`

	// Headline3: The third headline of the ad.
	Headline3 string `json:"headline3,omitempty"`

	// Path1: Text appended to the auto-generated visible URL with a
	// delimiter.
	Path1 string `json:"path1,omitempty"`

	// Path2: Text appended to path1 with a delimiter.
	Path2 string `json:"path2,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdTrackingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdTrackingId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__SearchAds360ExpandedTextAdInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__SearchAds360ExpandedTextAdInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__SearchAds360ProductAdInfo: A Search
// Ads 360 product ad.
type GoogleAdsSearchads360V0Common__SearchAds360ProductAdInfo struct {
}

// GoogleAdsSearchads360V0Common__SearchAds360ResponsiveSearchAdInfo: A
// Search Ads 360 responsive search ad.
type GoogleAdsSearchads360V0Common__SearchAds360ResponsiveSearchAdInfo struct {
	// AdTrackingId: The tracking id of the ad.
	AdTrackingId int64 `json:"adTrackingId,omitempty,string"`

	// Path1: Text appended to the auto-generated visible URL with a
	// delimiter.
	Path1 string `json:"path1,omitempty"`

	// Path2: Text appended to path1 with a delimiter.
	Path2 string `json:"path2,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdTrackingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdTrackingId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__SearchAds360ResponsiveSearchAdInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__SearchAds360ResponsiveSearchAdInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__SearchAds360TextAdInfo: A Search Ads
// 360 text ad.
type GoogleAdsSearchads360V0Common__SearchAds360TextAdInfo struct {
	// AdTrackingId: The tracking id of the ad.
	AdTrackingId int64 `json:"adTrackingId,omitempty,string"`

	// Description1: The first line of the ad's description.
	Description1 string `json:"description1,omitempty"`

	// Description2: The second line of the ad's description.
	Description2 string `json:"description2,omitempty"`

	// DisplayMobileUrl: The displayed mobile URL of the ad.
	DisplayMobileUrl string `json:"displayMobileUrl,omitempty"`

	// DisplayUrl: The displayed URL of the ad.
	DisplayUrl string `json:"displayUrl,omitempty"`

	// Headline: The headline of the ad.
	Headline string `json:"headline,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdTrackingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdTrackingId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__SearchAds360TextAdInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__SearchAds360TextAdInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__Segments: Segment only fields.
type GoogleAdsSearchads360V0Common__Segments struct {
	// AdNetworkType: Ad network type.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "SEARCH" - Google search.
	//   "SEARCH_PARTNERS" - Search partners.
	//   "CONTENT" - Display Network.
	//   "YOUTUBE_SEARCH" - YouTube Search.
	//   "YOUTUBE_WATCH" - YouTube Videos
	//   "MIXED" - Cross-network.
	AdNetworkType string `json:"adNetworkType,omitempty"`

	// AssetInteractionTarget: Only used with CustomerAsset, CampaignAsset
	// and AdGroupAsset metrics. Indicates whether the interaction metrics
	// occurred on the asset itself or a different asset or ad unit.
	// Interactions (for example, clicks) are counted across all the parts
	// of the served ad (for example, Ad itself and other components like
	// Sitelinks) when they are served together. When
	// interaction_on_this_asset is true, it means the interactions are on
	// this specific asset and when interaction_on_this_asset is false, it
	// means the interactions is not on this specific asset but on other
	// parts of the served ad this asset is served with.
	AssetInteractionTarget *GoogleAdsSearchads360V0Common__AssetInteractionTarget `json:"assetInteractionTarget,omitempty"`

	// ConversionAction: Resource name of the conversion action.
	ConversionAction string `json:"conversionAction,omitempty"`

	// ConversionActionCategory: Conversion action category.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "DEFAULT" - Default category.
	//   "PAGE_VIEW" - User visiting a page.
	//   "PURCHASE" - Purchase, sales, or "order placed" event.
	//   "SIGNUP" - Signup user action.
	//   "LEAD" - Lead-generating action.
	//   "DOWNLOAD" - Software download action (as for an app).
	//   "ADD_TO_CART" - The addition of items to a shopping cart or bag on
	// an advertiser site.
	//   "BEGIN_CHECKOUT" - When someone enters the checkout flow on an
	// advertiser site.
	//   "SUBSCRIBE_PAID" - The start of a paid subscription for a product
	// or service.
	//   "PHONE_CALL_LEAD" - A call to indicate interest in an advertiser's
	// offering.
	//   "IMPORTED_LEAD" - A lead conversion imported from an external
	// source into Google Ads.
	//   "SUBMIT_LEAD_FORM" - A submission of a form on an advertiser site
	// indicating business interest.
	//   "BOOK_APPOINTMENT" - A booking of an appointment with an
	// advertiser's business.
	//   "REQUEST_QUOTE" - A quote or price estimate request.
	//   "GET_DIRECTIONS" - A search for an advertiser's business location
	// with intention to visit.
	//   "OUTBOUND_CLICK" - A click to an advertiser's partner's site.
	//   "CONTACT" - A call, SMS, email, chat or other type of contact to an
	// advertiser.
	//   "ENGAGEMENT" - A website engagement event such as long site time or
	// a Google Analytics (GA) Smart Goal. Intended to be used for GA,
	// Firebase, GA Gold goal imports.
	//   "STORE_VISIT" - A visit to a physical store location.
	//   "STORE_SALE" - A sale occurring in a physical store.
	//   "QUALIFIED_LEAD" - A lead conversion imported from an external
	// source into Google Ads, that has been further qualified by the
	// advertiser (marketing/sales team). In the lead-to-sale journey,
	// advertisers get leads, then act on them by reaching out to the
	// consumer. If the consumer is interested and may end up buying their
	// product, the advertiser marks such leads as "qualified leads".
	//   "CONVERTED_LEAD" - A lead conversion imported from an external
	// source into Google Ads, that has further completed a chosen stage as
	// defined by the lead gen advertiser.
	ConversionActionCategory string `json:"conversionActionCategory,omitempty"`

	// ConversionActionName: Conversion action name.
	ConversionActionName string `json:"conversionActionName,omitempty"`

	// Date: Date to which metrics apply. yyyy-MM-dd format, for example,
	// 2018-04-17.
	Date string `json:"date,omitempty"`

	// DayOfWeek: Day of the week, for example, MONDAY.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "MONDAY" - Monday.
	//   "TUESDAY" - Tuesday.
	//   "WEDNESDAY" - Wednesday.
	//   "THURSDAY" - Thursday.
	//   "FRIDAY" - Friday.
	//   "SATURDAY" - Saturday.
	//   "SUNDAY" - Sunday.
	DayOfWeek string `json:"dayOfWeek,omitempty"`

	// Device: Device to which metrics apply.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "MOBILE" - Mobile devices with full browsers.
	//   "TABLET" - Tablets with full browsers.
	//   "DESKTOP" - Computers.
	//   "CONNECTED_TV" - Smart TVs and game consoles.
	//   "OTHER" - Other device types.
	Device string `json:"device,omitempty"`

	// Keyword: Keyword criterion.
	Keyword *GoogleAdsSearchads360V0Common__Keyword `json:"keyword,omitempty"`

	// Month: Month as represented by the date of the first day of a month.
	// Formatted as yyyy-MM-dd.
	Month string `json:"month,omitempty"`

	// ProductBiddingCategoryLevel1: Bidding category (level 1) of the
	// product.
	ProductBiddingCategoryLevel1 string `json:"productBiddingCategoryLevel1,omitempty"`

	// ProductBiddingCategoryLevel2: Bidding category (level 2) of the
	// product.
	ProductBiddingCategoryLevel2 string `json:"productBiddingCategoryLevel2,omitempty"`

	// ProductBiddingCategoryLevel3: Bidding category (level 3) of the
	// product.
	ProductBiddingCategoryLevel3 string `json:"productBiddingCategoryLevel3,omitempty"`

	// ProductBiddingCategoryLevel4: Bidding category (level 4) of the
	// product.
	ProductBiddingCategoryLevel4 string `json:"productBiddingCategoryLevel4,omitempty"`

	// ProductBiddingCategoryLevel5: Bidding category (level 5) of the
	// product.
	ProductBiddingCategoryLevel5 string `json:"productBiddingCategoryLevel5,omitempty"`

	// ProductBrand: Brand of the product.
	ProductBrand string `json:"productBrand,omitempty"`

	// ProductChannel: Channel of the product.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ONLINE" - The item is sold online.
	//   "LOCAL" - The item is sold in local stores.
	ProductChannel string `json:"productChannel,omitempty"`

	// ProductChannelExclusivity: Channel exclusivity of the product.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "SINGLE_CHANNEL" - The item is sold through one channel only,
	// either local stores or online as indicated by its ProductChannel.
	//   "MULTI_CHANNEL" - The item is matched to its online or local stores
	// counterpart, indicating it is available for purchase in both
	// ShoppingProductChannels.
	ProductChannelExclusivity string `json:"productChannelExclusivity,omitempty"`

	// ProductCondition: Condition of the product.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "OLD" - The product condition is old.
	//   "NEW" - The product condition is new.
	//   "REFURBISHED" - The product condition is refurbished.
	//   "USED" - The product condition is used.
	ProductCondition string `json:"productCondition,omitempty"`

	// ProductCountry: Resource name of the geo target constant for the
	// country of sale of the product.
	ProductCountry string `json:"productCountry,omitempty"`

	// ProductCustomAttribute0: Custom attribute 0 of the product.
	ProductCustomAttribute0 string `json:"productCustomAttribute0,omitempty"`

	// ProductCustomAttribute1: Custom attribute 1 of the product.
	ProductCustomAttribute1 string `json:"productCustomAttribute1,omitempty"`

	// ProductCustomAttribute2: Custom attribute 2 of the product.
	ProductCustomAttribute2 string `json:"productCustomAttribute2,omitempty"`

	// ProductCustomAttribute3: Custom attribute 3 of the product.
	ProductCustomAttribute3 string `json:"productCustomAttribute3,omitempty"`

	// ProductCustomAttribute4: Custom attribute 4 of the product.
	ProductCustomAttribute4 string `json:"productCustomAttribute4,omitempty"`

	// ProductItemId: Item ID of the product.
	ProductItemId string `json:"productItemId,omitempty"`

	// ProductLanguage: Resource name of the language constant for the
	// language of the product.
	ProductLanguage string `json:"productLanguage,omitempty"`

	// ProductSoldBiddingCategoryLevel1: Bidding category (level 1) of the
	// product sold.
	ProductSoldBiddingCategoryLevel1 string `json:"productSoldBiddingCategoryLevel1,omitempty"`

	// ProductSoldBiddingCategoryLevel2: Bidding category (level 2) of the
	// product sold.
	ProductSoldBiddingCategoryLevel2 string `json:"productSoldBiddingCategoryLevel2,omitempty"`

	// ProductSoldBiddingCategoryLevel3: Bidding category (level 3) of the
	// product sold.
	ProductSoldBiddingCategoryLevel3 string `json:"productSoldBiddingCategoryLevel3,omitempty"`

	// ProductSoldBiddingCategoryLevel4: Bidding category (level 4) of the
	// product sold.
	ProductSoldBiddingCategoryLevel4 string `json:"productSoldBiddingCategoryLevel4,omitempty"`

	// ProductSoldBiddingCategoryLevel5: Bidding category (level 5) of the
	// product sold.
	ProductSoldBiddingCategoryLevel5 string `json:"productSoldBiddingCategoryLevel5,omitempty"`

	// ProductSoldBrand: Brand of the product sold.
	ProductSoldBrand string `json:"productSoldBrand,omitempty"`

	// ProductSoldCondition: Condition of the product sold.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "OLD" - The product condition is old.
	//   "NEW" - The product condition is new.
	//   "REFURBISHED" - The product condition is refurbished.
	//   "USED" - The product condition is used.
	ProductSoldCondition string `json:"productSoldCondition,omitempty"`

	// ProductSoldCustomAttribute0: Custom attribute 0 of the product sold.
	ProductSoldCustomAttribute0 string `json:"productSoldCustomAttribute0,omitempty"`

	// ProductSoldCustomAttribute1: Custom attribute 1 of the product sold.
	ProductSoldCustomAttribute1 string `json:"productSoldCustomAttribute1,omitempty"`

	// ProductSoldCustomAttribute2: Custom attribute 2 of the product sold.
	ProductSoldCustomAttribute2 string `json:"productSoldCustomAttribute2,omitempty"`

	// ProductSoldCustomAttribute3: Custom attribute 3 of the product sold.
	ProductSoldCustomAttribute3 string `json:"productSoldCustomAttribute3,omitempty"`

	// ProductSoldCustomAttribute4: Custom attribute 4 of the product sold.
	ProductSoldCustomAttribute4 string `json:"productSoldCustomAttribute4,omitempty"`

	// ProductSoldItemId: Item ID of the product sold.
	ProductSoldItemId string `json:"productSoldItemId,omitempty"`

	// ProductSoldTitle: Title of the product sold.
	ProductSoldTitle string `json:"productSoldTitle,omitempty"`

	// ProductSoldTypeL1: Type (level 1) of the product sold.
	ProductSoldTypeL1 string `json:"productSoldTypeL1,omitempty"`

	// ProductSoldTypeL2: Type (level 2) of the product sold.
	ProductSoldTypeL2 string `json:"productSoldTypeL2,omitempty"`

	// ProductSoldTypeL3: Type (level 3) of the product sold.
	ProductSoldTypeL3 string `json:"productSoldTypeL3,omitempty"`

	// ProductSoldTypeL4: Type (level 4) of the product sold.
	ProductSoldTypeL4 string `json:"productSoldTypeL4,omitempty"`

	// ProductSoldTypeL5: Type (level 5) of the product sold.
	ProductSoldTypeL5 string `json:"productSoldTypeL5,omitempty"`

	// ProductStoreId: Store ID of the product.
	ProductStoreId string `json:"productStoreId,omitempty"`

	// ProductTitle: Title of the product.
	ProductTitle string `json:"productTitle,omitempty"`

	// ProductTypeL1: Type (level 1) of the product.
	ProductTypeL1 string `json:"productTypeL1,omitempty"`

	// ProductTypeL2: Type (level 2) of the product.
	ProductTypeL2 string `json:"productTypeL2,omitempty"`

	// ProductTypeL3: Type (level 3) of the product.
	ProductTypeL3 string `json:"productTypeL3,omitempty"`

	// ProductTypeL4: Type (level 4) of the product.
	ProductTypeL4 string `json:"productTypeL4,omitempty"`

	// ProductTypeL5: Type (level 5) of the product.
	ProductTypeL5 string `json:"productTypeL5,omitempty"`

	// Quarter: Quarter as represented by the date of the first day of a
	// quarter. Uses the calendar year for quarters, for example, the second
	// quarter of 2018 starts on 2018-04-01. Formatted as yyyy-MM-dd.
	Quarter string `json:"quarter,omitempty"`

	// Week: Week as defined as Monday through Sunday, and represented by
	// the date of Monday. Formatted as yyyy-MM-dd.
	Week string `json:"week,omitempty"`

	// Year: Year, formatted as yyyy.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdNetworkType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdNetworkType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__Segments) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__Segments
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TargetCpa: An automated bid strategy
// that sets bids to help get as many conversions as possible at the
// target cost-per-acquisition (CPA) you set.
type GoogleAdsSearchads360V0Common__TargetCpa struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// This should only be set for portfolio bid strategies.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// CpcBidFloorMicros: Minimum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// This should only be set for portfolio bid strategies.
	CpcBidFloorMicros int64 `json:"cpcBidFloorMicros,omitempty,string"`

	// TargetCpaMicros: Average CPA target. This target should be greater
	// than or equal to minimum billable unit based on the currency for the
	// account.
	TargetCpaMicros int64 `json:"targetCpaMicros,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetCpa) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetCpa
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TargetCpm: Target CPM (cost per
// thousand impressions) is an automated bidding strategy that sets bids
// to optimize performance given the target CPM you set.
type GoogleAdsSearchads360V0Common__TargetCpm struct {
}

// GoogleAdsSearchads360V0Common__TargetImpressionShare: An automated
// bidding strategy that sets bids so that a certain percentage of
// search ads are shown at the top of the first page (or other targeted
// location).
type GoogleAdsSearchads360V0Common__TargetImpressionShare struct {
	// CpcBidCeilingMicros: The highest CPC bid the automated bidding system
	// is permitted to specify. This is a required field entered by the
	// advertiser that sets the ceiling and specified in local micros.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// Location: The targeted location on the search results page.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ANYWHERE_ON_PAGE" - Any location on the web page.
	//   "TOP_OF_PAGE" - Top box of ads.
	//   "ABSOLUTE_TOP_OF_PAGE" - Top slot in the top box of ads.
	Location string `json:"location,omitempty"`

	// LocationFractionMicros: The chosen fraction of ads to be shown in the
	// targeted location in micros. For example, 1% equals 10,000.
	LocationFractionMicros int64 `json:"locationFractionMicros,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetImpressionShare) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetImpressionShare
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TargetOutrankShare: An automated
// bidding strategy that sets bids based on the target fraction of
// auctions where the advertiser should outrank a specific competitor.
// This strategy is deprecated.
type GoogleAdsSearchads360V0Common__TargetOutrankShare struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetOutrankShare) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetOutrankShare
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TargetRestriction: The list of
// per-targeting-dimension targeting settings.
type GoogleAdsSearchads360V0Common__TargetRestriction struct {
	// BidOnly: Indicates whether to restrict your ads to show only for the
	// criteria you have selected for this targeting_dimension, or to target
	// all values for this targeting_dimension and show ads based on your
	// targeting in other TargetingDimensions. A value of `true` means that
	// these criteria will only apply bid modifiers, and not affect
	// targeting. A value of `false` means that these criteria will restrict
	// targeting as well as applying bid modifiers.
	BidOnly bool `json:"bidOnly,omitempty"`

	// TargetingDimension: The targeting dimension that these settings apply
	// to.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "KEYWORD" - Keyword criteria, for example, 'mars cruise'. KEYWORD
	// may be used as a custom bid dimension. Keywords are always a
	// targeting dimension, so may not be set as a target "ALL" dimension
	// with TargetRestriction.
	//   "AUDIENCE" - Audience criteria, which include user list, user
	// interest, custom affinity, and custom in market.
	//   "TOPIC" - Topic criteria for targeting categories of content, for
	// example, 'category::Animals>Pets' Used for Display and Video
	// targeting.
	//   "GENDER" - Criteria for targeting gender.
	//   "AGE_RANGE" - Criteria for targeting age ranges.
	//   "PLACEMENT" - Placement criteria, which include websites like
	// 'www.flowers4sale.com', as well as mobile applications, mobile app
	// categories, YouTube videos, and YouTube channels.
	//   "PARENTAL_STATUS" - Criteria for parental status targeting.
	//   "INCOME_RANGE" - Criteria for income range targeting.
	TargetingDimension string `json:"targetingDimension,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BidOnly") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BidOnly") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TargetRoas: An automated bidding
// strategy that helps you maximize revenue while averaging a specific
// target return on ad spend (ROAS).
type GoogleAdsSearchads360V0Common__TargetRoas struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// This should only be set for portfolio bid strategies.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// CpcBidFloorMicros: Minimum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	// This should only be set for portfolio bid strategies.
	CpcBidFloorMicros int64 `json:"cpcBidFloorMicros,omitempty,string"`

	// TargetRoas: Required. The chosen revenue (based on conversion data)
	// per unit of spend. Value must be between 0.01 and 1000.0, inclusive.
	TargetRoas float64 `json:"targetRoas,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetRoas) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetRoas
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Common__TargetRoas) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Common__TargetRoas
	var s1 struct {
		TargetRoas gensupport.JSONFloat64 `json:"targetRoas"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetRoas = float64(s1.TargetRoas)
	return nil
}

// GoogleAdsSearchads360V0Common__TargetSpend: An automated bid strategy
// that sets your bids to help get as many clicks as possible within
// your budget.
type GoogleAdsSearchads360V0Common__TargetSpend struct {
	// CpcBidCeilingMicros: Maximum bid limit that can be set by the bid
	// strategy. The limit applies to all keywords managed by the strategy.
	CpcBidCeilingMicros int64 `json:"cpcBidCeilingMicros,omitempty,string"`

	// TargetSpendMicros: The spend target under which to maximize clicks. A
	// TargetSpend bidder will attempt to spend the smaller of this value or
	// the natural throttling spend amount. If not specified, the budget is
	// used as the spend target. This field is deprecated and should no
	// longer be used. See
	// https://ads-developers.googleblog.com/2020/05/reminder-about-sunset-creation-of.html
	// for details.
	TargetSpendMicros int64 `json:"targetSpendMicros,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CpcBidCeilingMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpcBidCeilingMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetSpend) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetSpend
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TargetingSetting: Settings for the
// targeting-related features, at the campaign and ad group levels. For
// more details about the targeting setting, visit
// https://support.google.com/google-ads/answer/7365594
type GoogleAdsSearchads360V0Common__TargetingSetting struct {
	// TargetRestrictions: The per-targeting-dimension setting to restrict
	// the reach of your campaign or ad group.
	TargetRestrictions []*GoogleAdsSearchads360V0Common__TargetRestriction `json:"targetRestrictions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetRestrictions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetRestrictions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TargetingSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TargetingSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TextAsset: A Text asset.
type GoogleAdsSearchads360V0Common__TextAsset struct {
	// Text: Text content of the text asset.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TextAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TextAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__TextLabel: A type of label displaying
// text on a colored background.
type GoogleAdsSearchads360V0Common__TextLabel struct {
	// BackgroundColor: Background color of the label in RGB format. This
	// string must match the regular expression
	// '^\#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$'. Note: The background color may
	// not be visible for manager accounts.
	BackgroundColor string `json:"backgroundColor,omitempty"`

	// Description: A short description of the label. The length must be no
	// more than 200 characters.
	Description string `json:"description,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__TextLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__TextLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__UnifiedCallAsset: A unified call
// asset.
type GoogleAdsSearchads360V0Common__UnifiedCallAsset struct {
	// AdScheduleTargets: List of non-overlapping schedules specifying all
	// time intervals for which the asset may serve. There can be a maximum
	// of 6 schedules per day, 42 in total.
	AdScheduleTargets []*GoogleAdsSearchads360V0Common__AdScheduleInfo `json:"adScheduleTargets,omitempty"`

	// CallConversionAction: The conversion action to attribute a call
	// conversion to. If not set, the default conversion action is used.
	// This field only has effect if call_conversion_reporting_state is set
	// to USE_RESOURCE_LEVEL_CALL_CONVERSION_ACTION.
	CallConversionAction string `json:"callConversionAction,omitempty"`

	// CallConversionReportingState: Output only. Indicates whether this
	// CallAsset should use its own call conversion setting, follow the
	// account level setting, or disable call conversion.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "DISABLED" - Call conversion action is disabled.
	//   "USE_ACCOUNT_LEVEL_CALL_CONVERSION_ACTION" - Call conversion action
	// will use call conversion type set at the account level.
	//   "USE_RESOURCE_LEVEL_CALL_CONVERSION_ACTION" - Call conversion
	// action will use call conversion type set at the resource (call only
	// ads/call extensions) level.
	CallConversionReportingState string `json:"callConversionReportingState,omitempty"`

	// CallOnly: Whether the call only shows the phone number without a link
	// to the website. Applies to Microsoft Ads.
	CallOnly bool `json:"callOnly,omitempty"`

	// CallTrackingEnabled: Whether the call should be enabled on call
	// tracking. Applies to Microsoft Ads.
	CallTrackingEnabled bool `json:"callTrackingEnabled,omitempty"`

	// CountryCode: Two-letter country code of the phone number. Examples:
	// 'US', 'us'.
	CountryCode string `json:"countryCode,omitempty"`

	// EndDate: Last date of when this asset is effective and still serving,
	// in yyyy-MM-dd format.
	EndDate string `json:"endDate,omitempty"`

	// PhoneNumber: The advertiser's raw phone number. Examples:
	// '1234567890', '(123)456-7890'
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// StartDate: Start date of when this asset is effective and can begin
	// serving, in yyyy-MM-dd format.
	StartDate string `json:"startDate,omitempty"`

	// UseSearcherTimeZone: Whether to show the call extension in search
	// user's time zone. Applies to Microsoft Ads.
	UseSearcherTimeZone bool `json:"useSearcherTimeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdScheduleTargets")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdScheduleTargets") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__UnifiedCallAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__UnifiedCallAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__UnifiedCalloutAsset: A unified callout
// asset.
type GoogleAdsSearchads360V0Common__UnifiedCalloutAsset struct {
	// AdScheduleTargets: List of non-overlapping schedules specifying all
	// time intervals for which the asset may serve. There can be a maximum
	// of 6 schedules per day, 42 in total.
	AdScheduleTargets []*GoogleAdsSearchads360V0Common__AdScheduleInfo `json:"adScheduleTargets,omitempty"`

	// CalloutText: The callout text. The length of this string should be
	// between 1 and 25, inclusive.
	CalloutText string `json:"calloutText,omitempty"`

	// EndDate: Last date of when this asset is effective and still serving,
	// in yyyy-MM-dd format.
	EndDate string `json:"endDate,omitempty"`

	// StartDate: Start date of when this asset is effective and can begin
	// serving, in yyyy-MM-dd format.
	StartDate string `json:"startDate,omitempty"`

	// UseSearcherTimeZone: Whether to show the asset in search user's time
	// zone. Applies to Microsoft Ads.
	UseSearcherTimeZone bool `json:"useSearcherTimeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdScheduleTargets")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdScheduleTargets") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__UnifiedCalloutAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__UnifiedCalloutAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__UnifiedLocationAsset: A unified
// location asset.
type GoogleAdsSearchads360V0Common__UnifiedLocationAsset struct {
	// BusinessProfileLocations: The list of business locations for the
	// customer. This will only be returned if the Location Asset is syncing
	// from the Business Profile account. It is possible to have multiple
	// Business Profile listings under the same account that point to the
	// same Place ID.
	BusinessProfileLocations []*GoogleAdsSearchads360V0Common__BusinessProfileLocation `json:"businessProfileLocations,omitempty"`

	// LocationOwnershipType: The type of location ownership. If the type is
	// BUSINESS_OWNER, it will be served as a location extension. If the
	// type is AFFILIATE, it will be served as an affiliate location.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "BUSINESS_OWNER" - Business Owner of location(legacy location
	// extension - LE).
	//   "AFFILIATE" - Affiliate location(Third party location extension -
	// ALE).
	LocationOwnershipType string `json:"locationOwnershipType,omitempty"`

	// PlaceId: Place IDs uniquely identify a place in the Google Places
	// database and on Google Maps. This field is unique for a given
	// customer ID and asset type. See
	// https://developers.google.com/places/web-service/place-id to learn
	// more about Place ID.
	PlaceId string `json:"placeId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BusinessProfileLocations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BusinessProfileLocations")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__UnifiedLocationAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__UnifiedLocationAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__UnifiedPageFeedAsset: A Unified Page
// Feed asset.
type GoogleAdsSearchads360V0Common__UnifiedPageFeedAsset struct {
	// Labels: Labels used to group the page urls.
	Labels []string `json:"labels,omitempty"`

	// PageUrl: The webpage that advertisers want to target.
	PageUrl string `json:"pageUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Labels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__UnifiedPageFeedAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__UnifiedPageFeedAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__UnifiedSitelinkAsset: A unified
// sitelink asset.
type GoogleAdsSearchads360V0Common__UnifiedSitelinkAsset struct {
	// AdScheduleTargets: List of non-overlapping schedules specifying all
	// time intervals for which the asset may serve. There can be a maximum
	// of 6 schedules per day, 42 in total.
	AdScheduleTargets []*GoogleAdsSearchads360V0Common__AdScheduleInfo `json:"adScheduleTargets,omitempty"`

	// Description1: First line of the description for the sitelink. If set,
	// the length should be between 1 and 35, inclusive, and description2
	// must also be set.
	Description1 string `json:"description1,omitempty"`

	// Description2: Second line of the description for the sitelink. If
	// set, the length should be between 1 and 35, inclusive, and
	// description1 must also be set.
	Description2 string `json:"description2,omitempty"`

	// EndDate: Last date of when this asset is effective and still serving,
	// in yyyy-MM-dd format.
	EndDate string `json:"endDate,omitempty"`

	// LinkText: URL display text for the sitelink. The length of this
	// string should be between 1 and 25, inclusive.
	LinkText string `json:"linkText,omitempty"`

	// MobilePreferred: Whether the preference is for the sitelink asset to
	// be displayed on mobile devices. Applies to Microsoft Ads.
	MobilePreferred bool `json:"mobilePreferred,omitempty"`

	// StartDate: Start date of when this asset is effective and can begin
	// serving, in yyyy-MM-dd format.
	StartDate string `json:"startDate,omitempty"`

	// TrackingId: ID used for tracking clicks for the sitelink asset. This
	// is a Yahoo! Japan only field.
	TrackingId int64 `json:"trackingId,omitempty,string"`

	// UseSearcherTimeZone: Whether to show the sitelink asset in search
	// user's time zone. Applies to Microsoft Ads.
	UseSearcherTimeZone bool `json:"useSearcherTimeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdScheduleTargets")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdScheduleTargets") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__UnifiedSitelinkAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__UnifiedSitelinkAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__UserListInfo: A User List criterion.
// Represents a user list that is defined by the advertiser to be
// targeted.
type GoogleAdsSearchads360V0Common__UserListInfo struct {
	// UserList: The User List resource name.
	UserList string `json:"userList,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserList") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserList") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__UserListInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__UserListInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__Value: A generic data container.
type GoogleAdsSearchads360V0Common__Value struct {
	// BooleanValue: A boolean.
	BooleanValue bool `json:"booleanValue,omitempty"`

	// DoubleValue: A double.
	DoubleValue float64 `json:"doubleValue,omitempty"`

	// FloatValue: A float.
	FloatValue float64 `json:"floatValue,omitempty"`

	// Int64Value: An int64.
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// StringValue: A string.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__Value) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__Value
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Common__Value) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Common__Value
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		FloatValue  gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleAdsSearchads360V0Common__WebpageConditionInfo: Logical
// expression for targeting webpages of an advertiser's website.
type GoogleAdsSearchads360V0Common__WebpageConditionInfo struct {
	// Argument: Argument of webpage targeting condition.
	Argument string `json:"argument,omitempty"`

	// Operand: Operand of webpage targeting condition.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "URL" - Operand denoting a webpage URL targeting condition.
	//   "CATEGORY" - Operand denoting a webpage category targeting
	// condition.
	//   "PAGE_TITLE" - Operand denoting a webpage title targeting
	// condition.
	//   "PAGE_CONTENT" - Operand denoting a webpage content targeting
	// condition.
	//   "CUSTOM_LABEL" - Operand denoting a webpage custom label targeting
	// condition.
	Operand string `json:"operand,omitempty"`

	// Operator: Operator of webpage targeting condition.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "EQUALS" - The argument web condition is equal to the compared web
	// condition.
	//   "CONTAINS" - The argument web condition is part of the compared web
	// condition.
	Operator string `json:"operator,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Argument") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Argument") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__WebpageConditionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__WebpageConditionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Common__WebpageInfo: Represents a criterion
// for targeting webpages of an advertiser's website.
type GoogleAdsSearchads360V0Common__WebpageInfo struct {
	// Conditions: Conditions, or logical expressions, for webpage
	// targeting. The list of webpage targeting conditions are and-ed
	// together when evaluated for targeting. An empty list of conditions
	// indicates all pages of the campaign's website are targeted. This
	// field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	Conditions []*GoogleAdsSearchads360V0Common__WebpageConditionInfo `json:"conditions,omitempty"`

	// CoveragePercentage: Website criteria coverage percentage. This is the
	// computed percentage of website coverage based on the website target,
	// negative website target and negative keywords in the ad group and
	// campaign. For instance, when coverage returns as 1, it indicates it
	// has 100% coverage. This field is read-only.
	CoveragePercentage float64 `json:"coveragePercentage,omitempty"`

	// CriterionName: The name of the criterion that is defined by this
	// parameter. The name value will be used for identifying, sorting and
	// filtering criteria with this type of parameters. This field is
	// required for CREATE operations and is prohibited on UPDATE
	// operations.
	CriterionName string `json:"criterionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conditions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__WebpageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__WebpageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Common__WebpageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Common__WebpageInfo
	var s1 struct {
		CoveragePercentage gensupport.JSONFloat64 `json:"coveragePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoveragePercentage = float64(s1.CoveragePercentage)
	return nil
}

// GoogleAdsSearchads360V0Common__YoutubeVideoAsset: A YouTube asset.
type GoogleAdsSearchads360V0Common__YoutubeVideoAsset struct {
	// YoutubeVideoId: YouTube video id. This is the 11 character string
	// value used in the YouTube video URL.
	YoutubeVideoId string `json:"youtubeVideoId,omitempty"`

	// YoutubeVideoTitle: YouTube video title.
	YoutubeVideoTitle string `json:"youtubeVideoTitle,omitempty"`

	// ForceSendFields is a list of field names (e.g. "YoutubeVideoId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "YoutubeVideoId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Common__YoutubeVideoAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Common__YoutubeVideoAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ErrorsErrorLocationFieldPathElement: A part of
// a field path.
type GoogleAdsSearchads360V0ErrorsErrorLocationFieldPathElement struct {
	// FieldName: The name of a field or a oneof
	FieldName string `json:"fieldName,omitempty"`

	// Index: If field_name is a repeated field, this is the element that
	// failed
	Index int64 `json:"index,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ErrorsErrorLocationFieldPathElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ErrorsErrorLocationFieldPathElement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Errors__ErrorCode: The error reason
// represented by type and enum.
type GoogleAdsSearchads360V0Errors__ErrorCode struct {
	// AuthenticationError: Indicates failure to properly authenticate user.
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "AUTHENTICATION_ERROR" - Authentication of the request failed.
	//   "CLIENT_CUSTOMER_ID_INVALID" - Client customer ID is not a number.
	//   "CUSTOMER_NOT_FOUND" - No customer found for the provided customer
	// ID.
	//   "GOOGLE_ACCOUNT_DELETED" - Client's Google account is deleted.
	//   "GOOGLE_ACCOUNT_COOKIE_INVALID" - Account login token in the cookie
	// is invalid.
	//   "GOOGLE_ACCOUNT_AUTHENTICATION_FAILED" - A problem occurred during
	// Google account authentication.
	//   "GOOGLE_ACCOUNT_USER_AND_ADS_USER_MISMATCH" - The user in the
	// Google account login token does not match the user ID in the cookie.
	//   "LOGIN_COOKIE_REQUIRED" - Login cookie is required for
	// authentication.
	//   "NOT_ADS_USER" - The Google account that generated the OAuth access
	// token is not associated with a Search Ads 360 account. Create a new
	// account, or add the Google account to an existing Search Ads 360
	// account.
	//   "OAUTH_TOKEN_INVALID" - OAuth token in the header is not valid.
	//   "OAUTH_TOKEN_EXPIRED" - OAuth token in the header has expired.
	//   "OAUTH_TOKEN_DISABLED" - OAuth token in the header has been
	// disabled.
	//   "OAUTH_TOKEN_REVOKED" - OAuth token in the header has been revoked.
	//   "OAUTH_TOKEN_HEADER_INVALID" - OAuth token HTTP header is
	// malformed.
	//   "LOGIN_COOKIE_INVALID" - Login cookie is not valid.
	//   "USER_ID_INVALID" - User ID in the header is not a valid ID.
	//   "TWO_STEP_VERIFICATION_NOT_ENROLLED" - An account administrator
	// changed this account's authentication settings. To access this
	// account, enable 2-Step Verification in your Google account at
	// https://www.google.com/landing/2step.
	//   "ADVANCED_PROTECTION_NOT_ENROLLED" - An account administrator
	// changed this account's authentication settings. To access this
	// account, enable Advanced Protection in your Google account at
	// https://landing.google.com/advancedprotection.
	AuthenticationError string `json:"authenticationError,omitempty"`

	// AuthorizationError: An error encountered when trying to authorize a
	// user.
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "USER_PERMISSION_DENIED" - User doesn't have permission to access
	// customer. Note: If you're accessing a client customer, the manager's
	// customer ID must be set in the `login-customer-id` header. Learn more
	// at
	// https://developers.google.com/search-ads/reporting/concepts/call-structure#login_customer_id_header
	//   "PROJECT_DISABLED" - The Google Cloud project sent in the request
	// does not have permission to access the api.
	//   "AUTHORIZATION_ERROR" - Authorization of the client failed.
	//   "ACTION_NOT_PERMITTED" - The user does not have permission to
	// perform this action (for example, ADD, UPDATE, REMOVE) on the
	// resource or call a method.
	//   "INCOMPLETE_SIGNUP" - Signup not complete.
	//   "CUSTOMER_NOT_ENABLED" - The customer account can't be accessed
	// because it is not yet enabled or has been deactivated.
	//   "MISSING_TOS" - The developer must sign the terms of service. They
	// can be found here: https://developers.google.com/terms
	//   "INVALID_LOGIN_CUSTOMER_ID_SERVING_CUSTOMER_ID_COMBINATION" - The
	// login customer specified does not have access to the account
	// specified, so the request is invalid.
	//   "SERVICE_ACCESS_DENIED" - The developer specified does not have
	// access to the service.
	//   "ACCESS_DENIED_FOR_ACCOUNT_TYPE" - The customer (or login customer)
	// isn't allowed in Search Ads 360 API. It belongs to another ads
	// system.
	//   "METRIC_ACCESS_DENIED" - The developer does not have access to the
	// metrics queried.
	AuthorizationError string `json:"authorizationError,omitempty"`

	// CustomColumnError: The reasons for the custom column error
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "CUSTOM_COLUMN_NOT_FOUND" - The custom column has not been found.
	//   "CUSTOM_COLUMN_NOT_AVAILABLE" - The custom column is not available.
	CustomColumnError string `json:"customColumnError,omitempty"`

	// DateError: The reasons for the date error
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "INVALID_FIELD_VALUES_IN_DATE" - Given field values do not
	// correspond to a valid date.
	//   "INVALID_FIELD_VALUES_IN_DATE_TIME" - Given field values do not
	// correspond to a valid date time.
	//   "INVALID_STRING_DATE" - The string date's format should be
	// yyyy-mm-dd.
	//   "INVALID_STRING_DATE_TIME_MICROS" - The string date time's format
	// should be yyyy-mm-dd hh:mm:ss.ssssss.
	//   "INVALID_STRING_DATE_TIME_SECONDS" - The string date time's format
	// should be yyyy-mm-dd hh:mm:ss.
	//   "INVALID_STRING_DATE_TIME_SECONDS_WITH_OFFSET" - The string date
	// time's format should be yyyy-mm-dd hh:mm:ss+|-hh:mm.
	//   "EARLIER_THAN_MINIMUM_DATE" - Date is before allowed minimum.
	//   "LATER_THAN_MAXIMUM_DATE" - Date is after allowed maximum.
	//   "DATE_RANGE_MINIMUM_DATE_LATER_THAN_MAXIMUM_DATE" - Date range
	// bounds are not in order.
	//   "DATE_RANGE_MINIMUM_AND_MAXIMUM_DATES_BOTH_NULL" - Both dates in
	// range are null.
	DateError string `json:"dateError,omitempty"`

	// DateRangeError: The reasons for the date range error
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "INVALID_DATE" - Invalid date.
	//   "START_DATE_AFTER_END_DATE" - The start date was after the end
	// date.
	//   "CANNOT_SET_DATE_TO_PAST" - Cannot set date to past time
	//   "AFTER_MAXIMUM_ALLOWABLE_DATE" - A date was used that is past the
	// system "last" date.
	//   "CANNOT_MODIFY_START_DATE_IF_ALREADY_STARTED" - Trying to change
	// start date on a resource that has started.
	DateRangeError string `json:"dateRangeError,omitempty"`

	// DistinctError: The reasons for the distinct error
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "DUPLICATE_ELEMENT" - Duplicate element.
	//   "DUPLICATE_TYPE" - Duplicate type.
	DistinctError string `json:"distinctError,omitempty"`

	// HeaderError: The reasons for the header error.
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "INVALID_USER_SELECTED_CUSTOMER_ID" - The user selected customer ID
	// could not be validated.
	//   "INVALID_LOGIN_CUSTOMER_ID" - The login customer ID could not be
	// validated.
	HeaderError string `json:"headerError,omitempty"`

	// InternalError: An unexpected server-side error.
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "INTERNAL_ERROR" - API encountered unexpected internal error.
	//   "ERROR_CODE_NOT_PUBLISHED" - The intended error code doesn't exist
	// in specified API version. It will be released in a future API
	// version.
	//   "TRANSIENT_ERROR" - API encountered an unexpected transient error.
	// The user should retry their request in these cases.
	//   "DEADLINE_EXCEEDED" - The request took longer than a deadline.
	InternalError string `json:"internalError,omitempty"`

	// InvalidParameterError: The reasons for invalid parameter errors.
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "INVALID_CURRENCY_CODE" - The specified currency code is invalid.
	InvalidParameterError string `json:"invalidParameterError,omitempty"`

	// QueryError: An error with the query
	//
	// Possible values:
	//   "UNSPECIFIED" - Name unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "QUERY_ERROR" - Returned if all other query error reasons are not
	// applicable.
	//   "BAD_ENUM_CONSTANT" - A condition used in the query references an
	// invalid enum constant.
	//   "BAD_ESCAPE_SEQUENCE" - Query contains an invalid escape sequence.
	//   "BAD_FIELD_NAME" - Field name is invalid.
	//   "BAD_LIMIT_VALUE" - Limit value is invalid (for example, not a
	// number)
	//   "BAD_NUMBER" - Encountered number can not be parsed.
	//   "BAD_OPERATOR" - Invalid operator encountered.
	//   "BAD_PARAMETER_NAME" - Parameter unknown or not supported.
	//   "BAD_PARAMETER_VALUE" - Parameter have invalid value.
	//   "BAD_RESOURCE_TYPE_IN_FROM_CLAUSE" - Invalid resource type was
	// specified in the FROM clause.
	//   "BAD_SYMBOL" - Non-ASCII symbol encountered outside of strings.
	//   "BAD_VALUE" - Value is invalid.
	//   "DATE_RANGE_TOO_WIDE" - Date filters fail to restrict date to a
	// range smaller than 31 days. Applicable if the query is segmented by
	// date.
	//   "DATE_RANGE_TOO_NARROW" - Filters on date/week/month/quarter have a
	// start date after end date.
	//   "EXPECTED_AND" - Expected AND between values with BETWEEN operator.
	//   "EXPECTED_BY" - Expecting ORDER BY to have BY.
	//   "EXPECTED_DIMENSION_FIELD_IN_SELECT_CLAUSE" - There was no
	// dimension field selected.
	//   "EXPECTED_FILTERS_ON_DATE_RANGE" - Missing filters on date related
	// fields.
	//   "EXPECTED_FROM" - Missing FROM clause.
	//   "EXPECTED_LIST" - The operator used in the conditions requires the
	// value to be a list.
	//   "EXPECTED_REFERENCED_FIELD_IN_SELECT_CLAUSE" - Fields used in WHERE
	// or ORDER BY clauses are missing from the SELECT clause.
	//   "EXPECTED_SELECT" - SELECT is missing at the beginning of query.
	//   "EXPECTED_SINGLE_VALUE" - A list was passed as a value to a
	// condition whose operator expects a single value.
	//   "EXPECTED_VALUE_WITH_BETWEEN_OPERATOR" - Missing one or both values
	// with BETWEEN operator.
	//   "INVALID_DATE_FORMAT" - Invalid date format. Expected 'YYYY-MM-DD'.
	//   "MISALIGNED_DATE_FOR_FILTER" - Misaligned date value for the
	// filter. The date should be the start of a week/month/quarter if the
	// filtered field is segments.week/segments.month/segments.quarter.
	//   "INVALID_STRING_VALUE" - Value passed was not a string when it
	// should have been. For example, it was a number or unquoted literal.
	//   "INVALID_VALUE_WITH_BETWEEN_OPERATOR" - A String value passed to
	// the BETWEEN operator does not parse as a date.
	//   "INVALID_VALUE_WITH_DURING_OPERATOR" - The value passed to the
	// DURING operator is not a Date range literal
	//   "INVALID_VALUE_WITH_LIKE_OPERATOR" - A value was passed to the LIKE
	// operator.
	//   "OPERATOR_FIELD_MISMATCH" - An operator was provided that is
	// inapplicable to the field being filtered.
	//   "PROHIBITED_EMPTY_LIST_IN_CONDITION" - A Condition was found with
	// an empty list.
	//   "PROHIBITED_ENUM_CONSTANT" - A condition used in the query
	// references an unsupported enum constant.
	//   "PROHIBITED_FIELD_COMBINATION_IN_SELECT_CLAUSE" - Fields that are
	// not allowed to be selected together were included in the SELECT
	// clause.
	//   "PROHIBITED_FIELD_IN_ORDER_BY_CLAUSE" - A field that is not
	// orderable was included in the ORDER BY clause.
	//   "PROHIBITED_FIELD_IN_SELECT_CLAUSE" - A field that is not
	// selectable was included in the SELECT clause.
	//   "PROHIBITED_FIELD_IN_WHERE_CLAUSE" - A field that is not filterable
	// was included in the WHERE clause.
	//   "PROHIBITED_RESOURCE_TYPE_IN_FROM_CLAUSE" - Resource type specified
	// in the FROM clause is not supported by this service.
	//   "PROHIBITED_RESOURCE_TYPE_IN_SELECT_CLAUSE" - A field that comes
	// from an incompatible resource was included in the SELECT clause.
	//   "PROHIBITED_RESOURCE_TYPE_IN_WHERE_CLAUSE" - A field that comes
	// from an incompatible resource was included in the WHERE clause.
	//   "PROHIBITED_METRIC_IN_SELECT_OR_WHERE_CLAUSE" - A metric
	// incompatible with the main resource or other selected segmenting
	// resources was included in the SELECT or WHERE clause.
	//   "PROHIBITED_SEGMENT_IN_SELECT_OR_WHERE_CLAUSE" - A segment
	// incompatible with the main resource or other selected segmenting
	// resources was included in the SELECT or WHERE clause.
	//   "PROHIBITED_SEGMENT_WITH_METRIC_IN_SELECT_OR_WHERE_CLAUSE" - A
	// segment in the SELECT clause is incompatible with a metric in the
	// SELECT or WHERE clause.
	//   "LIMIT_VALUE_TOO_LOW" - The value passed to the limit clause is too
	// low.
	//   "PROHIBITED_NEWLINE_IN_STRING" - Query has a string containing a
	// newline character.
	//   "PROHIBITED_VALUE_COMBINATION_IN_LIST" - List contains values of
	// different types.
	//   "PROHIBITED_VALUE_COMBINATION_WITH_BETWEEN_OPERATOR" - The values
	// passed to the BETWEEN operator are not of the same type.
	//   "STRING_NOT_TERMINATED" - Query contains unterminated string.
	//   "TOO_MANY_SEGMENTS" - Too many segments are specified in SELECT
	// clause.
	//   "UNEXPECTED_END_OF_QUERY" - Query is incomplete and cannot be
	// parsed.
	//   "UNEXPECTED_FROM_CLAUSE" - FROM clause cannot be specified in this
	// query.
	//   "UNRECOGNIZED_FIELD" - Query contains one or more unrecognized
	// fields.
	//   "UNEXPECTED_INPUT" - Query has an unexpected extra part.
	//   "REQUESTED_METRICS_FOR_MANAGER" - Metrics cannot be requested for a
	// manager account. To retrieve metrics, issue separate requests against
	// each client account under the manager account.
	//   "FILTER_HAS_TOO_MANY_VALUES" - The number of values
	// (right-hand-side operands) in a filter exceeds the limit.
	QueryError string `json:"queryError,omitempty"`

	// QuotaError: An error with the amount of quota remaining.
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "RESOURCE_EXHAUSTED" - Too many requests.
	//   "RESOURCE_TEMPORARILY_EXHAUSTED" - Too many requests in a short
	// amount of time.
	QuotaError string `json:"quotaError,omitempty"`

	// RequestError: An error caused by the request
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "RESOURCE_NAME_MISSING" - Resource name is required for this
	// request.
	//   "RESOURCE_NAME_MALFORMED" - Resource name provided is malformed.
	//   "BAD_RESOURCE_ID" - Resource name provided is malformed.
	//   "INVALID_PRODUCT_NAME" - Product name is invalid.
	//   "INVALID_CUSTOMER_ID" - Customer ID is invalid.
	//   "OPERATION_REQUIRED" - Mutate operation should have either create,
	// update, or remove specified.
	//   "RESOURCE_NOT_FOUND" - Requested resource not found.
	//   "INVALID_PAGE_TOKEN" - Next page token specified in user request is
	// invalid.
	//   "EXPIRED_PAGE_TOKEN" - Next page token specified in user request
	// has expired.
	//   "INVALID_PAGE_SIZE" - Page size specified in user request is
	// invalid.
	//   "REQUIRED_FIELD_MISSING" - Required field is missing.
	//   "IMMUTABLE_FIELD" - The field cannot be modified because it's
	// immutable. It's also possible that the field can be modified using
	// 'create' operation but not 'update'.
	//   "TOO_MANY_MUTATE_OPERATIONS" - Received too many entries in
	// request.
	//   "CANNOT_BE_EXECUTED_BY_MANAGER_ACCOUNT" - Request cannot be
	// executed by a manager account.
	//   "CANNOT_MODIFY_FOREIGN_FIELD" - Mutate request was attempting to
	// modify a readonly field. For instance, Budget fields can be requested
	// for Ad Group, but are read-only for adGroups:mutate.
	//   "INVALID_ENUM_VALUE" - Enum value is not permitted.
	//   "LOGIN_CUSTOMER_ID_PARAMETER_MISSING" - The login-customer-id
	// parameter is required for this request.
	//   "LOGIN_OR_LINKED_CUSTOMER_ID_PARAMETER_REQUIRED" - Either
	// login-customer-id or linked-customer-id parameter is required for
	// this request.
	//   "VALIDATE_ONLY_REQUEST_HAS_PAGE_TOKEN" - page_token is set in the
	// validate only request
	//   "CANNOT_RETURN_SUMMARY_ROW_FOR_REQUEST_WITHOUT_METRICS" -
	// return_summary_row cannot be enabled if request did not select any
	// metrics field.
	//   "CANNOT_RETURN_SUMMARY_ROW_FOR_VALIDATE_ONLY_REQUESTS" -
	// return_summary_row should not be enabled for validate only requests.
	//   "INCONSISTENT_RETURN_SUMMARY_ROW_VALUE" - return_summary_row
	// parameter value should be the same between requests with page_token
	// field set and their original request.
	//   "TOTAL_RESULTS_COUNT_NOT_ORIGINALLY_REQUESTED" - The total results
	// count cannot be returned if it was not requested in the original
	// request.
	//   "RPC_DEADLINE_TOO_SHORT" - Deadline specified by the client was too
	// short.
	//   "PRODUCT_NOT_SUPPORTED" - The product associated with the request
	// is not supported for the current request.
	RequestError string `json:"requestError,omitempty"`

	// SizeLimitError: The reasons for the size limit error
	//
	// Possible values:
	//   "UNSPECIFIED" - Enum unspecified.
	//   "UNKNOWN" - The received error code is not known in this version.
	//   "REQUEST_SIZE_LIMIT_EXCEEDED" - The number of entries in the
	// request exceeds the system limit, or the contents of the operations
	// exceed transaction limits due to their size or complexity. Try
	// reducing the number of entries per request.
	//   "RESPONSE_SIZE_LIMIT_EXCEEDED" - The number of entries in the
	// response exceeds the system limit.
	SizeLimitError string `json:"sizeLimitError,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuthenticationError")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthenticationError") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Errors__ErrorCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Errors__ErrorCode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Errors__ErrorDetails: Additional error
// details.
type GoogleAdsSearchads360V0Errors__ErrorDetails struct {
	// QuotaErrorDetails: Details on the quota error, including the scope
	// (account or developer), the rate bucket name and the retry delay.
	QuotaErrorDetails *GoogleAdsSearchads360V0Errors__QuotaErrorDetails `json:"quotaErrorDetails,omitempty"`

	// UnpublishedErrorCode: The error code that should have been returned,
	// but wasn't. This is used when the error code is not published in the
	// client specified version.
	UnpublishedErrorCode string `json:"unpublishedErrorCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QuotaErrorDetails")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QuotaErrorDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Errors__ErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Errors__ErrorDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Errors__ErrorLocation: Describes the part of
// the request proto that caused the error.
type GoogleAdsSearchads360V0Errors__ErrorLocation struct {
	// FieldPathElements: A field path that indicates which field was
	// invalid in the request.
	FieldPathElements []*GoogleAdsSearchads360V0ErrorsErrorLocationFieldPathElement `json:"fieldPathElements,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldPathElements")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldPathElements") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Errors__ErrorLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Errors__ErrorLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Errors__QuotaErrorDetails: Additional quota
// error details when there is QuotaError.
type GoogleAdsSearchads360V0Errors__QuotaErrorDetails struct {
	// RateName: The high level description of the quota bucket. Examples
	// are "Get requests for standard access" or "Requests per account".
	RateName string `json:"rateName,omitempty"`

	// RateScope: The rate scope of the quota limit.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unspecified enum
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ACCOUNT" - Per customer account quota
	//   "DEVELOPER" - Per project quota
	RateScope string `json:"rateScope,omitempty"`

	// RetryDelay: Backoff period that customers should wait before sending
	// next request.
	RetryDelay string `json:"retryDelay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RateName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RateName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Errors__QuotaErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Errors__QuotaErrorDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Errors__SearchAds360Error:
// SearchAds360-specific error.
type GoogleAdsSearchads360V0Errors__SearchAds360Error struct {
	// Details: Additional error details, which are returned by certain
	// error codes. Most error codes do not include details.
	Details *GoogleAdsSearchads360V0Errors__ErrorDetails `json:"details,omitempty"`

	// ErrorCode: An enum value that indicates which error occurred.
	ErrorCode *GoogleAdsSearchads360V0Errors__ErrorCode `json:"errorCode,omitempty"`

	// Location: Describes the part of the request proto that caused the
	// error.
	Location *GoogleAdsSearchads360V0Errors__ErrorLocation `json:"location,omitempty"`

	// Message: A human-readable description of the error.
	Message string `json:"message,omitempty"`

	// Trigger: The value that triggered the error.
	Trigger *GoogleAdsSearchads360V0Common__Value `json:"trigger,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Details") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Details") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Errors__SearchAds360Error) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Errors__SearchAds360Error
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Errors__SearchAds360Failure: Describes how a
// Search Ads 360 API call failed. It's returned inside
// google.rpc.Status.details when a call fails.
type GoogleAdsSearchads360V0Errors__SearchAds360Failure struct {
	// Errors: The list of errors that occurred.
	Errors []*GoogleAdsSearchads360V0Errors__SearchAds360Error `json:"errors,omitempty"`

	// RequestId: The unique ID of the request that is used for debugging
	// purposes.
	RequestId string `json:"requestId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Errors__SearchAds360Failure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Errors__SearchAds360Failure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesAdGroupCriterionPositionEstimates:
// Estimates for criterion bids at various positions.
type GoogleAdsSearchads360V0ResourcesAdGroupCriterionPositionEstimates struct {
	// TopOfPageCpcMicros: Output only. The estimate of the CPC bid required
	// for ad to be displayed at the top of the first page of search
	// results.
	TopOfPageCpcMicros int64 `json:"topOfPageCpcMicros,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "TopOfPageCpcMicros")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TopOfPageCpcMicros") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesAdGroupCriterionPositionEstimates) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesAdGroupCriterionPositionEstimates
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesAdGroupCriterionQualityInfo: A
// container for ad group criterion quality information.
type GoogleAdsSearchads360V0ResourcesAdGroupCriterionQualityInfo struct {
	// QualityScore: Output only. The quality score. This field may not be
	// populated if Google does not have enough information to determine a
	// value.
	QualityScore int64 `json:"qualityScore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QualityScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QualityScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesAdGroupCriterionQualityInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesAdGroupCriterionQualityInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignDynamicSearchAdsSetting: The
// setting for controlling Dynamic Search Ads (DSA).
type GoogleAdsSearchads360V0ResourcesCampaignDynamicSearchAdsSetting struct {
	// DomainName: Required. The Internet domain name that this setting
	// represents, for example, "google.com" or "www.google.com".
	DomainName string `json:"domainName,omitempty"`

	// LanguageCode: Required. The language code specifying the language of
	// the domain, for example, "en".
	LanguageCode string `json:"languageCode,omitempty"`

	// UseSuppliedUrlsOnly: Whether the campaign uses advertiser supplied
	// URLs exclusively.
	UseSuppliedUrlsOnly bool `json:"useSuppliedUrlsOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DomainName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DomainName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignDynamicSearchAdsSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignDynamicSearchAdsSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignGeoTargetTypeSetting:
// Represents a collection of settings related to ads geotargeting.
type GoogleAdsSearchads360V0ResourcesCampaignGeoTargetTypeSetting struct {
	// NegativeGeoTargetType: The setting used for negative geotargeting in
	// this particular campaign.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "PRESENCE_OR_INTEREST" - Specifies that a user is excluded from
	// seeing the ad if they are in, or show interest in, advertiser's
	// excluded locations.
	//   "PRESENCE" - Specifies that a user is excluded from seeing the ad
	// if they are in advertiser's excluded locations.
	NegativeGeoTargetType string `json:"negativeGeoTargetType,omitempty"`

	// PositiveGeoTargetType: The setting used for positive geotargeting in
	// this particular campaign.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - The value is unknown in this version.
	//   "PRESENCE_OR_INTEREST" - Specifies that an ad is triggered if the
	// user is in, or shows interest in, advertiser's targeted locations.
	//   "SEARCH_INTEREST" - Specifies that an ad is triggered if the user
	// searches for advertiser's targeted locations. This can only be used
	// with Search and standard Shopping campaigns.
	//   "PRESENCE" - Specifies that an ad is triggered if the user is in or
	// regularly in advertiser's targeted locations.
	PositiveGeoTargetType string `json:"positiveGeoTargetType,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "NegativeGeoTargetType") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NegativeGeoTargetType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignGeoTargetTypeSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignGeoTargetTypeSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignNetworkSettings: The network
// settings for the campaign.
type GoogleAdsSearchads360V0ResourcesCampaignNetworkSettings struct {
	// TargetContentNetwork: Whether ads will be served on specified
	// placements in the Google Display Network. Placements are specified
	// using the Placement criterion.
	TargetContentNetwork bool `json:"targetContentNetwork,omitempty"`

	// TargetGoogleSearch: Whether ads will be served with google.com search
	// results.
	TargetGoogleSearch bool `json:"targetGoogleSearch,omitempty"`

	// TargetPartnerSearchNetwork: Whether ads will be served on the Google
	// Partner Network. This is available only to some select Google partner
	// accounts.
	TargetPartnerSearchNetwork bool `json:"targetPartnerSearchNetwork,omitempty"`

	// TargetSearchNetwork: Whether ads will be served on partner sites in
	// the Google Search Network (requires `target_google_search` to also be
	// `true`).
	TargetSearchNetwork bool `json:"targetSearchNetwork,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "TargetContentNetwork") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetContentNetwork") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignNetworkSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignNetworkSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignOptimizationGoalSetting:
// Optimization goal setting for this campaign, which includes a set of
// optimization goal types.
type GoogleAdsSearchads360V0ResourcesCampaignOptimizationGoalSetting struct {
	// OptimizationGoalTypes: The list of optimization goal types.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used as a return value only. Represents value unknown
	// in this version.
	//   "CALL_CLICKS" - Optimize for call clicks. Call click conversions
	// are times people selected 'Call' to contact a store after viewing an
	// ad.
	//   "DRIVING_DIRECTIONS" - Optimize for driving directions. Driving
	// directions conversions are times people selected 'Get directions' to
	// navigate to a store after viewing an ad.
	//   "APP_PRE_REGISTRATION" - Optimize for pre-registration.
	// Pre-registration conversions are the number of pre-registration
	// signups to receive a notification when the app is released.
	OptimizationGoalTypes []string `json:"optimizationGoalTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "OptimizationGoalTypes") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptimizationGoalTypes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignOptimizationGoalSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignOptimizationGoalSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignSelectiveOptimization:
// Selective optimization setting for this campaign, which includes a
// set of conversion actions to optimize this campaign towards. This
// feature only applies to app campaigns that use MULTI_CHANNEL as
// AdvertisingChannelType and APP_CAMPAIGN or
// APP_CAMPAIGN_FOR_ENGAGEMENT as AdvertisingChannelSubType.
type GoogleAdsSearchads360V0ResourcesCampaignSelectiveOptimization struct {
	// ConversionActions: The selected set of conversion actions for
	// optimizing this campaign.
	ConversionActions []string `json:"conversionActions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConversionActions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversionActions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignSelectiveOptimization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignSelectiveOptimization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignShoppingSetting: The setting
// for Shopping campaigns. Defines the universe of products that can be
// advertised by the campaign, and how this campaign interacts with
// other Shopping campaigns.
type GoogleAdsSearchads360V0ResourcesCampaignShoppingSetting struct {
	// CampaignPriority: Priority of the campaign. Campaigns with
	// numerically higher priorities take precedence over those with lower
	// priorities. This field is required for Shopping campaigns, with
	// values between 0 and 2, inclusive. This field is optional for Smart
	// Shopping campaigns, but must be equal to 3 if set.
	CampaignPriority int64 `json:"campaignPriority,omitempty"`

	// EnableLocal: Whether to include local products.
	EnableLocal bool `json:"enableLocal,omitempty"`

	// FeedLabel: Feed label of products to include in the campaign. Only
	// one of feed_label or sales_country can be set. If used instead of
	// sales_country, the feed_label field accepts country codes in the same
	// format for example: 'XX'. Otherwise can be any string used for feed
	// label in Google Merchant Center.
	FeedLabel string `json:"feedLabel,omitempty"`

	// MerchantId: Immutable. ID of the Merchant Center account. This field
	// is required for create operations. This field is immutable for
	// Shopping campaigns.
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// SalesCountry: Sales country of products to include in the campaign.
	SalesCountry string `json:"salesCountry,omitempty"`

	// UseVehicleInventory: Immutable. Whether to target Vehicle Listing
	// inventory.
	UseVehicleInventory bool `json:"useVehicleInventory,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CampaignPriority") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CampaignPriority") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignShoppingSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignShoppingSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesCampaignTrackingSetting:
// Campaign-level settings for tracking information.
type GoogleAdsSearchads360V0ResourcesCampaignTrackingSetting struct {
	// TrackingUrl: Output only. The url used for dynamic tracking.
	TrackingUrl string `json:"trackingUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TrackingUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TrackingUrl") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesCampaignTrackingSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesCampaignTrackingSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesConversionActionAttributionModelSettin
// gs: Settings related to this conversion action's attribution model.
type GoogleAdsSearchads360V0ResourcesConversionActionAttributionModelSettings struct {
	// AttributionModel: The attribution model type of this conversion
	// action.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "EXTERNAL" - Uses external attribution.
	//   "GOOGLE_ADS_LAST_CLICK" - Attributes all credit for a conversion to
	// its last click.
	//   "GOOGLE_SEARCH_ATTRIBUTION_FIRST_CLICK" - Attributes all credit for
	// a conversion to its first click using Google Search attribution.
	//   "GOOGLE_SEARCH_ATTRIBUTION_LINEAR" - Attributes credit for a
	// conversion equally across all of its clicks using Google Search
	// attribution.
	//   "GOOGLE_SEARCH_ATTRIBUTION_TIME_DECAY" - Attributes exponentially
	// more credit for a conversion to its more recent clicks using Google
	// Search attribution (half-life is 1 week).
	//   "GOOGLE_SEARCH_ATTRIBUTION_POSITION_BASED" - Attributes 40% of the
	// credit for a conversion to its first and last clicks. Remaining 20%
	// is evenly distributed across all other clicks. This uses Google
	// Search attribution.
	//   "GOOGLE_SEARCH_ATTRIBUTION_DATA_DRIVEN" - Flexible model that uses
	// machine learning to determine the appropriate distribution of credit
	// among clicks using Google Search attribution.
	AttributionModel string `json:"attributionModel,omitempty"`

	// DataDrivenModelStatus: Output only. The status of the data-driven
	// attribution model for the conversion action.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "AVAILABLE" - The data driven model is available.
	//   "STALE" - The data driven model is stale. It hasn't been updated
	// for at least 7 days. It is still being used, but will become expired
	// if it does not get updated for 30 days.
	//   "EXPIRED" - The data driven model expired. It hasn't been updated
	// for at least 30 days and cannot be used. Most commonly this is
	// because there hasn't been the required number of events in a recent
	// 30-day period.
	//   "NEVER_GENERATED" - The data driven model has never been generated.
	// Most commonly this is because there has never been the required
	// number of events in any 30-day period.
	DataDrivenModelStatus string `json:"dataDrivenModelStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributionModel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionModel") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesConversionActionAttributionModelSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesConversionActionAttributionModelSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesConversionActionFloodlightSettings:
// Settings related to a Floodlight conversion action.
type GoogleAdsSearchads360V0ResourcesConversionActionFloodlightSettings struct {
	// ActivityGroupTag: Output only. String used to identify a Floodlight
	// activity group when reporting conversions.
	ActivityGroupTag string `json:"activityGroupTag,omitempty"`

	// ActivityId: Output only. ID of the Floodlight activity in DoubleClick
	// Campaign Manager (DCM).
	ActivityId int64 `json:"activityId,omitempty,string"`

	// ActivityTag: Output only. String used to identify a Floodlight
	// activity when reporting conversions.
	ActivityTag string `json:"activityTag,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActivityGroupTag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActivityGroupTag") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesConversionActionFloodlightSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesConversionActionFloodlightSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesConversionActionValueSettings:
// Settings related to the value for conversion events associated with
// this conversion action.
type GoogleAdsSearchads360V0ResourcesConversionActionValueSettings struct {
	// AlwaysUseDefaultValue: Controls whether the default value and default
	// currency code are used in place of the value and currency code
	// specified in conversion events for this conversion action.
	AlwaysUseDefaultValue bool `json:"alwaysUseDefaultValue,omitempty"`

	// DefaultCurrencyCode: The currency code to use when conversion events
	// for this conversion action are sent with an invalid or missing
	// currency code, or when this conversion action is configured to always
	// use the default value.
	DefaultCurrencyCode string `json:"defaultCurrencyCode,omitempty"`

	// DefaultValue: The value to use when conversion events for this
	// conversion action are sent with an invalid, disallowed or missing
	// value, or when this conversion action is configured to always use the
	// default value.
	DefaultValue float64 `json:"defaultValue,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AlwaysUseDefaultValue") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlwaysUseDefaultValue") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesConversionActionValueSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesConversionActionValueSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0ResourcesConversionActionValueSettings) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0ResourcesConversionActionValueSettings
	var s1 struct {
		DefaultValue gensupport.JSONFloat64 `json:"defaultValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DefaultValue = float64(s1.DefaultValue)
	return nil
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBidd
// ingCategory: One element of a bidding category at a certain level.
// Top-level categories are at level 1, their children at level 2, and
// so on. We currently support up to 5 levels. The user must specify a
// dimension type that indicates the level of the category. All cases of
// the same subdivision must have the same dimension type (category
// level).
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBiddingCategory struct {
	// Id: ID of the product bidding category. This ID is equivalent to the
	// google_product_category ID as described in this article:
	// https://support.google.com/merchants/answer/6324436
	Id int64 `json:"id,omitempty,string"`

	// Level: Indicates the level of the category in the taxonomy.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "LEVEL1" - Level 1.
	//   "LEVEL2" - Level 2.
	//   "LEVEL3" - Level 3.
	//   "LEVEL4" - Level 4.
	//   "LEVEL5" - Level 5.
	Level string `json:"level,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBiddingCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBiddingCategory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBran
// d: Brand of the product.
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBrand struct {
	// Value: String value of the product brand.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBrand) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBrand
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductChan
// nel: Locality of a product offer.
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductChannel struct {
	// Channel: Value of the locality.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ONLINE" - The item is sold online.
	//   "LOCAL" - The item is sold in local stores.
	Channel string `json:"channel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Channel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Channel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductChannel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductChannel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCond
// ition: Condition of a product offer.
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCondition struct {
	// Condition: Value of the condition.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "NEW" - The product condition is new.
	//   "REFURBISHED" - The product condition is refurbished.
	//   "USED" - The product condition is used.
	Condition string `json:"condition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCondition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCust
// omAttribute: Custom attribute of a product offer.
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCustomAttribute struct {
	// Index: Indicates the index of the custom attribute.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "INDEX0" - First listing group filter custom attribute.
	//   "INDEX1" - Second listing group filter custom attribute.
	//   "INDEX2" - Third listing group filter custom attribute.
	//   "INDEX3" - Fourth listing group filter custom attribute.
	//   "INDEX4" - Fifth listing group filter custom attribute.
	Index string `json:"index,omitempty"`

	// Value: String value of the product custom attribute.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Index") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCustomAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductItem
// Id: Item id of a product offer.
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductItemId struct {
	// Value: Value of the id.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductItemId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductItemId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductType
// : Type of a product offer.
type GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductType struct {
	// Level: Level of the type.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "LEVEL1" - Level 1.
	//   "LEVEL2" - Level 2.
	//   "LEVEL3" - Level 3.
	//   "LEVEL4" - Level 4.
	//   "LEVEL5" - Level 5.
	Level string `json:"level,omitempty"`

	// Value: Value of the type.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Level") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Level") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Ad: An ad.
type GoogleAdsSearchads360V0Resources__Ad struct {
	// DisplayUrl: The URL that appears in the ad description for some ad
	// formats.
	DisplayUrl string `json:"displayUrl,omitempty"`

	// ExpandedDynamicSearchAd: Immutable. Details pertaining to an expanded
	// dynamic search ad.
	ExpandedDynamicSearchAd *GoogleAdsSearchads360V0Common__SearchAds360ExpandedDynamicSearchAdInfo `json:"expandedDynamicSearchAd,omitempty"`

	// ExpandedTextAd: Immutable. Details pertaining to an expanded text ad.
	ExpandedTextAd *GoogleAdsSearchads360V0Common__SearchAds360ExpandedTextAdInfo `json:"expandedTextAd,omitempty"`

	// FinalUrls: The list of possible final URLs after all cross-domain
	// redirects for the ad.
	FinalUrls []string `json:"finalUrls,omitempty"`

	// Id: Output only. The ID of the ad.
	Id int64 `json:"id,omitempty,string"`

	// Name: Immutable. The name of the ad. This is only used to be able to
	// identify the ad. It does not need to be unique and does not affect
	// the served ad. The name field is currently only supported for
	// DisplayUploadAd, ImageAd, ShoppingComparisonListingAd and VideoAd.
	Name string `json:"name,omitempty"`

	// ProductAd: Immutable. Details pertaining to a product ad.
	ProductAd *GoogleAdsSearchads360V0Common__SearchAds360ProductAdInfo `json:"productAd,omitempty"`

	// ResourceName: Immutable. The resource name of the ad. Ad resource
	// names have the form: `customers/{customer_id}/ads/{ad_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ResponsiveSearchAd: Immutable. Details pertaining to a responsive
	// search ad.
	ResponsiveSearchAd *GoogleAdsSearchads360V0Common__SearchAds360ResponsiveSearchAdInfo `json:"responsiveSearchAd,omitempty"`

	// TextAd: Immutable. Details pertaining to a text ad.
	TextAd *GoogleAdsSearchads360V0Common__SearchAds360TextAdInfo `json:"textAd,omitempty"`

	// Type: Output only. The type of ad.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "TEXT_AD" - The ad is a text ad.
	//   "EXPANDED_TEXT_AD" - The ad is an expanded text ad.
	//   "CALL_ONLY_AD" - The ad is a call only ad.
	//   "EXPANDED_DYNAMIC_SEARCH_AD" - The ad is an expanded dynamic search
	// ad.
	//   "HOTEL_AD" - The ad is a hotel ad.
	//   "SHOPPING_SMART_AD" - The ad is a Smart Shopping ad.
	//   "SHOPPING_PRODUCT_AD" - The ad is a standard Shopping ad.
	//   "VIDEO_AD" - The ad is a video ad.
	//   "GMAIL_AD" - This ad is a Gmail ad.
	//   "IMAGE_AD" - This ad is an Image ad.
	//   "RESPONSIVE_SEARCH_AD" - The ad is a responsive search ad.
	//   "LEGACY_RESPONSIVE_DISPLAY_AD" - The ad is a legacy responsive
	// display ad.
	//   "APP_AD" - The ad is an app ad.
	//   "LEGACY_APP_INSTALL_AD" - The ad is a legacy app install ad.
	//   "RESPONSIVE_DISPLAY_AD" - The ad is a responsive display ad.
	//   "LOCAL_AD" - The ad is a local ad.
	//   "HTML5_UPLOAD_AD" - The ad is a display upload ad with the
	// HTML5_UPLOAD_AD product type.
	//   "DYNAMIC_HTML5_AD" - The ad is a display upload ad with one of the
	// DYNAMIC_HTML5_* product types.
	//   "APP_ENGAGEMENT_AD" - The ad is an app engagement ad.
	//   "SHOPPING_COMPARISON_LISTING_AD" - The ad is a Shopping Comparison
	// Listing ad.
	//   "VIDEO_BUMPER_AD" - Video bumper ad.
	//   "VIDEO_NON_SKIPPABLE_IN_STREAM_AD" - Video non-skippable in-stream
	// ad.
	//   "VIDEO_OUTSTREAM_AD" - Video outstream ad.
	//   "VIDEO_TRUEVIEW_DISCOVERY_AD" - Video TrueView in-display ad.
	//   "VIDEO_TRUEVIEW_IN_STREAM_AD" - Video TrueView in-stream ad.
	//   "VIDEO_RESPONSIVE_AD" - Video responsive ad.
	//   "SMART_CAMPAIGN_AD" - Smart campaign ad.
	//   "APP_PRE_REGISTRATION_AD" - Universal app pre-registration ad.
	//   "DISCOVERY_MULTI_ASSET_AD" - Discovery multi asset ad.
	//   "DISCOVERY_CAROUSEL_AD" - Discovery carousel ad.
	//   "TRAVEL_AD" - Travel ad.
	//   "DISCOVERY_VIDEO_RESPONSIVE_AD" - Discovery video responsive ad.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Ad) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Ad
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroup: An ad group.
type GoogleAdsSearchads360V0Resources__AdGroup struct {
	// AdRotationMode: The ad rotation mode of the ad group.
	//
	// Possible values:
	//   "UNSPECIFIED" - The ad rotation mode has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "OPTIMIZE" - Optimize ad group ads based on clicks or conversions.
	//   "ROTATE_FOREVER" - Rotate evenly forever.
	AdRotationMode string `json:"adRotationMode,omitempty"`

	// CpcBidMicros: The maximum CPC (cost-per-click) bid.
	CpcBidMicros int64 `json:"cpcBidMicros,omitempty,string"`

	// CreationTime: Output only. The timestamp when this ad_group was
	// created. The timestamp is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss" format.
	CreationTime string `json:"creationTime,omitempty"`

	// EndDate: Output only. Date when the ad group ends serving ads. By
	// default, the ad group ends on the ad group's end date. If this field
	// is set, then the ad group ends at the end of the specified date in
	// the customer's time zone. This field is only available for Microsoft
	// Advertising and Facebook gateway accounts. Format: YYYY-MM-DD
	// Example: 2019-03-14
	EndDate string `json:"endDate,omitempty"`

	// EngineId: Output only. ID of the ad group in the external engine
	// account. This field is for non-Google Ads account only, for example,
	// Yahoo Japan, Microsoft, Baidu etc. For Google Ads entity, use
	// "ad_group.id" instead.
	EngineId string `json:"engineId,omitempty"`

	// EngineStatus: Output only. The Engine Status for ad group.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "AD_GROUP_ELIGIBLE" - Deprecated. Do not use.
	//   "AD_GROUP_EXPIRED" - No ads are running for this ad group, because
	// the ad group's end date has passed.
	//   "AD_GROUP_REMOVED" - The ad group has been deleted.
	//   "AD_GROUP_DRAFT" - No ads are running for this ad group because the
	// associated ad group is still in draft form.
	//   "AD_GROUP_PAUSED" - The ad group has been paused.
	//   "AD_GROUP_SERVING" - The ad group is active and currently serving
	// ads.
	//   "AD_GROUP_SUBMITTED" - The ad group has been submitted (Microsoft
	// Bing Ads legacy status).
	//   "CAMPAIGN_PAUSED" - No ads are running for this ad group, because
	// the campaign has been paused.
	//   "ACCOUNT_PAUSED" - No ads are running for this ad group, because
	// the account has been paused.
	EngineStatus string `json:"engineStatus,omitempty"`

	// Id: Output only. The ID of the ad group.
	Id int64 `json:"id,omitempty,string"`

	// Labels: Output only. The resource names of labels attached to this ad
	// group.
	Labels []string `json:"labels,omitempty"`

	// LanguageCode: Output only. The language of the ads and keywords in an
	// ad group. This field is only available for Microsoft Advertising
	// accounts. More details:
	// https://docs.microsoft.com/en-us/advertising/guides/ad-languages?view=bingads-13#adlanguage
	LanguageCode string `json:"languageCode,omitempty"`

	// LastModifiedTime: Output only. The datetime when this ad group was
	// last modified. The datetime is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// Name: The name of the ad group. This field is required and should not
	// be empty when creating new ad groups. It must contain fewer than 255
	// UTF-8 full-width characters. It must not contain any null (code point
	// 0x0), NL line feed (code point 0xA) or carriage return (code point
	// 0xD) characters.
	Name string `json:"name,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group. Ad group
	// resource names have the form:
	// `customers/{customer_id}/adGroups/{ad_group_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// StartDate: Output only. Date when this ad group starts serving ads.
	// By default, the ad group starts now or the ad group's start date,
	// whichever is later. If this field is set, then the ad group starts at
	// the beginning of the specified date in the customer's time zone. This
	// field is only available for Microsoft Advertising and Facebook
	// gateway accounts. Format: YYYY-MM-DD Example: 2019-03-14
	StartDate string `json:"startDate,omitempty"`

	// Status: The status of the ad group.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The ad group is enabled.
	//   "PAUSED" - The ad group is paused.
	//   "REMOVED" - The ad group is removed.
	Status string `json:"status,omitempty"`

	// TargetingSetting: Setting for targeting related features.
	TargetingSetting *GoogleAdsSearchads360V0Common__TargetingSetting `json:"targetingSetting,omitempty"`

	// Type: Immutable. The type of the ad group.
	//
	// Possible values:
	//   "UNSPECIFIED" - The type has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "SEARCH_STANDARD" - The default ad group type for Search campaigns.
	//   "DISPLAY_STANDARD" - The default ad group type for Display
	// campaigns.
	//   "SHOPPING_PRODUCT_ADS" - The ad group type for Shopping campaigns
	// serving standard product ads.
	//   "SHOPPING_SHOWCASE_ADS" - The type for ad groups that are limited
	// to serving Showcase or Merchant ads in Shopping results.
	//   "HOTEL_ADS" - The default ad group type for Hotel campaigns.
	//   "SHOPPING_SMART_ADS" - The type for ad groups in Smart Shopping
	// campaigns.
	//   "VIDEO_BUMPER" - Short unskippable in-stream video ads.
	//   "VIDEO_TRUE_VIEW_IN_STREAM" - TrueView (skippable) in-stream video
	// ads.
	//   "VIDEO_TRUE_VIEW_IN_DISPLAY" - TrueView in-display video ads.
	//   "VIDEO_NON_SKIPPABLE_IN_STREAM" - Unskippable in-stream video ads.
	//   "VIDEO_OUTSTREAM" - Outstream video ads.
	//   "SEARCH_DYNAMIC_ADS" - Ad group type for Dynamic Search Ads ad
	// groups.
	//   "SHOPPING_COMPARISON_LISTING_ADS" - The type for ad groups in
	// Shopping Comparison Listing campaigns.
	//   "PROMOTED_HOTEL_ADS" - The ad group type for Promoted Hotel ad
	// groups.
	//   "VIDEO_RESPONSIVE" - Video responsive ad groups.
	//   "VIDEO_EFFICIENT_REACH" - Video efficient reach ad groups.
	//   "SMART_CAMPAIGN_ADS" - Ad group type for Smart campaigns.
	//   "TRAVEL_ADS" - Ad group type for Travel campaigns.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdRotationMode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdRotationMode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupAd: An ad group ad.
type GoogleAdsSearchads360V0Resources__AdGroupAd struct {
	// Ad: Immutable. The ad.
	Ad *GoogleAdsSearchads360V0Resources__Ad `json:"ad,omitempty"`

	// CreationTime: Output only. The timestamp when this ad_group_ad was
	// created. The datetime is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss.ssssss" format.
	CreationTime string `json:"creationTime,omitempty"`

	// EngineId: Output only. ID of the ad in the external engine account.
	// This field is for SearchAds 360 account only, for example, Yahoo
	// Japan, Microsoft, Baidu etc. For non-SearchAds 360 entity, use
	// "ad_group_ad.ad.id" instead.
	EngineId string `json:"engineId,omitempty"`

	// EngineStatus: Output only. Additional status of the ad in the
	// external engine account. Possible statuses (depending on the type of
	// external account) include active, eligible, pending review, etc.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "AD_GROUP_AD_ELIGIBLE" - Deprecated. Do not use.
	//   "AD_GROUP_AD_INAPPROPRIATE_FOR_CAMPAIGN" - Baidu: Creative was not
	// approved.
	//   "AD_GROUP_AD_MOBILE_URL_UNDER_REVIEW" - Baidu: Mobile URL in
	// process to be reviewed.
	//   "AD_GROUP_AD_PARTIALLY_INVALID" - Baidu: Creative is invalid on
	// mobile device but valid on desktop.
	//   "AD_GROUP_AD_TO_BE_ACTIVATED" - Baidu: Creative is ready for
	// activation.
	//   "AD_GROUP_AD_NOT_REVIEWED" - Baidu: Creative not reviewed.
	//   "AD_GROUP_AD_ON_HOLD" - Deprecated. Do not use. Previously used by
	// Gemini
	//   "AD_GROUP_AD_PAUSED" - Creative has been paused.
	//   "AD_GROUP_AD_REMOVED" - Creative has been removed.
	//   "AD_GROUP_AD_PENDING_REVIEW" - Creative is pending review.
	//   "AD_GROUP_AD_UNDER_REVIEW" - Creative is under review.
	//   "AD_GROUP_AD_APPROVED" - Creative has been approved.
	//   "AD_GROUP_AD_DISAPPROVED" - Creative has been disapproved.
	//   "AD_GROUP_AD_SERVING" - Creative is serving.
	//   "AD_GROUP_AD_ACCOUNT_PAUSED" - Creative has been paused because the
	// account is paused.
	//   "AD_GROUP_AD_CAMPAIGN_PAUSED" - Creative has been paused because
	// the campaign is paused.
	//   "AD_GROUP_AD_AD_GROUP_PAUSED" - Creative has been paused because
	// the ad group is paused.
	EngineStatus string `json:"engineStatus,omitempty"`

	// Labels: Output only. The resource names of labels attached to this ad
	// group ad.
	Labels []string `json:"labels,omitempty"`

	// LastModifiedTime: Output only. The datetime when this ad group ad was
	// last modified. The datetime is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// ResourceName: Immutable. The resource name of the ad. Ad group ad
	// resource names have the form:
	// `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: The status of the ad.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The ad group ad is enabled.
	//   "PAUSED" - The ad group ad is paused.
	//   "REMOVED" - The ad group ad is removed.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ad") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ad") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupAd) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupAd
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupAdLabel: A relationship
// between an ad group ad and a label.
type GoogleAdsSearchads360V0Resources__AdGroupAdLabel struct {
	// AdGroupAd: Immutable. The ad group ad to which the label is attached.
	AdGroupAd string `json:"adGroupAd,omitempty"`

	// Label: Immutable. The label assigned to the ad group ad.
	Label string `json:"label,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group ad label.
	// Ad group ad label resource names have the form:
	// `customers/{customer_id}/adGroupAdLabels/{ad_group_id}~{ad_id}~{label_
	// id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroupAd") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroupAd") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupAdLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupAdLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupAsset: A link between an ad
// group and an asset.
type GoogleAdsSearchads360V0Resources__AdGroupAsset struct {
	// AdGroup: Required. Immutable. The ad group to which the asset is
	// linked.
	AdGroup string `json:"adGroup,omitempty"`

	// Asset: Required. Immutable. The asset which is linked to the ad
	// group.
	Asset string `json:"asset,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group asset.
	// AdGroupAsset resource names have the form:
	// `customers/{customer_id}/adGroupAssets/{ad_group_id}~{asset_id}~{field
	// _type}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Status of the ad group asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Asset link is enabled.
	//   "REMOVED" - Asset link has been removed.
	//   "PAUSED" - Asset link is paused.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupAssetSet: AdGroupAssetSet is
// the linkage between an ad group and an asset set. Creating an
// AdGroupAssetSet links an asset set with an ad group.
type GoogleAdsSearchads360V0Resources__AdGroupAssetSet struct {
	// AdGroup: Immutable. The ad group to which this asset set is linked.
	AdGroup string `json:"adGroup,omitempty"`

	// AssetSet: Immutable. The asset set which is linked to the ad group.
	AssetSet string `json:"assetSet,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group asset set.
	// Ad group asset set resource names have the form:
	// `customers/{customer_id}/adGroupAssetSets/{ad_group_id}~{asset_set_id}
	// `
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the ad group asset set. Read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The linkage between asset set and its container is
	// enabled.
	//   "REMOVED" - The linkage between asset set and its container is
	// removed.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupAssetSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupAssetSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupAudienceView: An ad group
// audience view. Includes performance data from interests and
// remarketing lists for Display Network and YouTube Network ads, and
// remarketing lists for search ads (RLSA), aggregated at the audience
// level.
type GoogleAdsSearchads360V0Resources__AdGroupAudienceView struct {
	// ResourceName: Output only. The resource name of the ad group audience
	// view. Ad group audience view resource names have the form:
	// `customers/{customer_id}/adGroupAudienceViews/{ad_group_id}~{criterion
	// _id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupAudienceView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupAudienceView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupBidModifier: Represents an
// ad group bid modifier.
type GoogleAdsSearchads360V0Resources__AdGroupBidModifier struct {
	// BidModifier: The modifier for the bid when the criterion matches. The
	// modifier must be in the range: 0.1 - 10.0. The range is 1.0 - 6.0 for
	// PreferredContent. Use 0 to opt out of a Device type.
	BidModifier float64 `json:"bidModifier,omitempty"`

	// Device: Immutable. A device criterion.
	Device *GoogleAdsSearchads360V0Common__DeviceInfo `json:"device,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group bid
	// modifier. Ad group bid modifier resource names have the form:
	// `customers/{customer_id}/adGroupBidModifiers/{ad_group_id}~{criterion_
	// id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BidModifier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BidModifier") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupBidModifier) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupBidModifier
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupBidModifier) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupBidModifier
	var s1 struct {
		BidModifier gensupport.JSONFloat64 `json:"bidModifier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BidModifier = float64(s1.BidModifier)
	return nil
}

// GoogleAdsSearchads360V0Resources__AdGroupCriterion: An ad group
// criterion.
type GoogleAdsSearchads360V0Resources__AdGroupCriterion struct {
	// AdGroup: Immutable. The ad group to which the criterion belongs.
	AdGroup string `json:"adGroup,omitempty"`

	// AgeRange: Immutable. Age range.
	AgeRange *GoogleAdsSearchads360V0Common__AgeRangeInfo `json:"ageRange,omitempty"`

	// BidModifier: The modifier for the bid when the criterion matches. The
	// modifier must be in the range: 0.1 - 10.0. Most targetable criteria
	// types support modifiers.
	BidModifier float64 `json:"bidModifier,omitempty"`

	// CpcBidMicros: The CPC (cost-per-click) bid.
	CpcBidMicros int64 `json:"cpcBidMicros,omitempty,string"`

	// CreationTime: Output only. The timestamp when this ad group criterion
	// was created. The timestamp is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss" format.
	CreationTime string `json:"creationTime,omitempty"`

	// CriterionId: Output only. The ID of the criterion.
	CriterionId int64 `json:"criterionId,omitempty,string"`

	// EffectiveCpcBidMicros: Output only. The effective CPC
	// (cost-per-click) bid.
	EffectiveCpcBidMicros int64 `json:"effectiveCpcBidMicros,omitempty,string"`

	// EngineId: Output only. ID of the ad group criterion in the external
	// engine account. This field is for non-Google Ads account only, for
	// example, Yahoo Japan, Microsoft, Baidu etc. For Google Ads entity,
	// use "ad_group_criterion.criterion_id" instead.
	EngineId string `json:"engineId,omitempty"`

	// EngineStatus: Output only. The Engine Status for ad group criterion.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "AD_GROUP_CRITERION_ELIGIBLE" - Deprecated. Do not use.
	//   "AD_GROUP_CRITERION_INAPPROPRIATE_FOR_CAMPAIGN" - Baidu: Bid or
	// quality too low to be displayed.
	//   "AD_GROUP_CRITERION_INVALID_MOBILE_SEARCH" - Baidu: Bid or quality
	// too low for mobile, but eligible to display for desktop.
	//   "AD_GROUP_CRITERION_INVALID_PC_SEARCH" - Baidu: Bid or quality too
	// low for desktop, but eligible to display for mobile.
	//   "AD_GROUP_CRITERION_INVALID_SEARCH" - Baidu: Bid or quality too low
	// to be displayed.
	//   "AD_GROUP_CRITERION_LOW_SEARCH_VOLUME" - Baidu: Paused by Baidu due
	// to low search volume.
	//   "AD_GROUP_CRITERION_MOBILE_URL_UNDER_REVIEW" - Baidu: Mobile URL in
	// process to be reviewed.
	//   "AD_GROUP_CRITERION_PARTIALLY_INVALID" - Baidu: The landing page
	// for one device is invalid, while the landing page for the other
	// device is valid.
	//   "AD_GROUP_CRITERION_TO_BE_ACTIVATED" - Baidu: Keyword has been
	// created and paused by Baidu account management, and is now ready for
	// you to activate it.
	//   "AD_GROUP_CRITERION_UNDER_REVIEW" - Baidu: In process to be
	// reviewed by Baidu. Gemini: Criterion under review.
	//   "AD_GROUP_CRITERION_NOT_REVIEWED" - Baidu: Criterion to be
	// reviewed.
	//   "AD_GROUP_CRITERION_ON_HOLD" - Deprecated. Do not use. Previously
	// used by Gemini
	//   "AD_GROUP_CRITERION_PENDING_REVIEW" - Y!J : Criterion pending
	// review
	//   "AD_GROUP_CRITERION_PAUSED" - Criterion has been paused.
	//   "AD_GROUP_CRITERION_REMOVED" - Criterion has been removed.
	//   "AD_GROUP_CRITERION_APPROVED" - Criterion has been approved.
	//   "AD_GROUP_CRITERION_DISAPPROVED" - Criterion has been disapproved.
	//   "AD_GROUP_CRITERION_SERVING" - Criterion is active and serving.
	//   "AD_GROUP_CRITERION_ACCOUNT_PAUSED" - Criterion has been paused
	// since the account is paused.
	EngineStatus string `json:"engineStatus,omitempty"`

	// FinalUrlSuffix: URL template for appending params to final URL.
	FinalUrlSuffix string `json:"finalUrlSuffix,omitempty"`

	// FinalUrls: The list of possible final URLs after all cross-domain
	// redirects for the ad.
	FinalUrls []string `json:"finalUrls,omitempty"`

	// Gender: Immutable. Gender.
	Gender *GoogleAdsSearchads360V0Common__GenderInfo `json:"gender,omitempty"`

	// Keyword: Immutable. Keyword.
	Keyword *GoogleAdsSearchads360V0Common__KeywordInfo `json:"keyword,omitempty"`

	// Labels: Output only. The resource names of labels attached to this ad
	// group criterion.
	Labels []string `json:"labels,omitempty"`

	// LastModifiedTime: Output only. The datetime when this ad group
	// criterion was last modified. The datetime is in the customer's time
	// zone and in "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// ListingGroup: Immutable. Listing group.
	ListingGroup *GoogleAdsSearchads360V0Common__ListingGroupInfo `json:"listingGroup,omitempty"`

	// Location: Immutable. Location.
	Location *GoogleAdsSearchads360V0Common__LocationInfo `json:"location,omitempty"`

	// Negative: Immutable. Whether to target (`false`) or exclude (`true`)
	// the criterion. This field is immutable. To switch a criterion from
	// positive to negative, remove then re-add it.
	Negative bool `json:"negative,omitempty"`

	// PositionEstimates: Output only. Estimates for criterion bids at
	// various positions.
	PositionEstimates *GoogleAdsSearchads360V0ResourcesAdGroupCriterionPositionEstimates `json:"positionEstimates,omitempty"`

	// QualityInfo: Output only. Information regarding the quality of the
	// criterion.
	QualityInfo *GoogleAdsSearchads360V0ResourcesAdGroupCriterionQualityInfo `json:"qualityInfo,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}~{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: The status of the criterion. This is the status of the ad
	// group criterion entity, set by the client. Note: UI reports may
	// incorporate additional information that affects whether a criterion
	// is eligible to run. In some cases a criterion that's REMOVED in the
	// API can still show as enabled in the UI. For example, campaigns by
	// default show to users of all age ranges unless excluded. The UI will
	// show each age range as "enabled", since they're eligible to see the
	// ads; but AdGroupCriterion.status will show "removed", since no
	// positive criterion was added.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The ad group criterion is enabled.
	//   "PAUSED" - The ad group criterion is paused.
	//   "REMOVED" - The ad group criterion is removed.
	Status string `json:"status,omitempty"`

	// TrackingUrlTemplate: The URL template for constructing a tracking
	// URL.
	TrackingUrlTemplate string `json:"trackingUrlTemplate,omitempty"`

	// Type: Output only. The type of the criterion.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "KEYWORD" - Keyword, for example, 'mars cruise'.
	//   "PLACEMENT" - Placement, also known as Website, for example,
	// 'www.flowers4sale.com'
	//   "MOBILE_APP_CATEGORY" - Mobile application categories to target.
	//   "MOBILE_APPLICATION" - Mobile applications to target.
	//   "DEVICE" - Devices to target.
	//   "LOCATION" - Locations to target.
	//   "LISTING_GROUP" - Listing groups to target.
	//   "AD_SCHEDULE" - Ad Schedule.
	//   "AGE_RANGE" - Age range.
	//   "GENDER" - Gender.
	//   "INCOME_RANGE" - Income Range.
	//   "PARENTAL_STATUS" - Parental status.
	//   "YOUTUBE_VIDEO" - YouTube Video.
	//   "YOUTUBE_CHANNEL" - YouTube Channel.
	//   "USER_LIST" - User list.
	//   "PROXIMITY" - Proximity.
	//   "TOPIC" - A topic target on the display network (for example, "Pets
	// & Animals").
	//   "LISTING_SCOPE" - Listing scope to target.
	//   "LANGUAGE" - Language.
	//   "IP_BLOCK" - IpBlock.
	//   "CONTENT_LABEL" - Content Label for category exclusion.
	//   "CARRIER" - Carrier.
	//   "USER_INTEREST" - A category the user is interested in.
	//   "WEBPAGE" - Webpage criterion for dynamic search ads.
	//   "OPERATING_SYSTEM_VERSION" - Operating system version.
	//   "APP_PAYMENT_MODEL" - App payment model.
	//   "MOBILE_DEVICE" - Mobile device.
	//   "CUSTOM_AFFINITY" - Custom affinity.
	//   "CUSTOM_INTENT" - Custom intent.
	//   "LOCATION_GROUP" - Location group.
	//   "CUSTOM_AUDIENCE" - Custom audience
	//   "COMBINED_AUDIENCE" - Combined audience
	//   "KEYWORD_THEME" - Smart Campaign keyword theme
	//   "AUDIENCE" - Audience
	//   "LOCAL_SERVICE_ID" - Local Services Ads Service ID.
	//   "BRAND" - Brand
	//   "BRAND_LIST" - Brand List
	Type string `json:"type,omitempty"`

	// UserList: Immutable. User List. The Similar Audiences sunset starts
	// May 2023. Refer to
	// https://ads-developers.googleblog.com/2022/11/announcing-deprecation-and-sunset-of.html
	// for other options.
	UserList *GoogleAdsSearchads360V0Common__UserListInfo `json:"userList,omitempty"`

	// Webpage: Immutable. Webpage
	Webpage *GoogleAdsSearchads360V0Common__WebpageInfo `json:"webpage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupCriterion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupCriterion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupCriterion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupCriterion
	var s1 struct {
		BidModifier gensupport.JSONFloat64 `json:"bidModifier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BidModifier = float64(s1.BidModifier)
	return nil
}

// GoogleAdsSearchads360V0Resources__AdGroupCriterionLabel: A
// relationship between an ad group criterion and a label.
type GoogleAdsSearchads360V0Resources__AdGroupCriterionLabel struct {
	// AdGroupCriterion: Immutable. The ad group criterion to which the
	// label is attached.
	AdGroupCriterion string `json:"adGroupCriterion,omitempty"`

	// Label: Immutable. The label assigned to the ad group criterion.
	Label string `json:"label,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group criterion
	// label. Ad group criterion label resource names have the form:
	// `customers/{customer_id}/adGroupCriterionLabels/{ad_group_id}~{criteri
	// on_id}~{label_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroupCriterion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroupCriterion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupCriterionLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupCriterionLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AdGroupLabel: A relationship
// between an ad group and a label.
type GoogleAdsSearchads360V0Resources__AdGroupLabel struct {
	// AdGroup: Immutable. The ad group to which the label is attached.
	AdGroup string `json:"adGroup,omitempty"`

	// Label: Immutable. The label assigned to the ad group.
	Label string `json:"label,omitempty"`

	// ResourceName: Immutable. The resource name of the ad group label. Ad
	// group label resource names have the form:
	// `customers/{customer_id}/adGroupLabels/{ad_group_id}~{label_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AdGroupLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AdGroupLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AgeRangeView: An age range view.
type GoogleAdsSearchads360V0Resources__AgeRangeView struct {
	// ResourceName: Output only. The resource name of the age range view.
	// Age range view resource names have the form:
	// `customers/{customer_id}/ageRangeViews/{ad_group_id}~{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AgeRangeView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AgeRangeView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Asset: Asset is a part of an ad
// which can be shared across multiple ads. It can be an image
// (ImageAsset), a video (YoutubeVideoAsset), etc. Assets are immutable
// and cannot be removed. To stop an asset from serving, remove the
// asset from the entity that is using it.
type GoogleAdsSearchads360V0Resources__Asset struct {
	// CallAsset: Output only. A unified call asset.
	CallAsset *GoogleAdsSearchads360V0Common__UnifiedCallAsset `json:"callAsset,omitempty"`

	// CallToActionAsset: Immutable. A call to action asset.
	CallToActionAsset *GoogleAdsSearchads360V0Common__CallToActionAsset `json:"callToActionAsset,omitempty"`

	// CalloutAsset: Output only. A unified callout asset.
	CalloutAsset *GoogleAdsSearchads360V0Common__UnifiedCalloutAsset `json:"calloutAsset,omitempty"`

	// CreationTime: Output only. The timestamp when this asset was created.
	// The timestamp is in the customer's time zone and in "yyyy-MM-dd
	// HH:mm:ss" format.
	CreationTime string `json:"creationTime,omitempty"`

	// EngineStatus: Output only. The Engine Status for an asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "SERVING" - The asset is active.
	//   "SERVING_LIMITED" - The asset is active limited.
	//   "DISAPPROVED" - The asset is disapproved (not eligible).
	//   "DISABLED" - The asset is inactive (pending).
	//   "REMOVED" - The asset has been removed.
	EngineStatus string `json:"engineStatus,omitempty"`

	// FinalUrls: A list of possible final URLs after all cross domain
	// redirects.
	FinalUrls []string `json:"finalUrls,omitempty"`

	// Id: Output only. The ID of the asset.
	Id int64 `json:"id,omitempty,string"`

	// ImageAsset: Output only. An image asset.
	ImageAsset *GoogleAdsSearchads360V0Common__ImageAsset `json:"imageAsset,omitempty"`

	// LastModifiedTime: Output only. The datetime when this asset was last
	// modified. The datetime is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// LocationAsset: Output only. A unified location asset.
	LocationAsset *GoogleAdsSearchads360V0Common__UnifiedLocationAsset `json:"locationAsset,omitempty"`

	// MobileAppAsset: A mobile app asset.
	MobileAppAsset *GoogleAdsSearchads360V0Common__MobileAppAsset `json:"mobileAppAsset,omitempty"`

	// Name: Optional name of the asset.
	Name string `json:"name,omitempty"`

	// PageFeedAsset: Output only. A unified page feed asset.
	PageFeedAsset *GoogleAdsSearchads360V0Common__UnifiedPageFeedAsset `json:"pageFeedAsset,omitempty"`

	// ResourceName: Immutable. The resource name of the asset. Asset
	// resource names have the form:
	// `customers/{customer_id}/assets/{asset_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// SitelinkAsset: Output only. A unified sitelink asset.
	SitelinkAsset *GoogleAdsSearchads360V0Common__UnifiedSitelinkAsset `json:"sitelinkAsset,omitempty"`

	// Status: Output only. The status of the asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The asset is enabled.
	//   "REMOVED" - The asset is removed.
	//   "ARCHIVED" - The asset is archived.
	//   "PENDING_SYSTEM_GENERATED" - The asset is system generated pending
	// user review.
	Status string `json:"status,omitempty"`

	// TextAsset: Output only. A text asset.
	TextAsset *GoogleAdsSearchads360V0Common__TextAsset `json:"textAsset,omitempty"`

	// TrackingUrlTemplate: URL template for constructing a tracking URL.
	TrackingUrlTemplate string `json:"trackingUrlTemplate,omitempty"`

	// Type: Output only. Type of the asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "YOUTUBE_VIDEO" - YouTube video asset.
	//   "MEDIA_BUNDLE" - Media bundle asset.
	//   "IMAGE" - Image asset.
	//   "TEXT" - Text asset.
	//   "LEAD_FORM" - Lead form asset.
	//   "BOOK_ON_GOOGLE" - Book on Google asset.
	//   "PROMOTION" - Promotion asset.
	//   "CALLOUT" - Callout asset.
	//   "STRUCTURED_SNIPPET" - Structured Snippet asset.
	//   "SITELINK" - Sitelink asset.
	//   "PAGE_FEED" - Page Feed asset.
	//   "DYNAMIC_EDUCATION" - Dynamic Education asset.
	//   "MOBILE_APP" - Mobile app asset.
	//   "HOTEL_CALLOUT" - Hotel callout asset.
	//   "CALL" - Call asset.
	//   "PRICE" - Price asset.
	//   "CALL_TO_ACTION" - Call to action asset.
	//   "DYNAMIC_REAL_ESTATE" - Dynamic real estate asset.
	//   "DYNAMIC_CUSTOM" - Dynamic custom asset.
	//   "DYNAMIC_HOTELS_AND_RENTALS" - Dynamic hotels and rentals asset.
	//   "DYNAMIC_FLIGHTS" - Dynamic flights asset.
	//   "DISCOVERY_CAROUSEL_CARD" - Discovery Carousel Card asset.
	//   "DYNAMIC_TRAVEL" - Dynamic travel asset.
	//   "DYNAMIC_LOCAL" - Dynamic local asset.
	//   "DYNAMIC_JOBS" - Dynamic jobs asset.
	//   "LOCATION" - Location asset.
	//   "HOTEL_PROPERTY" - Hotel property asset.
	Type string `json:"type,omitempty"`

	// YoutubeVideoAsset: Immutable. A YouTube video asset.
	YoutubeVideoAsset *GoogleAdsSearchads360V0Common__YoutubeVideoAsset `json:"youtubeVideoAsset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallAsset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallAsset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Asset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Asset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetGroup: An asset group.
// AssetGroupAsset is used to link an asset to the asset group.
// AssetGroupSignal is used to associate a signal to an asset group.
type GoogleAdsSearchads360V0Resources__AssetGroup struct {
	// AdStrength: Output only. Overall ad strength of this asset group.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "PENDING" - The ad strength is currently pending.
	//   "NO_ADS" - No ads could be generated.
	//   "POOR" - Poor strength.
	//   "AVERAGE" - Average strength.
	//   "GOOD" - Good strength.
	//   "EXCELLENT" - Excellent strength.
	AdStrength string `json:"adStrength,omitempty"`

	// Campaign: Immutable. The campaign with which this asset group is
	// associated. The asset which is linked to the asset group.
	Campaign string `json:"campaign,omitempty"`

	// FinalMobileUrls: A list of final mobile URLs after all cross domain
	// redirects. In performance max, by default, the urls are eligible for
	// expansion unless opted out.
	FinalMobileUrls []string `json:"finalMobileUrls,omitempty"`

	// FinalUrls: A list of final URLs after all cross domain redirects. In
	// performance max, by default, the urls are eligible for expansion
	// unless opted out.
	FinalUrls []string `json:"finalUrls,omitempty"`

	// Id: Output only. The ID of the asset group.
	Id int64 `json:"id,omitempty,string"`

	// Name: Required. Name of the asset group. Required. It must have a
	// minimum length of 1 and maximum length of 128. It must be unique
	// under a campaign.
	Name string `json:"name,omitempty"`

	// Path1: First part of text that may appear appended to the url
	// displayed in the ad.
	Path1 string `json:"path1,omitempty"`

	// Path2: Second part of text that may appear appended to the url
	// displayed in the ad. This field can only be set when path1 is set.
	Path2 string `json:"path2,omitempty"`

	// ResourceName: Immutable. The resource name of the asset group. Asset
	// group resource names have the form:
	// `customers/{customer_id}/assetGroups/{asset_group_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: The status of the asset group.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version.
	//   "ENABLED" - The asset group is enabled.
	//   "PAUSED" - The asset group is paused.
	//   "REMOVED" - The asset group is removed.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdStrength") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdStrength") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetGroupAsset: AssetGroupAsset is
// the link between an asset and an asset group. Adding an
// AssetGroupAsset links an asset with an asset group.
type GoogleAdsSearchads360V0Resources__AssetGroupAsset struct {
	// Asset: Immutable. The asset which this asset group asset is linking.
	Asset string `json:"asset,omitempty"`

	// AssetGroup: Immutable. The asset group which this asset group asset
	// is linking.
	AssetGroup string `json:"assetGroup,omitempty"`

	// FieldType: The description of the placement of the asset within the
	// asset group. For example: HEADLINE, YOUTUBE_VIDEO etc
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "HEADLINE" - The asset is linked for use as a headline.
	//   "DESCRIPTION" - The asset is linked for use as a description.
	//   "MANDATORY_AD_TEXT" - The asset is linked for use as mandatory ad
	// text.
	//   "MARKETING_IMAGE" - The asset is linked for use as a marketing
	// image.
	//   "MEDIA_BUNDLE" - The asset is linked for use as a media bundle.
	//   "YOUTUBE_VIDEO" - The asset is linked for use as a YouTube video.
	//   "BOOK_ON_GOOGLE" - The asset is linked to indicate that a hotels
	// campaign is "Book on Google" enabled.
	//   "LEAD_FORM" - The asset is linked for use as a Lead Form extension.
	//   "PROMOTION" - The asset is linked for use as a Promotion extension.
	//   "CALLOUT" - The asset is linked for use as a Callout extension.
	//   "STRUCTURED_SNIPPET" - The asset is linked for use as a Structured
	// Snippet extension.
	//   "SITELINK" - The asset is linked for use as a Sitelink.
	//   "MOBILE_APP" - The asset is linked for use as a Mobile App
	// extension.
	//   "HOTEL_CALLOUT" - The asset is linked for use as a Hotel Callout
	// extension.
	//   "CALL" - The asset is linked for use as a Call extension.
	//   "PRICE" - The asset is linked for use as a Price extension.
	//   "LONG_HEADLINE" - The asset is linked for use as a long headline.
	//   "BUSINESS_NAME" - The asset is linked for use as a business name.
	//   "SQUARE_MARKETING_IMAGE" - The asset is linked for use as a square
	// marketing image.
	//   "PORTRAIT_MARKETING_IMAGE" - The asset is linked for use as a
	// portrait marketing image.
	//   "LOGO" - The asset is linked for use as a logo.
	//   "LANDSCAPE_LOGO" - The asset is linked for use as a landscape logo.
	//   "VIDEO" - The asset is linked for use as a non YouTube logo.
	//   "CALL_TO_ACTION_SELECTION" - The asset is linked for use to select
	// a call-to-action.
	//   "AD_IMAGE" - The asset is linked for use to select an ad image.
	//   "BUSINESS_LOGO" - The asset is linked for use as a business logo.
	//   "HOTEL_PROPERTY" - The asset is linked for use as a hotel property
	// in a Performance Max for travel goals campaign.
	FieldType string `json:"fieldType,omitempty"`

	// ResourceName: Immutable. The resource name of the asset group asset.
	// Asset group asset resource name have the form:
	// `customers/{customer_id}/assetGroupAssets/{asset_group_id}~{asset_id}~
	// {field_type}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: The status of the link between an asset and asset group.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Asset link is enabled.
	//   "REMOVED" - Asset link has been removed.
	//   "PAUSED" - Asset link is paused.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetGroupAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetGroupAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetGroupAssetCombinationData:
// Asset group asset combination data
type GoogleAdsSearchads360V0Resources__AssetGroupAssetCombinationData struct {
	// AssetCombinationServedAssets: Output only. Served assets.
	AssetCombinationServedAssets []*GoogleAdsSearchads360V0Common__AssetUsage `json:"assetCombinationServedAssets,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AssetCombinationServedAssets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AssetCombinationServedAssets") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetGroupAssetCombinationData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetGroupAssetCombinationData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetGroupListingGroupFilter:
// AssetGroupListingGroupFilter represents a listing group filter tree
// node in an asset group.
type GoogleAdsSearchads360V0Resources__AssetGroupListingGroupFilter struct {
	// AssetGroup: Immutable. The asset group which this asset group listing
	// group filter is part of.
	AssetGroup string `json:"assetGroup,omitempty"`

	// CaseValue: Dimension value with which this listing group is refining
	// its parent. Undefined for the root group.
	CaseValue *GoogleAdsSearchads360V0Resources__ListingGroupFilterDimension `json:"caseValue,omitempty"`

	// Id: Output only. The ID of the ListingGroupFilter.
	Id int64 `json:"id,omitempty,string"`

	// ParentListingGroupFilter: Immutable. Resource name of the parent
	// listing group subdivision. Null for the root listing group filter
	// node.
	ParentListingGroupFilter string `json:"parentListingGroupFilter,omitempty"`

	// Path: Output only. The path of dimensions defining this listing group
	// filter.
	Path *GoogleAdsSearchads360V0Resources__ListingGroupFilterDimensionPath `json:"path,omitempty"`

	// ResourceName: Immutable. The resource name of the asset group listing
	// group filter. Asset group listing group filter resource name have the
	// form:
	// `customers/{customer_id}/assetGroupListingGroupFilters/{asset_group_id
	// }~{listing_group_filter_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Type: Immutable. Type of a listing group filter node.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "SUBDIVISION" - Subdivision of products along some listing
	// dimensions.
	//   "UNIT_INCLUDED" - An included listing group filter leaf node.
	//   "UNIT_EXCLUDED" - An excluded listing group filter leaf node.
	Type string `json:"type,omitempty"`

	// Vertical: Immutable. The vertical the current node tree represents.
	// All nodes in the same tree must belong to the same vertical.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "SHOPPING" - Represents the shopping vertical.
	Vertical string `json:"vertical,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetGroupListingGroupFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetGroupListingGroupFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetGroupSignal: AssetGroupSignal
// represents a signal in an asset group. The existence of a signal
// tells the performance max campaign who's most likely to convert.
// Performance Max uses the signal to look for new people with similar
// or stronger intent to find conversions across Search, Display, Video,
// and more.
type GoogleAdsSearchads360V0Resources__AssetGroupSignal struct {
	// AssetGroup: Immutable. The asset group which this asset group signal
	// belongs to.
	AssetGroup string `json:"assetGroup,omitempty"`

	// Audience: Immutable. The audience signal to be used by the
	// performance max campaign.
	Audience *GoogleAdsSearchads360V0Common__AudienceInfo `json:"audience,omitempty"`

	// ResourceName: Immutable. The resource name of the asset group signal.
	// Asset group signal resource name have the form:
	// `customers/{customer_id}/assetGroupSignals/{asset_group_id}~{signal_id
	// }`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetGroupSignal) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetGroupSignal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetGroupTopCombinationView: A
// view on the usage of ad group ad asset combination.
type GoogleAdsSearchads360V0Resources__AssetGroupTopCombinationView struct {
	// AssetGroupTopCombinations: Output only. The top combinations of
	// assets that served together.
	AssetGroupTopCombinations []*GoogleAdsSearchads360V0Resources__AssetGroupAssetCombinationData `json:"assetGroupTopCombinations,omitempty"`

	// ResourceName: Output only. The resource name of the asset group top
	// combination view. AssetGroup Top Combination view resource names have
	// the form:
	// "customers/{customer_id}/assetGroupTopCombinationViews/{asset_group_i
	// d}~{asset_combination_category}"
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AssetGroupTopCombinations") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AssetGroupTopCombinations") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetGroupTopCombinationView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetGroupTopCombinationView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetSet: An asset set representing
// a collection of assets. Use AssetSetAsset to link an asset to the
// asset set.
type GoogleAdsSearchads360V0Resources__AssetSet struct {
	// Id: Output only. The ID of the asset set.
	Id int64 `json:"id,omitempty,string"`

	// ResourceName: Immutable. The resource name of the asset set. Asset
	// set resource names have the form:
	// `customers/{customer_id}/assetSets/{asset_set_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__AssetSetAsset: AssetSetAsset is the
// link between an asset and an asset set. Adding an AssetSetAsset links
// an asset with an asset set.
type GoogleAdsSearchads360V0Resources__AssetSetAsset struct {
	// Asset: Immutable. The asset which this asset set asset is linking to.
	Asset string `json:"asset,omitempty"`

	// AssetSet: Immutable. The asset set which this asset set asset is
	// linking to.
	AssetSet string `json:"assetSet,omitempty"`

	// ResourceName: Immutable. The resource name of the asset set asset.
	// Asset set asset resource names have the form:
	// `customers/{customer_id}/assetSetAssets/{asset_set_id}~{asset_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the asset set asset. Read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The asset set asset is enabled.
	//   "REMOVED" - The asset set asset is removed.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__AssetSetAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__AssetSetAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Audience: Audience is an effective
// targeting option that lets you intersect different segment
// attributes, such as detailed demographics and affinities, to create
// audiences that represent sections of your target segments.
type GoogleAdsSearchads360V0Resources__Audience struct {
	// Description: Description of this audience.
	Description string `json:"description,omitempty"`

	// Id: Output only. ID of the audience.
	Id int64 `json:"id,omitempty,string"`

	// Name: Required. Name of the audience. It should be unique across all
	// audiences. It must have a minimum length of 1 and maximum length of
	// 255.
	Name string `json:"name,omitempty"`

	// ResourceName: Immutable. The resource name of the audience. Audience
	// names have the form:
	// `customers/{customer_id}/audiences/{audience_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Audience) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Audience
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__BiddingStrategy: A bidding
// strategy.
type GoogleAdsSearchads360V0Resources__BiddingStrategy struct {
	// CampaignCount: Output only. The number of campaigns attached to this
	// bidding strategy. This field is read-only.
	CampaignCount int64 `json:"campaignCount,omitempty,string"`

	// CurrencyCode: Immutable. The currency used by the bidding strategy
	// (ISO 4217 three-letter code). For bidding strategies in manager
	// customers, this currency can be set on creation and defaults to the
	// manager customer's currency. For serving customers, this field cannot
	// be set; all strategies in a serving customer implicitly use the
	// serving customer's currency. In all cases the effective_currency_code
	// field returns the currency used by the strategy.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// EffectiveCurrencyCode: Output only. The currency used by the bidding
	// strategy (ISO 4217 three-letter code). For bidding strategies in
	// manager customers, this is the currency set by the advertiser when
	// creating the strategy. For serving customers, this is the customer's
	// currency_code. Bidding strategy metrics are reported in this
	// currency. This field is read-only.
	EffectiveCurrencyCode string `json:"effectiveCurrencyCode,omitempty"`

	// EnhancedCpc: A bidding strategy that raises bids for clicks that seem
	// more likely to lead to a conversion and lowers them for clicks where
	// they seem less likely.
	EnhancedCpc *GoogleAdsSearchads360V0Common__EnhancedCpc `json:"enhancedCpc,omitempty"`

	// Id: Output only. The ID of the bidding strategy.
	Id int64 `json:"id,omitempty,string"`

	// MaximizeConversionValue: An automated bidding strategy to help get
	// the most conversion value for your campaigns while spending your
	// budget.
	MaximizeConversionValue *GoogleAdsSearchads360V0Common__MaximizeConversionValue `json:"maximizeConversionValue,omitempty"`

	// MaximizeConversions: An automated bidding strategy to help get the
	// most conversions for your campaigns while spending your budget.
	MaximizeConversions *GoogleAdsSearchads360V0Common__MaximizeConversions `json:"maximizeConversions,omitempty"`

	// Name: The name of the bidding strategy. All bidding strategies within
	// an account must be named distinctly. The length of this string should
	// be between 1 and 255, inclusive, in UTF-8 bytes, (trimmed).
	Name string `json:"name,omitempty"`

	// NonRemovedCampaignCount: Output only. The number of non-removed
	// campaigns attached to this bidding strategy. This field is read-only.
	NonRemovedCampaignCount int64 `json:"nonRemovedCampaignCount,omitempty,string"`

	// ResourceName: Immutable. The resource name of the bidding strategy.
	// Bidding strategy resource names have the form:
	// `customers/{customer_id}/biddingStrategies/{bidding_strategy_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the bidding strategy. This field
	// is read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The bidding strategy is enabled.
	//   "REMOVED" - The bidding strategy is removed.
	Status string `json:"status,omitempty"`

	// TargetCpa: A bidding strategy that sets bids to help get as many
	// conversions as possible at the target cost-per-acquisition (CPA) you
	// set.
	TargetCpa *GoogleAdsSearchads360V0Common__TargetCpa `json:"targetCpa,omitempty"`

	// TargetImpressionShare: A bidding strategy that automatically
	// optimizes towards a chosen percentage of impressions.
	TargetImpressionShare *GoogleAdsSearchads360V0Common__TargetImpressionShare `json:"targetImpressionShare,omitempty"`

	// TargetOutrankShare: A bidding strategy that sets bids based on the
	// target fraction of auctions where the advertiser should outrank a
	// specific competitor. This field is deprecated. Creating a new bidding
	// strategy with this field or attaching bidding strategies with this
	// field to a campaign will fail. Mutates to strategies that already
	// have this scheme populated are allowed.
	TargetOutrankShare *GoogleAdsSearchads360V0Common__TargetOutrankShare `json:"targetOutrankShare,omitempty"`

	// TargetRoas: A bidding strategy that helps you maximize revenue while
	// averaging a specific target Return On Ad Spend (ROAS).
	TargetRoas *GoogleAdsSearchads360V0Common__TargetRoas `json:"targetRoas,omitempty"`

	// TargetSpend: A bid strategy that sets your bids to help get as many
	// clicks as possible within your budget.
	TargetSpend *GoogleAdsSearchads360V0Common__TargetSpend `json:"targetSpend,omitempty"`

	// Type: Output only. The type of the bidding strategy. Create a bidding
	// strategy by setting the bidding scheme. This field is read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "COMMISSION" - Commission is an automatic bidding strategy in which
	// the advertiser pays a certain portion of the conversion value.
	//   "ENHANCED_CPC" - Enhanced CPC is a bidding strategy that raises
	// bids for clicks that seem more likely to lead to a conversion and
	// lowers them for clicks where they seem less likely.
	//   "INVALID" - Used for return value only. Indicates that a campaign
	// does not have a bidding strategy. This prevents the campaign from
	// serving. For example, a campaign may be attached to a manager bidding
	// strategy and the serving account is subsequently unlinked from the
	// manager account. In this case the campaign will automatically be
	// detached from the now inaccessible manager bidding strategy and
	// transition to the INVALID bidding strategy type.
	//   "MANUAL_CPA" - Manual bidding strategy that allows advertiser to
	// set the bid per advertiser-specified action.
	//   "MANUAL_CPC" - Manual click based bidding where user pays per
	// click.
	//   "MANUAL_CPM" - Manual impression based bidding where user pays per
	// thousand impressions.
	//   "MANUAL_CPV" - A bidding strategy that pays a configurable amount
	// per video view.
	//   "MAXIMIZE_CONVERSIONS" - A bidding strategy that automatically
	// maximizes number of conversions given a daily budget.
	//   "MAXIMIZE_CONVERSION_VALUE" - An automated bidding strategy that
	// automatically sets bids to maximize revenue while spending your
	// budget.
	//   "PAGE_ONE_PROMOTED" - Page-One Promoted bidding scheme, which sets
	// max cpc bids to target impressions on page one or page one promoted
	// slots on google.com. This enum value is deprecated.
	//   "PERCENT_CPC" - Percent Cpc is bidding strategy where bids are a
	// fraction of the advertised price for some good or service.
	//   "TARGET_CPA" - Target CPA is an automated bid strategy that sets
	// bids to help get as many conversions as possible at the target
	// cost-per-acquisition (CPA) you set.
	//   "TARGET_CPM" - Target CPM is an automated bid strategy that sets
	// bids to help get as many impressions as possible at the target cost
	// per one thousand impressions (CPM) you set.
	//   "TARGET_IMPRESSION_SHARE" - An automated bidding strategy that sets
	// bids so that a certain percentage of search ads are shown at the top
	// of the first page (or other targeted location).
	//   "TARGET_OUTRANK_SHARE" - Target Outrank Share is an automated
	// bidding strategy that sets bids based on the target fraction of
	// auctions where the advertiser should outrank a specific competitor.
	// This enum value is deprecated.
	//   "TARGET_ROAS" - Target ROAS is an automated bidding strategy that
	// helps you maximize revenue while averaging a specific target Return
	// On Average Spend (ROAS).
	//   "TARGET_SPEND" - Target Spend is an automated bid strategy that
	// sets your bids to help get as many clicks as possible within your
	// budget.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CampaignCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CampaignCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__BiddingStrategy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__BiddingStrategy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Campaign: A campaign.
type GoogleAdsSearchads360V0Resources__Campaign struct {
	// AdServingOptimizationStatus: The ad serving optimization status of
	// the campaign.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "OPTIMIZE" - Ad serving is optimized based on CTR for the campaign.
	//   "CONVERSION_OPTIMIZE" - Ad serving is optimized based on CTR *
	// Conversion for the campaign. If the campaign is not in the conversion
	// optimizer bidding strategy, it will default to OPTIMIZED.
	//   "ROTATE" - Ads are rotated evenly for 90 days, then optimized for
	// clicks.
	//   "ROTATE_INDEFINITELY" - Show lower performing ads more evenly with
	// higher performing ads, and do not optimize.
	//   "UNAVAILABLE" - Ad serving optimization status is not available.
	AdServingOptimizationStatus string `json:"adServingOptimizationStatus,omitempty"`

	// AdvertisingChannelSubType: Immutable. Optional refinement to
	// `advertising_channel_type`. Must be a valid sub-type of the parent
	// channel type. Can be set only when creating campaigns. After campaign
	// is created, the field can not be changed.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used as a return value only. Represents value unknown
	// in this version.
	//   "SEARCH_MOBILE_APP" - Mobile app campaigns for Search.
	//   "DISPLAY_MOBILE_APP" - Mobile app campaigns for Display.
	//   "SEARCH_EXPRESS" - AdWords express campaigns for search.
	//   "DISPLAY_EXPRESS" - AdWords Express campaigns for display.
	//   "SHOPPING_SMART_ADS" - Smart Shopping campaigns.
	//   "DISPLAY_GMAIL_AD" - Gmail Ad campaigns.
	//   "DISPLAY_SMART_CAMPAIGN" - Smart display campaigns. New campaigns
	// of this sub type cannot be created.
	//   "VIDEO_OUTSTREAM" - Video Outstream campaigns.
	//   "VIDEO_ACTION" - Video TrueView for Action campaigns.
	//   "VIDEO_NON_SKIPPABLE" - Video campaigns with non-skippable video
	// ads.
	//   "APP_CAMPAIGN" - App Campaign that lets you easily promote your
	// Android or iOS app across Google's top properties including Search,
	// Play, YouTube, and the Google Display Network.
	//   "APP_CAMPAIGN_FOR_ENGAGEMENT" - App Campaign for engagement,
	// focused on driving re-engagement with the app across several of
	// Google's top properties including Search, YouTube, and the Google
	// Display Network.
	//   "LOCAL_CAMPAIGN" - Campaigns specialized for local advertising.
	//   "SHOPPING_COMPARISON_LISTING_ADS" - Shopping Comparison Listing
	// campaigns.
	//   "SMART_CAMPAIGN" - Standard Smart campaigns.
	//   "VIDEO_SEQUENCE" - Video campaigns with sequence video ads.
	//   "APP_CAMPAIGN_FOR_PRE_REGISTRATION" - App Campaign for pre
	// registration, specialized for advertising mobile app
	// pre-registration, that targets multiple advertising channels across
	// Google Play, YouTube and Display Network.
	//   "VIDEO_REACH_TARGET_FREQUENCY" - Video reach campaign with Target
	// Frequency bidding strategy.
	//   "TRAVEL_ACTIVITIES" - Travel Activities campaigns.
	AdvertisingChannelSubType string `json:"advertisingChannelSubType,omitempty"`

	// AdvertisingChannelType: Immutable. The primary serving target for ads
	// within the campaign. The targeting options can be refined in
	// `network_settings`. This field is required and should not be empty
	// when creating new campaigns. Can be set only when creating campaigns.
	// After the campaign is created, the field can not be changed.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "SEARCH" - Search Network. Includes display bundled, and Search+
	// campaigns.
	//   "DISPLAY" - Google Display Network only.
	//   "SHOPPING" - Shopping campaigns serve on the shopping property and
	// on google.com search results.
	//   "HOTEL" - Hotel Ads campaigns.
	//   "VIDEO" - Video campaigns.
	//   "MULTI_CHANNEL" - App Campaigns, and App Campaigns for Engagement,
	// that run across multiple channels.
	//   "LOCAL" - Local ads campaigns.
	//   "SMART" - Smart campaigns.
	//   "PERFORMANCE_MAX" - Performance Max campaigns.
	//   "LOCAL_SERVICES" - Local services campaigns.
	//   "DISCOVERY" - Discovery campaigns.
	//   "TRAVEL" - Travel campaigns.
	AdvertisingChannelType string `json:"advertisingChannelType,omitempty"`

	// BiddingStrategy: Portfolio bidding strategy used by campaign.
	BiddingStrategy string `json:"biddingStrategy,omitempty"`

	// BiddingStrategySystemStatus: Output only. The system status of the
	// campaign's bidding strategy.
	//
	// Possible values:
	//   "UNSPECIFIED" - Signals that an unexpected error occurred, for
	// example, no bidding strategy type was found, or no status information
	// was found.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - The bid strategy is active, and AdWords cannot find any
	// specific issues with the strategy.
	//   "LEARNING_NEW" - The bid strategy is learning because it has been
	// recently created or recently reactivated.
	//   "LEARNING_SETTING_CHANGE" - The bid strategy is learning because of
	// a recent setting change.
	//   "LEARNING_BUDGET_CHANGE" - The bid strategy is learning because of
	// a recent budget change.
	//   "LEARNING_COMPOSITION_CHANGE" - The bid strategy is learning
	// because of recent change in number of campaigns, ad groups or
	// keywords attached to it.
	//   "LEARNING_CONVERSION_TYPE_CHANGE" - The bid strategy depends on
	// conversion reporting and the customer recently modified conversion
	// types that were relevant to the bid strategy.
	//   "LEARNING_CONVERSION_SETTING_CHANGE" - The bid strategy depends on
	// conversion reporting and the customer recently changed their
	// conversion settings.
	//   "LIMITED_BY_CPC_BID_CEILING" - The bid strategy is limited by its
	// bid ceiling.
	//   "LIMITED_BY_CPC_BID_FLOOR" - The bid strategy is limited by its bid
	// floor.
	//   "LIMITED_BY_DATA" - The bid strategy is limited because there was
	// not enough conversion traffic over the past weeks.
	//   "LIMITED_BY_BUDGET" - A significant fraction of keywords in this
	// bid strategy are limited by budget.
	//   "LIMITED_BY_LOW_PRIORITY_SPEND" - The bid strategy cannot reach its
	// target spend because its spend has been de-prioritized.
	//   "LIMITED_BY_LOW_QUALITY" - A significant fraction of keywords in
	// this bid strategy have a low Quality Score.
	//   "LIMITED_BY_INVENTORY" - The bid strategy cannot fully spend its
	// budget because of narrow targeting.
	//   "MISCONFIGURED_ZERO_ELIGIBILITY" - Missing conversion tracking (no
	// pings present) and/or remarketing lists for SSC.
	//   "MISCONFIGURED_CONVERSION_TYPES" - The bid strategy depends on
	// conversion reporting and the customer is lacking conversion types
	// that might be reported against this strategy.
	//   "MISCONFIGURED_CONVERSION_SETTINGS" - The bid strategy depends on
	// conversion reporting and the customer's conversion settings are
	// misconfigured.
	//   "MISCONFIGURED_SHARED_BUDGET" - There are campaigns outside the bid
	// strategy that share budgets with campaigns included in the strategy.
	//   "MISCONFIGURED_STRATEGY_TYPE" - The campaign has an invalid
	// strategy type and is not serving.
	//   "PAUSED" - The bid strategy is not active. Either there are no
	// active campaigns, ad groups or keywords attached to the bid strategy.
	// Or there are no active budgets connected to the bid strategy.
	//   "UNAVAILABLE" - This bid strategy currently does not support status
	// reporting.
	//   "MULTIPLE_LEARNING" - There were multiple LEARNING_* system
	// statuses for this bid strategy during the time in question.
	//   "MULTIPLE_LIMITED" - There were multiple LIMITED_* system statuses
	// for this bid strategy during the time in question.
	//   "MULTIPLE_MISCONFIGURED" - There were multiple MISCONFIGURED_*
	// system statuses for this bid strategy during the time in question.
	//   "MULTIPLE" - There were multiple system statuses for this bid
	// strategy during the time in question.
	BiddingStrategySystemStatus string `json:"biddingStrategySystemStatus,omitempty"`

	// BiddingStrategyType: Output only. The type of bidding strategy. A
	// bidding strategy can be created by setting either the bidding scheme
	// to create a standard bidding strategy or the `bidding_strategy` field
	// to create a portfolio bidding strategy. This field is read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "COMMISSION" - Commission is an automatic bidding strategy in which
	// the advertiser pays a certain portion of the conversion value.
	//   "ENHANCED_CPC" - Enhanced CPC is a bidding strategy that raises
	// bids for clicks that seem more likely to lead to a conversion and
	// lowers them for clicks where they seem less likely.
	//   "INVALID" - Used for return value only. Indicates that a campaign
	// does not have a bidding strategy. This prevents the campaign from
	// serving. For example, a campaign may be attached to a manager bidding
	// strategy and the serving account is subsequently unlinked from the
	// manager account. In this case the campaign will automatically be
	// detached from the now inaccessible manager bidding strategy and
	// transition to the INVALID bidding strategy type.
	//   "MANUAL_CPA" - Manual bidding strategy that allows advertiser to
	// set the bid per advertiser-specified action.
	//   "MANUAL_CPC" - Manual click based bidding where user pays per
	// click.
	//   "MANUAL_CPM" - Manual impression based bidding where user pays per
	// thousand impressions.
	//   "MANUAL_CPV" - A bidding strategy that pays a configurable amount
	// per video view.
	//   "MAXIMIZE_CONVERSIONS" - A bidding strategy that automatically
	// maximizes number of conversions given a daily budget.
	//   "MAXIMIZE_CONVERSION_VALUE" - An automated bidding strategy that
	// automatically sets bids to maximize revenue while spending your
	// budget.
	//   "PAGE_ONE_PROMOTED" - Page-One Promoted bidding scheme, which sets
	// max cpc bids to target impressions on page one or page one promoted
	// slots on google.com. This enum value is deprecated.
	//   "PERCENT_CPC" - Percent Cpc is bidding strategy where bids are a
	// fraction of the advertised price for some good or service.
	//   "TARGET_CPA" - Target CPA is an automated bid strategy that sets
	// bids to help get as many conversions as possible at the target
	// cost-per-acquisition (CPA) you set.
	//   "TARGET_CPM" - Target CPM is an automated bid strategy that sets
	// bids to help get as many impressions as possible at the target cost
	// per one thousand impressions (CPM) you set.
	//   "TARGET_IMPRESSION_SHARE" - An automated bidding strategy that sets
	// bids so that a certain percentage of search ads are shown at the top
	// of the first page (or other targeted location).
	//   "TARGET_OUTRANK_SHARE" - Target Outrank Share is an automated
	// bidding strategy that sets bids based on the target fraction of
	// auctions where the advertiser should outrank a specific competitor.
	// This enum value is deprecated.
	//   "TARGET_ROAS" - Target ROAS is an automated bidding strategy that
	// helps you maximize revenue while averaging a specific target Return
	// On Average Spend (ROAS).
	//   "TARGET_SPEND" - Target Spend is an automated bid strategy that
	// sets your bids to help get as many clicks as possible within your
	// budget.
	BiddingStrategyType string `json:"biddingStrategyType,omitempty"`

	// CampaignBudget: The budget of the campaign.
	CampaignBudget string `json:"campaignBudget,omitempty"`

	// CreateTime: Output only. The timestamp when this campaign was
	// created. The timestamp is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss" format. create_time will be deprecated in v1.
	// Use creation_time instead.
	CreateTime string `json:"createTime,omitempty"`

	// CreationTime: Output only. The timestamp when this campaign was
	// created. The timestamp is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss" format.
	CreationTime string `json:"creationTime,omitempty"`

	// DynamicSearchAdsSetting: The setting for controlling Dynamic Search
	// Ads (DSA).
	DynamicSearchAdsSetting *GoogleAdsSearchads360V0ResourcesCampaignDynamicSearchAdsSetting `json:"dynamicSearchAdsSetting,omitempty"`

	// EndDate: The last day of the campaign in serving customer's timezone
	// in YYYY-MM-DD format. On create, defaults to 2037-12-30, which means
	// the campaign will run indefinitely. To set an existing campaign to
	// run indefinitely, set this field to 2037-12-30.
	EndDate string `json:"endDate,omitempty"`

	// EngineId: Output only. ID of the campaign in the external engine
	// account. This field is for non-Google Ads account only, for example,
	// Yahoo Japan, Microsoft, Baidu etc. For Google Ads entity, use
	// "campaign.id" instead.
	EngineId string `json:"engineId,omitempty"`

	// ExcludedParentAssetFieldTypes: The asset field types that should be
	// excluded from this campaign. Asset links with these field types will
	// not be inherited by this campaign from the upper level.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "HEADLINE" - The asset is linked for use as a headline.
	//   "DESCRIPTION" - The asset is linked for use as a description.
	//   "MANDATORY_AD_TEXT" - The asset is linked for use as mandatory ad
	// text.
	//   "MARKETING_IMAGE" - The asset is linked for use as a marketing
	// image.
	//   "MEDIA_BUNDLE" - The asset is linked for use as a media bundle.
	//   "YOUTUBE_VIDEO" - The asset is linked for use as a YouTube video.
	//   "BOOK_ON_GOOGLE" - The asset is linked to indicate that a hotels
	// campaign is "Book on Google" enabled.
	//   "LEAD_FORM" - The asset is linked for use as a Lead Form extension.
	//   "PROMOTION" - The asset is linked for use as a Promotion extension.
	//   "CALLOUT" - The asset is linked for use as a Callout extension.
	//   "STRUCTURED_SNIPPET" - The asset is linked for use as a Structured
	// Snippet extension.
	//   "SITELINK" - The asset is linked for use as a Sitelink.
	//   "MOBILE_APP" - The asset is linked for use as a Mobile App
	// extension.
	//   "HOTEL_CALLOUT" - The asset is linked for use as a Hotel Callout
	// extension.
	//   "CALL" - The asset is linked for use as a Call extension.
	//   "PRICE" - The asset is linked for use as a Price extension.
	//   "LONG_HEADLINE" - The asset is linked for use as a long headline.
	//   "BUSINESS_NAME" - The asset is linked for use as a business name.
	//   "SQUARE_MARKETING_IMAGE" - The asset is linked for use as a square
	// marketing image.
	//   "PORTRAIT_MARKETING_IMAGE" - The asset is linked for use as a
	// portrait marketing image.
	//   "LOGO" - The asset is linked for use as a logo.
	//   "LANDSCAPE_LOGO" - The asset is linked for use as a landscape logo.
	//   "VIDEO" - The asset is linked for use as a non YouTube logo.
	//   "CALL_TO_ACTION_SELECTION" - The asset is linked for use to select
	// a call-to-action.
	//   "AD_IMAGE" - The asset is linked for use to select an ad image.
	//   "BUSINESS_LOGO" - The asset is linked for use as a business logo.
	//   "HOTEL_PROPERTY" - The asset is linked for use as a hotel property
	// in a Performance Max for travel goals campaign.
	ExcludedParentAssetFieldTypes []string `json:"excludedParentAssetFieldTypes,omitempty"`

	// FinalUrlSuffix: Suffix used to append query parameters to landing
	// pages that are served with parallel tracking.
	FinalUrlSuffix string `json:"finalUrlSuffix,omitempty"`

	// FrequencyCaps: A list that limits how often each user will see this
	// campaign's ads.
	FrequencyCaps []*GoogleAdsSearchads360V0Common__FrequencyCapEntry `json:"frequencyCaps,omitempty"`

	// GeoTargetTypeSetting: The setting for ads geotargeting.
	GeoTargetTypeSetting *GoogleAdsSearchads360V0ResourcesCampaignGeoTargetTypeSetting `json:"geoTargetTypeSetting,omitempty"`

	// Id: Output only. The ID of the campaign.
	Id int64 `json:"id,omitempty,string"`

	// Labels: Output only. The resource names of labels attached to this
	// campaign.
	Labels []string `json:"labels,omitempty"`

	// LastModifiedTime: Output only. The datetime when this campaign was
	// last modified. The datetime is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// ManualCpa: Standard Manual CPA bidding strategy. Manual bidding
	// strategy that allows advertiser to set the bid per
	// advertiser-specified action. Supported only for Local Services
	// campaigns.
	ManualCpa *GoogleAdsSearchads360V0Common__ManualCpa `json:"manualCpa,omitempty"`

	// ManualCpc: Standard Manual CPC bidding strategy. Manual click-based
	// bidding where user pays per click.
	ManualCpc *GoogleAdsSearchads360V0Common__ManualCpc `json:"manualCpc,omitempty"`

	// ManualCpm: Standard Manual CPM bidding strategy. Manual
	// impression-based bidding where user pays per thousand impressions.
	ManualCpm *GoogleAdsSearchads360V0Common__ManualCpm `json:"manualCpm,omitempty"`

	// MaximizeConversionValue: Standard Maximize Conversion Value bidding
	// strategy that automatically sets bids to maximize revenue while
	// spending your budget.
	MaximizeConversionValue *GoogleAdsSearchads360V0Common__MaximizeConversionValue `json:"maximizeConversionValue,omitempty"`

	// MaximizeConversions: Standard Maximize Conversions bidding strategy
	// that automatically maximizes number of conversions while spending
	// your budget.
	MaximizeConversions *GoogleAdsSearchads360V0Common__MaximizeConversions `json:"maximizeConversions,omitempty"`

	// Name: The name of the campaign. This field is required and should not
	// be empty when creating new campaigns. It must not contain any null
	// (code point 0x0), NL line feed (code point 0xA) or carriage return
	// (code point 0xD) characters.
	Name string `json:"name,omitempty"`

	// NetworkSettings: The network settings for the campaign.
	NetworkSettings *GoogleAdsSearchads360V0ResourcesCampaignNetworkSettings `json:"networkSettings,omitempty"`

	// OptimizationGoalSetting: Optimization goal setting for this campaign,
	// which includes a set of optimization goal types.
	OptimizationGoalSetting *GoogleAdsSearchads360V0ResourcesCampaignOptimizationGoalSetting `json:"optimizationGoalSetting,omitempty"`

	// PercentCpc: Standard Percent Cpc bidding strategy where bids are a
	// fraction of the advertised price for some good or service.
	PercentCpc *GoogleAdsSearchads360V0Common__PercentCpc `json:"percentCpc,omitempty"`

	// RealTimeBiddingSetting: Settings for Real-Time Bidding, a feature
	// only available for campaigns targeting the Ad Exchange network.
	RealTimeBiddingSetting *GoogleAdsSearchads360V0Common__RealTimeBiddingSetting `json:"realTimeBiddingSetting,omitempty"`

	// ResourceName: Immutable. The resource name of the campaign. Campaign
	// resource names have the form:
	// `customers/{customer_id}/campaigns/{campaign_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// SelectiveOptimization: Selective optimization setting for this
	// campaign, which includes a set of conversion actions to optimize this
	// campaign towards. This feature only applies to app campaigns that use
	// MULTI_CHANNEL as AdvertisingChannelType and APP_CAMPAIGN or
	// APP_CAMPAIGN_FOR_ENGAGEMENT as AdvertisingChannelSubType.
	SelectiveOptimization *GoogleAdsSearchads360V0ResourcesCampaignSelectiveOptimization `json:"selectiveOptimization,omitempty"`

	// ServingStatus: Output only. The ad serving status of the campaign.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "SERVING" - Serving.
	//   "NONE" - None.
	//   "ENDED" - Ended.
	//   "PENDING" - Pending.
	//   "SUSPENDED" - Suspended.
	ServingStatus string `json:"servingStatus,omitempty"`

	// ShoppingSetting: The setting for controlling Shopping campaigns.
	ShoppingSetting *GoogleAdsSearchads360V0ResourcesCampaignShoppingSetting `json:"shoppingSetting,omitempty"`

	// StartDate: The date when campaign started in serving customer's
	// timezone in YYYY-MM-DD format.
	StartDate string `json:"startDate,omitempty"`

	// Status: The status of the campaign. When a new campaign is added, the
	// status defaults to ENABLED.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Campaign is active and can show ads.
	//   "PAUSED" - Campaign has been paused by the user.
	//   "REMOVED" - Campaign has been removed.
	Status string `json:"status,omitempty"`

	// TargetCpa: Standard Target CPA bidding strategy that automatically
	// sets bids to help get as many conversions as possible at the target
	// cost-per-acquisition (CPA) you set.
	TargetCpa *GoogleAdsSearchads360V0Common__TargetCpa `json:"targetCpa,omitempty"`

	// TargetCpm: A bidding strategy that automatically optimizes cost per
	// thousand impressions.
	TargetCpm *GoogleAdsSearchads360V0Common__TargetCpm `json:"targetCpm,omitempty"`

	// TargetImpressionShare: Target Impression Share bidding strategy. An
	// automated bidding strategy that sets bids to achieve a chosen
	// percentage of impressions.
	TargetImpressionShare *GoogleAdsSearchads360V0Common__TargetImpressionShare `json:"targetImpressionShare,omitempty"`

	// TargetRoas: Standard Target ROAS bidding strategy that automatically
	// maximizes revenue while averaging a specific target return on ad
	// spend (ROAS).
	TargetRoas *GoogleAdsSearchads360V0Common__TargetRoas `json:"targetRoas,omitempty"`

	// TargetSpend: Standard Target Spend bidding strategy that
	// automatically sets your bids to help get as many clicks as possible
	// within your budget.
	TargetSpend *GoogleAdsSearchads360V0Common__TargetSpend `json:"targetSpend,omitempty"`

	// TrackingSetting: Output only. Campaign-level settings for tracking
	// information.
	TrackingSetting *GoogleAdsSearchads360V0ResourcesCampaignTrackingSetting `json:"trackingSetting,omitempty"`

	// TrackingUrlTemplate: The URL template for constructing a tracking
	// URL.
	TrackingUrlTemplate string `json:"trackingUrlTemplate,omitempty"`

	// UrlCustomParameters: The list of mappings used to substitute custom
	// parameter tags in a `tracking_url_template`, `final_urls`, or
	// `mobile_final_urls`.
	UrlCustomParameters []*GoogleAdsSearchads360V0Common__CustomParameter `json:"urlCustomParameters,omitempty"`

	// UrlExpansionOptOut: Represents opting out of URL expansion to more
	// targeted URLs. If opted out (true), only the final URLs in the asset
	// group or URLs specified in the advertiser's Google Merchant Center or
	// business data feeds are targeted. If opted in (false), the entire
	// domain will be targeted. This field can only be set for Performance
	// Max campaigns, where the default value is false.
	UrlExpansionOptOut bool `json:"urlExpansionOptOut,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdServingOptimizationStatus") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdServingOptimizationStatus") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Campaign) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Campaign
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CampaignAsset: A link between a
// Campaign and an Asset.
type GoogleAdsSearchads360V0Resources__CampaignAsset struct {
	// Asset: Immutable. The asset which is linked to the campaign.
	Asset string `json:"asset,omitempty"`

	// Campaign: Immutable. The campaign to which the asset is linked.
	Campaign string `json:"campaign,omitempty"`

	// ResourceName: Immutable. The resource name of the campaign asset.
	// CampaignAsset resource names have the form:
	// `customers/{customer_id}/campaignAssets/{campaign_id}~{asset_id}~{fiel
	// d_type}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. Status of the campaign asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Asset link is enabled.
	//   "REMOVED" - Asset link has been removed.
	//   "PAUSED" - Asset link is paused.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CampaignAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CampaignAssetSet: CampaignAssetSet
// is the linkage between a campaign and an asset set. Adding a
// CampaignAssetSet links an asset set with a campaign.
type GoogleAdsSearchads360V0Resources__CampaignAssetSet struct {
	// AssetSet: Immutable. The asset set which is linked to the campaign.
	AssetSet string `json:"assetSet,omitempty"`

	// Campaign: Immutable. The campaign to which this asset set is linked.
	Campaign string `json:"campaign,omitempty"`

	// ResourceName: Immutable. The resource name of the campaign asset set.
	// Asset set asset resource names have the form:
	// `customers/{customer_id}/campaignAssetSets/{campaign_id}~{asset_set_id
	// }`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the campaign asset set asset.
	// Read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The linkage between asset set and its container is
	// enabled.
	//   "REMOVED" - The linkage between asset set and its container is
	// removed.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetSet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetSet") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CampaignAssetSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignAssetSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CampaignAudienceView: A campaign
// audience view. Includes performance data from interests and
// remarketing lists for Display Network and YouTube Network ads, and
// remarketing lists for search ads (RLSA), aggregated by campaign and
// audience criterion. This view only includes audiences attached at the
// campaign level.
type GoogleAdsSearchads360V0Resources__CampaignAudienceView struct {
	// ResourceName: Output only. The resource name of the campaign audience
	// view. Campaign audience view resource names have the form:
	// `customers/{customer_id}/campaignAudienceViews/{campaign_id}~{criterio
	// n_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CampaignAudienceView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignAudienceView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CampaignBudget: A campaign budget.
type GoogleAdsSearchads360V0Resources__CampaignBudget struct {
	// AmountMicros: The amount of the budget, in the local currency for the
	// account. Amount is specified in micros, where one million is
	// equivalent to one currency unit. Monthly spend is capped at 30.4
	// times this amount.
	AmountMicros int64 `json:"amountMicros,omitempty,string"`

	// DeliveryMethod: The delivery method that determines the rate at which
	// the campaign budget is spent. Defaults to STANDARD if unspecified in
	// a create operation.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "STANDARD" - The budget server will throttle serving evenly across
	// the entire time period.
	//   "ACCELERATED" - The budget server will not throttle serving, and
	// ads will serve as fast as possible.
	DeliveryMethod string `json:"deliveryMethod,omitempty"`

	// Period: Immutable. Period over which to spend the budget. Defaults to
	// DAILY if not specified.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "DAILY" - Daily budget.
	//   "FIXED_DAILY" - Fixed daily budget.
	//   "CUSTOM_PERIOD" - Custom budget can be used with total_amount to
	// specify lifetime budget limit.
	Period string `json:"period,omitempty"`

	// ResourceName: Immutable. The resource name of the campaign budget.
	// Campaign budget resource names have the form:
	// `customers/{customer_id}/campaignBudgets/{campaign_budget_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AmountMicros") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AmountMicros") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CampaignBudget) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignBudget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CampaignCriterion: A campaign
// criterion.
type GoogleAdsSearchads360V0Resources__CampaignCriterion struct {
	// AgeRange: Immutable. Age range.
	AgeRange *GoogleAdsSearchads360V0Common__AgeRangeInfo `json:"ageRange,omitempty"`

	// BidModifier: The modifier for the bids when the criterion matches.
	// The modifier must be in the range: 0.1 - 10.0. Most targetable
	// criteria types support modifiers. Use 0 to opt out of a Device type.
	BidModifier float64 `json:"bidModifier,omitempty"`

	// CriterionId: Output only. The ID of the criterion. This field is
	// ignored during mutate.
	CriterionId int64 `json:"criterionId,omitempty,string"`

	// Device: Immutable. Device.
	Device *GoogleAdsSearchads360V0Common__DeviceInfo `json:"device,omitempty"`

	// DisplayName: Output only. The display name of the criterion. This
	// field is ignored for mutates.
	DisplayName string `json:"displayName,omitempty"`

	// Gender: Immutable. Gender.
	Gender *GoogleAdsSearchads360V0Common__GenderInfo `json:"gender,omitempty"`

	// Keyword: Immutable. Keyword.
	Keyword *GoogleAdsSearchads360V0Common__KeywordInfo `json:"keyword,omitempty"`

	// Language: Immutable. Language.
	Language *GoogleAdsSearchads360V0Common__LanguageInfo `json:"language,omitempty"`

	// LastModifiedTime: Output only. The datetime when this campaign
	// criterion was last modified. The datetime is in the customer's time
	// zone and in "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// Location: Immutable. Location.
	Location *GoogleAdsSearchads360V0Common__LocationInfo `json:"location,omitempty"`

	// LocationGroup: Immutable. Location Group
	LocationGroup *GoogleAdsSearchads360V0Common__LocationGroupInfo `json:"locationGroup,omitempty"`

	// Negative: Immutable. Whether to target (`false`) or exclude (`true`)
	// the criterion.
	Negative bool `json:"negative,omitempty"`

	// ResourceName: Immutable. The resource name of the campaign criterion.
	// Campaign criterion resource names have the form:
	// `customers/{customer_id}/campaignCriteria/{campaign_id}~{criterion_id}
	// `
	ResourceName string `json:"resourceName,omitempty"`

	// Status: The status of the criterion.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The campaign criterion is enabled.
	//   "PAUSED" - The campaign criterion is paused.
	//   "REMOVED" - The campaign criterion is removed.
	Status string `json:"status,omitempty"`

	// Type: Output only. The type of the criterion.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "KEYWORD" - Keyword, for example, 'mars cruise'.
	//   "PLACEMENT" - Placement, also known as Website, for example,
	// 'www.flowers4sale.com'
	//   "MOBILE_APP_CATEGORY" - Mobile application categories to target.
	//   "MOBILE_APPLICATION" - Mobile applications to target.
	//   "DEVICE" - Devices to target.
	//   "LOCATION" - Locations to target.
	//   "LISTING_GROUP" - Listing groups to target.
	//   "AD_SCHEDULE" - Ad Schedule.
	//   "AGE_RANGE" - Age range.
	//   "GENDER" - Gender.
	//   "INCOME_RANGE" - Income Range.
	//   "PARENTAL_STATUS" - Parental status.
	//   "YOUTUBE_VIDEO" - YouTube Video.
	//   "YOUTUBE_CHANNEL" - YouTube Channel.
	//   "USER_LIST" - User list.
	//   "PROXIMITY" - Proximity.
	//   "TOPIC" - A topic target on the display network (for example, "Pets
	// & Animals").
	//   "LISTING_SCOPE" - Listing scope to target.
	//   "LANGUAGE" - Language.
	//   "IP_BLOCK" - IpBlock.
	//   "CONTENT_LABEL" - Content Label for category exclusion.
	//   "CARRIER" - Carrier.
	//   "USER_INTEREST" - A category the user is interested in.
	//   "WEBPAGE" - Webpage criterion for dynamic search ads.
	//   "OPERATING_SYSTEM_VERSION" - Operating system version.
	//   "APP_PAYMENT_MODEL" - App payment model.
	//   "MOBILE_DEVICE" - Mobile device.
	//   "CUSTOM_AFFINITY" - Custom affinity.
	//   "CUSTOM_INTENT" - Custom intent.
	//   "LOCATION_GROUP" - Location group.
	//   "CUSTOM_AUDIENCE" - Custom audience
	//   "COMBINED_AUDIENCE" - Combined audience
	//   "KEYWORD_THEME" - Smart Campaign keyword theme
	//   "AUDIENCE" - Audience
	//   "LOCAL_SERVICE_ID" - Local Services Ads Service ID.
	//   "BRAND" - Brand
	//   "BRAND_LIST" - Brand List
	Type string `json:"type,omitempty"`

	// UserList: Immutable. User List. The Similar Audiences sunset starts
	// May 2023. Refer to
	// https://ads-developers.googleblog.com/2022/11/announcing-deprecation-and-sunset-of.html
	// for other options.
	UserList *GoogleAdsSearchads360V0Common__UserListInfo `json:"userList,omitempty"`

	// Webpage: Immutable. Webpage.
	Webpage *GoogleAdsSearchads360V0Common__WebpageInfo `json:"webpage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgeRange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgeRange") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CampaignCriterion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignCriterion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAdsSearchads360V0Resources__CampaignCriterion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignCriterion
	var s1 struct {
		BidModifier gensupport.JSONFloat64 `json:"bidModifier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BidModifier = float64(s1.BidModifier)
	return nil
}

// GoogleAdsSearchads360V0Resources__CampaignLabel: Represents a
// relationship between a campaign and a label.
type GoogleAdsSearchads360V0Resources__CampaignLabel struct {
	// Campaign: Immutable. The campaign to which the label is attached.
	Campaign string `json:"campaign,omitempty"`

	// Label: Immutable. The label assigned to the campaign.
	Label string `json:"label,omitempty"`

	// ResourceName: Immutable. Name of the resource. Campaign label
	// resource names have the form:
	// `customers/{customer_id}/campaignLabels/{campaign_id}~{label_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Campaign") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Campaign") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CampaignLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CampaignLabel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CartDataSalesView: Cart data sales
// view.
type GoogleAdsSearchads360V0Resources__CartDataSalesView struct {
	// ResourceName: Output only. The resource name of the Cart data sales
	// view. Cart data sales view resource names have the form:
	// `customers/{customer_id}/cartDataSalesView`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CartDataSalesView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CartDataSalesView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Conversion: A conversion.
type GoogleAdsSearchads360V0Resources__Conversion struct {
	// AdId: Output only. Ad ID. A value of 0 indicates that the ad is
	// unattributed.
	AdId int64 `json:"adId,omitempty,string"`

	// AdvertiserConversionId: Output only. For offline conversions, this is
	// an ID provided by advertisers. If an advertiser doesn't specify such
	// an ID, Search Ads 360 generates one. For online conversions, this is
	// equal to the id column or the floodlight_order_id column depending on
	// the advertiser's Floodlight instructions.
	AdvertiserConversionId string `json:"advertiserConversionId,omitempty"`

	// AssetFieldType: Output only. Asset field type of the conversion
	// event.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "HEADLINE" - The asset is linked for use as a headline.
	//   "DESCRIPTION" - The asset is linked for use as a description.
	//   "MANDATORY_AD_TEXT" - The asset is linked for use as mandatory ad
	// text.
	//   "MARKETING_IMAGE" - The asset is linked for use as a marketing
	// image.
	//   "MEDIA_BUNDLE" - The asset is linked for use as a media bundle.
	//   "YOUTUBE_VIDEO" - The asset is linked for use as a YouTube video.
	//   "BOOK_ON_GOOGLE" - The asset is linked to indicate that a hotels
	// campaign is "Book on Google" enabled.
	//   "LEAD_FORM" - The asset is linked for use as a Lead Form extension.
	//   "PROMOTION" - The asset is linked for use as a Promotion extension.
	//   "CALLOUT" - The asset is linked for use as a Callout extension.
	//   "STRUCTURED_SNIPPET" - The asset is linked for use as a Structured
	// Snippet extension.
	//   "SITELINK" - The asset is linked for use as a Sitelink.
	//   "MOBILE_APP" - The asset is linked for use as a Mobile App
	// extension.
	//   "HOTEL_CALLOUT" - The asset is linked for use as a Hotel Callout
	// extension.
	//   "CALL" - The asset is linked for use as a Call extension.
	//   "PRICE" - The asset is linked for use as a Price extension.
	//   "LONG_HEADLINE" - The asset is linked for use as a long headline.
	//   "BUSINESS_NAME" - The asset is linked for use as a business name.
	//   "SQUARE_MARKETING_IMAGE" - The asset is linked for use as a square
	// marketing image.
	//   "PORTRAIT_MARKETING_IMAGE" - The asset is linked for use as a
	// portrait marketing image.
	//   "LOGO" - The asset is linked for use as a logo.
	//   "LANDSCAPE_LOGO" - The asset is linked for use as a landscape logo.
	//   "VIDEO" - The asset is linked for use as a non YouTube logo.
	//   "CALL_TO_ACTION_SELECTION" - The asset is linked for use to select
	// a call-to-action.
	//   "AD_IMAGE" - The asset is linked for use to select an ad image.
	//   "BUSINESS_LOGO" - The asset is linked for use as a business logo.
	//   "HOTEL_PROPERTY" - The asset is linked for use as a hotel property
	// in a Performance Max for travel goals campaign.
	AssetFieldType string `json:"assetFieldType,omitempty"`

	// AssetId: Output only. ID of the asset which was interacted with
	// during the conversion event.
	AssetId int64 `json:"assetId,omitempty,string"`

	// AttributionType: Output only. What the conversion is attributed to:
	// Visit or Keyword+Ad.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "VISIT" - The conversion is attributed to a visit.
	//   "CRITERION_AD" - The conversion is attributed to a criterion and ad
	// pair.
	AttributionType string `json:"attributionType,omitempty"`

	// ClickId: Output only. A unique string, for the visit that the
	// conversion is attributed to, that is passed to the landing page as
	// the click id URL parameter.
	ClickId string `json:"clickId,omitempty"`

	// ConversionDateTime: Output only. The timestamp of the conversion
	// event.
	ConversionDateTime string `json:"conversionDateTime,omitempty"`

	// ConversionLastModifiedDateTime: Output only. The timestamp of the
	// last time the conversion was modified.
	ConversionLastModifiedDateTime string `json:"conversionLastModifiedDateTime,omitempty"`

	// ConversionQuantity: Output only. The quantity of items recorded by
	// the conversion, as determined by the qty url parameter. The
	// advertiser is responsible for dynamically populating the parameter
	// (such as number of items sold in the conversion), otherwise it
	// defaults to 1.
	ConversionQuantity int64 `json:"conversionQuantity,omitempty,string"`

	// ConversionRevenueMicros: Output only. The adjusted revenue in micros
	// for the conversion event. This will always be in the currency of the
	// serving account.
	ConversionRevenueMicros int64 `json:"conversionRevenueMicros,omitempty,string"`

	// ConversionVisitDateTime: Output only. The timestamp of the visit that
	// the conversion is attributed to.
	ConversionVisitDateTime string `json:"conversionVisitDateTime,omitempty"`

	// CriterionId: Output only. Search Ads 360 criterion ID. A value of 0
	// indicates that the criterion is unattributed.
	CriterionId int64 `json:"criterionId,omitempty,string"`

	// FloodlightOrderId: Output only. The Floodlight order ID provided by
	// the advertiser for the conversion.
	FloodlightOrderId string `json:"floodlightOrderId,omitempty"`

	// FloodlightOriginalRevenue: Output only. The original, unchanged
	// revenue associated with the Floodlight event (in the currency of the
	// current report), before Floodlight currency instruction
	// modifications.
	FloodlightOriginalRevenue int64 `json:"floodlightOriginalRevenue,omitempty,string"`

	// Id: Output only. The ID of the conversion
	Id int64 `json:"id,omitempty,string"`

	// MerchantId: Output only. The SearchAds360 inventory account ID
	// containing the product that was clicked on. SearchAds360 generates
	// this ID when you link an inventory account in SearchAds360.
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// ProductChannel: Output only. The sales channel of the product that
	// was clicked on: Online or Local.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ONLINE" - The item is sold online.
	//   "LOCAL" - The item is sold in local stores.
	ProductChannel string `json:"productChannel,omitempty"`

	// ProductCountryCode: Output only. The country (ISO-3166-format)
	// registered for the inventory feed that contains the product clicked
	// on.
	ProductCountryCode string `json:"productCountryCode,omitempty"`

	// ProductId: Output only. The ID of the product clicked on.
	ProductId string `json:"productId,omitempty"`

	// ProductLanguageCode: Output only. The language (ISO-639-1) that has
	// been set for the Merchant Center feed containing data about the
	// product.
	ProductLanguageCode string `json:"productLanguageCode,omitempty"`

	// ProductStoreId: Output only. The store in the Local Inventory Ad that
	// was clicked on. This should match the store IDs used in your local
	// products feed.
	ProductStoreId string `json:"productStoreId,omitempty"`

	// ResourceName: Output only. The resource name of the conversion.
	// Conversion resource names have the form:
	// `customers/{customer_id}/conversions/{ad_group_id}~{criterion_id}~{ds_
	// conversion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the conversion, either ENABLED or
	// REMOVED..
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - The conversion is enabled.
	//   "REMOVED" - The conversion has been removed.
	Status string `json:"status,omitempty"`

	// VisitId: Output only. The SearchAds360 visit ID that the conversion
	// is attributed to.
	VisitId int64 `json:"visitId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AdId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Conversion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Conversion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ConversionAction: A conversion
// action.
type GoogleAdsSearchads360V0Resources__ConversionAction struct {
	// AppId: App ID for an app conversion action.
	AppId string `json:"appId,omitempty"`

	// AttributionModelSettings: Settings related to this conversion
	// action's attribution model.
	AttributionModelSettings *GoogleAdsSearchads360V0ResourcesConversionActionAttributionModelSettings `json:"attributionModelSettings,omitempty"`

	// Category: The category of conversions reported for this conversion
	// action.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "DEFAULT" - Default category.
	//   "PAGE_VIEW" - User visiting a page.
	//   "PURCHASE" - Purchase, sales, or "order placed" event.
	//   "SIGNUP" - Signup user action.
	//   "LEAD" - Lead-generating action.
	//   "DOWNLOAD" - Software download action (as for an app).
	//   "ADD_TO_CART" - The addition of items to a shopping cart or bag on
	// an advertiser site.
	//   "BEGIN_CHECKOUT" - When someone enters the checkout flow on an
	// advertiser site.
	//   "SUBSCRIBE_PAID" - The start of a paid subscription for a product
	// or service.
	//   "PHONE_CALL_LEAD" - A call to indicate interest in an advertiser's
	// offering.
	//   "IMPORTED_LEAD" - A lead conversion imported from an external
	// source into Google Ads.
	//   "SUBMIT_LEAD_FORM" - A submission of a form on an advertiser site
	// indicating business interest.
	//   "BOOK_APPOINTMENT" - A booking of an appointment with an
	// advertiser's business.
	//   "REQUEST_QUOTE" - A quote or price estimate request.
	//   "GET_DIRECTIONS" - A search for an advertiser's business location
	// with intention to visit.
	//   "OUTBOUND_CLICK" - A click to an advertiser's partner's site.
	//   "CONTACT" - A call, SMS, email, chat or other type of contact to an
	// advertiser.
	//   "ENGAGEMENT" - A website engagement event such as long site time or
	// a Google Analytics (GA) Smart Goal. Intended to be used for GA,
	// Firebase, GA Gold goal imports.
	//   "STORE_VISIT" - A visit to a physical store location.
	//   "STORE_SALE" - A sale occurring in a physical store.
	//   "QUALIFIED_LEAD" - A lead conversion imported from an external
	// source into Google Ads, that has been further qualified by the
	// advertiser (marketing/sales team). In the lead-to-sale journey,
	// advertisers get leads, then act on them by reaching out to the
	// consumer. If the consumer is interested and may end up buying their
	// product, the advertiser marks such leads as "qualified leads".
	//   "CONVERTED_LEAD" - A lead conversion imported from an external
	// source into Google Ads, that has further completed a chosen stage as
	// defined by the lead gen advertiser.
	Category string `json:"category,omitempty"`

	// ClickThroughLookbackWindowDays: The maximum number of days that may
	// elapse between an interaction (for example, a click) and a conversion
	// event.
	ClickThroughLookbackWindowDays int64 `json:"clickThroughLookbackWindowDays,omitempty,string"`

	// CreationTime: Output only. Timestamp of the Floodlight activity's
	// creation, formatted in ISO 8601.
	CreationTime string `json:"creationTime,omitempty"`

	// FloodlightSettings: Output only. Floodlight settings for Floodlight
	// conversion types.
	FloodlightSettings *GoogleAdsSearchads360V0ResourcesConversionActionFloodlightSettings `json:"floodlightSettings,omitempty"`

	// Id: Output only. The ID of the conversion action.
	Id int64 `json:"id,omitempty,string"`

	// IncludeInClientAccountConversionsMetric: Whether this conversion
	// action should be included in the "client_account_conversions" metric.
	IncludeInClientAccountConversionsMetric bool `json:"includeInClientAccountConversionsMetric,omitempty"`

	// IncludeInConversionsMetric: Output only. Whether this conversion
	// action should be included in the "conversions" metric.
	IncludeInConversionsMetric bool `json:"includeInConversionsMetric,omitempty"`

	// Name: The name of the conversion action. This field is required and
	// should not be empty when creating new conversion actions.
	Name string `json:"name,omitempty"`

	// OwnerCustomer: Output only. The resource name of the conversion
	// action owner customer, or null if this is a system-defined conversion
	// action.
	OwnerCustomer string `json:"ownerCustomer,omitempty"`

	// PrimaryForGoal: If a conversion action's primary_for_goal bit is
	// false, the conversion action is non-biddable for all campaigns
	// regardless of their customer conversion goal or campaign conversion
	// goal. However, custom conversion goals do not respect
	// primary_for_goal, so if a campaign has a custom conversion goal
	// configured with a primary_for_goal = false conversion action, that
	// conversion action is still biddable. By default, primary_for_goal
	// will be true if not set. In V9, primary_for_goal can only be set to
	// false after creation through an 'update' operation because it's not
	// declared as optional.
	PrimaryForGoal bool `json:"primaryForGoal,omitempty"`

	// ResourceName: Immutable. The resource name of the conversion action.
	// Conversion action resource names have the form:
	// `customers/{customer_id}/conversionActions/{conversion_action_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: The status of this conversion action for conversion event
	// accrual.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Conversions will be recorded.
	//   "REMOVED" - Conversions will not be recorded.
	//   "HIDDEN" - Conversions will not be recorded and the conversion
	// action will not appear in the UI.
	Status string `json:"status,omitempty"`

	// Type: Immutable. The type of this conversion action.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "AD_CALL" - Conversions that occur when a user clicks on an ad's
	// call extension.
	//   "CLICK_TO_CALL" - Conversions that occur when a user on a mobile
	// device clicks a phone number.
	//   "GOOGLE_PLAY_DOWNLOAD" - Conversions that occur when a user
	// downloads a mobile app from the Google Play Store.
	//   "GOOGLE_PLAY_IN_APP_PURCHASE" - Conversions that occur when a user
	// makes a purchase in an app through Android billing.
	//   "UPLOAD_CALLS" - Call conversions that are tracked by the
	// advertiser and uploaded.
	//   "UPLOAD_CLICKS" - Conversions that are tracked by the advertiser
	// and uploaded with attributed clicks.
	//   "WEBPAGE" - Conversions that occur on a webpage.
	//   "WEBSITE_CALL" - Conversions that occur when a user calls a
	// dynamically-generated phone number from an advertiser's website.
	//   "STORE_SALES_DIRECT_UPLOAD" - Store Sales conversion based on
	// first-party or third-party merchant data uploads. Only customers on
	// the allowlist can use store sales direct upload types.
	//   "STORE_SALES" - Store Sales conversion based on first-party or
	// third-party merchant data uploads and/or from in-store purchases
	// using cards from payment networks. Only customers on the allowlist
	// can use store sales types. Read only.
	//   "FIREBASE_ANDROID_FIRST_OPEN" - Android app first open conversions
	// tracked through Firebase.
	//   "FIREBASE_ANDROID_IN_APP_PURCHASE" - Android app in app purchase
	// conversions tracked through Firebase.
	//   "FIREBASE_ANDROID_CUSTOM" - Android app custom conversions tracked
	// through Firebase.
	//   "FIREBASE_IOS_FIRST_OPEN" - iOS app first open conversions tracked
	// through Firebase.
	//   "FIREBASE_IOS_IN_APP_PURCHASE" - iOS app in app purchase
	// conversions tracked through Firebase.
	//   "FIREBASE_IOS_CUSTOM" - iOS app custom conversions tracked through
	// Firebase.
	//   "THIRD_PARTY_APP_ANALYTICS_ANDROID_FIRST_OPEN" - Android app first
	// open conversions tracked through Third Party App Analytics.
	//   "THIRD_PARTY_APP_ANALYTICS_ANDROID_IN_APP_PURCHASE" - Android app
	// in app purchase conversions tracked through Third Party App
	// Analytics.
	//   "THIRD_PARTY_APP_ANALYTICS_ANDROID_CUSTOM" - Android app custom
	// conversions tracked through Third Party App Analytics.
	//   "THIRD_PARTY_APP_ANALYTICS_IOS_FIRST_OPEN" - iOS app first open
	// conversions tracked through Third Party App Analytics.
	//   "THIRD_PARTY_APP_ANALYTICS_IOS_IN_APP_PURCHASE" - iOS app in app
	// purchase conversions tracked through Third Party App Analytics.
	//   "THIRD_PARTY_APP_ANALYTICS_IOS_CUSTOM" - iOS app custom conversions
	// tracked through Third Party App Analytics.
	//   "ANDROID_APP_PRE_REGISTRATION" - Conversions that occur when a user
	// pre-registers a mobile app from the Google Play Store. Read only.
	//   "ANDROID_INSTALLS_ALL_OTHER_APPS" - Conversions that track all
	// Google Play downloads which aren't tracked by an app-specific type.
	// Read only.
	//   "FLOODLIGHT_ACTION" - Floodlight activity that counts the number of
	// times that users have visited a particular webpage after seeing or
	// clicking on one of an advertiser's ads. Read only.
	//   "FLOODLIGHT_TRANSACTION" - Floodlight activity that tracks the
	// number of sales made or the number of items purchased. Can also
	// capture the total value of each sale. Read only.
	//   "GOOGLE_HOSTED" - Conversions that track local actions from
	// Google's products and services after interacting with an ad. Read
	// only.
	//   "LEAD_FORM_SUBMIT" - Conversions reported when a user submits a
	// lead form. Read only.
	//   "SALESFORCE" - Conversions that come from Salesforce. Read only.
	//   "SEARCH_ADS_360" - Conversions imported from Search Ads 360
	// Floodlight data. Read only.
	//   "SMART_CAMPAIGN_AD_CLICKS_TO_CALL" - Call conversions that occur on
	// Smart campaign Ads without call tracking setup, using Smart campaign
	// custom criteria. Read only.
	//   "SMART_CAMPAIGN_MAP_CLICKS_TO_CALL" - The user clicks on a call
	// element within Google Maps. Smart campaign only. Read only.
	//   "SMART_CAMPAIGN_MAP_DIRECTIONS" - The user requests directions to a
	// business location within Google Maps. Smart campaign only. Read only.
	//   "SMART_CAMPAIGN_TRACKED_CALLS" - Call conversions that occur on
	// Smart campaign Ads with call tracking setup, using Smart campaign
	// custom criteria. Read only.
	//   "STORE_VISITS" - Conversions that occur when a user visits an
	// advertiser's retail store. Read only.
	//   "WEBPAGE_CODELESS" - Conversions created from website events (such
	// as form submissions or page loads), that don't use individually coded
	// event snippets. Read only.
	//   "UNIVERSAL_ANALYTICS_GOAL" - Conversions that come from linked
	// Universal Analytics goals.
	//   "UNIVERSAL_ANALYTICS_TRANSACTION" - Conversions that come from
	// linked Universal Analytics transactions.
	//   "GOOGLE_ANALYTICS_4_CUSTOM" - Conversions that come from linked
	// Google Analytics 4 custom event conversions.
	//   "GOOGLE_ANALYTICS_4_PURCHASE" - Conversions that come from linked
	// Google Analytics 4 purchase conversions.
	Type string `json:"type,omitempty"`

	// ValueSettings: Settings related to the value for conversion events
	// associated with this conversion action.
	ValueSettings *GoogleAdsSearchads360V0ResourcesConversionActionValueSettings `json:"valueSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ConversionAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ConversionAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ConversionTrackingSetting: A
// collection of customer-wide settings related to Search Ads 360
// Conversion Tracking.
type GoogleAdsSearchads360V0Resources__ConversionTrackingSetting struct {
	// AcceptedCustomerDataTerms: Output only. Whether the customer has
	// accepted customer data terms. If using cross-account conversion
	// tracking, this value is inherited from the manager. This field is
	// read-only. For more information, see
	// https://support.google.com/adspolicy/answer/7475709.
	AcceptedCustomerDataTerms bool `json:"acceptedCustomerDataTerms,omitempty"`

	// ConversionTrackingId: Output only. The conversion tracking id used
	// for this account. This id doesn't indicate whether the customer uses
	// conversion tracking (conversion_tracking_status does). This field is
	// read-only.
	ConversionTrackingId int64 `json:"conversionTrackingId,omitempty,string"`

	// ConversionTrackingStatus: Output only. Conversion tracking status. It
	// indicates whether the customer is using conversion tracking, and who
	// is the conversion tracking owner of this customer. If this customer
	// is using cross-account conversion tracking, the value returned will
	// differ based on the `login-customer-id` of the request.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "NOT_CONVERSION_TRACKED" - Customer does not use any conversion
	// tracking.
	//   "CONVERSION_TRACKING_MANAGED_BY_SELF" - The conversion actions are
	// created and managed by this customer.
	//   "CONVERSION_TRACKING_MANAGED_BY_THIS_MANAGER" - The conversion
	// actions are created and managed by the manager specified in the
	// request's `login-customer-id`.
	//   "CONVERSION_TRACKING_MANAGED_BY_ANOTHER_MANAGER" - The conversion
	// actions are created and managed by a manager different from the
	// customer or manager specified in the request's `login-customer-id`.
	ConversionTrackingStatus string `json:"conversionTrackingStatus,omitempty"`

	// CrossAccountConversionTrackingId: Output only. The conversion
	// tracking id of the customer's manager. This is set when the customer
	// is opted into cross-account conversion tracking, and it overrides
	// conversion_tracking_id.
	CrossAccountConversionTrackingId int64 `json:"crossAccountConversionTrackingId,omitempty,string"`

	// EnhancedConversionsForLeadsEnabled: Output only. Whether the customer
	// is opted-in for enhanced conversions for leads. If using
	// cross-account conversion tracking, this value is inherited from the
	// manager. This field is read-only.
	EnhancedConversionsForLeadsEnabled bool `json:"enhancedConversionsForLeadsEnabled,omitempty"`

	// GoogleAdsConversionCustomer: Output only. The resource name of the
	// customer where conversions are created and managed. This field is
	// read-only.
	GoogleAdsConversionCustomer string `json:"googleAdsConversionCustomer,omitempty"`

	// GoogleAdsCrossAccountConversionTrackingId: Output only. The
	// conversion tracking id of the customer's manager. This is set when
	// the customer is opted into conversion tracking, and it overrides
	// conversion_tracking_id. This field can only be managed through the
	// Google Ads UI. This field is read-only.
	GoogleAdsCrossAccountConversionTrackingId int64 `json:"googleAdsCrossAccountConversionTrackingId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "AcceptedCustomerDataTerms") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AcceptedCustomerDataTerms") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ConversionTrackingSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ConversionTrackingSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CustomColumn: A custom column. See
// Search Ads 360 custom column at
// https://support.google.com/sa360/answer/9633916
type GoogleAdsSearchads360V0Resources__CustomColumn struct {
	// Description: Output only. User-defined description of the custom
	// column.
	Description string `json:"description,omitempty"`

	// Id: Output only. ID of the custom column.
	Id int64 `json:"id,omitempty,string"`

	// Name: Output only. User-defined name of the custom column.
	Name string `json:"name,omitempty"`

	// Queryable: Output only. True when the custom column is available to
	// be used in the query of SearchAds360Service.Search and
	// SearchAds360Service.SearchStream.
	Queryable bool `json:"queryable,omitempty"`

	// ReferencedSystemColumns: Output only. The list of the referenced
	// system columns of this custom column. For example, A custom column
	// "sum of impressions and clicks" has referenced system columns of
	// {"metrics.clicks", "metrics.impressions"}.
	ReferencedSystemColumns []string `json:"referencedSystemColumns,omitempty"`

	// ReferencesAttributes: Output only. True when the custom column is
	// referring to one or more attributes.
	ReferencesAttributes bool `json:"referencesAttributes,omitempty"`

	// ReferencesMetrics: Output only. True when the custom column is
	// referring to one or more metrics.
	ReferencesMetrics bool `json:"referencesMetrics,omitempty"`

	// ResourceName: Immutable. The resource name of the custom column.
	// Custom column resource names have the form:
	// `customers/{customer_id}/customColumns/{custom_column_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ValueType: Output only. The type of the result value of the custom
	// column.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Unknown.
	//   "STRING" - The custom column value is a string.
	//   "INT64" - The custom column value is an int64 number.
	//   "DOUBLE" - The custom column value is a double number.
	//   "BOOLEAN" - The custom column value is a boolean.
	ValueType string `json:"valueType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CustomColumn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CustomColumn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Customer: A customer.
type GoogleAdsSearchads360V0Resources__Customer struct {
	// AccountStatus: Output only. Account status, for example, Enabled,
	// Paused, Removed, etc.
	//
	// Possible values:
	//   "UNSPECIFIED" - Default value.
	//   "UNKNOWN" - Unknown value.
	//   "ENABLED" - Account is able to serve ads.
	//   "PAUSED" - Account is deactivated by the user.
	//   "SUSPENDED" - Account is deactivated by an internal process.
	//   "REMOVED" - Account is irrevocably deactivated.
	//   "DRAFT" - Account is still in the process of setup, not ENABLED
	// yet.
	AccountStatus string `json:"accountStatus,omitempty"`

	// AccountType: Output only. Engine account type, for example, Google
	// Ads, Microsoft Advertising, Yahoo Japan, Baidu, Facebook, Engine
	// Track, etc.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "BAIDU" - Baidu account.
	//   "ENGINE_TRACK" - Engine track account.
	//   "FACEBOOK" - Facebook account.
	//   "FACEBOOK_GATEWAY" - Facebook account managed through gateway.
	//   "GOOGLE_ADS" - Google Ads account.
	//   "MICROSOFT" - Microsoft Advertising account.
	//   "SEARCH_ADS_360" - Search Ads 360 manager account.
	//   "YAHOO_JAPAN" - Yahoo Japan account.
	AccountType string `json:"accountType,omitempty"`

	// AutoTaggingEnabled: Whether auto-tagging is enabled for the customer.
	AutoTaggingEnabled bool `json:"autoTaggingEnabled,omitempty"`

	// ConversionTrackingSetting: Output only. Conversion tracking setting
	// for a customer.
	ConversionTrackingSetting *GoogleAdsSearchads360V0Resources__ConversionTrackingSetting `json:"conversionTrackingSetting,omitempty"`

	// CreationTime: Output only. The timestamp when this customer was
	// created. The timestamp is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss" format.
	CreationTime string `json:"creationTime,omitempty"`

	// CurrencyCode: Immutable. The currency in which the account operates.
	// A subset of the currency codes from the ISO 4217 standard is
	// supported.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// DescriptiveName: Optional, non-unique descriptive name of the
	// customer.
	DescriptiveName string `json:"descriptiveName,omitempty"`

	// DoubleClickCampaignManagerSetting: Output only. DoubleClick Campaign
	// Manager (DCM) setting for a manager customer.
	DoubleClickCampaignManagerSetting *GoogleAdsSearchads360V0Resources__DoubleClickCampaignManagerSetting `json:"doubleClickCampaignManagerSetting,omitempty"`

	// EngineId: Output only. ID of the account in the external engine
	// account.
	EngineId string `json:"engineId,omitempty"`

	// FinalUrlSuffix: The URL template for appending params to the final
	// URL.
	FinalUrlSuffix string `json:"finalUrlSuffix,omitempty"`

	// Id: Output only. The ID of the customer.
	Id int64 `json:"id,omitempty,string"`

	// LastModifiedTime: Output only. The datetime when this customer was
	// last modified. The datetime is in the customer's time zone and in
	// "yyyy-MM-dd HH:mm:ss.ssssss" format.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`

	// Manager: Output only. Whether the customer is a manager.
	Manager bool `json:"manager,omitempty"`

	// ResourceName: Immutable. The resource name of the customer. Customer
	// resource names have the form: `customers/{customer_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the customer.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Indicates an active account able to serve ads.
	//   "CANCELED" - Indicates a canceled account unable to serve ads. Can
	// be reactivated by an admin user.
	//   "SUSPENDED" - Indicates a suspended account unable to serve ads.
	// May only be activated by Google support.
	//   "CLOSED" - Indicates a closed account unable to serve ads. Test
	// account will also have CLOSED status. Status is permanent and may not
	// be reopened.
	Status string `json:"status,omitempty"`

	// TimeZone: Immutable. The local timezone ID of the customer.
	TimeZone string `json:"timeZone,omitempty"`

	// TrackingUrlTemplate: The URL template for constructing a tracking URL
	// out of parameters.
	TrackingUrlTemplate string `json:"trackingUrlTemplate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountStatus") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Customer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Customer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CustomerAsset: A link between a
// customer and an asset.
type GoogleAdsSearchads360V0Resources__CustomerAsset struct {
	// Asset: Required. Immutable. The asset which is linked to the
	// customer.
	Asset string `json:"asset,omitempty"`

	// ResourceName: Immutable. The resource name of the customer asset.
	// CustomerAsset resource names have the form:
	// `customers/{customer_id}/customerAssets/{asset_id}~{field_type}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Status of the customer asset.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Asset link is enabled.
	//   "REMOVED" - Asset link has been removed.
	//   "PAUSED" - Asset link is paused.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CustomerAsset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CustomerAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CustomerAssetSet: CustomerAssetSet
// is the linkage between a customer and an asset set. Adding a
// CustomerAssetSet links an asset set with a customer.
type GoogleAdsSearchads360V0Resources__CustomerAssetSet struct {
	// AssetSet: Immutable. The asset set which is linked to the customer.
	AssetSet string `json:"assetSet,omitempty"`

	// Customer: Immutable. The customer to which this asset set is linked.
	Customer string `json:"customer,omitempty"`

	// ResourceName: Immutable. The resource name of the customer asset set.
	// Asset set asset resource names have the form:
	// `customers/{customer_id}/customerAssetSets/{asset_set_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the customer asset set asset.
	// Read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - The status has not been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The linkage between asset set and its container is
	// enabled.
	//   "REMOVED" - The linkage between asset set and its container is
	// removed.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetSet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetSet") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CustomerAssetSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CustomerAssetSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CustomerClient: A link between the
// given customer and a client customer. CustomerClients only exist for
// manager customers. All direct and indirect client customers are
// included, as well as the manager itself.
type GoogleAdsSearchads360V0Resources__CustomerClient struct {
	// AppliedLabels: Output only. The resource names of the labels owned by
	// the requesting customer that are applied to the client customer.
	// Label resource names have the form:
	// `customers/{customer_id}/labels/{label_id}`
	AppliedLabels []string `json:"appliedLabels,omitempty"`

	// ClientCustomer: Output only. The resource name of the client-customer
	// which is linked to the given customer. Read only.
	ClientCustomer string `json:"clientCustomer,omitempty"`

	// CurrencyCode: Output only. Currency code (for example, 'USD', 'EUR')
	// for the client. Read only.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// DescriptiveName: Output only. Descriptive name for the client. Read
	// only.
	DescriptiveName string `json:"descriptiveName,omitempty"`

	// Hidden: Output only. Specifies whether this is a hidden account. Read
	// only.
	Hidden bool `json:"hidden,omitempty"`

	// Id: Output only. The ID of the client customer. Read only.
	Id int64 `json:"id,omitempty,string"`

	// Level: Output only. Distance between given customer and client. For
	// self link, the level value will be 0. Read only.
	Level int64 `json:"level,omitempty,string"`

	// Manager: Output only. Identifies if the client is a manager. Read
	// only.
	Manager bool `json:"manager,omitempty"`

	// ResourceName: Output only. The resource name of the customer client.
	// CustomerClient resource names have the form:
	// `customers/{customer_id}/customerClients/{client_customer_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. The status of the client customer. Read only.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Indicates an active account able to serve ads.
	//   "CANCELED" - Indicates a canceled account unable to serve ads. Can
	// be reactivated by an admin user.
	//   "SUSPENDED" - Indicates a suspended account unable to serve ads.
	// May only be activated by Google support.
	//   "CLOSED" - Indicates a closed account unable to serve ads. Test
	// account will also have CLOSED status. Status is permanent and may not
	// be reopened.
	Status string `json:"status,omitempty"`

	// TestAccount: Output only. Identifies if the client is a test account.
	// Read only.
	TestAccount bool `json:"testAccount,omitempty"`

	// TimeZone: Output only. Common Locale Data Repository (CLDR) string
	// representation of the time zone of the client, for example,
	// America/Los_Angeles. Read only.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppliedLabels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppliedLabels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CustomerClient) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CustomerClient
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__CustomerManagerLink: Represents
// customer-manager link relationship.
type GoogleAdsSearchads360V0Resources__CustomerManagerLink struct {
	// ManagerCustomer: Output only. The manager customer linked to the
	// customer.
	ManagerCustomer string `json:"managerCustomer,omitempty"`

	// ManagerLinkId: Output only. ID of the customer-manager link. This
	// field is read only.
	ManagerLinkId int64 `json:"managerLinkId,omitempty,string"`

	// ResourceName: Immutable. Name of the resource. CustomerManagerLink
	// resource names have the form:
	// `customers/{customer_id}/customerManagerLinks/{manager_customer_id}~{m
	// anager_link_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Status of the link between the customer and the manager.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ACTIVE" - Indicates current in-effect relationship
	//   "INACTIVE" - Indicates terminated relationship
	//   "PENDING" - Indicates relationship has been requested by manager,
	// but the client hasn't accepted yet.
	//   "REFUSED" - Relationship was requested by the manager, but the
	// client has refused.
	//   "CANCELED" - Indicates relationship has been requested by manager,
	// but manager canceled it.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ManagerCustomer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ManagerCustomer") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__CustomerManagerLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__CustomerManagerLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__DoubleClickCampaignManagerSetting:
// DoubleClick Campaign Manager (DCM) setting for a manager customer.
type GoogleAdsSearchads360V0Resources__DoubleClickCampaignManagerSetting struct {
	// AdvertiserId: Output only. ID of the Campaign Manager advertiser
	// associated with this customer.
	AdvertiserId int64 `json:"advertiserId,omitempty,string"`

	// NetworkId: Output only. ID of the Campaign Manager network associated
	// with this customer.
	NetworkId int64 `json:"networkId,omitempty,string"`

	// TimeZone: Output only. Time zone of the Campaign Manager network
	// associated with this customer in IANA Time Zone Database format, such
	// as America/New_York.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdvertiserId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvertiserId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__DoubleClickCampaignManagerSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__DoubleClickCampaignManagerSetting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__DynamicSearchAdsSearchTermView: A
// dynamic search ads search term view.
type GoogleAdsSearchads360V0Resources__DynamicSearchAdsSearchTermView struct {
	// LandingPage: Output only. The dynamically selected landing page URL
	// of the impression. This field is read-only.
	LandingPage string `json:"landingPage,omitempty"`

	// ResourceName: Output only. The resource name of the dynamic search
	// ads search term view. Dynamic search ads search term view resource
	// names have the form:
	// `customers/{customer_id}/dynamicSearchAdsSearchTermViews/{ad_group_id}
	// ~{search_term_fingerprint}~{headline_fingerprint}~{landing_page_finger
	// print}~{page_url_fingerprint}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LandingPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LandingPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__DynamicSearchAdsSearchTermView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__DynamicSearchAdsSearchTermView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__GenderView: A gender view.
type GoogleAdsSearchads360V0Resources__GenderView struct {
	// ResourceName: Output only. The resource name of the gender view.
	// Gender view resource names have the form:
	// `customers/{customer_id}/genderViews/{ad_group_id}~{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__GenderView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__GenderView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__GeoTargetConstant: A geo target
// constant.
type GoogleAdsSearchads360V0Resources__GeoTargetConstant struct {
	// CanonicalName: Output only. The fully qualified English name,
	// consisting of the target's name and that of its parent and country.
	CanonicalName string `json:"canonicalName,omitempty"`

	// CountryCode: Output only. The ISO-3166-1 alpha-2 country code that is
	// associated with the target.
	CountryCode string `json:"countryCode,omitempty"`

	// Id: Output only. The ID of the geo target constant.
	Id int64 `json:"id,omitempty,string"`

	// Name: Output only. Geo target constant English name.
	Name string `json:"name,omitempty"`

	// ParentGeoTarget: Output only. The resource name of the parent geo
	// target constant. Geo target constant resource names have the form:
	// `geoTargetConstants/{parent_geo_target_constant_id}`
	ParentGeoTarget string `json:"parentGeoTarget,omitempty"`

	// ResourceName: Output only. The resource name of the geo target
	// constant. Geo target constant resource names have the form:
	// `geoTargetConstants/{geo_target_constant_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. Geo target constant status.
	//
	// Possible values:
	//   "UNSPECIFIED" - No value has been specified.
	//   "UNKNOWN" - The received value is not known in this version. This
	// is a response-only value.
	//   "ENABLED" - The geo target constant is valid.
	//   "REMOVAL_PLANNED" - The geo target constant is obsolete and will be
	// removed.
	Status string `json:"status,omitempty"`

	// TargetType: Output only. Geo target constant target type.
	TargetType string `json:"targetType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__GeoTargetConstant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__GeoTargetConstant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__KeywordView: A keyword view.
type GoogleAdsSearchads360V0Resources__KeywordView struct {
	// ResourceName: Output only. The resource name of the keyword view.
	// Keyword view resource names have the form:
	// `customers/{customer_id}/keywordViews/{ad_group_id}~{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__KeywordView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__KeywordView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Label: A label.
type GoogleAdsSearchads360V0Resources__Label struct {
	// Id: Output only. ID of the label. Read only.
	Id int64 `json:"id,omitempty,string"`

	// Name: The name of the label. This field is required and should not be
	// empty when creating a new label. The length of this string should be
	// between 1 and 80, inclusive.
	Name string `json:"name,omitempty"`

	// ResourceName: Immutable. Name of the resource. Label resource names
	// have the form: `customers/{customer_id}/labels/{label_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. Status of the label. Read only.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ENABLED" - Label is enabled.
	//   "REMOVED" - Label is removed.
	Status string `json:"status,omitempty"`

	// TextLabel: A type of label displaying text on a colored background.
	TextLabel *GoogleAdsSearchads360V0Common__TextLabel `json:"textLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Label) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Label
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__LanguageConstant: A language.
type GoogleAdsSearchads360V0Resources__LanguageConstant struct {
	// Code: Output only. The language code, for example, "en_US", "en_AU",
	// "es", "fr", etc.
	Code string `json:"code,omitempty"`

	// Id: Output only. The ID of the language constant.
	Id int64 `json:"id,omitempty,string"`

	// Name: Output only. The full name of the language in English, for
	// example, "English (US)", "Spanish", etc.
	Name string `json:"name,omitempty"`

	// ResourceName: Output only. The resource name of the language
	// constant. Language constant resource names have the form:
	// `languageConstants/{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Targetable: Output only. Whether the language is targetable.
	Targetable bool `json:"targetable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__LanguageConstant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__LanguageConstant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ListingGroupFilterDimension:
// Listing dimensions for the asset group listing group filter.
type GoogleAdsSearchads360V0Resources__ListingGroupFilterDimension struct {
	// ProductBiddingCategory: Bidding category of a product offer.
	ProductBiddingCategory *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBiddingCategory `json:"productBiddingCategory,omitempty"`

	// ProductBrand: Brand of a product offer.
	ProductBrand *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductBrand `json:"productBrand,omitempty"`

	// ProductChannel: Locality of a product offer.
	ProductChannel *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductChannel `json:"productChannel,omitempty"`

	// ProductCondition: Condition of a product offer.
	ProductCondition *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCondition `json:"productCondition,omitempty"`

	// ProductCustomAttribute: Custom attribute of a product offer.
	ProductCustomAttribute *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductCustomAttribute `json:"productCustomAttribute,omitempty"`

	// ProductItemId: Item id of a product offer.
	ProductItemId *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductItemId `json:"productItemId,omitempty"`

	// ProductType: Type of a product offer.
	ProductType *GoogleAdsSearchads360V0ResourcesListingGroupFilterDimensionProductType `json:"productType,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ProductBiddingCategory") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProductBiddingCategory")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ListingGroupFilterDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ListingGroupFilterDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ListingGroupFilterDimensionPath:
// The path defining of dimensions defining a listing group filter.
type GoogleAdsSearchads360V0Resources__ListingGroupFilterDimensionPath struct {
	// Dimensions: Output only. The complete path of dimensions through the
	// listing group filter hierarchy (excluding the root node) to this
	// listing group filter.
	Dimensions []*GoogleAdsSearchads360V0Resources__ListingGroupFilterDimension `json:"dimensions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ListingGroupFilterDimensionPath) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ListingGroupFilterDimensionPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__LocationView: A location view
// summarizes the performance of campaigns by Location criteria.
type GoogleAdsSearchads360V0Resources__LocationView struct {
	// ResourceName: Output only. The resource name of the location view.
	// Location view resource names have the form:
	// `customers/{customer_id}/locationViews/{campaign_id}~{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__LocationView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__LocationView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ProductBiddingCategoryConstant: A
// Product Bidding Category.
type GoogleAdsSearchads360V0Resources__ProductBiddingCategoryConstant struct {
	// CountryCode: Output only. Two-letter upper-case country code of the
	// product bidding category.
	CountryCode string `json:"countryCode,omitempty"`

	// Id: Output only. ID of the product bidding category. This ID is
	// equivalent to the google_product_category ID as described in this
	// article: https://support.google.com/merchants/answer/6324436.
	Id int64 `json:"id,omitempty,string"`

	// LanguageCode: Output only. Language code of the product bidding
	// category.
	LanguageCode string `json:"languageCode,omitempty"`

	// Level: Output only. Level of the product bidding category.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "LEVEL1" - Level 1.
	//   "LEVEL2" - Level 2.
	//   "LEVEL3" - Level 3.
	//   "LEVEL4" - Level 4.
	//   "LEVEL5" - Level 5.
	Level string `json:"level,omitempty"`

	// LocalizedName: Output only. Display value of the product bidding
	// category localized according to language_code.
	LocalizedName string `json:"localizedName,omitempty"`

	// ProductBiddingCategoryConstantParent: Output only. Resource name of
	// the parent product bidding category.
	ProductBiddingCategoryConstantParent string `json:"productBiddingCategoryConstantParent,omitempty"`

	// ResourceName: Output only. The resource name of the product bidding
	// category. Product bidding category resource names have the form:
	// `productBiddingCategoryConstants/{country_code}~{level}~{id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Status: Output only. Status of the product bidding category.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ACTIVE" - The category is active and can be used for bidding.
	//   "OBSOLETE" - The category is obsolete. Used only for reporting
	// purposes.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ProductBiddingCategoryConstant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ProductBiddingCategoryConstant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ProductGroupView: A product group
// view.
type GoogleAdsSearchads360V0Resources__ProductGroupView struct {
	// ResourceName: Output only. The resource name of the product group
	// view. Product group view resource names have the form:
	// `customers/{customer_id}/productGroupViews/{ad_group_id}~{criterion_id
	// }`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ProductGroupView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ProductGroupView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__SearchAds360Field: A field or
// resource (artifact) used by SearchAds360Service.
type GoogleAdsSearchads360V0Resources__SearchAds360Field struct {
	// AttributeResources: Output only. The names of all resources that are
	// selectable with the described artifact. Fields from these resources
	// do not segment metrics when included in search queries. This field is
	// only set for artifacts whose category is RESOURCE.
	AttributeResources []string `json:"attributeResources,omitempty"`

	// Category: Output only. The category of the artifact.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unspecified
	//   "UNKNOWN" - Unknown
	//   "RESOURCE" - The described artifact is a resource.
	//   "ATTRIBUTE" - The described artifact is a field and is an attribute
	// of a resource. Including a resource attribute field in a query may
	// segment the query if the resource to which it is attributed segments
	// the resource found in the FROM clause.
	//   "SEGMENT" - The described artifact is a field and always segments
	// search queries.
	//   "METRIC" - The described artifact is a field and is a metric. It
	// never segments search queries.
	Category string `json:"category,omitempty"`

	// DataType: Output only. This field determines the operators that can
	// be used with the artifact in WHERE clauses.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unspecified
	//   "UNKNOWN" - Unknown
	//   "BOOLEAN" - Maps to google.protobuf.BoolValue Applicable operators:
	// =, !=
	//   "DATE" - Maps to google.protobuf.StringValue. It can be compared
	// using the set of operators specific to dates however. Applicable
	// operators: =, <, >, <=, >=, BETWEEN, DURING, and IN
	//   "DOUBLE" - Maps to google.protobuf.DoubleValue Applicable
	// operators: =, !=, <, >, IN, NOT IN
	//   "ENUM" - Maps to an enum. It's specific definition can be found at
	// type_url. Applicable operators: =, !=, IN, NOT IN
	//   "FLOAT" - Maps to google.protobuf.FloatValue Applicable operators:
	// =, !=, <, >, IN, NOT IN
	//   "INT32" - Maps to google.protobuf.Int32Value Applicable operators:
	// =, !=, <, >, <=, >=, BETWEEN, IN, NOT IN
	//   "INT64" - Maps to google.protobuf.Int64Value Applicable operators:
	// =, !=, <, >, <=, >=, BETWEEN, IN, NOT IN
	//   "MESSAGE" - Maps to a protocol buffer message type. The data type's
	// details can be found in type_url. No operators work with MESSAGE
	// fields.
	//   "RESOURCE_NAME" - Maps to google.protobuf.StringValue. Represents
	// the resource name (unique id) of a resource or one of its foreign
	// keys. No operators work with RESOURCE_NAME fields.
	//   "STRING" - Maps to google.protobuf.StringValue. Applicable
	// operators: =, !=, LIKE, NOT LIKE, IN, NOT IN
	//   "UINT64" - Maps to google.protobuf.UInt64Value Applicable
	// operators: =, !=, <, >, <=, >=, BETWEEN, IN, NOT IN
	DataType string `json:"dataType,omitempty"`

	// EnumValues: Output only. Values the artifact can assume if it is a
	// field of type ENUM. This field is only set for artifacts of category
	// SEGMENT or ATTRIBUTE.
	EnumValues []string `json:"enumValues,omitempty"`

	// Filterable: Output only. Whether the artifact can be used in a WHERE
	// clause in search queries.
	Filterable bool `json:"filterable,omitempty"`

	// IsRepeated: Output only. Whether the field artifact is repeated.
	IsRepeated bool `json:"isRepeated,omitempty"`

	// Metrics: Output only. This field lists the names of all metrics that
	// are selectable with the described artifact when it is used in the
	// FROM clause. It is only set for artifacts whose category is RESOURCE.
	Metrics []string `json:"metrics,omitempty"`

	// Name: Output only. The name of the artifact.
	Name string `json:"name,omitempty"`

	// ResourceName: Output only. The resource name of the artifact.
	// Artifact resource names have the form: `SearchAds360Fields/{name}`
	ResourceName string `json:"resourceName,omitempty"`

	// Segments: Output only. This field lists the names of all artifacts,
	// whether a segment or another resource, that segment metrics when
	// included in search queries and when the described artifact is used in
	// the FROM clause. It is only set for artifacts whose category is
	// RESOURCE.
	Segments []string `json:"segments,omitempty"`

	// Selectable: Output only. Whether the artifact can be used in a SELECT
	// clause in search queries.
	Selectable bool `json:"selectable,omitempty"`

	// SelectableWith: Output only. The names of all resources, segments,
	// and metrics that are selectable with the described artifact.
	SelectableWith []string `json:"selectableWith,omitempty"`

	// Sortable: Output only. Whether the artifact can be used in a ORDER BY
	// clause in search queries.
	Sortable bool `json:"sortable,omitempty"`

	// TypeUrl: Output only. The URL of proto describing the artifact's data
	// type.
	TypeUrl string `json:"typeUrl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributeResources")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeResources") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__SearchAds360Field) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__SearchAds360Field
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__ShoppingPerformanceView: Shopping
// performance view. Provides Shopping campaign statistics aggregated at
// several product dimension levels. Product dimension values from
// Merchant Center such as brand, category, custom attributes, product
// condition and product type will reflect the state of each dimension
// as of the date and time when the corresponding event was recorded.
type GoogleAdsSearchads360V0Resources__ShoppingPerformanceView struct {
	// ResourceName: Output only. The resource name of the Shopping
	// performance view. Shopping performance view resource names have the
	// form: `customers/{customer_id}/shoppingPerformanceView`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__ShoppingPerformanceView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__ShoppingPerformanceView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__UserList: A user list. This is a
// list of users a customer may target.
type GoogleAdsSearchads360V0Resources__UserList struct {
	// Id: Output only. Id of the user list.
	Id int64 `json:"id,omitempty,string"`

	// Name: Name of this user list. Depending on its access_reason, the
	// user list name may not be unique (for example, if
	// access_reason=SHARED)
	Name string `json:"name,omitempty"`

	// ResourceName: Immutable. The resource name of the user list. User
	// list resource names have the form:
	// `customers/{customer_id}/userLists/{user_list_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// Type: Output only. Type of this list. This field is read-only.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "REMARKETING" - UserList represented as a collection of conversion
	// types.
	//   "LOGICAL" - UserList represented as a combination of other user
	// lists/interests.
	//   "EXTERNAL_REMARKETING" - UserList created in the Google Ad Manager
	// platform.
	//   "RULE_BASED" - UserList associated with a rule.
	//   "SIMILAR" - UserList with users similar to users of another
	// UserList.
	//   "CRM_BASED" - UserList of first-party CRM data provided by
	// advertiser in the form of emails or other formats.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__UserList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__UserList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__Visit: A visit.
type GoogleAdsSearchads360V0Resources__Visit struct {
	// AdId: Output only. Ad ID. A value of 0 indicates that the ad is
	// unattributed.
	AdId int64 `json:"adId,omitempty,string"`

	// AssetFieldType: Output only. Asset field type of the visit event.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "HEADLINE" - The asset is linked for use as a headline.
	//   "DESCRIPTION" - The asset is linked for use as a description.
	//   "MANDATORY_AD_TEXT" - The asset is linked for use as mandatory ad
	// text.
	//   "MARKETING_IMAGE" - The asset is linked for use as a marketing
	// image.
	//   "MEDIA_BUNDLE" - The asset is linked for use as a media bundle.
	//   "YOUTUBE_VIDEO" - The asset is linked for use as a YouTube video.
	//   "BOOK_ON_GOOGLE" - The asset is linked to indicate that a hotels
	// campaign is "Book on Google" enabled.
	//   "LEAD_FORM" - The asset is linked for use as a Lead Form extension.
	//   "PROMOTION" - The asset is linked for use as a Promotion extension.
	//   "CALLOUT" - The asset is linked for use as a Callout extension.
	//   "STRUCTURED_SNIPPET" - The asset is linked for use as a Structured
	// Snippet extension.
	//   "SITELINK" - The asset is linked for use as a Sitelink.
	//   "MOBILE_APP" - The asset is linked for use as a Mobile App
	// extension.
	//   "HOTEL_CALLOUT" - The asset is linked for use as a Hotel Callout
	// extension.
	//   "CALL" - The asset is linked for use as a Call extension.
	//   "PRICE" - The asset is linked for use as a Price extension.
	//   "LONG_HEADLINE" - The asset is linked for use as a long headline.
	//   "BUSINESS_NAME" - The asset is linked for use as a business name.
	//   "SQUARE_MARKETING_IMAGE" - The asset is linked for use as a square
	// marketing image.
	//   "PORTRAIT_MARKETING_IMAGE" - The asset is linked for use as a
	// portrait marketing image.
	//   "LOGO" - The asset is linked for use as a logo.
	//   "LANDSCAPE_LOGO" - The asset is linked for use as a landscape logo.
	//   "VIDEO" - The asset is linked for use as a non YouTube logo.
	//   "CALL_TO_ACTION_SELECTION" - The asset is linked for use to select
	// a call-to-action.
	//   "AD_IMAGE" - The asset is linked for use to select an ad image.
	//   "BUSINESS_LOGO" - The asset is linked for use as a business logo.
	//   "HOTEL_PROPERTY" - The asset is linked for use as a hotel property
	// in a Performance Max for travel goals campaign.
	AssetFieldType string `json:"assetFieldType,omitempty"`

	// AssetId: Output only. ID of the asset which was interacted with
	// during the visit event.
	AssetId int64 `json:"assetId,omitempty,string"`

	// ClickId: Output only. A unique string for each visit that is passed
	// to the landing page as the click id URL parameter.
	ClickId string `json:"clickId,omitempty"`

	// CriterionId: Output only. Search Ads 360 keyword ID. A value of 0
	// indicates that the keyword is unattributed.
	CriterionId int64 `json:"criterionId,omitempty,string"`

	// Id: Output only. The ID of the visit.
	Id int64 `json:"id,omitempty,string"`

	// MerchantId: Output only. The Search Ads 360 inventory account ID
	// containing the product that was clicked on. Search Ads 360 generates
	// this ID when you link an inventory account in Search Ads 360.
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// ProductChannel: Output only. The sales channel of the product that
	// was clicked on: Online or Local.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Used for return value only. Represents value unknown in
	// this version.
	//   "ONLINE" - The item is sold online.
	//   "LOCAL" - The item is sold in local stores.
	ProductChannel string `json:"productChannel,omitempty"`

	// ProductCountryCode: Output only. The country (ISO-3166 format)
	// registered for the inventory feed that contains the product clicked
	// on.
	ProductCountryCode string `json:"productCountryCode,omitempty"`

	// ProductId: Output only. The ID of the product clicked on.
	ProductId string `json:"productId,omitempty"`

	// ProductLanguageCode: Output only. The language (ISO-639-1) that has
	// been set for the Merchant Center feed containing data about the
	// product.
	ProductLanguageCode string `json:"productLanguageCode,omitempty"`

	// ProductStoreId: Output only. The store in the Local Inventory Ad that
	// was clicked on. This should match the store IDs used in your local
	// products feed.
	ProductStoreId string `json:"productStoreId,omitempty"`

	// ResourceName: Output only. The resource name of the visit. Visit
	// resource names have the form:
	// `customers/{customer_id}/visits/{ad_group_id}~{criterion_id}~{ds_visit
	// _id}`
	ResourceName string `json:"resourceName,omitempty"`

	// VisitDateTime: Output only. The timestamp of the visit event. The
	// timestamp is in the customer's time zone and in "yyyy-MM-dd HH:mm:ss"
	// format.
	VisitDateTime string `json:"visitDateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__Visit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__Visit
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Resources__WebpageView: A webpage view.
type GoogleAdsSearchads360V0Resources__WebpageView struct {
	// ResourceName: Output only. The resource name of the webpage view.
	// Webpage view resource names have the form:
	// `customers/{customer_id}/webpageViews/{ad_group_id}~{criterion_id}`
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Resources__WebpageView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Resources__WebpageView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__CustomColumnHeader: Message for
// custom column header.
type GoogleAdsSearchads360V0Services__CustomColumnHeader struct {
	// Id: The custom column ID.
	Id int64 `json:"id,omitempty,string"`

	// Name: The user defined name of the custom column.
	Name string `json:"name,omitempty"`

	// ReferencesMetrics: True when the custom column references metrics.
	ReferencesMetrics bool `json:"referencesMetrics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__CustomColumnHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__CustomColumnHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse:
// Response message for CustomerService.ListAccessibleCustomers.
type GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse struct {
	// ResourceNames: Resource name of customers directly accessible by the
	// user authenticating the call.
	ResourceNames []string `json:"resourceNames,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ResourceNames") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceNames") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__ListCustomColumnsResponse: Response
// message for fetching all custom columns associated with a customer.
type GoogleAdsSearchads360V0Services__ListCustomColumnsResponse struct {
	// CustomColumns: The CustomColumns owned by the provided customer.
	CustomColumns []*GoogleAdsSearchads360V0Resources__CustomColumn `json:"customColumns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomColumns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomColumns") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__ListCustomColumnsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__ListCustomColumnsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__SearchAds360Row: A returned row from
// the query.
type GoogleAdsSearchads360V0Services__SearchAds360Row struct {
	// AdGroup: The ad group referenced in the query.
	AdGroup *GoogleAdsSearchads360V0Resources__AdGroup `json:"adGroup,omitempty"`

	// AdGroupAd: The ad referenced in the query.
	AdGroupAd *GoogleAdsSearchads360V0Resources__AdGroupAd `json:"adGroupAd,omitempty"`

	// AdGroupAdLabel: The ad group ad label referenced in the query.
	AdGroupAdLabel *GoogleAdsSearchads360V0Resources__AdGroupAdLabel `json:"adGroupAdLabel,omitempty"`

	// AdGroupAsset: The ad group asset referenced in the query.
	AdGroupAsset *GoogleAdsSearchads360V0Resources__AdGroupAsset `json:"adGroupAsset,omitempty"`

	// AdGroupAssetSet: The ad group asset set referenced in the query.
	AdGroupAssetSet *GoogleAdsSearchads360V0Resources__AdGroupAssetSet `json:"adGroupAssetSet,omitempty"`

	// AdGroupAudienceView: The ad group audience view referenced in the
	// query.
	AdGroupAudienceView *GoogleAdsSearchads360V0Resources__AdGroupAudienceView `json:"adGroupAudienceView,omitempty"`

	// AdGroupBidModifier: The bid modifier referenced in the query.
	AdGroupBidModifier *GoogleAdsSearchads360V0Resources__AdGroupBidModifier `json:"adGroupBidModifier,omitempty"`

	// AdGroupCriterion: The criterion referenced in the query.
	AdGroupCriterion *GoogleAdsSearchads360V0Resources__AdGroupCriterion `json:"adGroupCriterion,omitempty"`

	// AdGroupCriterionLabel: The ad group criterion label referenced in the
	// query.
	AdGroupCriterionLabel *GoogleAdsSearchads360V0Resources__AdGroupCriterionLabel `json:"adGroupCriterionLabel,omitempty"`

	// AdGroupLabel: The ad group label referenced in the query.
	AdGroupLabel *GoogleAdsSearchads360V0Resources__AdGroupLabel `json:"adGroupLabel,omitempty"`

	// AgeRangeView: The age range view referenced in the query.
	AgeRangeView *GoogleAdsSearchads360V0Resources__AgeRangeView `json:"ageRangeView,omitempty"`

	// Asset: The asset referenced in the query.
	Asset *GoogleAdsSearchads360V0Resources__Asset `json:"asset,omitempty"`

	// AssetGroup: The asset group referenced in the query.
	AssetGroup *GoogleAdsSearchads360V0Resources__AssetGroup `json:"assetGroup,omitempty"`

	// AssetGroupAsset: The asset group asset referenced in the query.
	AssetGroupAsset *GoogleAdsSearchads360V0Resources__AssetGroupAsset `json:"assetGroupAsset,omitempty"`

	// AssetGroupListingGroupFilter: The asset group listing group filter
	// referenced in the query.
	AssetGroupListingGroupFilter *GoogleAdsSearchads360V0Resources__AssetGroupListingGroupFilter `json:"assetGroupListingGroupFilter,omitempty"`

	// AssetGroupSignal: The asset group signal referenced in the query.
	AssetGroupSignal *GoogleAdsSearchads360V0Resources__AssetGroupSignal `json:"assetGroupSignal,omitempty"`

	// AssetGroupTopCombinationView: The asset group top combination view
	// referenced in the query.
	AssetGroupTopCombinationView *GoogleAdsSearchads360V0Resources__AssetGroupTopCombinationView `json:"assetGroupTopCombinationView,omitempty"`

	// AssetSet: The asset set referenced in the query.
	AssetSet *GoogleAdsSearchads360V0Resources__AssetSet `json:"assetSet,omitempty"`

	// AssetSetAsset: The asset set asset referenced in the query.
	AssetSetAsset *GoogleAdsSearchads360V0Resources__AssetSetAsset `json:"assetSetAsset,omitempty"`

	// Audience: The Audience referenced in the query.
	Audience *GoogleAdsSearchads360V0Resources__Audience `json:"audience,omitempty"`

	// BiddingStrategy: The bidding strategy referenced in the query.
	BiddingStrategy *GoogleAdsSearchads360V0Resources__BiddingStrategy `json:"biddingStrategy,omitempty"`

	// Campaign: The campaign referenced in the query.
	Campaign *GoogleAdsSearchads360V0Resources__Campaign `json:"campaign,omitempty"`

	// CampaignAsset: The campaign asset referenced in the query.
	CampaignAsset *GoogleAdsSearchads360V0Resources__CampaignAsset `json:"campaignAsset,omitempty"`

	// CampaignAssetSet: The campaign asset set referenced in the query.
	CampaignAssetSet *GoogleAdsSearchads360V0Resources__CampaignAssetSet `json:"campaignAssetSet,omitempty"`

	// CampaignAudienceView: The campaign audience view referenced in the
	// query.
	CampaignAudienceView *GoogleAdsSearchads360V0Resources__CampaignAudienceView `json:"campaignAudienceView,omitempty"`

	// CampaignBudget: The campaign budget referenced in the query.
	CampaignBudget *GoogleAdsSearchads360V0Resources__CampaignBudget `json:"campaignBudget,omitempty"`

	// CampaignCriterion: The campaign criterion referenced in the query.
	CampaignCriterion *GoogleAdsSearchads360V0Resources__CampaignCriterion `json:"campaignCriterion,omitempty"`

	// CampaignLabel: The campaign label referenced in the query.
	CampaignLabel *GoogleAdsSearchads360V0Resources__CampaignLabel `json:"campaignLabel,omitempty"`

	// CartDataSalesView: The cart data sales view referenced in the query.
	CartDataSalesView *GoogleAdsSearchads360V0Resources__CartDataSalesView `json:"cartDataSalesView,omitempty"`

	// Conversion: The event level conversion referenced in the query.
	Conversion *GoogleAdsSearchads360V0Resources__Conversion `json:"conversion,omitempty"`

	// ConversionAction: The conversion action referenced in the query.
	ConversionAction *GoogleAdsSearchads360V0Resources__ConversionAction `json:"conversionAction,omitempty"`

	// CustomColumns: The custom columns.
	CustomColumns []*GoogleAdsSearchads360V0Common__Value `json:"customColumns,omitempty"`

	// Customer: The customer referenced in the query.
	Customer *GoogleAdsSearchads360V0Resources__Customer `json:"customer,omitempty"`

	// CustomerAsset: The customer asset referenced in the query.
	CustomerAsset *GoogleAdsSearchads360V0Resources__CustomerAsset `json:"customerAsset,omitempty"`

	// CustomerAssetSet: The customer asset set referenced in the query.
	CustomerAssetSet *GoogleAdsSearchads360V0Resources__CustomerAssetSet `json:"customerAssetSet,omitempty"`

	// CustomerClient: The CustomerClient referenced in the query.
	CustomerClient *GoogleAdsSearchads360V0Resources__CustomerClient `json:"customerClient,omitempty"`

	// CustomerManagerLink: The CustomerManagerLink referenced in the query.
	CustomerManagerLink *GoogleAdsSearchads360V0Resources__CustomerManagerLink `json:"customerManagerLink,omitempty"`

	// DynamicSearchAdsSearchTermView: The dynamic search ads search term
	// view referenced in the query.
	DynamicSearchAdsSearchTermView *GoogleAdsSearchads360V0Resources__DynamicSearchAdsSearchTermView `json:"dynamicSearchAdsSearchTermView,omitempty"`

	// GenderView: The gender view referenced in the query.
	GenderView *GoogleAdsSearchads360V0Resources__GenderView `json:"genderView,omitempty"`

	// GeoTargetConstant: The geo target constant referenced in the query.
	GeoTargetConstant *GoogleAdsSearchads360V0Resources__GeoTargetConstant `json:"geoTargetConstant,omitempty"`

	// KeywordView: The keyword view referenced in the query.
	KeywordView *GoogleAdsSearchads360V0Resources__KeywordView `json:"keywordView,omitempty"`

	// Label: The label referenced in the query.
	Label *GoogleAdsSearchads360V0Resources__Label `json:"label,omitempty"`

	// LanguageConstant: The language constant referenced in the query.
	LanguageConstant *GoogleAdsSearchads360V0Resources__LanguageConstant `json:"languageConstant,omitempty"`

	// LocationView: The location view referenced in the query.
	LocationView *GoogleAdsSearchads360V0Resources__LocationView `json:"locationView,omitempty"`

	// Metrics: The metrics.
	Metrics *GoogleAdsSearchads360V0Common__Metrics `json:"metrics,omitempty"`

	// ProductBiddingCategoryConstant: The Product Bidding Category
	// referenced in the query.
	ProductBiddingCategoryConstant *GoogleAdsSearchads360V0Resources__ProductBiddingCategoryConstant `json:"productBiddingCategoryConstant,omitempty"`

	// ProductGroupView: The product group view referenced in the query.
	ProductGroupView *GoogleAdsSearchads360V0Resources__ProductGroupView `json:"productGroupView,omitempty"`

	// Segments: The segments.
	Segments *GoogleAdsSearchads360V0Common__Segments `json:"segments,omitempty"`

	// ShoppingPerformanceView: The shopping performance view referenced in
	// the query.
	ShoppingPerformanceView *GoogleAdsSearchads360V0Resources__ShoppingPerformanceView `json:"shoppingPerformanceView,omitempty"`

	// UserList: The user list referenced in the query.
	UserList *GoogleAdsSearchads360V0Resources__UserList `json:"userList,omitempty"`

	// Visit: The event level visit referenced in the query.
	Visit *GoogleAdsSearchads360V0Resources__Visit `json:"visit,omitempty"`

	// WebpageView: The webpage view referenced in the query.
	WebpageView *GoogleAdsSearchads360V0Resources__WebpageView `json:"webpageView,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__SearchAds360Row) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__SearchAds360Row
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest:
// Request message for
// SearchAds360FieldService.SearchSearchAds360Fields.
type GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest struct {
	// PageSize: Number of elements to retrieve in a single page. When too
	// large a page is requested, the server may decide to further limit the
	// number of returned resources.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request the
	// next page of results.
	PageToken string `json:"pageToken,omitempty"`

	// Query: Required. The query string.
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse:
// Response message for
// SearchAds360FieldService.SearchSearchAds360Fields.
type GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse struct {
	// NextPageToken: Pagination token used to retrieve the next page of
	// results. Pass the content of this string as the `page_token`
	// attribute of the next request. `next_page_token` is not returned for
	// the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: The list of fields that matched the query.
	Results []*GoogleAdsSearchads360V0Resources__SearchAds360Field `json:"results,omitempty"`

	// TotalResultsCount: Total number of results that match the query
	// ignoring the LIMIT clause.
	TotalResultsCount int64 `json:"totalResultsCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__SearchSearchAds360Request: Request
// message for SearchAds360Service.Search.
type GoogleAdsSearchads360V0Services__SearchSearchAds360Request struct {
	// PageSize: Number of elements to retrieve in a single page. When too
	// large a page is requested, the server may decide to further limit the
	// number of returned resources.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request the
	// next page of results.
	PageToken string `json:"pageToken,omitempty"`

	// Query: Required. The query string.
	Query string `json:"query,omitempty"`

	// ReturnTotalResultsCount: If true, the total number of results that
	// match the query ignoring the LIMIT clause will be included in the
	// response. Default is false.
	ReturnTotalResultsCount bool `json:"returnTotalResultsCount,omitempty"`

	// SummaryRowSetting: Determines whether a summary row will be returned.
	// By default, summary row is not returned. If requested, the summary
	// row will be sent in a response by itself after all other query
	// results are returned.
	//
	// Possible values:
	//   "UNSPECIFIED" - Not specified.
	//   "UNKNOWN" - Represent unknown values of return summary row.
	//   "NO_SUMMARY_ROW" - Do not return summary row.
	//   "SUMMARY_ROW_WITH_RESULTS" - Return summary row along with results.
	// The summary row will be returned in the last batch alone (last batch
	// will contain no results).
	//   "SUMMARY_ROW_ONLY" - Return summary row only and return no results.
	SummaryRowSetting string `json:"summaryRowSetting,omitempty"`

	// ValidateOnly: If true, the request is validated but not executed.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__SearchSearchAds360Request) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__SearchSearchAds360Request
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAdsSearchads360V0Services__SearchSearchAds360Response: Response
// message for SearchAds360Service.Search.
type GoogleAdsSearchads360V0Services__SearchSearchAds360Response struct {
	// CustomColumnHeaders: The headers of the custom columns in the
	// results.
	CustomColumnHeaders []*GoogleAdsSearchads360V0Services__CustomColumnHeader `json:"customColumnHeaders,omitempty"`

	// FieldMask: FieldMask that represents what fields were requested by
	// the user.
	FieldMask string `json:"fieldMask,omitempty"`

	// NextPageToken: Pagination token used to retrieve the next page of
	// results. Pass the content of this string as the `page_token`
	// attribute of the next request. `next_page_token` is not returned for
	// the last page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: The list of rows that matched the query.
	Results []*GoogleAdsSearchads360V0Services__SearchAds360Row `json:"results,omitempty"`

	// SummaryRow: Summary row that contains summary of metrics in results.
	// Summary of metrics means aggregation of metrics across all results,
	// here aggregation could be sum, average, rate, etc.
	SummaryRow *GoogleAdsSearchads360V0Services__SearchAds360Row `json:"summaryRow,omitempty"`

	// TotalResultsCount: Total number of results that match the query
	// ignoring the LIMIT clause.
	TotalResultsCount int64 `json:"totalResultsCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomColumnHeaders")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomColumnHeaders") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAdsSearchads360V0Services__SearchSearchAds360Response) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAdsSearchads360V0Services__SearchSearchAds360Response
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "searchads360.customers.listAccessibleCustomers":

type CustomersListAccessibleCustomersCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListAccessibleCustomers: Returns resource names of customers directly
// accessible by the user authenticating the call. List of thrown
// errors: AuthenticationError () [AuthorizationError]() HeaderError ()
// [InternalError]() QuotaError () [RequestError]()
func (r *CustomersService) ListAccessibleCustomers() *CustomersListAccessibleCustomersCall {
	c := &CustomersListAccessibleCustomersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersListAccessibleCustomersCall) Fields(s ...googleapi.Field) *CustomersListAccessibleCustomersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersListAccessibleCustomersCall) IfNoneMatch(entityTag string) *CustomersListAccessibleCustomersCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersListAccessibleCustomersCall) Context(ctx context.Context) *CustomersListAccessibleCustomersCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersListAccessibleCustomersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersListAccessibleCustomersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v0/customers:listAccessibleCustomers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "searchads360.customers.listAccessibleCustomers" call.
// Exactly one of
// *GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersListAccessibleCustomersCall) Do(opts ...googleapi.CallOption) (*GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns resource names of customers directly accessible by the user authenticating the call. List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]() [InternalError]() [QuotaError]() [RequestError]()",
	//   "flatPath": "v0/customers:listAccessibleCustomers",
	//   "httpMethod": "GET",
	//   "id": "searchads360.customers.listAccessibleCustomers",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v0/customers:listAccessibleCustomers",
	//   "response": {
	//     "$ref": "GoogleAdsSearchads360V0Services__ListAccessibleCustomersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclicksearch"
	//   ]
	// }

}

// method id "searchads360.customers.customColumns.get":

type CustomersCustomColumnsGetCall struct {
	s            *Service
	resourceName string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the requested custom column in full detail.
//
// - resourceName: The resource name of the custom column to fetch.
func (r *CustomersCustomColumnsService) Get(resourceName string) *CustomersCustomColumnsGetCall {
	c := &CustomersCustomColumnsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceName = resourceName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersCustomColumnsGetCall) Fields(s ...googleapi.Field) *CustomersCustomColumnsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersCustomColumnsGetCall) IfNoneMatch(entityTag string) *CustomersCustomColumnsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersCustomColumnsGetCall) Context(ctx context.Context) *CustomersCustomColumnsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersCustomColumnsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersCustomColumnsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v0/{+resourceName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceName": c.resourceName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "searchads360.customers.customColumns.get" call.
// Exactly one of *GoogleAdsSearchads360V0Resources__CustomColumn or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAdsSearchads360V0Resources__CustomColumn.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersCustomColumnsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAdsSearchads360V0Resources__CustomColumn, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAdsSearchads360V0Resources__CustomColumn{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the requested custom column in full detail.",
	//   "flatPath": "v0/customers/{customersId}/customColumns/{customColumnsId}",
	//   "httpMethod": "GET",
	//   "id": "searchads360.customers.customColumns.get",
	//   "parameterOrder": [
	//     "resourceName"
	//   ],
	//   "parameters": {
	//     "resourceName": {
	//       "description": "Required. The resource name of the custom column to fetch.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/customColumns/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v0/{+resourceName}",
	//   "response": {
	//     "$ref": "GoogleAdsSearchads360V0Resources__CustomColumn"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclicksearch"
	//   ]
	// }

}

// method id "searchads360.customers.customColumns.list":

type CustomersCustomColumnsListCall struct {
	s            *Service
	customerId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all the custom columns associated with the customer in
// full detail.
//
//   - customerId: The ID of the customer to apply the CustomColumn list
//     operation to.
func (r *CustomersCustomColumnsService) List(customerId string) *CustomersCustomColumnsListCall {
	c := &CustomersCustomColumnsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersCustomColumnsListCall) Fields(s ...googleapi.Field) *CustomersCustomColumnsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersCustomColumnsListCall) IfNoneMatch(entityTag string) *CustomersCustomColumnsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersCustomColumnsListCall) Context(ctx context.Context) *CustomersCustomColumnsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersCustomColumnsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersCustomColumnsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v0/customers/{+customerId}/customColumns")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "searchads360.customers.customColumns.list" call.
// Exactly one of
// *GoogleAdsSearchads360V0Services__ListCustomColumnsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAdsSearchads360V0Services__ListCustomColumnsResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersCustomColumnsListCall) Do(opts ...googleapi.CallOption) (*GoogleAdsSearchads360V0Services__ListCustomColumnsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAdsSearchads360V0Services__ListCustomColumnsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns all the custom columns associated with the customer in full detail.",
	//   "flatPath": "v0/customers/{customersId}/customColumns",
	//   "httpMethod": "GET",
	//   "id": "searchads360.customers.customColumns.list",
	//   "parameterOrder": [
	//     "customerId"
	//   ],
	//   "parameters": {
	//     "customerId": {
	//       "description": "Required. The ID of the customer to apply the CustomColumn list operation to.",
	//       "location": "path",
	//       "pattern": "^[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v0/customers/{+customerId}/customColumns",
	//   "response": {
	//     "$ref": "GoogleAdsSearchads360V0Services__ListCustomColumnsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclicksearch"
	//   ]
	// }

}

// method id "searchads360.customers.searchAds360.search":

type CustomersSearchAds360SearchCall struct {
	s                                                          *Service
	customerId                                                 string
	googleadssearchads360v0services__searchsearchads360request *GoogleAdsSearchads360V0Services__SearchSearchAds360Request
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// Search: Returns all rows that match the search query. List of thrown
// errors: AuthenticationError () [AuthorizationError]() HeaderError ()
// [InternalError]() QueryError () [QuotaError]() RequestError ()
//
// - customerId: The ID of the customer being queried.
func (r *CustomersSearchAds360Service) Search(customerId string, googleadssearchads360v0services__searchsearchads360request *GoogleAdsSearchads360V0Services__SearchSearchAds360Request) *CustomersSearchAds360SearchCall {
	c := &CustomersSearchAds360SearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.googleadssearchads360v0services__searchsearchads360request = googleadssearchads360v0services__searchsearchads360request
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersSearchAds360SearchCall) Fields(s ...googleapi.Field) *CustomersSearchAds360SearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersSearchAds360SearchCall) Context(ctx context.Context) *CustomersSearchAds360SearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersSearchAds360SearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersSearchAds360SearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleadssearchads360v0services__searchsearchads360request)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v0/customers/{+customerId}/searchAds360:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "searchads360.customers.searchAds360.search" call.
// Exactly one of
// *GoogleAdsSearchads360V0Services__SearchSearchAds360Response or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAdsSearchads360V0Services__SearchSearchAds360Response.ServerRes
// ponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersSearchAds360SearchCall) Do(opts ...googleapi.CallOption) (*GoogleAdsSearchads360V0Services__SearchSearchAds360Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAdsSearchads360V0Services__SearchSearchAds360Response{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns all rows that match the search query. List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]() [InternalError]() [QueryError]() [QuotaError]() [RequestError]()",
	//   "flatPath": "v0/customers/{customersId}/searchAds360:search",
	//   "httpMethod": "POST",
	//   "id": "searchads360.customers.searchAds360.search",
	//   "parameterOrder": [
	//     "customerId"
	//   ],
	//   "parameters": {
	//     "customerId": {
	//       "description": "Required. The ID of the customer being queried.",
	//       "location": "path",
	//       "pattern": "^[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v0/customers/{+customerId}/searchAds360:search",
	//   "request": {
	//     "$ref": "GoogleAdsSearchads360V0Services__SearchSearchAds360Request"
	//   },
	//   "response": {
	//     "$ref": "GoogleAdsSearchads360V0Services__SearchSearchAds360Response"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclicksearch"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersSearchAds360SearchCall) Pages(ctx context.Context, f func(*GoogleAdsSearchads360V0Services__SearchSearchAds360Response) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleadssearchads360v0services__searchsearchads360request.PageToken = pt }(c.googleadssearchads360v0services__searchsearchads360request.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleadssearchads360v0services__searchsearchads360request.PageToken = x.NextPageToken
	}
}

// method id "searchads360.searchAds360Fields.get":

type SearchAds360FieldsGetCall struct {
	s            *Service
	resourceName string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns just the requested field. List of thrown errors:
// AuthenticationError () [AuthorizationError]() HeaderError ()
// [InternalError]() QuotaError () [RequestError]()
//
// - resourceName: The resource name of the field to get.
func (r *SearchAds360FieldsService) Get(resourceName string) *SearchAds360FieldsGetCall {
	c := &SearchAds360FieldsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceName = resourceName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *SearchAds360FieldsGetCall) Fields(s ...googleapi.Field) *SearchAds360FieldsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *SearchAds360FieldsGetCall) IfNoneMatch(entityTag string) *SearchAds360FieldsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *SearchAds360FieldsGetCall) Context(ctx context.Context) *SearchAds360FieldsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *SearchAds360FieldsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SearchAds360FieldsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v0/{+resourceName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceName": c.resourceName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "searchads360.searchAds360Fields.get" call.
// Exactly one of *GoogleAdsSearchads360V0Resources__SearchAds360Field
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAdsSearchads360V0Resources__SearchAds360Field.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *SearchAds360FieldsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAdsSearchads360V0Resources__SearchAds360Field, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAdsSearchads360V0Resources__SearchAds360Field{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns just the requested field. List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]() [InternalError]() [QuotaError]() [RequestError]()",
	//   "flatPath": "v0/searchAds360Fields/{searchAds360FieldsId}",
	//   "httpMethod": "GET",
	//   "id": "searchads360.searchAds360Fields.get",
	//   "parameterOrder": [
	//     "resourceName"
	//   ],
	//   "parameters": {
	//     "resourceName": {
	//       "description": "Required. The resource name of the field to get.",
	//       "location": "path",
	//       "pattern": "^searchAds360Fields/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v0/{+resourceName}",
	//   "response": {
	//     "$ref": "GoogleAdsSearchads360V0Resources__SearchAds360Field"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclicksearch"
	//   ]
	// }

}

// method id "searchads360.searchAds360Fields.search":

type SearchAds360FieldsSearchCall struct {
	s                                                                *Service
	googleadssearchads360v0services__searchsearchads360fieldsrequest *GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// Search: Returns all fields that match the search query. List of
// thrown errors: AuthenticationError () [AuthorizationError]()
// HeaderError () [InternalError]() QueryError () [QuotaError]()
// RequestError ()
func (r *SearchAds360FieldsService) Search(googleadssearchads360v0services__searchsearchads360fieldsrequest *GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest) *SearchAds360FieldsSearchCall {
	c := &SearchAds360FieldsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleadssearchads360v0services__searchsearchads360fieldsrequest = googleadssearchads360v0services__searchsearchads360fieldsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *SearchAds360FieldsSearchCall) Fields(s ...googleapi.Field) *SearchAds360FieldsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *SearchAds360FieldsSearchCall) Context(ctx context.Context) *SearchAds360FieldsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *SearchAds360FieldsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SearchAds360FieldsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleadssearchads360v0services__searchsearchads360fieldsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v0/searchAds360Fields:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "searchads360.searchAds360Fields.search" call.
// Exactly one of
// *GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse.Ser
// verResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *SearchAds360FieldsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns all fields that match the search query. List of thrown errors: [AuthenticationError]() [AuthorizationError]() [HeaderError]() [InternalError]() [QueryError]() [QuotaError]() [RequestError]()",
	//   "flatPath": "v0/searchAds360Fields:search",
	//   "httpMethod": "POST",
	//   "id": "searchads360.searchAds360Fields.search",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v0/searchAds360Fields:search",
	//   "request": {
	//     "$ref": "GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclicksearch"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *SearchAds360FieldsSearchCall) Pages(ctx context.Context, f func(*GoogleAdsSearchads360V0Services__SearchSearchAds360FieldsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleadssearchads360v0services__searchsearchads360fieldsrequest.PageToken = pt }(c.googleadssearchads360v0services__searchsearchads360fieldsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleadssearchads360v0services__searchsearchads360fieldsrequest.PageToken = x.NextPageToken
	}
}
