package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyLogRetrievalStatus invokes the waf_openapi.ModifyLogRetrievalStatus API synchronously
func (client *Client) ModifyLogRetrievalStatus(request *ModifyLogRetrievalStatusRequest) (response *ModifyLogRetrievalStatusResponse, err error) {
	response = CreateModifyLogRetrievalStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyLogRetrievalStatusWithChan invokes the waf_openapi.ModifyLogRetrievalStatus API asynchronously
func (client *Client) ModifyLogRetrievalStatusWithChan(request *ModifyLogRetrievalStatusRequest) (<-chan *ModifyLogRetrievalStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyLogRetrievalStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyLogRetrievalStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyLogRetrievalStatusWithCallback invokes the waf_openapi.ModifyLogRetrievalStatus API asynchronously
func (client *Client) ModifyLogRetrievalStatusWithCallback(request *ModifyLogRetrievalStatusRequest, callback func(response *ModifyLogRetrievalStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyLogRetrievalStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyLogRetrievalStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyLogRetrievalStatusRequest is the request struct for api ModifyLogRetrievalStatus
type ModifyLogRetrievalStatusRequest struct {
	*requests.RpcRequest
	Enabled    requests.Integer `position:"Query" name:"Enabled"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	Domain     string           `position:"Query" name:"Domain"`
	Lang       string           `position:"Query" name:"Lang"`
}

// ModifyLogRetrievalStatusResponse is the response struct for api ModifyLogRetrievalStatus
type ModifyLogRetrievalStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyLogRetrievalStatusRequest creates a request to invoke ModifyLogRetrievalStatus API
func CreateModifyLogRetrievalStatusRequest() (request *ModifyLogRetrievalStatusRequest) {
	request = &ModifyLogRetrievalStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "ModifyLogRetrievalStatus", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyLogRetrievalStatusResponse creates a response to parse from ModifyLogRetrievalStatus response
func CreateModifyLogRetrievalStatusResponse() (response *ModifyLogRetrievalStatusResponse) {
	response = &ModifyLogRetrievalStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
