package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIPv6Translators invokes the vpc.DescribeIPv6Translators API synchronously
func (client *Client) DescribeIPv6Translators(request *DescribeIPv6TranslatorsRequest) (response *DescribeIPv6TranslatorsResponse, err error) {
	response = CreateDescribeIPv6TranslatorsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIPv6TranslatorsWithChan invokes the vpc.DescribeIPv6Translators API asynchronously
func (client *Client) DescribeIPv6TranslatorsWithChan(request *DescribeIPv6TranslatorsRequest) (<-chan *DescribeIPv6TranslatorsResponse, <-chan error) {
	responseChan := make(chan *DescribeIPv6TranslatorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIPv6Translators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIPv6TranslatorsWithCallback invokes the vpc.DescribeIPv6Translators API asynchronously
func (client *Client) DescribeIPv6TranslatorsWithCallback(request *DescribeIPv6TranslatorsRequest, callback func(response *DescribeIPv6TranslatorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIPv6TranslatorsResponse
		var err error
		defer close(result)
		response, err = client.DescribeIPv6Translators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIPv6TranslatorsRequest is the request struct for api DescribeIPv6Translators
type DescribeIPv6TranslatorsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AllocateIpv4Addr     string           `position:"Query" name:"AllocateIpv4Addr"`
	Spec                 string           `position:"Query" name:"Spec"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	BusinessStatus       string           `position:"Query" name:"BusinessStatus"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	AllocateIpv6Addr     string           `position:"Query" name:"AllocateIpv6Addr"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
	Ipv6TranslatorId     string           `position:"Query" name:"Ipv6TranslatorId"`
	PayType              string           `position:"Query" name:"PayType"`
	Status               string           `position:"Query" name:"Status"`
}

// DescribeIPv6TranslatorsResponse is the response struct for api DescribeIPv6Translators
type DescribeIPv6TranslatorsResponse struct {
	*responses.BaseResponse
	PageSize        int             `json:"PageSize" xml:"PageSize"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	PageNumber      int             `json:"PageNumber" xml:"PageNumber"`
	TotalCount      int             `json:"TotalCount" xml:"TotalCount"`
	Ipv6Translators Ipv6Translators `json:"Ipv6Translators" xml:"Ipv6Translators"`
}

// CreateDescribeIPv6TranslatorsRequest creates a request to invoke DescribeIPv6Translators API
func CreateDescribeIPv6TranslatorsRequest() (request *DescribeIPv6TranslatorsRequest) {
	request = &DescribeIPv6TranslatorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeIPv6Translators", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIPv6TranslatorsResponse creates a response to parse from DescribeIPv6Translators response
func CreateDescribeIPv6TranslatorsResponse() (response *DescribeIPv6TranslatorsResponse) {
	response = &DescribeIPv6TranslatorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
