package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDnatEntry invokes the uis.ModifyDnatEntry API synchronously
// api document: https://help.aliyun.com/api/uis/modifydnatentry.html
func (client *Client) ModifyDnatEntry(request *ModifyDnatEntryRequest) (response *ModifyDnatEntryResponse, err error) {
	response = CreateModifyDnatEntryResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDnatEntryWithChan invokes the uis.ModifyDnatEntry API asynchronously
// api document: https://help.aliyun.com/api/uis/modifydnatentry.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDnatEntryWithChan(request *ModifyDnatEntryRequest) (<-chan *ModifyDnatEntryResponse, <-chan error) {
	responseChan := make(chan *ModifyDnatEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDnatEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDnatEntryWithCallback invokes the uis.ModifyDnatEntry API asynchronously
// api document: https://help.aliyun.com/api/uis/modifydnatentry.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDnatEntryWithCallback(request *ModifyDnatEntryRequest, callback func(response *ModifyDnatEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDnatEntryResponse
		var err error
		defer close(result)
		response, err = client.ModifyDnatEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDnatEntryRequest is the request struct for api ModifyDnatEntry
type ModifyDnatEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	IpProtocol           string           `position:"Query" name:"IpProtocol"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OriginalPort         requests.Integer `position:"Query" name:"OriginalPort"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OriginalIp           string           `position:"Query" name:"OriginalIp"`
	DestinationIp        string           `position:"Query" name:"DestinationIp"`
	DestinationPort      requests.Integer `position:"Query" name:"DestinationPort"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	UisDnatId            string           `position:"Query" name:"UisDnatId"`
	Name                 string           `position:"Query" name:"Name"`
}

// ModifyDnatEntryResponse is the response struct for api ModifyDnatEntry
type ModifyDnatEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDnatEntryRequest creates a request to invoke ModifyDnatEntry API
func CreateModifyDnatEntryRequest() (request *ModifyDnatEntryRequest) {
	request = &ModifyDnatEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "ModifyDnatEntry", "uis", "openAPI")
	return
}

// CreateModifyDnatEntryResponse creates a response to parse from ModifyDnatEntry response
func CreateModifyDnatEntryResponse() (response *ModifyDnatEntryResponse) {
	response = &ModifyDnatEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
