package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetGatewayADInfo invokes the sgw.SetGatewayADInfo API synchronously
func (client *Client) SetGatewayADInfo(request *SetGatewayADInfoRequest) (response *SetGatewayADInfoResponse, err error) {
	response = CreateSetGatewayADInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SetGatewayADInfoWithChan invokes the sgw.SetGatewayADInfo API asynchronously
func (client *Client) SetGatewayADInfoWithChan(request *SetGatewayADInfoRequest) (<-chan *SetGatewayADInfoResponse, <-chan error) {
	responseChan := make(chan *SetGatewayADInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetGatewayADInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetGatewayADInfoWithCallback invokes the sgw.SetGatewayADInfo API asynchronously
func (client *Client) SetGatewayADInfoWithCallback(request *SetGatewayADInfoRequest, callback func(response *SetGatewayADInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetGatewayADInfoResponse
		var err error
		defer close(result)
		response, err = client.SetGatewayADInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetGatewayADInfoRequest is the request struct for api SetGatewayADInfo
type SetGatewayADInfoRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	Password      string           `position:"Query" name:"Password"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ServerIp      string           `position:"Query" name:"ServerIp"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
	Username      string           `position:"Query" name:"Username"`
	IsEnabled     requests.Boolean `position:"Query" name:"IsEnabled"`
}

// SetGatewayADInfoResponse is the response struct for api SetGatewayADInfo
type SetGatewayADInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateSetGatewayADInfoRequest creates a request to invoke SetGatewayADInfo API
func CreateSetGatewayADInfoRequest() (request *SetGatewayADInfoRequest) {
	request = &SetGatewayADInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "SetGatewayADInfo", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetGatewayADInfoResponse creates a response to parse from SetGatewayADInfo response
func CreateSetGatewayADInfoResponse() (response *SetGatewayADInfoResponse) {
	response = &SetGatewayADInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
