package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIntentStatistics invokes the outboundbot.DescribeIntentStatistics API synchronously
func (client *Client) DescribeIntentStatistics(request *DescribeIntentStatisticsRequest) (response *DescribeIntentStatisticsResponse, err error) {
	response = CreateDescribeIntentStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIntentStatisticsWithChan invokes the outboundbot.DescribeIntentStatistics API asynchronously
func (client *Client) DescribeIntentStatisticsWithChan(request *DescribeIntentStatisticsRequest) (<-chan *DescribeIntentStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeIntentStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIntentStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIntentStatisticsWithCallback invokes the outboundbot.DescribeIntentStatistics API asynchronously
func (client *Client) DescribeIntentStatisticsWithCallback(request *DescribeIntentStatisticsRequest, callback func(response *DescribeIntentStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIntentStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeIntentStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIntentStatisticsRequest is the request struct for api DescribeIntentStatistics
type DescribeIntentStatisticsRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	JobGroupId string           `position:"Query" name:"JobGroupId"`
	Limit      requests.Integer `position:"Query" name:"Limit"`
}

// DescribeIntentStatisticsResponse is the response struct for api DescribeIntentStatistics
type DescribeIntentStatisticsResponse struct {
	*responses.BaseResponse
	RequestId            string                 `json:"RequestId" xml:"RequestId"`
	Success              bool                   `json:"Success" xml:"Success"`
	Code                 string                 `json:"Code" xml:"Code"`
	Message              string                 `json:"Message" xml:"Message"`
	HttpStatusCode       int                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	InstanceId           string                 `json:"InstanceId" xml:"InstanceId"`
	GroupId              string                 `json:"GroupId" xml:"GroupId"`
	ProcessIntentNum     int                    `json:"ProcessIntentNum" xml:"ProcessIntentNum"`
	GlobalIntentNum      int                    `json:"GlobalIntentNum" xml:"GlobalIntentNum"`
	ProcessIntents       []IntentStatisticsItem `json:"ProcessIntents" xml:"ProcessIntents"`
	GlobalIntents        []IntentStatisticsItem `json:"GlobalIntents" xml:"GlobalIntents"`
	IntentsAfterNoAnswer []IntentStatisticsItem `json:"IntentsAfterNoAnswer" xml:"IntentsAfterNoAnswer"`
}

// CreateDescribeIntentStatisticsRequest creates a request to invoke DescribeIntentStatistics API
func CreateDescribeIntentStatisticsRequest() (request *DescribeIntentStatisticsRequest) {
	request = &DescribeIntentStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeIntentStatistics", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIntentStatisticsResponse creates a response to parse from DescribeIntentStatistics response
func CreateDescribeIntentStatisticsResponse() (response *DescribeIntentStatisticsResponse) {
	response = &DescribeIntentStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
