package onsmqtt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryToken invokes the onsmqtt.QueryToken API synchronously
func (client *Client) QueryToken(request *QueryTokenRequest) (response *QueryTokenResponse, err error) {
	response = CreateQueryTokenResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTokenWithChan invokes the onsmqtt.QueryToken API asynchronously
func (client *Client) QueryTokenWithChan(request *QueryTokenRequest) (<-chan *QueryTokenResponse, <-chan error) {
	responseChan := make(chan *QueryTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTokenWithCallback invokes the onsmqtt.QueryToken API asynchronously
func (client *Client) QueryTokenWithCallback(request *QueryTokenRequest, callback func(response *QueryTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTokenResponse
		var err error
		defer close(result)
		response, err = client.QueryToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTokenRequest is the request struct for api QueryToken
type QueryTokenRequest struct {
	*requests.RpcRequest
	Token      string `position:"Query" name:"Token"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// QueryTokenResponse is the response struct for api QueryToken
type QueryTokenResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TokenStatus bool   `json:"TokenStatus" xml:"TokenStatus"`
}

// CreateQueryTokenRequest creates a request to invoke QueryToken API
func CreateQueryTokenRequest() (request *QueryTokenRequest) {
	request = &QueryTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OnsMqtt", "2020-04-20", "QueryToken", "onsmqtt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTokenResponse creates a response to parse from QueryToken response
func CreateQueryTokenResponse() (response *QueryTokenResponse) {
	response = &QueryTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
