package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectVideoIPCObject invokes the objectdet.DetectVideoIPCObject API synchronously
func (client *Client) DetectVideoIPCObject(request *DetectVideoIPCObjectRequest) (response *DetectVideoIPCObjectResponse, err error) {
	response = CreateDetectVideoIPCObjectResponse()
	err = client.DoAction(request, response)
	return
}

// DetectVideoIPCObjectWithChan invokes the objectdet.DetectVideoIPCObject API asynchronously
func (client *Client) DetectVideoIPCObjectWithChan(request *DetectVideoIPCObjectRequest) (<-chan *DetectVideoIPCObjectResponse, <-chan error) {
	responseChan := make(chan *DetectVideoIPCObjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectVideoIPCObject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectVideoIPCObjectWithCallback invokes the objectdet.DetectVideoIPCObject API asynchronously
func (client *Client) DetectVideoIPCObjectWithCallback(request *DetectVideoIPCObjectRequest, callback func(response *DetectVideoIPCObjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectVideoIPCObjectResponse
		var err error
		defer close(result)
		response, err = client.DetectVideoIPCObject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectVideoIPCObjectRequest is the request struct for api DetectVideoIPCObject
type DetectVideoIPCObjectRequest struct {
	*requests.RpcRequest
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoURL string           `position:"Body" name:"VideoURL"`
}

// DetectVideoIPCObjectResponse is the response struct for api DetectVideoIPCObject
type DetectVideoIPCObjectResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectVideoIPCObjectRequest creates a request to invoke DetectVideoIPCObject API
func CreateDetectVideoIPCObjectRequest() (request *DetectVideoIPCObjectRequest) {
	request = &DetectVideoIPCObjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "DetectVideoIPCObject", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectVideoIPCObjectResponse creates a response to parse from DetectVideoIPCObject response
func CreateDetectVideoIPCObjectResponse() (response *DetectVideoIPCObjectResponse) {
	response = &DetectVideoIPCObjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
