package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateListener invokes the ga.CreateListener API synchronously
func (client *Client) CreateListener(request *CreateListenerRequest) (response *CreateListenerResponse, err error) {
	response = CreateCreateListenerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateListenerWithChan invokes the ga.CreateListener API asynchronously
func (client *Client) CreateListenerWithChan(request *CreateListenerRequest) (<-chan *CreateListenerResponse, <-chan error) {
	responseChan := make(chan *CreateListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateListenerWithCallback invokes the ga.CreateListener API asynchronously
func (client *Client) CreateListenerWithCallback(request *CreateListenerRequest, callback func(response *CreateListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateListenerResponse
		var err error
		defer close(result)
		response, err = client.CreateListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateListenerRequest is the request struct for api CreateListener
type CreateListenerRequest struct {
	*requests.RpcRequest
	ClientToken    string                        `position:"Query" name:"ClientToken"`
	Description    string                        `position:"Query" name:"Description"`
	BackendPorts   *[]CreateListenerBackendPorts `position:"Query" name:"BackendPorts"  type:"Repeated"`
	Protocol       string                        `position:"Query" name:"Protocol"`
	AcceleratorId  string                        `position:"Query" name:"AcceleratorId"`
	ProxyProtocol  requests.Boolean              `position:"Query" name:"ProxyProtocol"`
	PortRanges     *[]CreateListenerPortRanges   `position:"Query" name:"PortRanges"  type:"Repeated"`
	Certificates   *[]CreateListenerCertificates `position:"Query" name:"Certificates"  type:"Repeated"`
	Name           string                        `position:"Query" name:"Name"`
	ClientAffinity string                        `position:"Query" name:"ClientAffinity"`
}

// CreateListenerBackendPorts is a repeated param struct in CreateListenerRequest
type CreateListenerBackendPorts struct {
	FromPort string `name:"FromPort"`
	ToPort   string `name:"ToPort"`
}

// CreateListenerPortRanges is a repeated param struct in CreateListenerRequest
type CreateListenerPortRanges struct {
	FromPort string `name:"FromPort"`
	ToPort   string `name:"ToPort"`
}

// CreateListenerCertificates is a repeated param struct in CreateListenerRequest
type CreateListenerCertificates struct {
	Id string `name:"Id"`
}

// CreateListenerResponse is the response struct for api CreateListener
type CreateListenerResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ListenerId string `json:"ListenerId" xml:"ListenerId"`
}

// CreateCreateListenerRequest creates a request to invoke CreateListener API
func CreateCreateListenerRequest() (request *CreateListenerRequest) {
	request = &CreateListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "CreateListener", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateListenerResponse creates a response to parse from CreateListener response
func CreateCreateListenerResponse() (response *CreateListenerResponse) {
	response = &CreateListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
