package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMockRule invokes the edas.UpdateMockRule API synchronously
func (client *Client) UpdateMockRule(request *UpdateMockRuleRequest) (response *UpdateMockRuleResponse, err error) {
	response = CreateUpdateMockRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMockRuleWithChan invokes the edas.UpdateMockRule API asynchronously
func (client *Client) UpdateMockRuleWithChan(request *UpdateMockRuleRequest) (<-chan *UpdateMockRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateMockRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMockRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMockRuleWithCallback invokes the edas.UpdateMockRule API asynchronously
func (client *Client) UpdateMockRuleWithCallback(request *UpdateMockRuleRequest, callback func(response *UpdateMockRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMockRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateMockRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMockRuleRequest is the request struct for api UpdateMockRule
type UpdateMockRuleRequest struct {
	*requests.RoaRequest
	ScMockItemJson    string `position:"Query" name:"ScMockItemJson"`
	DubboMockItemJson string `position:"Query" name:"DubboMockItemJson"`
	ExtraJson         string `position:"Query" name:"ExtraJson"`
	Name              string `position:"Query" name:"Name"`
	Id                string `position:"Query" name:"Id"`
	Region            string `position:"Query" name:"Region"`
}

// UpdateMockRuleResponse is the response struct for api UpdateMockRule
type UpdateMockRuleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateMockRuleRequest creates a request to invoke UpdateMockRule API
func CreateUpdateMockRuleRequest() (request *UpdateMockRuleRequest) {
	request = &UpdateMockRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateMockRule", "/pop/sp/api/mock/updateMockRule", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMockRuleResponse creates a response to parse from UpdateMockRule response
func CreateUpdateMockRuleResponse() (response *UpdateMockRuleResponse) {
	response = &UpdateMockRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
