package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableMockRule invokes the edas.EnableMockRule API synchronously
func (client *Client) EnableMockRule(request *EnableMockRuleRequest) (response *EnableMockRuleResponse, err error) {
	response = CreateEnableMockRuleResponse()
	err = client.DoAction(request, response)
	return
}

// EnableMockRuleWithChan invokes the edas.EnableMockRule API asynchronously
func (client *Client) EnableMockRuleWithChan(request *EnableMockRuleRequest) (<-chan *EnableMockRuleResponse, <-chan error) {
	responseChan := make(chan *EnableMockRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableMockRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableMockRuleWithCallback invokes the edas.EnableMockRule API asynchronously
func (client *Client) EnableMockRuleWithCallback(request *EnableMockRuleRequest, callback func(response *EnableMockRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableMockRuleResponse
		var err error
		defer close(result)
		response, err = client.EnableMockRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableMockRuleRequest is the request struct for api EnableMockRule
type EnableMockRuleRequest struct {
	*requests.RoaRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// EnableMockRuleResponse is the response struct for api EnableMockRule
type EnableMockRuleResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEnableMockRuleRequest creates a request to invoke EnableMockRule API
func CreateEnableMockRuleRequest() (request *EnableMockRuleRequest) {
	request = &EnableMockRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "EnableMockRule", "/pop/sp/api/mock/enableMockRule", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableMockRuleResponse creates a response to parse from EnableMockRule response
func CreateEnableMockRuleResponse() (response *EnableMockRuleResponse) {
	response = &EnableMockRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
