package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendVerification invokes the dyvmsapi.SendVerification API synchronously
func (client *Client) SendVerification(request *SendVerificationRequest) (response *SendVerificationResponse, err error) {
	response = CreateSendVerificationResponse()
	err = client.DoAction(request, response)
	return
}

// SendVerificationWithChan invokes the dyvmsapi.SendVerification API asynchronously
func (client *Client) SendVerificationWithChan(request *SendVerificationRequest) (<-chan *SendVerificationResponse, <-chan error) {
	responseChan := make(chan *SendVerificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendVerification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendVerificationWithCallback invokes the dyvmsapi.SendVerification API asynchronously
func (client *Client) SendVerificationWithCallback(request *SendVerificationRequest, callback func(response *SendVerificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendVerificationResponse
		var err error
		defer close(result)
		response, err = client.SendVerification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendVerificationRequest is the request struct for api SendVerification
type SendVerificationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VerifyType           string           `position:"Query" name:"VerifyType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Target               string           `position:"Query" name:"Target"`
	BizType              string           `position:"Query" name:"BizType"`
}

// SendVerificationResponse is the response struct for api SendVerification
type SendVerificationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateSendVerificationRequest creates a request to invoke SendVerification API
func CreateSendVerificationRequest() (request *SendVerificationRequest) {
	request = &SendVerificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "SendVerification", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendVerificationResponse creates a response to parse from SendVerification response
func CreateSendVerificationResponse() (response *SendVerificationResponse) {
	response = &SendVerificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
