package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLayer4Rule invokes the ddoscoo.CreateLayer4Rule API synchronously
func (client *Client) CreateLayer4Rule(request *CreateLayer4RuleRequest) (response *CreateLayer4RuleResponse, err error) {
	response = CreateCreateLayer4RuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLayer4RuleWithChan invokes the ddoscoo.CreateLayer4Rule API asynchronously
func (client *Client) CreateLayer4RuleWithChan(request *CreateLayer4RuleRequest) (<-chan *CreateLayer4RuleResponse, <-chan error) {
	responseChan := make(chan *CreateLayer4RuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLayer4Rule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLayer4RuleWithCallback invokes the ddoscoo.CreateLayer4Rule API asynchronously
func (client *Client) CreateLayer4RuleWithCallback(request *CreateLayer4RuleRequest, callback func(response *CreateLayer4RuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLayer4RuleResponse
		var err error
		defer close(result)
		response, err = client.CreateLayer4Rule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLayer4RuleRequest is the request struct for api CreateLayer4Rule
type CreateLayer4RuleRequest struct {
	*requests.RpcRequest
	Listeners string `position:"Query" name:"Listeners"`
	SourceIp  string `position:"Query" name:"SourceIp"`
}

// CreateLayer4RuleResponse is the response struct for api CreateLayer4Rule
type CreateLayer4RuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLayer4RuleRequest creates a request to invoke CreateLayer4Rule API
func CreateCreateLayer4RuleRequest() (request *CreateLayer4RuleRequest) {
	request = &CreateLayer4RuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "CreateLayer4Rule", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateLayer4RuleResponse creates a response to parse from CreateLayer4Rule response
func CreateCreateLayer4RuleResponse() (response *CreateLayer4RuleResponse) {
	response = &CreateLayer4RuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
