package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricOrganizationChannels invokes the baas.DescribeFabricOrganizationChannels API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationchannels.html
func (client *Client) DescribeFabricOrganizationChannels(request *DescribeFabricOrganizationChannelsRequest) (response *DescribeFabricOrganizationChannelsResponse, err error) {
	response = CreateDescribeFabricOrganizationChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricOrganizationChannelsWithChan invokes the baas.DescribeFabricOrganizationChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationChannelsWithChan(request *DescribeFabricOrganizationChannelsRequest) (<-chan *DescribeFabricOrganizationChannelsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricOrganizationChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricOrganizationChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricOrganizationChannelsWithCallback invokes the baas.DescribeFabricOrganizationChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationChannelsWithCallback(request *DescribeFabricOrganizationChannelsRequest, callback func(response *DescribeFabricOrganizationChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricOrganizationChannelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricOrganizationChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricOrganizationChannelsRequest is the request struct for api DescribeFabricOrganizationChannels
type DescribeFabricOrganizationChannelsRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeFabricOrganizationChannelsResponse is the response struct for api DescribeFabricOrganizationChannels
type DescribeFabricOrganizationChannelsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeFabricOrganizationChannelsRequest creates a request to invoke DescribeFabricOrganizationChannels API
func CreateDescribeFabricOrganizationChannelsRequest() (request *DescribeFabricOrganizationChannelsRequest) {
	request = &DescribeFabricOrganizationChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricOrganizationChannels", "baas", "openAPI")
	return
}

// CreateDescribeFabricOrganizationChannelsResponse creates a response to parse from DescribeFabricOrganizationChannels response
func CreateDescribeFabricOrganizationChannelsResponse() (response *DescribeFabricOrganizationChannelsResponse) {
	response = &DescribeFabricOrganizationChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
