/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolder;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.VcsBackgroundTask;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.Action;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCopyCommand;
import org.zmlx.hg4idea.command.HgMoveCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgVFSListener
extends VcsVFSListener {
    private final VcsDirtyScopeManager dirtyScopeManager;
    private static final Logger LOG = Logger.getInstance(HgVFSListener.class);

    private HgVFSListener(@NotNull HgVcs vcs, @NotNull CoroutineScope activeScope) {
        if (vcs == null) {
            HgVFSListener.$$$reportNull$$$0(0);
        }
        if (activeScope == null) {
            HgVFSListener.$$$reportNull$$$0(1);
        }
        super((AbstractVcs)vcs, activeScope);
        this.dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public static HgVFSListener createInstance(@NotNull HgVcs vcs, @NotNull CoroutineScope activeScope) {
        if (vcs == null) {
            HgVFSListener.$$$reportNull$$$0(2);
        }
        if (activeScope == null) {
            HgVFSListener.$$$reportNull$$$0(3);
        }
        HgVFSListener listener = new HgVFSListener(vcs, activeScope);
        listener.installListeners();
        HgVFSListener hgVFSListener = listener;
        if (hgVFSListener == null) {
            HgVFSListener.$$$reportNull$$$0(4);
        }
        return hgVFSListener;
    }

    @NotNull
    protected String getAddTitle() {
        String string = HgBundle.message("hg4idea.add.title", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = HgBundle.message("hg4idea.add.single.title", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = HgBundle.message("hg4idea.add.body", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void executeAdd(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(8);
        }
        if (copyFromMap == null) {
            HgVFSListener.$$$reportNull$$$0(9);
        }
        this.saveUnsavedVcsIgnoreFiles();
        Iterator<Map.Entry<VirtualFile, VirtualFile>> it = copyFromMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VirtualFile, VirtualFile> entry = it.next();
            VirtualFile rootFrom = HgUtil.getHgRootOrNull(this.myProject, entry.getKey());
            VirtualFile rootTo = HgUtil.getHgRootOrNull(this.myProject, entry.getValue());
            if (rootTo != null && rootTo.equals(rootFrom)) continue;
            it.remove();
        }
        it = addedFiles.iterator();
        while (it.hasNext()) {
            if (HgUtil.getHgRootOrNull(this.myProject, (VirtualFile)it.next()) != null) continue;
            it.remove();
        }
        final Map<VirtualFile, Collection<VirtualFile>> sortedFiles = HgUtil.sortByHgRoots(this.myProject, addedFiles);
        final HashSet untrackedFiles = new HashSet();
        new Task.Backgroundable(this.myProject, HgBundle.message("hg4idea.progress.checking.ignored", new Object[0]), false){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    VirtualFile repo = (VirtualFile)e.getKey();
                    Collection files = (Collection)e.getValue();
                    pi.setText(repo.getPresentableUrl());
                    Collection<VirtualFile> untrackedForRepo = new HgStatusCommand.Builder(false).unknown(true).removed(true).build(this.myProject).getFiles(repo, (List<VirtualFile>)new ArrayList<VirtualFile>(files));
                    untrackedFiles.addAll(untrackedForRepo);
                }
                addedFiles.retainAll(untrackedFiles);
                if (!addedFiles.isEmpty() || !copyFromMap.isEmpty()) {
                    HgVFSListener.this.performAddingWithConfirmation(addedFiles, copyFromMap);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "org/zmlx/hg4idea/HgVFSListener$1", "run"));
            }
        }.queue();
    }

    @NotNull
    VcsRepositoryIgnoredFilesHolder getIgnoreRepoHolder(@NotNull VirtualFile repoRoot) {
        if (repoRoot == null) {
            HgVFSListener.$$$reportNull$$$0(10);
        }
        VcsRepositoryIgnoredFilesHolder vcsRepositoryIgnoredFilesHolder = Objects.requireNonNull((HgRepository)HgUtil.getRepositoryManager(this.myProject).getRepositoryForRootQuick(repoRoot)).getIgnoredFilesHolder();
        if (vcsRepositoryIgnoredFilesHolder == null) {
            HgVFSListener.$$$reportNull$$$0(11);
        }
        return vcsRepositoryIgnoredFilesHolder;
    }

    protected void performAdding(final @NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copiedFilesFrom) {
        if (addedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(12);
        }
        if (copiedFilesFrom == null) {
            HgVFSListener.$$$reportNull$$$0(13);
        }
        final HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(copiedFilesFrom);
        new Task.Backgroundable(this.myProject, HgBundle.message("hg4idea.add.progress", new Object[0]), false){

            public void run(@NotNull ProgressIndicator aProgressIndicator) {
                if (aProgressIndicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                ArrayList<VirtualFile> adds = new ArrayList<VirtualFile>();
                HashMap<VirtualFile, VirtualFile> copies = new HashMap<VirtualFile, VirtualFile>();
                LOG.assertTrue(this.myProject != null, (Object)"Project is null");
                ArrayList<VirtualFile> unversionedAndIgnoredFiles = new ArrayList<VirtualFile>();
                Map<VirtualFile, Collection<VirtualFile>> sortedSourceFilesByRepos = HgUtil.sortByHgRoots(this.myProject, copyFromMap.values());
                HgStatusCommand statusCommand = new HgStatusCommand.Builder(false).unknown(true).ignored(true).build(this.myProject);
                for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : sortedSourceFilesByRepos.entrySet()) {
                    Set<HgChange> changes = statusCommand.executeInCurrentThread(entry.getKey(), ContainerUtil.map(entry.getValue(), virtualFile -> VcsUtil.getFilePath((VirtualFile)virtualFile)));
                    for (HgChange change : changes) {
                        unversionedAndIgnoredFiles.add(change.afterFile().toFilePath().getVirtualFile());
                    }
                }
                copyFromMap.values().removeAll(unversionedAndIgnoredFiles);
                for (VirtualFile virtualFile2 : addedFiles) {
                    VirtualFile copyFrom = (VirtualFile)copyFromMap.get(virtualFile2);
                    if (copyFrom != null) {
                        copies.put(copyFrom, virtualFile2);
                        continue;
                    }
                    adds.add(virtualFile2);
                }
                if (!adds.isEmpty()) {
                    new HgAddCommand(this.myProject).executeInCurrentThread(adds);
                }
                if (!copies.isEmpty()) {
                    for (Map.Entry<Object, Collection<Object>> entry : copies.entrySet()) {
                        new HgCopyCommand(this.myProject).executeInCurrentThread((VirtualFile)entry.getKey(), (VirtualFile)entry.getValue());
                    }
                }
                for (VirtualFile virtualFile3 : addedFiles) {
                    if (virtualFile3.isDirectory()) {
                        HgVFSListener.this.dirtyScopeManager.dirDirtyRecursively(virtualFile3);
                        continue;
                    }
                    HgVFSListener.this.dirtyScopeManager.fileDirty(virtualFile3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aProgressIndicator", "org/zmlx/hg4idea/HgVFSListener$2", "run"));
            }
        }.queue();
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = HgBundle.message("hg4idea.remove.multiple.title", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected String getSingleFileDeleteTitle() {
        return HgBundle.message("hg4idea.remove.single.title", new Object[0]);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return HgBundle.message("hg4idea.remove.single.body", new Object[0]);
    }

    protected boolean shouldIgnoreDeletion(@NotNull FileStatus status) {
        if (status == null) {
            HgVFSListener.$$$reportNull$$$0(15);
        }
        return status == FileStatus.UNKNOWN;
    }

    protected void executeDelete() {
        final List filesToConfirmDeletion = this.myProcessor.acquireDeletedFiles();
        this.skipNotUnderHg(filesToConfirmDeletion);
        this.skipVcsIgnored(filesToConfirmDeletion);
        final ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>();
        Iterator it = filesToConfirmDeletion.iterator();
        while (it.hasNext()) {
            FilePath filePath = (FilePath)it.next();
            Change fileChange = ChangeListManager.getInstance((Project)this.myProject).getChange(filePath);
            if (fileChange == null || !fileChange.getFileStatus().equals(FileStatus.ADDED)) continue;
            filesToDelete.add(filePath);
            it.remove();
        }
        new Task.Backgroundable(this.myProject, HgBundle.message("hg4idea.remove.progress", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (HgVFSListener.this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                    if (HgVFSListener.this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || filesToConfirmDeletion.isEmpty()) {
                        filesToDelete.addAll(filesToConfirmDeletion);
                    } else {
                        AtomicReference filePaths = new AtomicReference();
                        ApplicationManager.getApplication().invokeAndWait(() -> filePaths.set(HgVFSListener.this.selectFilePathsToDelete(filesToConfirmDeletion)));
                        if (filePaths.get() != null) {
                            filesToDelete.addAll((Collection)filePaths.get());
                        }
                    }
                }
                if (!filesToDelete.isEmpty()) {
                    HgVFSListener.this.performDeletion(filesToDelete);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/HgVFSListener$3", "run"));
            }
        }.queue();
    }

    private void skipVcsIgnored(@NotNull List<FilePath> filePaths) {
        if (filePaths == null) {
            HgVFSListener.$$$reportNull$$$0(16);
        }
        Map<VirtualFile, Collection<FilePath>> groupFilePathsByHgRoots = HgUtil.groupFilePathsByHgRoots(this.myProject, filePaths);
        List ignored = groupFilePathsByHgRoots.entrySet().stream().map(entry -> this.getIgnoreRepoHolder((VirtualFile)entry.getKey()).removeIgnoredFiles((Collection)entry.getValue())).flatMap(Collection::stream).toList();
        filePaths.removeAll(ignored);
    }

    private void skipNotUnderHg(Collection<FilePath> filesToFilter) {
        Iterator<FilePath> iter = filesToFilter.iterator();
        while (iter.hasNext()) {
            FilePath filePath = iter.next();
            if (HgUtil.getHgRootOrNull(this.myProject, filePath) != null) continue;
            iter.remove();
        }
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            HgVFSListener.$$$reportNull$$$0(17);
        }
        ArrayList<HgFile> deletes = new ArrayList<HgFile>();
        for (FilePath filePath : filesToDelete) {
            VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
            if (root == null) continue;
            deletes.add(new HgFile(root, filePath));
        }
        if (!deletes.isEmpty()) {
            new HgRemoveCommand(this.myProject).executeInCurrentThread(deletes);
        }
        for (HgFile hgFile : deletes) {
            this.dirtyScopeManager.fileDirty(hgFile.toFilePath());
        }
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        if (movedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(18);
        }
        final ArrayList failedToMove = new ArrayList();
        new VcsBackgroundTask<VcsVFSListener.MovedFileInfo>(this.myProject, HgBundle.message("hg4idea.move.progress", new Object[0]), movedFiles){

            public void onFinished() {
                if (!failedToMove.isEmpty()) {
                    this.handleRenameError();
                }
            }

            private void handleRenameError() {
                NotificationAction viewFilesAction = NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.VFSListener.text.view.files", (Object[])new Object[0]), () -> {
                    List filePaths = ContainerUtil.map((Collection)failedToMove, movedInfo -> movedInfo.getOldPath());
                    ProcessedFilePathsDialog dialog = new ProcessedFilePathsDialog(this.myProject, filePaths);
                    dialog.setTitle(HgBundle.message("hg4idea.rename.error.title", new Object[0]));
                    dialog.show();
                });
                NotificationAction retryAction = NotificationAction.createSimpleExpiring((String)HgBundle.message("retry", new Object[0]), () -> HgVFSListener.this.performMoveRename(failedToMove));
                VcsNotifier.getInstance((Project)this.myProject).notifyError("hg.rename.failed", HgBundle.message("hg4idea.rename.error", new Object[0]), HgBundle.message("hg4idea.rename.error.msg", new Object[0]), new NotificationAction[]{viewFilesAction, retryAction});
            }

            protected void process(VcsVFSListener.MovedFileInfo file) {
                FilePath source = file.getOldPath();
                FilePath target = file.getNewPath();
                VirtualFile sourceRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)source);
                VirtualFile targetRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)target);
                if (sourceRoot != null && sourceRoot.equals(targetRoot)) {
                    HgCommandResult result;
                    int attempt = 0;
                    while (HgErrorUtil.isWLockError(result = new HgMoveCommand(this.myProject).execute(sourceRoot, source, target)) && attempt++ < 2) {
                    }
                    if (!HgErrorUtil.hasErrorsInCommandExecution(result)) {
                        HgVFSListener.this.dirtyScopeManager.fileDirty(source);
                        HgVFSListener.this.dirtyScopeManager.fileDirty(target);
                    } else {
                        failedToMove.add(file);
                        LOG.warn("Hg rename failed:" + result.getRawError());
                    }
                }
            }
        }.queue();
    }

    protected boolean isRecursiveDeleteSupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgVFSListener";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFilesFrom";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgVFSListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreRepoHolder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreRepoHolder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreDeletion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "skipVcsIgnored";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 14 -> new IllegalStateException(string);
        };
    }

    private static class ProcessedFilePathsDialog
    extends SelectFilePathsDialog {
        ProcessedFilePathsDialog(@NotNull Project project, @NotNull List<FilePath> files) {
            if (project == null) {
                ProcessedFilePathsDialog.$$$reportNull$$$0(0);
            }
            if (files == null) {
                ProcessedFilePathsDialog.$$$reportNull$$$0(1);
            }
            super(project, files, null, null, null, null, false);
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                ProcessedFilePathsDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/HgVFSListener$ProcessedFilePathsDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/HgVFSListener$ProcessedFilePathsDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

