/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion.treeAssertion;

import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleMutableTree;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTree;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeBuilder;
import com.intellij.platform.testFramework.assertion.treeAssertion.SimpleTreeImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003\u001a1\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u001d\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b\u001aX\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\b\u000b2\u001d\u0010\u000f\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\r0\b\u00a2\u0006\u0002\b\u000b\u001a\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00012\u0006\u0010\u0011\u001a\u00020\u0005\u001a<\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0015\u0012\u0004\u0012\u0002H\u00130\b\u001aD\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u001e\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00170\bH\u0002\u00a8\u0006\u0018"}, d2={"deepCopyTree", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleMutableTree;", "T", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTree;", "getTreeString", "", "buildTree", "configure", "Lkotlin/Function1;", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTreeBuilder;", "", "Lkotlin/ExtensionFunctionType;", "roots", "", "nameGetter", "childrenGetter", "", "treeString", "mapTreeValues", "R", "transform", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleTree$Node;", "mapTree", "Lcom/intellij/platform/testFramework/assertion/treeAssertion/SimpleMutableTree$Node;", "intellij.platform.testFramework"})
public final class SimpleTreeUtilKt {
    @NotNull
    public static final <T> SimpleMutableTree<T> deepCopyTree(@NotNull SimpleTree<T> $this$deepCopyTree) {
        Intrinsics.checkNotNullParameter($this$deepCopyTree, (String)"<this>");
        ArrayDeque queue = new ArrayDeque();
        SimpleTreeImpl tree = new SimpleTreeImpl(null, 1, null);
        for (SimpleTree.Node<T> root : $this$deepCopyTree.getRoots()) {
            SimpleTreeImpl.Node mutableRoot = new SimpleTreeImpl.Node(root.getName(), root.getValue(), null, 4, null);
            tree.getRoots().add(mutableRoot);
            queue.add((Object)TuplesKt.to(root, mutableRoot));
        }
        while (!((Collection)queue).isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            SimpleTree.Node node = (SimpleTree.Node)pair.component1();
            SimpleMutableTree.Node mutableNode = (SimpleMutableTree.Node)pair.component2();
            for (SimpleTree.Node child : node.getChildren()) {
                SimpleTreeImpl.Node mutableChild = new SimpleTreeImpl.Node(child.getName(), child.getValue(), null, 4, null);
                mutableNode.getChildren().add(mutableChild);
                queue.add((Object)TuplesKt.to(child, mutableChild));
            }
        }
        return tree;
    }

    @NotNull
    public static final <T> String getTreeString(@NotNull SimpleTree<T> $this$getTreeString) {
        Intrinsics.checkNotNullParameter($this$getTreeString, (String)"<this>");
        StringJoiner result = new StringJoiner("\n");
        ArrayDeque stack = new ArrayDeque();
        for (SimpleTree.Node root : CollectionsKt.asReversed($this$getTreeString.getRoots())) {
            stack.addLast((Object)TuplesKt.to((Object)0, (Object)root));
        }
        while (!((Collection)stack).isEmpty()) {
            Pair pair = (Pair)stack.removeLast();
            int indent = ((Number)pair.component1()).intValue();
            SimpleTree.Node node = (SimpleTree.Node)pair.component2();
            String indentString = StringsKt.repeat((CharSequence)" ", (int)indent);
            String nodeMarker = !((Collection)node.getChildren()).isEmpty() ? "-" : "";
            result.add(indentString + nodeMarker + node.getName());
            for (SimpleTree.Node child : CollectionsKt.asReversed(node.getChildren())) {
                stack.addLast((Object)TuplesKt.to((Object)(indent + 1), (Object)child));
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final <T> SimpleMutableTree<T> buildTree(@NotNull Function1<? super SimpleTreeBuilder<T>, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        SimpleTreeBuilder treeBuilder = new SimpleTreeBuilder();
        configure.invoke(treeBuilder);
        return treeBuilder.getTree();
    }

    @NotNull
    public static final <T> SimpleMutableTree<T> buildTree(@NotNull List<? extends T> roots, @NotNull Function1<? super T, String> nameGetter, @NotNull Function1<? super T, ? extends List<? extends T>> childrenGetter) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(nameGetter, (String)"nameGetter");
        Intrinsics.checkNotNullParameter(childrenGetter, (String)"childrenGetter");
        SimpleTreeImpl tree = new SimpleTreeImpl(null, 1, null);
        ArrayDeque queue = new ArrayDeque();
        for (T root : roots) {
            SimpleTreeImpl.Node node = new SimpleTreeImpl.Node((String)nameGetter.invoke(root), root, null, 4, null);
            tree.getRoots().add(node);
            queue.add(node);
        }
        while (!((Collection)queue).isEmpty()) {
            SimpleTreeImpl.Node node = (SimpleTreeImpl.Node)queue.removeLast();
            for (Object child : (List)childrenGetter.invoke(node.getValue())) {
                SimpleTreeImpl.Node childNode = new SimpleTreeImpl.Node((String)nameGetter.invoke(child), child, null, 4, null);
                node.getChildren().add(childNode);
                queue.addFirst(childNode);
            }
        }
        return tree;
    }

    @NotNull
    public static final SimpleMutableTree buildTree(@NotNull String treeString) {
        Intrinsics.checkNotNullParameter((Object)treeString, (String)"treeString");
        ArrayDeque stack = new ArrayDeque();
        String[] stringArray = new String[]{"\n"};
        Iterator iterator = ((Iterable)StringsKt.split$default((CharSequence)treeString, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String nodeString = (String)iterator.next();
            int indent = nodeString.length() - ((Object)StringsKt.trimStart((CharSequence)nodeString)).toString().length();
            String name = StringsKt.removePrefix((String)((Object)StringsKt.trimStart((CharSequence)nodeString)).toString(), (CharSequence)"-");
            SimpleTreeImpl.Node node = new SimpleTreeImpl.Node(name, null, null, 4, null);
            Pair parentNode = (Pair)stack.lastOrNull();
            while (parentNode != null && ((Number)parentNode.getFirst()).intValue() >= indent) {
                stack.removeLast();
                parentNode = (Pair)stack.lastOrNull();
            }
            Pair pair = parentNode;
            if (!((pair != null ? ((Number)pair.getFirst()).intValue() : -1) == indent - 1)) {
                boolean bl = false;
                String string = "Incorrect tree structure at " + index + ":\n" + treeString;
                throw new IllegalArgumentException(string.toString());
            }
            Pair pair2 = parentNode;
            if ((pair2 != null ? (SimpleMutableTree.Node)pair2.getSecond() : null) != null) {
                ((SimpleMutableTree.Node)parentNode.getSecond()).getChildren().add(node);
            }
            stack.add((Object)TuplesKt.to((Object)indent, node));
        }
        SimpleTreeImpl tree = new SimpleTreeImpl(null, 1, null);
        for (Pair index : stack) {
            int indent = ((Number)index.component1()).intValue();
            SimpleMutableTree.Node node = (SimpleMutableTree.Node)index.component2();
            if (indent != 0) continue;
            tree.getRoots().add(node);
        }
        if (!Intrinsics.areEqual((Object)treeString, (Object)SimpleTreeUtilKt.getTreeString(tree))) {
            boolean bl = false;
            String string = "Incorrect tree structure:\n" + treeString;
            throw new IllegalArgumentException(string.toString());
        }
        return tree;
    }

    @NotNull
    public static final <T, R> SimpleMutableTree<R> mapTreeValues(@NotNull SimpleTree<T> $this$mapTreeValues, @NotNull Function1<? super SimpleTree.Node<T>, ? extends R> transform) {
        Intrinsics.checkNotNullParameter($this$mapTreeValues, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return SimpleTreeUtilKt.mapTree($this$mapTreeValues, arg_0 -> SimpleTreeUtilKt.mapTreeValues$lambda$2(transform, arg_0));
    }

    private static final <T, R> SimpleMutableTree<R> mapTree(SimpleTree<T> $this$mapTree, Function1<? super SimpleTree.Node<T>, ? extends SimpleMutableTree.Node<R>> transform) {
        SimpleTreeImpl tree = new SimpleTreeImpl(null, 1, null);
        ArrayDeque queue = new ArrayDeque();
        for (SimpleTree.Node<T> oldRootNode : $this$mapTree.getRoots()) {
            SimpleMutableTree.Node newRootNode = (SimpleMutableTree.Node)transform.invoke(oldRootNode);
            tree.getRoots().add(newRootNode);
            queue.add((Object)TuplesKt.to(oldRootNode, (Object)newRootNode));
        }
        while (!((Collection)queue).isEmpty()) {
            Pair pair = (Pair)queue.removeLast();
            SimpleTree.Node oldNode = (SimpleTree.Node)pair.component1();
            SimpleMutableTree.Node newNode = (SimpleMutableTree.Node)pair.component2();
            for (SimpleTree.Node oldChildNode : oldNode.getChildren()) {
                SimpleMutableTree.Node newChildNode = (SimpleMutableTree.Node)transform.invoke(oldChildNode);
                newNode.getChildren().add(newChildNode);
                queue.addFirst((Object)TuplesKt.to(oldChildNode, (Object)newChildNode));
            }
        }
        return tree;
    }

    private static final SimpleMutableTree.Node mapTreeValues$lambda$2(Function1 $transform, SimpleTree.Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SimpleTreeImpl.Node(it.getName(), $transform.invoke((Object)it), null, 4, null);
    }
}

