/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.editor.Document;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/debugger/sourcemap/MappingList;", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "<init>", "(Ljava/util/List;)V", "size", "", "getSize", "()I", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "indexOf", "line", "column", "get", "getNext", "index", "mapping", "getNextOnTheSameLine", "skipIfColumnEquals", "", "getEndOffset", "lineStartOffset", "document", "Lcom/intellij/openapi/editor/Document;", "getByIndex", "getMappingsInLine", "", "processMappingsInLine", "entryProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMappingList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingList.kt\norg/jetbrains/debugger/sourcemap/MappingList\n+ 2 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n*L\n1#1,178:1\n403#2,7:179\n*S KotlinDebug\n*F\n+ 1 MappingList.kt\norg/jetbrains/debugger/sourcemap/MappingList\n*L\n118#1:179,7\n*E\n"})
public abstract class MappingList
implements Mappings {
    @NotNull
    private final Comparator<MappingEntry> comparator;
    @NotNull
    private final List<MappingEntry> mappings;

    public MappingList(@NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> MappingList.comparator$lambda$0((Function1)new Function1<MappingEntry, Integer>((Object)this){

            public final Integer invoke(MappingEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MappingList)this.receiver).getLine(p0);
            }
        }, arg_0)).thenComparing(arg_0 -> MappingList.comparator$lambda$1((Function1)new Function1<MappingEntry, Integer>((Object)this){

            public final Integer invoke(MappingEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MappingList)this.receiver).getColumn(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparing(...)");
        this.comparator = comparator2;
        this.mappings = this instanceof GeneratedMappingList ? mappings : CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)mappings, this.comparator));
    }

    public final int getSize() {
        return this.mappings.size();
    }

    @Override
    public int indexOf(int line, int column) {
        int middle = CollectionsKt.binarySearch$default(this.mappings, (int)0, (int)0, arg_0 -> MappingList.indexOf$lambda$2(this, line, column, arg_0), (int)3, null);
        if (middle == -1) {
            middle = 0;
        } else if (middle < -1) {
            middle = -middle - 2;
        }
        if (this.getLine(this.mappings.get(middle)) < line && middle < this.mappings.size()) {
            int lastOfEquivalent;
            for (lastOfEquivalent = middle; lastOfEquivalent < this.mappings.size() - 1 && this.getLine(this.mappings.get(lastOfEquivalent)) == this.getLine(this.mappings.get(lastOfEquivalent + 1)) && this.getColumn(this.mappings.get(lastOfEquivalent)) == this.getColumn(this.mappings.get(lastOfEquivalent + 1)); ++lastOfEquivalent) {
            }
            if (lastOfEquivalent == this.mappings.size() - 1) {
                return -1;
            }
            middle = lastOfEquivalent + 1;
        }
        while (middle > 0 && this.getLine(this.mappings.get(middle)) == this.getLine(this.mappings.get(middle - 1)) && this.getColumn(this.mappings.get(middle)) == this.getColumn(this.mappings.get(middle - 1))) {
            --middle;
        }
        return line == this.getLine(this.mappings.get(middle)) ? middle : -1;
    }

    @Override
    @Nullable
    public MappingEntry get(int line, int column) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)this.indexOf(line, column));
    }

    private final MappingEntry getNext(int index) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)(index + 1));
    }

    @Override
    @Nullable
    public MappingEntry getNext(@NotNull MappingEntry mapping) {
        int n;
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        int index = CollectionsKt.binarySearch$default(this.mappings, (Object)mapping, this.comparator, (int)0, (int)0, (int)12, null);
        if (index < 0) {
            return null;
        }
        MappingEntry result2 = null;
        do {
            n = ++index;
            ++index;
        } while (mapping == (result2 = (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)n)));
        return result2;
    }

    @Override
    @Nullable
    public MappingEntry getNextOnTheSameLine(int index, boolean skipIfColumnEquals) {
        MappingEntry mappingEntry = this.getNext(index);
        if (mappingEntry == null) {
            return null;
        }
        MappingEntry nextMapping = mappingEntry;
        MappingEntry mapping = this.getByIndex(index);
        if (this.getLine(nextMapping) != this.getLine(mapping)) {
            return null;
        }
        if (skipIfColumnEquals) {
            int i = index;
            while (this.getColumn(nextMapping) == this.getColumn(mapping)) {
                if (this.getNextOnTheSameLine(++i, false) != null) continue;
                return null;
            }
        }
        return nextMapping;
    }

    public final int getEndOffset(@NotNull MappingEntry mapping, int lineStartOffset, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        MappingEntry nextMapping = Mappings.getNextOnTheSameLine$default(this, CollectionsKt.binarySearch$default(this.mappings, (Object)mapping, this.comparator, (int)0, (int)0, (int)12, null), false, 2, null);
        return nextMapping == null ? document.getLineEndOffset(this.getLine(mapping)) : lineStartOffset + this.getColumn(nextMapping);
    }

    @Override
    @NotNull
    public MappingEntry getByIndex(int index) {
        return this.mappings.get(index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<MappingEntry> getMappingsInLine(int line) {
        int lastIndex;
        int firstIndex;
        void $this$binarySearchBy_u24default$iv;
        List<MappingEntry> list2 = this.mappings;
        Comparable key$iv = Integer.valueOf(line);
        int fromIndex$iv = 0;
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        boolean $i$f$binarySearchBy = false;
        int middle = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)fromIndex$iv, (int)toIndex$iv, (Function1)((Function1)new Function1<MappingEntry, Integer>(key$iv, this){
            final /* synthetic */ Comparable $key;
            final /* synthetic */ MappingList this$0;
            {
                this.$key = $key;
                this.this$0 = mappingList;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                MappingEntry it2 = (MappingEntry)it;
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(this.this$0.getLine(it2)), (Comparable)this.$key);
            }
        }));
        if (middle < 0) {
            return CollectionsKt.emptyList();
        }
        for (firstIndex = middle; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
        }
        for (lastIndex = middle; lastIndex < this.mappings.size() - 1 && this.getLine(this.mappings.get(lastIndex + 1)) == line; ++lastIndex) {
        }
        return this.mappings.subList(firstIndex, lastIndex + 1);
    }

    public final boolean processMappingsInLine(int line, @NotNull MappingsProcessorInLine entryProcessor) {
        Intrinsics.checkNotNullParameter((Object)entryProcessor, (String)"entryProcessor");
        Iterable<MappingEntry> mappingsInLine = this.getMappingsInLine(line);
        return entryProcessor.processIterable(mappingsInLine);
    }

    private static final Integer comparator$lambda$0(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer comparator$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final int indexOf$lambda$2(MappingList this$0, int $line, int $column, MappingEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int compareLines = Intrinsics.compare((int)this$0.getLine(it), (int)$line);
        return compareLines != 0 ? compareLines : Intrinsics.compare((int)this$0.getColumn(it), (int)$column);
    }
}

