/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions.convert;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.convert.ConvertAction;
import com.intellij.jupyter.py.actions.convert.PythonIntervalsGenerator;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.notebooks.visualization.IntervalsGenerator;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/py/actions/convert/ConvertPythonToJupyterAction;", "Lcom/intellij/jupyter/core/jupyter/actions/convert/ConvertAction;", "<init>", "()V", "sourceLanguage", "Lcom/intellij/lang/Language;", "getSourceLanguage", "()Lcom/intellij/lang/Language;", "targetLanguage", "getTargetLanguage", "loadContents", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellsContents;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "writeContents", "", "content", "project", "Lcom/intellij/openapi/project/Project;", "getFile", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSupported", "", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nConvertPythonToJupyterAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertPythonToJupyterAction.kt\ncom/intellij/jupyter/py/actions/convert/ConvertPythonToJupyterAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,101:1\n1557#2:102\n1628#2,2:103\n1755#2,3:105\n1557#2:108\n1628#2,3:109\n1630#2:112\n3829#3:113\n4344#3:114\n4345#3:116\n12364#3,2:117\n19#4:115\n*S KotlinDebug\n*F\n+ 1 ConvertPythonToJupyterAction.kt\ncom/intellij/jupyter/py/actions/convert/ConvertPythonToJupyterAction\n*L\n35#1:102\n35#1:103,2\n38#1:105,3\n45#1:108\n45#1:109,3\n35#1:112\n71#1:113\n71#1:114\n71#1:116\n77#1:117,2\n71#1:115\n*E\n"})
public final class ConvertPythonToJupyterAction
extends ConvertAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language sourceLanguage;
    @NotNull
    private final Language targetLanguage;

    public ConvertPythonToJupyterAction() {
        PythonLanguage pythonLanguage = PythonLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"INSTANCE");
        this.sourceLanguage = (Language)pythonLanguage;
        this.targetLanguage = (Language)JupyterLanguage.INSTANCE;
    }

    @NotNull
    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    @NotNull
    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NotebookCellsContents loadContents(@NotNull VirtualFile virtualFile) {
        void $this$mapTo$iv$iv;
        Object object;
        Document document;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)virtualFile);
        if (document2 == null) {
            document2 = document = (Document)new DocumentImpl(VirtualFileUtil.readText((VirtualFile)virtualFile));
        }
        if ((object = (NotebookCellLinesProvider)NotebookCellLinesProvider.Companion.forLanguage(this.getSourceLanguage())) == null || (object = IntervalsGenerator.makeIntervals$default((IntervalsGenerator)((IntervalsGenerator)object), (Document)document, null, (int)2, null)) == null) {
            return null;
        }
        Object intervals = object;
        Iterable $this$map$iv = (Iterable)intervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Iterable sourceLines;
            boolean bl;
            String lineText;
            IntRange lines;
            Collection collection;
            block7: {
                void interval;
                NotebookCellLines.Interval interval2 = (NotebookCellLines.Interval)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                lines = interval.getLines();
                lineText = NotebookVisualizationUiUtilKt.getLineText((Document)document, (int)lines.getFirst());
                Iterable $this$any$iv = PythonIntervalsGenerator.Companion.getFIRST_MARKERS$intellij_jupyter_py();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)lineText, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean hasStartDelimiter = bl;
            boolean isMdCell = hasStartDelimiter && StringsKt.contains$default((CharSequence)lineText, (CharSequence)"md", (boolean)false, (int)2, null);
            String firstLine = isMdCell ? "#%% md" : "#%%";
            Iterable $this$map$iv2 = sourceLines = hasStartDelimiter ? (Iterable)CollectionsKt.drop((Iterable)((Iterable)lines), (int)1) : (Iterable)lines;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                int n = ((Number)item$iv$iv2).intValue();
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                String line = NotebookVisualizationUiUtilKt.getLineText((Document)document, (int)it);
                collection2.add(isMdCell ? StringsKt.removePrefix((String)line, (CharSequence)"# ") : line);
            }
            List otherLines = (List)destination$iv$iv2;
            String intervalText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)firstLine), (Iterable)otherLines), (CharSequence)"\n", null, null, (int)0, null, ConvertPythonToJupyterAction::loadContents$lambda$3$lambda$2, (int)30, null);
            collection.add(intervalText);
        }
        List preparedTexts = (List)destination$iv$iv;
        String preparedText = CollectionsKt.joinToString$default((Iterable)preparedTexts, (CharSequence)"\n", null, null, (int)0, null, ConvertPythonToJupyterAction::loadContents$lambda$4, (int)30, null);
        return new NotebookCellsContents(preparedText, (List)intervals, null, this.getSourceLanguage(), 4, null);
    }

    public void writeContents(@NotNull VirtualFile virtualFile, @NotNull NotebookCellsContents content, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = Companion.createJupyterNotebookContent(content, this.getTargetLanguage());
        if (string == null) {
            return;
        }
        String text = string;
        Companion.createJupyterNotebook(virtualFile, text, project);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected List<VirtualFile> getFile(@NotNull AnActionEvent e) {
        void $this$filterTo$iv$iv;
        VirtualFile[] files;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return null;
        }
        VirtualFile[] $this$filter$iv = files = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            FileType $this$asSafely$iv = it.getFileType();
            boolean $i$f$asSafely = false;
            FileType fileType = $this$asSafely$iv;
            if (!(fileType instanceof LanguageFileType)) {
                fileType = null;
            }
            LanguageFileType languageFileType = (LanguageFileType)fileType;
            if (!Intrinsics.areEqual((Object)(languageFileType != null ? languageFileType.getLanguage() : null), (Object)this.getSourceLanguage())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    protected boolean isSupported(@NotNull AnActionEvent e) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            VirtualFile[] files = virtualFileArray;
            if (files.length == 0) {
                return false;
            }
            VirtualFile[] $this$all$iv = files;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getExtension(), (Object)PythonFileType.INSTANCE.getDefaultExtension())) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    private static final CharSequence loadContents$lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence loadContents$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/actions/convert/ConvertPythonToJupyterAction$Companion;", "", "<init>", "()V", "createJupyterNotebook", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "project", "Lcom/intellij/openapi/project/Project;", "createJupyterNotebookContent", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellsContents;", "targetLanguage", "Lcom/intellij/lang/Language;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public final void createJupyterNotebook(@NotNull VirtualFile virtualFile, @NotNull String content, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(notebookFile.getFile());
            if (psiFile2 == null) {
                return;
            }
            PsiFile psiFile3 = psiFile2;
            Document document = psiDocumentManager.getDocument(psiFile3);
            if (document == null) {
                return;
            }
            Document document2 = document;
            document2.setText((CharSequence)content);
            psiDocumentManager.commitDocument(document2);
            FileDocumentManager.getInstance().saveDocument(document2);
        }

        @Nullable
        public final String createJupyterNotebookContent(@NotNull NotebookCellsContents content, @NotNull Language targetLanguage) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
            NotebookCellLinesEditHelper notebookCellLinesEditHelper = (NotebookCellLinesEditHelper)NotebookCellLinesEditHelper.Companion.forLanguage(targetLanguage);
            if (notebookCellLinesEditHelper == null) {
                return null;
            }
            NotebookCellLinesEditHelper helper = notebookCellLinesEditHelper;
            return helper.makeInsertedCells(content, 0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

