/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.chainedMethods;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.webcore.formatter.SpacingStrategy;
import com.intellij.webcore.formatter.chainedMethods.CallChainBlock;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.webcore.formatter.chainedMethods.ParameterListBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedBlocksSpacingStrategy
implements SpacingStrategy {
    private final CommonCodeStyleSettings myLangSettings;

    public ChainedBlocksSpacingStrategy(@NotNull CommonCodeStyleSettings langSettings) {
        if (langSettings == null) {
            ChainedBlocksSpacingStrategy.l(0);
        }
        this.myLangSettings = langSettings;
    }

    @Override
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            ChainedBlocksSpacingStrategy.l(1);
        }
        if (child1 instanceof CallChainBlock && child2 instanceof CallChainBlock) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myLangSettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child2 instanceof ParameterListBlock) {
            int n10 = this.myLangSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES ? 1 : 0;
            return Spacing.createSpacing((int)n10, (int)n10, (int)0, (boolean)this.myLangSettings.KEEP_LINE_BREAKS, (int)this.myLangSettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child1 instanceof CallChainDotBlock) {
            return this.l(this.isDotOnNewLine());
        }
        if (child2 instanceof CallChainDotBlock) {
            return this.l(!this.isDotOnNewLine());
        }
        return null;
    }

    private Spacing l(boolean bl2) {
        return Spacing.createSpacing((int)0, (int)0, (int)0, (!bl2 && this.myLangSettings.KEEP_LINE_BREAKS ? (char)'\u0001' : '\u0000') != '\u0000', (int)(bl2 ? 0 : this.myLangSettings.KEEP_BLANK_LINES_IN_CODE));
    }

    protected boolean isDotOnNewLine() {
        return true;
    }

    private static /* synthetic */ void l(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/formatter/chainedMethods/ChainedBlocksSpacingStrategy";
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

