/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.SeparatorAction;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0002J>\u0010\u000b\u001a\u00020\u00052\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002JL\u0010\u0012\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0015j\b\u0012\u0004\u0012\u00020\b`\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0015j\b\u0012\u0004\u0012\u00020\u0018`\u0016H\u0002J\u001a\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/utils/DumpActionsAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "<init>", "()V", "main", "", "args", "", "", "dumpActionsNames", "outputFile", "collectMainMenuActions", "groups", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "parentName", "processAction", "actionId", "visitedActions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "actionsDescriptions", "Lcom/intellij/internal/statistic/utils/DumpActionsAppStarter$ActionDescription;", "appendName", "parentMenuPath", "ActionDescription", "intellij.platform.statistics"})
public final class DumpActionsAppStarter
implements ApplicationStarter {
    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Object object = CollectionsKt.getOrNull(args, (int)1);
        Intrinsics.checkNotNull((Object)object);
        String outputFile = (String)object;
        this.dumpActionsNames(outputFile);
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void dumpActionsNames(String outputFile) {
        ActionManager actionManager = ActionManager.getInstance();
        List list = actionManager.getActionIdList("");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActionIdList(...)");
        List actionIdList = list;
        HashSet<String> visitedActions = new HashSet<String>();
        HashSet<ActionDescription> actionsDescriptions = new HashSet<ActionDescription>();
        for (String actionId : actionIdList) {
            AnAction action = actionManager.getAction(actionId);
            this.processAction(action, actionId, visitedActions, actionsDescriptions);
        }
        HashMap<String, String> mainMenuAction = new HashMap<String, String>();
        AnAction anAction = actionManager.getAction("MainMenu");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        this.collectMainMenuActions(mainMenuAction, (AnAction)((ActionGroup)anAction), null);
        StringBuilder builder = new StringBuilder();
        builder.append("Id;Name;Description;Path").append('\n');
        Iterator<ActionDescription> iterator = actionsDescriptions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ActionDescription> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ActionDescription description;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            String string = mainMenuAction.get(description.getId());
            if (string == null) {
                string = "";
            }
            String path = string;
            builder.append(description.getId() + ";" + description.getName() + ";" + description.getDescription() + ";" + path).append('\n');
        }
        FileUtil.writeToFile((File)new File(outputFile), (String)builder.toString());
        File file = new File(outputFile);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
    }

    private final void collectMainMenuActions(HashMap<String, String> groups, AnAction action, String parentName) {
        if (action instanceof SeparatorAction) {
            return;
        }
        try {
            String path = this.appendName(action, parentName);
            if (action instanceof ActionGroup) {
                for (AnAction child : ((ActionGroup)action).getChildren(null)) {
                    Intrinsics.checkNotNull((Object)child);
                    this.collectMainMenuActions(groups, child, path);
                }
            } else {
                String string = ActionManager.getInstance().getId(action);
                if (string == null) {
                    string = action.getClass().getName();
                }
                String id = string;
                ((Map)groups).put(id, path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void processAction(AnAction action, String actionId, HashSet<String> visitedActions, HashSet<ActionDescription> actionsDescriptions) {
        if (action == null) {
            return;
        }
        if (action instanceof SeparatorAction) {
            return;
        }
        try {
            String name;
            String id;
            String string = actionId;
            if (string == null && (string = ActionManager.getInstance().getId(action)) == null) {
                string = action.getClass().getName();
            }
            if (visitedActions.contains(id = string)) {
                return;
            }
            visitedActions.add(id);
            Presentation presentation = action.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
            Presentation templatePresentation = presentation;
            String string2 = templatePresentation.getText();
            if (string2 == null) {
                string2 = name = "";
            }
            if (action instanceof ActionGroup) {
                AnAction[] anActionArray = ((ActionGroup)action).getChildren(null);
                Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
                for (AnAction child : anActionArray) {
                    this.processAction(child, null, visitedActions, actionsDescriptions);
                }
            } else {
                Intrinsics.checkNotNull((Object)id);
                if (!StringsKt.startsWith$default((String)id, (String)"<anonymous-group", (boolean)false, (int)2, null)) {
                    String string3 = templatePresentation.getDescription();
                    if (string3 == null) {
                        string3 = "";
                    }
                    String description = string3;
                    actionsDescriptions.add(new ActionDescription(id, name, description));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final String appendName(AnAction action, String parentMenuPath) {
        Object object;
        Presentation presentation = action.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        Presentation templatePresentation = presentation;
        if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
            String string = parentMenuPath;
            if (string == null) {
                string = "";
            }
            return string;
        }
        CharSequence charSequence = templatePresentation.getText();
        String text = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "?" : templatePresentation.getText();
        charSequence = parentMenuPath;
        if (charSequence == null || charSequence.length() == 0) {
            Intrinsics.checkNotNull((Object)text);
            object = text;
        } else {
            object = parentMenuPath + " | " + text;
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/utils/DumpActionsAppStarter$ActionDescription;", "", "id", "", "name", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "getDescription", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    private static final class ActionDescription {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String description;

        public ActionDescription(@NotNull String id, @NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.id = id;
            this.name = name;
            this.description = description;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ActionDescription copy(@NotNull String id, @NotNull String name, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new ActionDescription(id, name, description);
        }

        public static /* synthetic */ ActionDescription copy$default(ActionDescription actionDescription, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = actionDescription.id;
            }
            if ((n & 2) != 0) {
                string2 = actionDescription.name;
            }
            if ((n & 4) != 0) {
                string3 = actionDescription.description;
            }
            return actionDescription.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ActionDescription(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.description.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActionDescription)) {
                return false;
            }
            ActionDescription actionDescription = (ActionDescription)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)actionDescription.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)actionDescription.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)actionDescription.description);
        }
    }
}

