/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;

public class InteriorPointLine {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public static Coordinate getInteriorPoint(Geometry geom) {
        InteriorPointLine intPt = new InteriorPointLine(geom);
        return intPt.getInteriorPoint();
    }

    public InteriorPointLine(Geometry g) {
        this.centroid = g.getCentroid().getCoordinate();
        this.addInterior(g);
        if (this.interiorPoint == null) {
            this.addEndpoints(g);
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void addInterior(Geometry geom) {
        if (geom instanceof LineString) {
            this.addInterior(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
                this.addInterior(gc.getGeometryN(i2));
            }
        }
    }

    private void addInterior(Coordinate[] pts) {
        for (int i2 = 1; i2 < pts.length - 1; ++i2) {
            this.add(pts[i2]);
        }
    }

    private void addEndpoints(Geometry geom) {
        if (geom instanceof LineString) {
            this.addEndpoints(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
                this.addEndpoints(gc.getGeometryN(i2));
            }
        }
    }

    private void addEndpoints(Coordinate[] pts) {
        this.add(pts[0]);
        this.add(pts[pts.length - 1]);
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }
}

