/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.sql.database.SqlTxModelWrapper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private final SqlObjectBuilder myObjectBuilder;
    private final Logger myLogger;
    private final Map<DasObject, BasicElement> mySources;
    private Map<BasicElement, Pointer<DasObject>> myMapping;
    private SqlTxModelWrapper myStagingModel;
    private SqlFileProcessor myProcessor;
    private boolean myApplied;
    private SqlObjectBuilder.Context myBuilderContext;

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlObjectBuilder objectBuilder, @NotNull BasicModModel model, @NotNull Map<BasicElement, Pointer<DasObject>> mapping, @Nullable Logger logger2) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(0);
        }
        if (objectBuilder == null) {
            SqlModelBuilder.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(2);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(3);
        }
        this.mySources = new HashMap<DasObject, BasicElement>();
        this.myApplied = false;
        this.myProject = project;
        this.myModel = model;
        this.myMapping = mapping;
        this.myObjectBuilder = objectBuilder;
        this.myLogger = logger2;
    }

    public SqlModelBuilder(@NotNull Project project, @NotNull BasicModModel model, @NotNull Map<BasicElement, Pointer<DasObject>> mapping, @Nullable Logger logger2) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(4);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(5);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(6);
        }
        this(project, SqlObjectBuilder.EP.forDbms(model.getDbms()), model, mapping, logger2);
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            SqlModelBuilder.$$$reportNull$$$0(7);
        }
        return basicModModel;
    }

    public void begin(boolean saveSources) {
        this.trace("begin");
        this.myStagingModel = new SqlTxModelWrapper(this.myModel, this.mySources, saveSources);
        class Ctx
        extends SqlObjectBuilder.Context
        implements SqlObjectBuilder.ContextWithSource,
        SqlObjectBuilder.ResolvingContext {
            Ctx() {
            }

            @Override
            public boolean withSource() {
                return SqlModelBuilder.this.myStagingModel.withSources();
            }

            @Override
            @Nullable
            public BasicModElement resolve(@NotNull DasObject object) {
                if (object == null) {
                    Ctx.$$$reportNull$$$0(0);
                }
                return SqlModelBuilder.this.myProcessor.process(object);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/database/SqlModelBuilder$1Ctx", "resolve"));
            }
        }
        this.myBuilderContext = new Ctx();
        this.myProcessor = new SqlFileProcessor(this.myProject, this.myStagingModel, this.myObjectBuilder);
        this.myApplied = false;
    }

    public int introspect(@NotNull List<SqlFile> files2, int start2, boolean clear, long syncTimeout) {
        if (files2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(8);
        }
        if (this.mySources.isEmpty() && !this.myMapping.isEmpty()) {
            for (Map.Entry<BasicElement, Pointer<DasObject>> entry : this.myMapping.entrySet()) {
                DasObject object = (DasObject)entry.getValue().dereference();
                if (object == null) continue;
                this.mySources.put(object, entry.getKey());
            }
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        long time = System.currentTimeMillis();
        for (int i2 = start2; i2 < files2.size(); ++i2) {
            SqlFile file = files2.get(i2);
            if (indicator != null) {
                indicator.setFraction(((double)i2 + 0.0) / (double)files2.size());
                indicator.setText2(file.getName());
            }
            this.myStagingModel.modify(() -> this.myProcessor.process(file));
            long cur = System.currentTimeMillis();
            if (syncTimeout == -1L || cur - time <= syncTimeout) continue;
            this.myMapping = this.apply(this.myProcessor, clear);
            this.myApplied = true;
            return i2 + 1;
        }
        this.myMapping = this.apply(this.myProcessor, clear);
        this.myApplied = true;
        return files2.size();
    }

    @NotNull
    public Map<BasicElement, Pointer<DasObject>> getMapping() {
        Map<BasicElement, Pointer<DasObject>> map2 = this.myMapping;
        if (map2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public void end() {
        this.trace("end");
        if (this.myApplied) {
            this.myModel.modify(BasicModRoot.class, r -> this.finish());
        }
        this.myStagingModel = null;
        this.myProcessor = null;
        this.myApplied = false;
        this.mySources.clear();
    }

    @NotNull
    public Map<BasicElement, Pointer<DasObject>> apply(SqlFileProcessor processor2, boolean clear) {
        this.trace("apply");
        final Map<BasicElement, Pointer<DasObject>> tmp = processor2.reverseMap();
        this.myModel.modify(BasicModRoot.class, r -> {
            if (clear) {
                this.prepare();
            }
            processor2.apply();
        });
        final HashMap<BasicElement, Pointer<DasObject>> result2 = new HashMap<BasicElement, Pointer<DasObject>>(this.myMapping);
        result2.keySet().removeIf(e -> e instanceof BasicModElement && ((BasicModElement)e).isDropped());
        new SqlTxModelWrapper.TwoModelVisitor(){

            @Override
            public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                if (guide == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (guided == null) {
                    1.$$$reportNull$$$0(1);
                }
                ContainerUtil.putIfNotNull((Object)guide, (Object)((Pointer)tmp.get(guided)), (Map)result2);
                super.visit(guide, guided);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guide";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guided";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(this.myModel.getRoot(), processor2.getRoot());
        HashMap<BasicElement, Pointer<DasObject>> hashMap = result2;
        if (hashMap == null) {
            SqlModelBuilder.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public void prepare() {
        for (BasicModElement element : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily modFamily : element.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void finish() {
        for (BasicModElement element : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily modFamily : element.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
        this.finalizeObjects();
    }

    public void finalizeObjects() {
        for (BasicModElement element : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            this.myObjectBuilder.finalize(element);
        }
    }

    public static boolean isIgnored(Dbms dbms, ObjectKind p2, ObjectKind c2) {
        if (c2 == SqlDbElementType.ANY) {
            return true;
        }
        if (p2 == ObjectKind.SCHEMA && c2 == ObjectKind.ROLE) {
            return true;
        }
        if (dbms.isOracle()) {
            if (p2 == ObjectKind.BODY) {
                return true;
            }
            if (p2 == ObjectKind.SCHEMA) {
                return c2 == ObjectKind.OPERATOR || c2 == ObjectKind.EXCEPTION || "library".equals(c2.name()) || "INDEX TYPE".equals(c2.name());
            }
        }
        if (p2 == ObjectKind.OBJECT_TYPE) {
            return c2 == SqlDbElementType.CONSTRAINT;
        }
        return false;
    }

    public void trace(String msg) {
        if (this.myLogger != null) {
            this.myLogger.finest(msg);
        }
    }

    private void traceWithProgress(String msg, boolean txt1) {
        if (this.isTraceable()) {
            this.trace(msg);
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator != null) {
                if (txt1) {
                    indicator.setText(msg);
                } else {
                    indicator.setText2(msg);
                }
            }
        }
    }

    private boolean isTraceable() {
        return this.myLogger != null && this.myLogger.isLoggable(Level.FINEST);
    }

    protected void buildObject(@NotNull BasicModElement target2, @NotNull DasObject obj2) {
        if (target2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(11);
        }
        if (obj2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(12);
        }
        if (obj2 instanceof BasicModElement) {
            BasicMetaUtils.copyMatchedPropertiesImpl((BasicModElement)obj2, target2, false, true, true, (Condition<BasicMetaId>)((Condition)id -> id != BasicModNamedElement.NAME));
        } else {
            this.myObjectBuilder.build(target2, obj2, this.myBuilderContext);
        }
    }

    private static DasObject unwrapFake(DasObject obj2) {
        SqlDefinition delegate;
        if (obj2 instanceof SqlFileImpl.GroupImpl && (delegate = (SqlDefinition)((SqlFileImpl.GroupImpl)obj2).delegates().first()) != null) {
            return delegate;
        }
        if (obj2 instanceof DbElement) {
            return (DasObject)((DbElement)obj2).getDelegate();
        }
        return obj2;
    }

    private static boolean isAppendable(BasicModElement target2) {
        return target2 instanceof DasNamespace || target2.getKind() == ObjectKind.PACKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectBuilder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    private class SqlFileProcessor {
        private final Project myProject;
        private final Map<ObjectPath, BasicModElement> myObjects;
        private final Map<DasObject, BasicModElement> myProcessed;
        private final Set<DasObject> myDelayed;
        private final SqlTxModelWrapper myModel;
        private SqlLanguageDialectEx myLanguage;
        private ObjectPath myInitialPath;
        private final SqlObjectBuilder myObjectBuilder;
        private final Dbms myDbms;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        SqlFileProcessor(@NotNull Project project, @NotNull SqlTxModelWrapper model, SqlObjectBuilder objectBuilder) {
            if (project == null) {
                SqlFileProcessor.$$$reportNull$$$0(0);
            }
            if (model == null) {
                SqlFileProcessor.$$$reportNull$$$0(1);
            }
            if (objectBuilder == null) {
                SqlFileProcessor.$$$reportNull$$$0(2);
            }
            this.myObjects = new HashMap<ObjectPath, BasicModElement>();
            this.myProcessed = new LinkedHashMap<DasObject, BasicModElement>();
            this.myDelayed = new LinkedHashSet<DasObject>();
            this.myOraPackageRestarter = new HashMap<DasObject, PsiElement>();
            this.myProject = project;
            this.myModel = model;
            this.myObjectBuilder = objectBuilder;
            this.myDbms = this.myModel.getDbms();
        }

        public void processDelayed() {
            while (!this.myDelayed.isEmpty()) {
                Iterator<DasObject> it = this.myDelayed.iterator();
                DasObject d = it.next();
                it.remove();
                d.getDasChildren(null).forEach(o -> this.process((DasObject)o));
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(3);
            }
            long start2 = this.traceStart(file);
            this.myLanguage = (SqlLanguageDialectEx)file.getSqlLanguage();
            this.myInitialPath = ((SqlFileImpl)file).getInitialPath();
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            for (DasObject obj2 : file.traverser().preOrderDfsTraversal()) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.process(obj2);
            }
            for (SqlStatement stmt : this.getStubbedStatements(file)) {
                if (stmt instanceof DasObject) continue;
                this.myObjectBuilder.build((SqlElement)stmt, SqlModelBuilder.this.myBuilderContext);
            }
            this.processDelayed();
            this.traceFinish(file, start2);
        }

        private long traceStart(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(4);
            }
            if (!SqlModelBuilder.this.isTraceable()) {
                return 0L;
            }
            SqlModelBuilder.this.traceWithProgress("Processing " + file.getViewProvider().getVirtualFile().getUrl() + "...", true);
            return System.currentTimeMillis();
        }

        private void traceFinish(@NotNull SqlFile file, long start2) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(5);
            }
            if (SqlModelBuilder.this.isTraceable()) {
                long took = System.currentTimeMillis() - start2;
                SqlModelBuilder.this.trace("Processed in " + StringUtil.formatDuration((long)took) + " " + file.getViewProvider().getVirtualFile().getUrl());
            }
        }

        @NotNull
        protected JBIterable<SqlStatement> getStubbedStatements(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(6);
            }
            if (((SqlFileImpl)file).getStub() != null) {
                JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)file).filter(SqlStatement.class);
                if (jBIterable == null) {
                    SqlFileProcessor.$$$reportNull$$$0(7);
                }
                return jBIterable;
            }
            JBIterable jBIterable = SqlImplUtil.sqlCompositeElements((PsiElement)file).filter(SqlStatement.class).filter(s -> s instanceof SqlStubbedElement && ((SqlStubbedElement)((Object)s)).getElementType().shouldCreateStub(s.getNode()));
            if (jBIterable == null) {
                SqlFileProcessor.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        @Nullable
        private BasicModElement process(@NotNull DasObject obj2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(9);
            }
            if (obj2 instanceof SqlRenameToClause || obj2 instanceof PsiElement && !(obj2 instanceof FakePsiElement) && !(obj2 instanceof SqlStubbedElement)) {
                return null;
            }
            obj2 = SqlModelBuilder.unwrapFake(obj2);
            ObjectPath path = this.extractPath(obj2);
            if (this.myProcessed.containsKey(obj2)) {
                return this.myModel.nullize(this.getProcessed(obj2, path));
            }
            BasicModElement parent = this.getParent(obj2);
            return this.processSingle(obj2, path, parent);
        }

        @Nullable
        private BasicModElement getProcessed(@NotNull DasObject obj2, @NotNull ObjectPath path) {
            BasicModElement target2;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(10);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(11);
            }
            if ((target2 = this.myProcessed.get(obj2)) != null) {
                return target2;
            }
            if (obj2 instanceof DasConstraint && obj2.getName().isEmpty()) {
                return null;
            }
            target2 = this.myObjects.get(path);
            ContainerUtil.putIfNotNull((Object)obj2, (Object)target2, this.myProcessed);
            return target2;
        }

        private void processSingle(@NotNull DasObject obj2, @Nullable BasicModElement parent) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(12);
            }
            this.processSingle(obj2, this.extractPath(SqlModelBuilder.unwrapFake(obj2)), parent);
        }

        @Nullable
        private BasicModElement processSingle(@NotNull DasObject obj2, @NotNull ObjectPath path, @Nullable BasicModElement parent) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(13);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(14);
            }
            long start2 = this.traceProcessing(obj2, path);
            ObjectKind kind = this.getKind(obj2);
            if (this.myModel.getMetaModel().findKind(kind.code()) == null) {
                this.markObjectReady(path, obj2, null);
                return null;
            }
            this.processOddities(obj2, parent, kind);
            BasicModElement target2 = this.myModel.createOrGet(obj2, parent, path, kind);
            this.markObjectReady(path, obj2, target2);
            if (target2 == null) {
                ObjectKind parentKind;
                boolean ignored = false;
                ObjectPath p2 = path;
                while (p2.parent != null && !ignored) {
                    if (SqlModelBuilder.isIgnored(this.myDbms, p2.parent.kind, p2.kind)) {
                        ignored = true;
                    }
                    p2 = p2.parent;
                }
                ObjectKind objectKind = parentKind = parent == null ? ObjectKind.NONE : parent.getKind();
                if (!ignored && !SqlModelBuilder.isIgnored(this.myDbms, parentKind, obj2.getKind())) {
                    boolean ignore;
                    SqlLanguageDialect lang = DbSqlUtilCore.getSqlDialect((PsiElement)ObjectUtils.tryCast((Object)obj2, PsiElement.class));
                    boolean bl = ignore = lang != null && lang.getDbms() != this.myModel.getDbms() || parent == null && obj2.getDasParent() instanceof SqlRenameToClause;
                    if (!ignore) {
                        SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parentKind.code());
                    }
                }
            } else {
                if (!SqlModelBuilder.isAppendable(target2)) {
                    target2.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                }
                this.processRequiredChildren(obj2, target2);
                SqlModelBuilder.this.buildObject(target2, obj2);
            }
            this.traceProcessed(path, start2);
            return target2;
        }

        private void traceProcessed(@NotNull ObjectPath path, long start2) {
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(15);
            }
            if (SqlModelBuilder.this.isTraceable()) {
                long duration = System.currentTimeMillis() - start2;
                SqlModelBuilder.this.trace("->\ttook " + StringUtil.formatDuration((long)duration) + " for " + path.getDisplayName());
            }
        }

        private long traceProcessing(@NotNull DasObject obj2, @NotNull ObjectPath path) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(16);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(17);
            }
            if (!SqlModelBuilder.this.isTraceable()) {
                return 0L;
            }
            int offset = obj2 instanceof PsiElement ? ((PsiElement)obj2).getTextOffset() : -1;
            SqlModelBuilder.this.traceWithProgress("->\t" + path.getDisplayName() + (String)(offset == -1 ? "" : " at offset " + offset), false);
            return System.currentTimeMillis();
        }

        @NotNull
        private ObjectKind getKind(@NotNull DasObject obj2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(18);
            }
            if (this.myLanguage.getDbms().isOracle() && obj2.getKind() == ObjectKind.OBJECT_TYPE) {
                DasObject p2 = obj2.getDasParent();
                if (p2 != null && p2.getKind() == ObjectKind.PACKAGE) {
                    ObjectKind objectKind = ObjectKind.ALIAS_TYPE;
                    if (objectKind == null) {
                        SqlFileProcessor.$$$reportNull$$$0(19);
                    }
                    return objectKind;
                }
            } else if (this.myLanguage.getDbms().in(Dbms.MYSQL_LIKE) && obj2.getKind() == ObjectKind.INDEX && obj2 instanceof DasIndex && ((DasIndex)obj2).isUnique()) {
                ObjectKind objectKind = ObjectKind.KEY;
                if (objectKind == null) {
                    SqlFileProcessor.$$$reportNull$$$0(20);
                }
                return objectKind;
            }
            ObjectKind objectKind = this.myLanguage.unaliased(obj2.getKind());
            if (objectKind == null) {
                SqlFileProcessor.$$$reportNull$$$0(21);
            }
            return objectKind;
        }

        private void processRequiredChildren(@NotNull DasObject obj2, @NotNull BasicModElement target2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(22);
            }
            if (target2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(23);
            }
            if (target2 instanceof BasicTable) {
                for (DasObject column2 : obj2.getDasChildren(ObjectKind.COLUMN)) {
                    this.processSingle(column2, target2);
                }
            }
            if (target2 instanceof BasicModRoutine) {
                for (DasObject argument : obj2.getDasChildren(ObjectKind.ARGUMENT)) {
                    this.processSingle(argument, target2);
                }
            }
        }

        private void markObjectReady(ObjectPath path, @NotNull DasObject obj2, @Nullable BasicModElement target2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(24);
            }
            BasicModElement nnTarget = this.myModel.notNullize(target2);
            this.myObjects.put(path, nnTarget);
            this.myProcessed.put(obj2, nnTarget);
        }

        private void processOddities(@NotNull DasObject obj2, @Nullable BasicModElement parent, @NotNull ObjectKind kind) {
            PsiElement element;
            PsiObject pkg;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(25);
            }
            if (kind == null) {
                SqlFileProcessor.$$$reportNull$$$0(26);
            }
            if (this.myDbms.isOracle() && parent != null && parent.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)((PsiElement)ObjectUtils.tryCast((Object)obj2, PsiElement.class)), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element = this.myOraPackageRestarter.get(parent)) == null || element != pkg)) {
                this.myOraPackageRestarter.put(parent, pkg);
                JBIterable.from(parent.getFamilies()).filter(x -> x.getMetaObject().kind != ObjectKind.BODY).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @Nullable
        private BasicModElement getParent(@NotNull DasObject obj2) {
            ObjectKind kind;
            DasObject parent;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(27);
            }
            if ((parent = SqlModelBuilder.unwrapFake(obj2.getDasParent())) != null && !this.isValidParent(parent, obj2)) {
                parent = null;
            }
            ObjectKind objectKind = kind = parent == null ? ObjectKind.NONE : parent.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) {
                return this.myModel.getEmptyParent(this.getKind(obj2));
            }
            ObjectPath parentPath = this.extractPath(parent);
            BasicModElement element = this.getProcessed(parent, parentPath);
            if (element != null) {
                return this.myModel.nullize(element);
            }
            if (!(parent instanceof BasicElement) && !(parent instanceof DasNamespace)) {
                this.myDelayed.add(parent);
            }
            return this.process(parent);
        }

        private boolean isValidParent(DasObject parent, @NotNull DasObject obj2) {
            ObjectKind pk;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(28);
            }
            if ((pk = this.getKind(parent)) == ObjectKind.NONE) {
                pk = ObjectKind.ROOT;
            }
            ObjectKind ck = this.getKind(obj2);
            if (pk == ObjectKind.BODY) {
                return true;
            }
            return this.myModel.getMetaModel().getChildKinds(pk).contains((Object)ck);
        }

        @NotNull
        public Map<BasicElement, Pointer<DasObject>> reverseMap() {
            LinkedHashMap<BasicElement, Pointer<DasObject>> res2 = new LinkedHashMap<BasicElement, Pointer<DasObject>>();
            for (Map.Entry<DasObject, BasicModElement> pair : this.myProcessed.entrySet()) {
                Pointer<DasObject> pointer;
                BasicModElement target2 = pair.getValue();
                if (this.myModel.nullize(target2) == null || (pointer = SqlFileProcessor.createPointer(pair.getKey())) == null) continue;
                res2.put(target2, pointer);
            }
            LinkedHashMap<BasicElement, Pointer<DasObject>> linkedHashMap = res2;
            if (linkedHashMap == null) {
                SqlFileProcessor.$$$reportNull$$$0(29);
            }
            return linkedHashMap;
        }

        @Nullable
        private static Pointer<DasObject> createPointer(@Nullable DasObject obj2) {
            SmartPsiElementPointer smartPsiElementPointer;
            if (obj2 instanceof PsiElement) {
                PsiElement po = (PsiElement)obj2;
                smartPsiElementPointer = po.isValid() ? SmartPointerManager.createPointer((PsiElement)po) : null;
            } else if (obj2 instanceof Symbol) {
                Symbol so = (Symbol)obj2;
                smartPsiElementPointer = so.createPointer();
            } else {
                smartPsiElementPointer = null;
            }
            SmartPsiElementPointer pointer = smartPsiElementPointer;
            return pointer == null ? null : new CastedPointer<DasObject>((Pointer<?>)pointer, DasObject.class);
        }

        public void apply() {
            this.materialize();
            for (BasicElement element : this.myModel.getDirty()) {
                this.myObjectBuilder.finalize((BasicModElement)element);
            }
            this.myModel.apply();
        }

        void materialize() {
            List dirty = JBIterable.from(this.myModel.getDirty()).toList();
            for (BasicElement element : dirty) {
                if (!(element instanceof BasicHierarchicalObject)) continue;
                BasicHierarchicalObject obj2 = (BasicHierarchicalObject)element;
                this.myObjectBuilder.materializeInlineReferences(obj2);
            }
        }

        @NotNull
        public BasicElement getRoot() {
            BasicModElement basicModElement = this.myModel.getRoot();
            if (basicModElement == null) {
                SqlFileProcessor.$$$reportNull$$$0(30);
            }
            return basicModElement;
        }

        @NotNull
        private ObjectPath extractPath(@NotNull DasObject obj2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(31);
            }
            ObjectPath path = ObjectPaths.of(obj2);
            if (this.myInitialPath == null) {
                ObjectPath objectPath = path;
                if (objectPath == null) {
                    SqlFileProcessor.$$$reportNull$$$0(32);
                }
                return objectPath;
            }
            ObjectPath tmp = path;
            while (tmp != null) {
                ObjectPath replacement;
                if (tmp.name.isEmpty() && (replacement = this.myInitialPath.findParent(tmp.kind, false)) != null) {
                    ObjectPath stopAt = tmp;
                    ObjectPath objectPath = path.reduce(null, (r, o) -> r != null ? r.appendPart((ObjectPart)o) : (o == stopAt ? replacement : null));
                    if (objectPath == null) {
                        SqlFileProcessor.$$$reportNull$$$0(33);
                    }
                    return objectPath;
                }
                tmp = tmp.parent;
            }
            ObjectPath objectPath = path;
            if (objectPath == null) {
                SqlFileProcessor.$$$reportNull$$$0(34);
            }
            return objectPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 19, 20, 21, 29, 30, 32, 33, 34 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectBuilder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: 
                case 8: 
                case 19: 
                case 20: 
                case 21: 
                case 29: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 11: 
                case 14: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubbedStatements";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reverseMap";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 32: 
                case 33: 
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "traceStart";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "traceFinish";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getStubbedStatements";
                    break;
                }
                case 7: 
                case 8: 
                case 19: 
                case 20: 
                case 21: 
                case 29: 
                case 30: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessed";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "processSingle";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "traceProcessed";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "traceProcessing";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getKind";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "processRequiredChildren";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "markObjectReady";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "processOddities";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidParent";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "extractPath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 19, 20, 21, 29, 30, 32, 33, 34 -> new IllegalStateException(string);
            };
        }
    }

    public static class CastedPointer<T>
    implements Pointer<T> {
        private final Pointer<?> myPointer;
        private final Class<T> myClazz;

        public CastedPointer(@NotNull Pointer<?> pointer, @NotNull Class<T> clazz) {
            if (pointer == null) {
                CastedPointer.$$$reportNull$$$0(0);
            }
            if (clazz == null) {
                CastedPointer.$$$reportNull$$$0(1);
            }
            this.myPointer = pointer;
            this.myClazz = clazz;
        }

        @Nullable
        public T dereference() {
            return (T)ObjectUtils.tryCast((Object)this.myPointer.dereference(), this.myClazz);
        }

        public int hashCode() {
            return this.myPointer.hashCode();
        }

        public boolean equals(Object obj2) {
            return this.myPointer.equals(obj2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazz";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$CastedPointer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

