/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelRoot;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.run.actions.IconWithLockOverlay;
import com.intellij.database.run.actions.IconWithLogOverlay;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DbActiveConnectionInfoProviders;
import com.intellij.database.view.DvTreeIcons;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.IconUtil;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001d\u0010\r\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\nH\u0000\u001a2\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0002\u001a\u001a\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010'H\u0000\u001a\u0018\u0010,\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0016H\u0002\u001a\u001a\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\b\u0010%\u001a\u0004\u0018\u00010\nH\u0000\u001a\f\u00101\u001a\u00020\u0004*\u000202H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u001a\u00103\u001a\u00020\u0004*\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00065"}, d2={"hidePillsWhenL3RegistryKey", "", "boldDataSourcesRegistryKey", "hidePillsWhenL3", "", "getHidePillsWhenL3", "()Z", "boldDataSources", "getBoldDataSources", "getDataSourceForTopNode", "Lcom/intellij/database/model/RawDataSource;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNodePrimaryText", "Lorg/jetbrains/annotations/Nls;", "structure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "countShowChildrenNum", "", "vo", "Lcom/intellij/database/view/structure/DvViewOptions;", "getNodeIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "getDataSourceIcon", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "getLocalDataSourceIcon", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "addLevelIcon", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "area", "Lcom/intellij/database/model/basic/BasicMultiLevelIntrospectableArea;", "dataSource", "level", "Lcom/intellij/database/model/properties/Level;", "declared", "extraLow", "nullMeansAuto", "addDetailsLevelIcon", "addSecondIcon", "secondIcon", "isInIntrospectionScope", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "scanToCheckWhetherModelHasLowIntrospectionLevels", "Lcom/intellij/database/model/DasModel;", "isLow", "(Lcom/intellij/database/model/properties/Level;)Z", "intellij.database.impl"})
@JvmName(name="DbNodeDescriptorHelper")
@SourceDebugExtension(value={"SMAP\nDbNodeDescriptorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbNodeDescriptorHelper.kt\ncom/intellij/database/view/DbNodeDescriptorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class DbNodeDescriptorHelper {
    @NotNull
    private static final String hidePillsWhenL3RegistryKey = "database.view.levels.hide.L3";
    @NotNull
    private static final String boldDataSourcesRegistryKey = "database.view.ds.bold";

    private static final boolean getHidePillsWhenL3() {
        return Registry.Companion.is(hidePillsWhenL3RegistryKey);
    }

    public static final boolean getBoldDataSources() {
        return Registry.Companion.is(boldDataSourcesRegistryKey);
    }

    @Nullable
    public static final RawDataSource getDataSourceForTopNode(@NotNull BasicNode node) {
        RawDataSource rawDataSource;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof DataSourceNode) {
            rawDataSource = ((DataSourceNode)node).dataSource;
        } else if (basicNode instanceof BasicNamespace) {
            BasicModel basicModel = ((BasicNamespace)node).getModel();
            if (basicModel != null) {
                BasicModel it = basicModel;
                boolean bl = false;
                rawDataSource = BasicModelRegistry.Companion.instance().getDataSource(it);
            } else {
                rawDataSource = null;
            }
        } else if (basicNode instanceof BasicIntrospectableArea) {
            BasicModel basicModel = ((BasicIntrospectableArea)node).getModel();
            if (basicModel != null) {
                BasicModel it = basicModel;
                boolean bl = false;
                rawDataSource = BasicModelRegistry.Companion.instance().getDataSource(it);
            } else {
                rawDataSource = null;
            }
        } else {
            rawDataSource = null;
        }
        return rawDataSource;
    }

    @NotNull
    public static final String getNodePrimaryText(@NotNull BasicNode node, @NotNull DvTreeStructure structure) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        String text2 = structure.presentableNameOf(node);
        if (node instanceof BasicElement && Intrinsics.areEqual((Object)((BasicElement)node).getKind(), (Object)ObjectKind.BODY)) {
            text2 = DatabaseBundle.message("ObjectKind.body", new Object[0]);
        }
        return text2;
    }

    public static final int countShowChildrenNum(@NotNull BasicNode node, @NotNull DvTreeStructure structure, @NotNull DvViewOptions vo) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)vo, (String)"vo");
        boolean toCount = node instanceof DvExtraNode ? ((DvExtraNode)node).getShowCount() : (DvTreeNodeRankFun.getTreeNodeRank(node) == DvTreeNodeRank.TL_FAMILY ? true : (node instanceof BasicNamespaceOwner ? !vo.getGroupNamespaces() : false));
        return toCount ? structure.countRealChildrenOf(node) : 0;
    }

    @Nullable
    public static final Icon getNodeIcon(@NotNull Project project, @NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Icon icon = null;
        BasicNode basicNode = node;
        if (basicNode instanceof BasicElement) {
            Object object = ((BasicElement)node).getModel();
            if (object == null || (object = object.getDbms()) == null) {
                object = Dbms.UNKNOWN;
            }
            Object dbms = object;
            ModelHelper modelHelper = ModelFacade.forDbms((Dbms)dbms).getModelHelper();
            Intrinsics.checkNotNullExpressionValue((Object)modelHelper, (String)"getModelHelper(...)");
            ModelHelper helper = modelHelper;
            icon = helper.getIcon((DasObject)((Object)node));
        } else if (basicNode instanceof HostFamily) {
            icon = DatabaseIcons.ObjectGroup;
        } else if (basicNode instanceof DvExtraNode) {
            Icon icon2 = TypePresentationService.getService().getIcon((Object)node);
            if (icon2 == null) {
                DvTreeIconItem dvTreeIconItem = ((DvExtraNode)node).getIconItem();
                if (dvTreeIconItem != null) {
                    DvTreeIconItem it = dvTreeIconItem;
                    boolean bl = false;
                    icon2 = DvTreeIcons.TREE_NODE_ITEMS.get((Object)it);
                } else {
                    icon2 = null;
                }
            }
            icon = icon2;
        } else if (basicNode instanceof DataSourceNode) {
            icon = DbNodeDescriptorHelper.getDataSourceIcon(project, (DataSourceNode)node);
        }
        return icon;
    }

    private static final Icon getDataSourceIcon(Project project, DataSourceNode dsn) {
        if (project.isDisposed()) {
            return null;
        }
        RawDataSource ds = dsn.dataSource;
        boolean isSpinning = DataSourceSyncManager.Companion.getInstance().isActive(ds);
        Icon icon = isSpinning ? (Icon)AnimatedIcon.Default.INSTANCE : (ds instanceof LocalDataSource ? DbNodeDescriptorHelper.getLocalDataSourceIcon(project, (LocalDataSource)ds) : ds.getIcon(0));
        return icon;
    }

    private static final Icon getLocalDataSourceIcon(Project project, LocalDataSource ds) {
        Icon icon;
        block5: {
            block6: {
                boolean active;
                icon = ds.getBaseIcon();
                if (ds.isReadOnly()) {
                    Icon icon2 = icon;
                    Intrinsics.checkNotNull((Object)icon2);
                    icon = (Icon)((Object)new IconWithLockOverlay(icon2));
                }
                if (icon == null) break block5;
                boolean bl = active = DbImplUtil.isConnected(project, ds) & DbImplUtil.getActiveConnectionCount(ds) > 0 || DbActiveConnectionInfoProviders.getActiveConnectionInfo(ds, project) != null;
                if (active) {
                    icon = ExecutionUtil.getLiveIndicator((Icon)icon);
                }
                if (DataSourceFun.isJdbcLogEnabled(ds) && active) break block6;
                String string = ds.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                if (!DiagnosticMonitor.INSTANCE.isRecordingDataSource(string)) break block5;
            }
            icon = (Icon)((Object)new IconWithLogOverlay(icon));
        }
        return icon;
    }

    public static final void addLevelIcon(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dsn.getDbms())) {
            return;
        }
        LocalDataSource localDataSource = dsn.getLocalDataSource();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource lds = localDataSource;
        Level level = lds.getIntrospectionLevel();
        DbNodeDescriptorHelper.addLevelIcon(presentation, level, true, false, true);
    }

    public static final void addLevelIcon(@NotNull PresentationData presentation, @NotNull BasicMultiLevelIntrospectableArea area, @Nullable RawDataSource dataSource) {
        boolean autodetect;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        BasicModel basicModel = area.getModel();
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        BasicRoot basicRoot = model.getRoot();
        BasicMultiLevelRoot basicMultiLevelRoot = basicRoot instanceof BasicMultiLevelRoot ? (BasicMultiLevelRoot)basicRoot : null;
        if (basicMultiLevelRoot == null) {
            return;
        }
        BasicMultiLevelRoot rootArea = basicMultiLevelRoot;
        Dbms dbms = model.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) {
            return;
        }
        boolean bl = autodetect = area instanceof BasicMultiLevelSchema && rootArea.getExplicitIntrospectionLevel() == null;
        if (DbNodeDescriptorHelper.getHidePillsWhenL3() && !autodetect && !DbNodeDescriptorHelper.scanToCheckWhetherModelHasLowIntrospectionLevels(model)) {
            return;
        }
        LocalDataSource localDataSource = dataSource instanceof LocalDataSource ? (LocalDataSource)dataSource : null;
        if (localDataSource == null) {
            return;
        }
        LocalDataSource lds = localDataSource;
        if (area instanceof BasicNamespace && !DbNodeDescriptorHelper.isInIntrospectionScope((BasicNamespace)((Object)area), lds)) {
            Icon icon = AllIcons.Nodes.EmptyNode;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"EmptyNode");
            DbNodeDescriptorHelper.addSecondIcon(presentation, icon);
            return;
        }
        Level explicitlyDeclaredLevel = area.getExplicitIntrospectionLevel();
        Level level = explicitlyDeclaredLevel;
        if (level == null) {
            level = ModelFun.effectiveExplicitIntrospectionLevel(area);
        }
        Level declaredLevel = level;
        Level showLevel = null;
        boolean showAsExplicit = false;
        boolean showAsExtraLow = false;
        if (autodetect && area instanceof BasicMultiLevelSchema) {
            Level lastActualLevel = ((BasicMultiLevelSchema)area).getLastIntrospectionLevel();
            if (explicitlyDeclaredLevel != null) {
                if (LevelFun.isGreaterOrEqualsTo(lastActualLevel, explicitlyDeclaredLevel)) {
                    showLevel = explicitlyDeclaredLevel;
                    showAsExplicit = true;
                } else {
                    showLevel = lastActualLevel;
                    showAsExplicit = false;
                    showAsExtraLow = true;
                }
            } else {
                showLevel = lastActualLevel;
                showAsExplicit = false;
            }
        } else {
            showLevel = declaredLevel;
            showAsExplicit = explicitlyDeclaredLevel != null;
        }
        DbNodeDescriptorHelper.addLevelIcon(presentation, showLevel, showAsExplicit, showAsExtraLow, false);
    }

    private static final void addLevelIcon(PresentationData presentation, Level level, boolean declared, boolean extraLow, boolean nullMeansAuto) {
        Icon icon;
        block17: {
            block15: {
                Level level2;
                block18: {
                    block16: {
                        if (level == null) break block15;
                        if (!extraLow) break block16;
                        level2 = level;
                        switch (WhenMappings.$EnumSwitchMapping$0[level2.ordinal()]) {
                            case 1: {
                                icon = DatabaseIcons.Level1_details;
                                break block17;
                            }
                            case 2: {
                                icon = DatabaseIcons.Level2_details;
                                break block17;
                            }
                            case 3: {
                                icon = DatabaseIcons.Level3_details;
                                break block17;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (!declared) break block18;
                    level2 = level;
                    switch (WhenMappings.$EnumSwitchMapping$0[level2.ordinal()]) {
                        case 1: {
                            icon = DatabaseIcons.Level1_declared;
                            break block17;
                        }
                        case 2: {
                            icon = DatabaseIcons.Level2_declared;
                            break block17;
                        }
                        case 3: {
                            icon = DatabaseIcons.Level3_declared;
                            break block17;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                level2 = level;
                switch (WhenMappings.$EnumSwitchMapping$0[level2.ordinal()]) {
                    case 1: {
                        icon = DatabaseIcons.Level1_inherited;
                        break block17;
                    }
                    case 2: {
                        icon = DatabaseIcons.Level2_inherited;
                        break block17;
                    }
                    case 3: {
                        icon = DatabaseIcons.Level3_inherited;
                        break block17;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            icon = nullMeansAuto ? DatabaseIcons.LevelAuto : AllIcons.Nodes.EmptyNode;
        }
        Icon icon2 = icon;
        Intrinsics.checkNotNull((Object)icon2);
        Icon levelIcon = icon2;
        DbNodeDescriptorHelper.addSecondIcon(presentation, levelIcon);
    }

    public static final void addDetailsLevelIcon(@NotNull PresentationData presentation, @Nullable Level level) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (level == null) {
            return;
        }
        Level level2 = level;
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[level2.ordinal()]) {
            case 1 -> DatabaseIcons.Level1_details;
            case 2 -> DatabaseIcons.Level2_details;
            case 3 -> DatabaseIcons.Level3_details;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)icon);
        Icon levelIcon = icon;
        DbNodeDescriptorHelper.addSecondIcon(presentation, levelIcon);
    }

    private static final void addSecondIcon(PresentationData presentation, Icon secondIcon) {
        Icon normalIcon = presentation.getIcon(false);
        Icon rowIcon = IconUtil.rowIcon((Icon)normalIcon, (Icon)secondIcon);
        presentation.setIcon(rowIcon);
    }

    public static final boolean isInIntrospectionScope(@NotNull BasicNamespace namespace, @Nullable RawDataSource dataSource) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (dataSource instanceof LocalDataSource) {
            TreePattern treePattern = ((LocalDataSource)dataSource).getIntrospectionScope();
            Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
            TreePattern scope2 = treePattern;
            bl = DataSourceSchemaMapping.isIntrospected(scope2, namespace);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean scanToCheckWhetherModelHasLowIntrospectionLevels(DasModel $this$scanToCheckWhetherModelHasLowIntrospectionLevels) {
        if ($this$scanToCheckWhetherModelHasLowIntrospectionLevels instanceof BasicModel) {
            BasicRoot basicRoot = ((BasicModel)$this$scanToCheckWhetherModelHasLowIntrospectionLevels).getRoot();
            BasicMultiLevelRoot basicMultiLevelRoot = basicRoot instanceof BasicMultiLevelRoot ? (BasicMultiLevelRoot)basicRoot : null;
            if (basicMultiLevelRoot == null) {
                return false;
            }
            BasicMultiLevelRoot root = basicMultiLevelRoot;
            if (DbNodeDescriptorHelper.isLow(root.getExplicitIntrospectionLevel())) {
                return true;
            }
            for (BasicSchema basicSchema : root.getAllSchemas()) {
                if (!(basicSchema instanceof BasicMultiLevelSchema) || !DbNodeDescriptorHelper.isLow(((BasicMultiLevelSchema)basicSchema).getExplicitIntrospectionLevel())) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isLow(Level $this$isLow) {
        return $this$isLow == Level.L1 || $this$isLow == Level.L2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.L1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

