/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "<init>", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "jdbcTypeNameToSqlTypeName", "", "Lcom/intellij/openapi/util/NlsSafe;", "typeName", "betterTypeName", "name", "getTimeZoneManager", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "PgBaseTimeZoneManager", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseExecutionEnvironmentHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseExecutionEnvironmentHelper.kt\ncom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper\n+ 2 StandardResultsProcessors.kt\ncom/intellij/database/dataSource/connection/statements/StandardResultsProcessors\n*L\n1#1,57:1\n149#2:58\n*S KotlinDebug\n*F\n+ 1 PgBaseExecutionEnvironmentHelper.kt\ncom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper\n*L\n17#1:58\n*E\n"})
public class PgBaseExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @Nullable
    public ThreeState getSslState(@NotNull DatabaseConnectionCore connection2) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                if (Intrinsics.areEqual((Object)connection2.getDbms(), (Object)Dbms.COCKROACH)) break block2;
                int[] nArray = new int[]{9, 5};
                if (connection2.getVersion().isOrGreater(nArray)) break block3;
            }
            return null;
        }
        boolean $i$f$first = false;
        Either<StagedException, Object> isSsl = SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple().execute("select ssl from pg_stat_ssl where pid = pg_backend_pid()", (ExecutionMode)StandardExecutionMode.QUERY, new ResultsProducer.VoidReadyProcessor<Boolean>(){

            public Boolean empty() {
                Object rs = null;
                boolean bl = false;
                return null;
            }

            public Boolean results(RemoteResultSet resultSet, int subQueryIndex, int resultSetIndex, ResultsProducer.ReferenceInfo referenceInfo, Function2<? super RemoteResultSet, ? super ResultsProducer.ReferenceInfo, Unit> referenceConsumer) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                Intrinsics.checkNotNullParameter(referenceConsumer, (String)"referenceConsumer");
                RemoteResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = rs;
                return remoteResultSet != null ? Boolean.valueOf(remoteResultSet.getBoolean(1)) : null;
            }

            public Boolean parameterResults(List<? extends OutParameter<?>> parameters, int subQueryIndex, int resultSetIndex, Function1<? super OutParameter<?>, ? extends Object> retriever) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                Object rs = null;
                boolean bl = false;
                return null;
            }

            public Boolean updateCount(int count) {
                Object rs = null;
                boolean bl = false;
                return null;
            }
        });
        Boolean bl = isSsl.rightOr((Object)null);
        return Intrinsics.areEqual((Object)bl, (Object)true) ? ThreeState.YES : (Intrinsics.areEqual((Object)bl, (Object)false) ? ThreeState.NO : ThreeState.UNSURE);
    }

    @Override
    @NotNull
    public String jdbcTypeNameToSqlTypeName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        char[] cArray = new char[]{'_'};
        String name2 = StringsKt.trimStart((String)typeName, (char[])cArray);
        return this.betterTypeName(name2) + CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)(typeName.length() - name2.length()))), null, null, null, (int)0, null, PgBaseExecutionEnvironmentHelper::jdbcTypeNameToSqlTypeName$lambda$1, (int)31, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String betterTypeName(String name2) {
        String string = name2;
        switch (string.hashCode()) {
            case 3237411: {
                if (string.equals("int2")) return "smallint";
                break;
            }
            case 3237413: {
                if (string.equals("int4")) return "integer";
                break;
            }
            case 3237417: {
                if (!string.equals("int8")) break;
                return "bigint";
            }
        }
        String string2 = name2;
        return string2;
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        return PgBaseTimeZoneManager.INSTANCE;
    }

    private static final CharSequence jdbcTypeNameToSqlTypeName$lambda$1(int it) {
        return "[]";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper$PgBaseTimeZoneManager;", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "<init>", "()V", "canChange", "", "changeTimeZone", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "timeZone", "", "intellij.database.dialects.postgresbase"})
    private static final class PgBaseTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        @NotNull
        public static final PgBaseTimeZoneManager INSTANCE = new PgBaseTimeZoneManager();

        private PgBaseTimeZoneManager() {
        }

        @Override
        public boolean canChange() {
            return true;
        }

        @Override
        public void changeTimeZone(@NotNull DatabaseConnectionCore connection2, @NotNull String timeZone) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
            BarrenStatement.QuietBarrenStatement<String> quietBarrenStatement = SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).barren().quiet();
            String string = "set timezone = '%s'";
            Object[] objectArray = new Object[]{timeZone};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            quietBarrenStatement.execute(string2);
        }
    }
}

