/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class DdlMappingLink
extends ActionLink {
    protected final DatabaseConfigEditor myController;

    public DdlMappingLink(@NotNull DatabaseConfigEditor controller) {
        if (controller == null) {
            DdlMappingLink.$$$reportNull$$$0(0);
        }
        super("");
        this.addActionListener(e -> {
            this.onMappingClicked();
            this.updateText();
        });
        this.myController = controller;
    }

    private void onMappingClicked() {
        JBIterable mappings = this.getMappings().collect();
        if (mappings.isEmpty()) {
            DdlMapping mapping = new DdlMapping(null);
            this.setUp(mapping);
            this.myController.onCreated(mapping);
            return;
        }
        DdlMapping single = (DdlMapping)mappings.single();
        if (single != null) {
            this.myController.navigateTo(single, true);
        } else {
            JBPopupFactory.getInstance().createPopupChooserBuilder(mappings.map(m -> (DdlMapping)this.myController.getTempTargetOrTarget(m)).toList()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<DdlMapping>(){

                protected void customizeCellRenderer(@NotNull JList<? extends DdlMapping> list, DdlMapping value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.setIcon(DdlMappingConfigurable.getIcon(DdlMappingLink.this.myController, value.getDataSourceId(), value.getDdlDataSourceId()));
                    this.append(value.getName());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/DdlMappingLink$1", "customizeCellRenderer"));
                }
            }).setItemChosenCallback(m -> this.myController.navigateTo(m, true)).createPopup().showUnderneathOf((Component)((Object)this));
        }
    }

    protected abstract void setUp(DdlMapping var1);

    public void updateText() {
        JBIterable mappings = this.getMappings().collect();
        DdlMapping first2 = (DdlMapping)mappings.first();
        int size = mappings.size();
        String name2 = first2 == null ? null : first2.getName();
        this.setText(DatabaseBundle.message("create.ddl.mapping.or.name", size - 1, name2));
        this.setToolTipText(this.getText());
        boolean hasProblems = mappings.find(m -> this.myController.getProblem(m) != null) != null;
        this.setForeground((Color)(hasProblems ? JBColor.red : JBUI.CurrentTheme.Link.Foreground.ENABLED));
        DdlMappingConfigurable.doNotStretchByText((JComponent)((Object)this));
    }

    protected abstract JBIterable<DdlMapping> getMappings();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/dataSource/DdlMappingLink", "<init>"));
    }
}

