/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.remoteDev.hostStatus.UnattendedHostStatus;
import com.jetbrains.gateway.ssh.AvailableIde;
import com.jetbrains.gateway.ssh.IdeStatus;
import com.jetbrains.gateway.ssh.IdeWithStatus;
import com.jetbrains.gateway.ssh.InstalledIde;
import com.jetbrains.gateway.ssh.InstalledIdeUIEx;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"getIdeToShow", "", "Lcom/jetbrains/gateway/ssh/IdeWithStatus;", "installed", "Lcom/jetbrains/gateway/ssh/InstalledIdeUIEx;", "available", "Lcom/jetbrains/gateway/ssh/AvailableIde;", "getInstalledIDEFrom", "Lcom/jetbrains/gateway/ssh/InstalledIde;", "hostStatus", "Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;", "getProductFrom", "Lcom/jetbrains/gateway/ssh/IntelliJPlatformProduct;", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nIDEUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDEUtil.kt\ncom/jetbrains/gateway/ssh/IDEUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1863#2,2:94\n1#3:96\n*S KotlinDebug\n*F\n+ 1 IDEUtil.kt\ncom/jetbrains/gateway/ssh/IDEUtilKt\n*L\n56#1:94,2\n*E\n"})
public final class IDEUtilKt {
    @NotNull
    public static final List<IdeWithStatus> getIdeToShow(@NotNull List<InstalledIdeUIEx> installed, @NotNull List<AvailableIde> available) {
        Intrinsics.checkNotNullParameter(installed, (String)"installed");
        Intrinsics.checkNotNullParameter(available, (String)"available");
        List ides = new ArrayList();
        Iterable $this$forEach$iv = installed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstalledIdeUIEx it = (InstalledIdeUIEx)element$iv;
            boolean bl = false;
            ides.add(new IdeWithStatus(it.getProduct(), it.getBuildNumber(), IdeStatus.ALREADY_INSTALLED, null, it.getPathToIde(), it.getPresentableVersion(), it.getRemoteDevType()));
        }
        for (AvailableIde ide : available) {
            boolean isNotInstalled;
            Object v0;
            block3: {
                Iterable iterable = installed;
                for (Object t : iterable) {
                    InstalledIdeUIEx it = (InstalledIdeUIEx)t;
                    boolean bl = false;
                    if (!(ide.getProduct() == it.getProduct() && Intrinsics.areEqual((Object)ide.getBuildNumber(), (Object)it.getBuildNumber()))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if (!(isNotInstalled = v0 == null)) continue;
            ides.add(new IdeWithStatus(ide.getProduct(), ide.getBuildNumber(), IdeStatus.DOWNLOAD, ide.getDownload(), null, ide.getPresentableVersion(), ide.getRemoteDevType()));
        }
        return ides;
    }

    @NotNull
    public static final InstalledIde getInstalledIDEFrom(@NotNull UnattendedHostStatus hostStatus) {
        Intrinsics.checkNotNullParameter((Object)hostStatus, (String)"hostStatus");
        BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)hostStatus.getAppVersion());
        if (buildNumber == null) {
            boolean $i$a$-requireNotNull-IDEUtilKt$getInstalledIDEFrom$32 = false;
            String $i$a$-requireNotNull-IDEUtilKt$getInstalledIDEFrom$32 = "Remote host returned strange backend version, unable to parse build number: \"" + hostStatus.getAppVersion() + "\"";
            throw new IllegalArgumentException($i$a$-requireNotNull-IDEUtilKt$getInstalledIDEFrom$32.toString());
        }
        String string = buildNumber.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        IntelliJPlatformProduct ide = IntelliJPlatformProduct.Companion.fromProductCode(string);
        if (ide == null) {
            boolean bl = false;
            String string2 = "Unknown product code: \"" + buildNumber.getProductCode() + "\"";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = buildNumber.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringWithoutProductCode(...)");
        return new InstalledIde(ide, string3, hostStatus.getIdePath());
    }

    @NotNull
    public static final IntelliJPlatformProduct getProductFrom(@NotNull UnattendedHostStatus hostStatus) {
        Intrinsics.checkNotNullParameter((Object)hostStatus, (String)"hostStatus");
        String[] stringArray = new String[]{"-"};
        List versionParts = StringsKt.split$default((CharSequence)hostStatus.getAppVersion(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!(versionParts.size() == 2)) {
            boolean $i$a$-require-IDEUtilKt$getProductFrom$32 = false;
            String $i$a$-require-IDEUtilKt$getProductFrom$32 = "Remote host returned strange backend version: \"" + hostStatus.getAppVersion() + "\"";
            throw new IllegalArgumentException($i$a$-require-IDEUtilKt$getProductFrom$32.toString());
        }
        String productCodeFromStatus = (String)versionParts.get(0);
        IntelliJPlatformProduct product = IntelliJPlatformProduct.Companion.fromProductCode(productCodeFromStatus);
        if (!(product != null)) {
            boolean bl = false;
            String string = "Cannot find product with code '" + productCodeFromStatus + "' installed at " + hostStatus.getIdePath();
            throw new IllegalArgumentException(string.toString());
        }
        return product;
    }
}

