/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeMethodStaticQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.static", new Object[0]);
        if (string == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(2);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), PyFunction.class)) == null) {
            return;
        }
        List usages = StreamEx.of(PyPsiIndexUtil.findUsages((PsiNamedElement)problemFunction, false)).map(UsageInfo::getElement).select(PyReferenceExpression.class).toList();
        ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(PyPsiBundle.message("refactoring.progress.title.updating.existing.usages", new Object[0]), problemFunction.getProject(), null, indicator -> {
            PyMakeMethodStaticQuickFix.updateDefinition(problemFunction);
            for (int i = 0; i < usages.size(); ++i) {
                indicator.checkCanceled();
                indicator.setFraction(((double)i + 1.0) / (double)usages.size());
                PyMakeMethodStaticQuickFix.updateUsage((PyReferenceExpression)usages.get(i));
            }
        });
    }

    private static void updateDefinition(@NotNull PyFunction function) {
        PyParameter[] parameters;
        if (function == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(3);
        }
        if ((parameters = function.getParameterList().getParameters()).length > 0) {
            parameters[0].delete();
        }
        PyUtil.addDecorator(function, "@staticmethod");
    }

    private static void updateUsage(@NotNull PyReferenceExpression element) {
        PyExpression qualifier;
        if (element == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(4);
        }
        if ((qualifier = element.getQualifier()) == null) {
            return;
        }
        PsiReference reference = qualifier.getReference();
        if (reference == null) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PyClass) {
            PyMakeMethodStaticQuickFix.updateArgumentList(element);
        }
    }

    private static void updateArgumentList(@NotNull PyReferenceExpression element) {
        PyCallExpression callExpression;
        if (element == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(5);
        }
        if ((callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) == null) {
            return;
        }
        PyArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PyExpression[] arguments = argumentList.getArguments();
        if (arguments.length > 0) {
            arguments[0].delete();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(6);
        }
        return currentFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateArgumentList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

