/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.ReferencesCodeVisionProvider;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.codeVision.PyCodeVisionUsageCollector;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/codeInsight/codeVision/PyReferencesCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/ReferencesCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "getVisionInfo", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "getHint", "", "logClickToFUS", "", "hint", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "Companion", "intellij.python.community.impl"})
public final class PyReferencesCodeVisionProvider
extends ReferencesCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "python.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof PyFile;
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        if (element instanceof PyClass && PyUtil.isTopLevel(element)) {
            return true;
        }
        if (element instanceof PyFunction) {
            PyClass containingClass;
            if (!(PyUtil.isTopLevel(element) || (containingClass = ((PyFunction)element).getContainingClass()) != null && PyUtil.isTopLevel(containingClass))) {
                return false;
            }
            String string = ((PyFunction)element).getName();
            if (string == null) {
                return false;
            }
            String elementName = string;
            return !PyUtilCore.isSpecialName((String)elementName);
        }
        return false;
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(element instanceof PsiNamedElement)) {
            return null;
        }
        String string = ((PsiNamedElement)element).getName();
        if (string == null) {
            return null;
        }
        String elementName = string;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)((PsiNamedElement)element).getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.getInstance((Project)((PsiNamedElement)element).getProject()).isCheapEnoughToSearch(elementName, scope, file);
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(...)");
        PsiSearchHelper.SearchCostResult costSearchOutsideCurrentFile = searchCostResult;
        if (costSearchOutsideCurrentFile == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return null;
        }
        AtomicInteger usagesCount = new AtomicInteger();
        AtomicInteger dynamicUsagesCount = new AtomicInteger();
        int limit = AdvancedSettings.Companion.getInt("python.code.vision.usages.limit");
        ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, (SearchScope)scope, false)).allowParallelProcessing().forEach(arg_0 -> PyReferencesCodeVisionProvider.getVisionInfo$lambda$0(element, dynamicUsagesCount, usagesCount, limit, arg_0));
        int result2 = usagesCount.get();
        int dynamicResult = dynamicUsagesCount.get();
        if (result2 == 0 && dynamicResult == 0) {
            return null;
        }
        if (dynamicResult == 0 || result2 > limit) {
            Object[] objectArray = new Object[]{Math.min(result2, limit), result2 > limit ? 1 : 0};
            String string2 = PyBundle.message("inlay.hints.usages.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(result2), result2 <= limit);
        }
        Object[] objectArray = new Object[]{result2, dynamicResult};
        String string3 = PyBundle.message("inlay.hints.usages.with.dynamic.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return new CodeVisionProviderBase.CodeVisionInfo(string3, Integer.valueOf(result2), false, 4, null);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        PyCodeVisionUsageCollector.INSTANCE.logClickToFUS(element);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static final boolean getVisionInfo$lambda$0(PsiElement $element, AtomicInteger $dynamicUsagesCount, AtomicInteger $usagesCount, int $limit, PsiReference it) {
        boolean bl;
        if (it == null) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)((PsiNamedElement)$element).getReference(), (Object)it)) {
            bl = true;
        } else {
            if (new UsageInfo(it).isDynamicUsage()) {
                $dynamicUsagesCount.incrementAndGet();
            }
            bl = $usagesCount.incrementAndGet() <= $limit;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/codeInsight/codeVision/PyReferencesCodeVisionProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

