/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH$J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH$J\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0004J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "", "lspServerLoader", "Lcom/intellij/lang/typescript/lsp/LspServerLoader;", "<init>", "(Lcom/intellij/lang/typescript/lsp/LspServerLoader;)V", "getLspServerLoader", "()Lcom/intellij/lang/typescript/lsp/LspServerLoader;", "isFileAcceptableForLspServer", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectContext", "project", "Lcom/intellij/openapi/project/Project;", "context", "isEnabledInSettings", "isLspServerEnabledAndAvailable", "isLspServerEnabled", "isLspServerAvailable", "isEnabledByContextAndSettings", "isEnabledByEnvironment", "forceEnabled", "isForceEnabledInTests", "markForceEnabled", "", "value", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class LspServerActivationRule {
    @NotNull
    private final LspServerLoader lspServerLoader;
    private boolean forceEnabled;

    public LspServerActivationRule(@NotNull LspServerLoader lspServerLoader) {
        Intrinsics.checkNotNullParameter((Object)lspServerLoader, (String)"lspServerLoader");
        this.lspServerLoader = lspServerLoader;
    }

    @NotNull
    public final LspServerLoader getLspServerLoader() {
        return this.lspServerLoader;
    }

    public abstract boolean isFileAcceptableForLspServer(@NotNull VirtualFile var1);

    protected abstract boolean isProjectContext(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isEnabledInSettings(@NotNull Project var1);

    public final boolean isLspServerEnabledAndAvailable(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.isLspServerEnabled(project, context2) && this.isLspServerAvailable(project);
    }

    public final boolean isLspServerEnabled(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.isFileAcceptableForLspServer(context2) && this.isEnabledByContextAndSettings(project, context2);
    }

    public final boolean isLspServerAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.lspServerLoader.getAbsolutePathOrRefresh(project) != null;
    }

    protected final boolean isEnabledByContextAndSettings(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isForceEnabledInTests()) {
            return true;
        }
        return this.isEnabledByEnvironment(project, context2) && this.isEnabledInSettings(project) && this.isProjectContext(project, context2);
    }

    protected boolean isEnabledByEnvironment(@NotNull Project project, @NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !ApplicationManager.getApplication().isUnitTestMode();
    }

    private final boolean isForceEnabledInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && this.forceEnabled;
    }

    @TestOnly
    public final void markForceEnabled(boolean value) {
        this.forceEnabled = value;
    }
}

