/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSConvertLoopsUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertIndexedForToForOfInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertIndexedForToForOfInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertIndexedForToForOfInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSForStatement(@NotNull JSForStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.FOR_OF)) {
                    return;
                }
                Pair<PsiElement, JSExpression> loopInfo = JSConvertLoopsUtils.getSequentiallyIteratedArrayIndexedFor(node, false);
                if (loopInfo == null) {
                    return;
                }
                PsiElement indexVariable = (PsiElement)loopInfo.first;
                JSExpression collectionExpression = (JSExpression)loopInfo.second;
                PsiElement child = node.getFirstChild();
                if (PsiUtilCore.getElementType((PsiElement)child) != JSTokenTypes.FOR_KEYWORD) {
                    return;
                }
                TextRange range = TextRange.from((int)0, (int)child.getTextLength());
                if (JSConvertLoopsUtils.containsOnlyIndexedAccessToCollection(node.getBody(), collectionExpression, indexVariable)) {
                    holder.registerProblem((PsiElement)node, range, JavaScriptBundle.message("js.convert.indexed.for.to.for.of.inspection.text", new Object[0]), new LocalQuickFix[]{new ES6ConvertIndexedForToForOfInspectionQuickFix((PsiElement)node)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6ConvertIndexedForToForOfInspection$1", "visitJSForStatement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6ConvertIndexedForToForOfInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ES6ConvertIndexedForToForOfInspectionQuickFix
    extends LocalQuickFixOnPsiElement {
        protected ES6ConvertIndexedForToForOfInspectionQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSVarStatement.VarKeyword variableKeyword;
            if (project == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(4);
            }
            assert (startElement instanceof JSForStatement);
            JSForStatement forStatement = (JSForStatement)startElement;
            Pair<PsiElement, JSExpression> loopInfo = JSConvertLoopsUtils.getSequentiallyIteratedArrayIndexedFor(forStatement, false);
            if (loopInfo == null) {
                return;
            }
            PsiElement indexVariable = (PsiElement)loopInfo.first;
            JSExpression collectionExpression = (JSExpression)loopInfo.second;
            PsiElement collectionReference = JSConvertLoopsUtils.resolveCollectionReference(collectionExpression);
            if (collectionReference == null) {
                return;
            }
            JSStatement previousBody = forStatement.getBody();
            if (previousBody == null) {
                return;
            }
            JSVarStatement assignment = JSConvertLoopsUtils.findCollectionItemAssignment(previousBody, collectionReference, indexVariable);
            String itemName = JSConvertLoopsUtils.getItemVariableName(assignment, (PsiElement)forStatement);
            JSVariable variable = JSConvertLoopsUtils.getItemVariable(assignment);
            JSVarStatement.VarKeyword varKeyword = variableKeyword = variable != null ? assignment.getVarKeyword() : null;
            if (variableKeyword == null) {
                variableKeyword = JSChangeUtil.getVariableKeyword(startElement, true);
            }
            String source = String.format("for (%s %s of %s) {}", variableKeyword.getText(), itemName, collectionExpression.getText());
            SmartPsiElementPointer forStatementPointer = SmartPointerManager.createPointer((PsiElement)forStatement);
            JSConvertLoopsUtils.replacePropertyAccessExpressions(previousBody, collectionReference, indexVariable, itemName);
            if (assignment != null) {
                JSConvertLoopsUtils.removeItemAssignmentAndReformat(project, file, assignment);
            }
            if ((forStatement = (JSForStatement)forStatementPointer.getElement()) == null) {
                return;
            }
            previousBody = forStatement.getBody();
            if (previousBody == null) {
                return;
            }
            JSForInStatement forEachStatement = JSPsiElementFactory.createJSStatement(source, startElement, JSForInStatement.class);
            JSStatement body = forEachStatement.getBody();
            assert (body != null);
            body.replace(previousBody);
            forStatement.replace(forEachStatement);
        }

        @Nls
        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("js.convert.indexed.for.to.for.of.text", new Object[0]);
            if (string == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.convert.indexed.for.to.for.of.family.name", new Object[0]);
            if (string == null) {
                ES6ConvertIndexedForToForOfInspectionQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertIndexedForToForOfInspection$ES6ConvertIndexedForToForOfInspectionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertIndexedForToForOfInspection$ES6ConvertIndexedForToForOfInspectionQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

