/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateActionContext {
    private final JSFile myJsFile;
    private final Editor myEditor;
    private final int myDocumentCaretOffset;

    GenerateActionContext(@NotNull JSFile jsFile, @NotNull Editor editor) {
        if (jsFile == null) {
            GenerateActionContext.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateActionContext.$$$reportNull$$$0(1);
        }
        this.myJsFile = jsFile;
        this.myEditor = editor;
        this.myDocumentCaretOffset = this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public JSFile getJsFile() {
        JSFile jSFile = this.myJsFile;
        if (jSFile == null) {
            GenerateActionContext.$$$reportNull$$$0(2);
        }
        return jSFile;
    }

    public int getDocumentCaretOffset() {
        return this.myDocumentCaretOffset;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            GenerateActionContext.$$$reportNull$$$0(3);
        }
        return editor;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myEditor.getDocument();
        if (document == null) {
            GenerateActionContext.$$$reportNull$$$0(4);
        }
        return document;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myJsFile.getProject();
        if (project == null) {
            GenerateActionContext.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditor.getCaretModel();
        if (caretModel == null) {
            GenerateActionContext.$$$reportNull$$$0(6);
        }
        return caretModel;
    }

    @Nullable
    public PsiElement getPsiElementUnderCaret() {
        PsiElement element = this.myJsFile.findElementAt(this.getDocumentCaretOffset());
        if (element == null) {
            element = this.myJsFile.getLastChild();
        }
        return element;
    }

    public void startTemplate(@NotNull Template template) {
        if (template == null) {
            GenerateActionContext.$$$reportNull$$$0(7);
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)this.getProject());
        templateManager.startTemplate(this.getEditor(), "", template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

