/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageVersionComparator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil;", "", "<init>", "()V", "PACKAGE_VERSION_CACHE", "", "", "Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$TimestampedVersion;", "getPackageVersion", "Lcom/intellij/util/text/SemVer;", "packageDir", "Ljava/nio/file/Path;", "getPackageVersionByPackageJson", "packageJson", "calc", "parseVersion", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "comparePackageVersions", "", "version1", "version2", "Timestamp", "TimestampedVersion", "intellij.javascript.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNodePackageVersionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePackageVersionUtil.kt\ncom/intellij/javascript/nodejs/NodePackageVersionUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n15#2:153\n*S KotlinDebug\n*F\n+ 1 NodePackageVersionUtil.kt\ncom/intellij/javascript/nodejs/NodePackageVersionUtil\n*L\n63#1:153\n*E\n"})
public final class NodePackageVersionUtil {
    @NotNull
    public static final NodePackageVersionUtil INSTANCE = new NodePackageVersionUtil();
    @NotNull
    private static final Map<String, TimestampedVersion> PACKAGE_VERSION_CACHE;

    private NodePackageVersionUtil() {
    }

    @JvmStatic
    @Nullable
    public static final SemVer getPackageVersion(@NotNull Path packageDir) {
        Intrinsics.checkNotNullParameter((Object)packageDir, (String)"packageDir");
        Path path2 = packageDir.resolve("package.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return INSTANCE.getPackageVersionByPackageJson(path2);
    }

    private final SemVer getPackageVersionByPackageJson(Path packageJson) {
        if (!Files.isRegularFile(packageJson, new LinkOption[0])) {
            return null;
        }
        String path2 = ((Object)packageJson.toAbsolutePath()).toString();
        TimestampedVersion r = PACKAGE_VERSION_CACHE.get(path2);
        Timestamp upToDateTimestamp = Timestamp.Companion.create(packageJson);
        if (r == null || !r.getTimestamp().isEqual(upToDateTimestamp)) {
            SemVer packageVersion = this.calc(packageJson);
            r = new TimestampedVersion(upToDateTimestamp, packageVersion);
            PACKAGE_VERSION_CACHE.put(path2, r);
        }
        return r.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SemVer calc(Path packageJson) {
        try {
            Object object = packageJson;
            Object object2 = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{};
            object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2);
            object2 = null;
            try {
                SemVer semVer;
                InputStreamReader reader = (InputStreamReader)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new JsonFactory().createParser((Reader)reader);
                Throwable throwable = null;
                try {
                    JsonParser parser2 = (JsonParser)closeable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)parser2);
                    String versionText = INSTANCE.parseVersion(parser2);
                    semVer = SemVer.parseFromText((String)versionText);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable, throwable);
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        object2 = throwable4;
                        throw throwable4;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                SemVer semVer2 = semVer;
                return semVer2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(NodePackageVersionUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse " + packageJson, (Throwable)e);
            return null;
        }
    }

    private final String parseVersion(JsonParser parser2) throws IOException {
        if (parser2.nextToken() == JsonToken.START_OBJECT) {
            while (parser2.nextToken() != JsonToken.END_OBJECT) {
                JsonParser jsonParser;
                if (parser2.currentToken() == JsonToken.FIELD_NAME) {
                    if (Intrinsics.areEqual((Object)parser2.currentName(), (Object)"version")) {
                        return parser2.nextTextValue();
                    }
                    parser2.nextToken();
                    jsonParser = parser2.skipChildren();
                    continue;
                }
                jsonParser = parser2.skipChildren();
            }
        }
        return null;
    }

    @JvmStatic
    public static final int comparePackageVersions(@NotNull String version1, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
        if (Intrinsics.areEqual((Object)version1, (Object)version2)) {
            return 0;
        }
        SemVer ver1 = SemVer.parseFromText((String)version1);
        SemVer ver2 = SemVer.parseFromText((String)version2);
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        int result2 = ver1.compareTo(ver2);
        if (result2 == 0) {
            if (Intrinsics.areEqual((Object)version1, (Object)ver1.getParsedVersion())) {
                return 1;
            }
            if (Intrinsics.areEqual((Object)version2, (Object)ver2.getParsedVersion())) {
                return -1;
            }
            result2 = PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
        }
        return result2;
    }

    static {
        Map map2 = Collections.synchronizedMap((Map)new FixedHashMap(10));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(...)");
        PACKAGE_VERSION_CACHE = map2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp;", "", "fileLastModified", "Ljava/nio/file/attribute/FileTime;", "vfsModificationStamp", "", "<init>", "(Ljava/nio/file/attribute/FileTime;J)V", "isEqual", "", "other", "Companion", "intellij.javascript.impl"})
    private static final class Timestamp {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final FileTime fileLastModified;
        private final long vfsModificationStamp;

        public Timestamp(@Nullable FileTime fileLastModified, long vfsModificationStamp) {
            this.fileLastModified = fileLastModified;
            this.vfsModificationStamp = vfsModificationStamp;
        }

        public final boolean isEqual(@NotNull Timestamp other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.vfsModificationStamp == other.vfsModificationStamp && Intrinsics.areEqual((Object)this.fileLastModified, (Object)other.fileLastModified);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp$Companion;", "", "<init>", "()V", "getVfsModificationStamp", "", "packageJson", "Ljava/nio/file/Path;", "create", "Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp;", "intellij.javascript.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final long getVfsModificationStamp(Path packageJson) {
                VirtualFile vfsPackageJson;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return -1L;
                }
                VirtualFile virtualFile = vfsPackageJson = LocalFileSystem.getInstance().findFileByNioFile(packageJson);
                return virtualFile != null ? virtualFile.getModificationStamp() : -1L;
            }

            @NotNull
            public final Timestamp create(@NotNull Path packageJson) {
                FileTime fileTime;
                Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
                try {
                    fileTime = Files.getLastModifiedTime(packageJson, new LinkOption[0]);
                }
                catch (IOException e) {
                    fileTime = null;
                }
                FileTime lastModified = fileTime;
                long vfsModificationStamp = this.getVfsModificationStamp(packageJson);
                return new Timestamp(lastModified, vfsModificationStamp);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$TimestampedVersion;", "", "timestamp", "Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp;", "version", "Lcom/intellij/util/text/SemVer;", "<init>", "(Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp;Lcom/intellij/util/text/SemVer;)V", "getTimestamp", "()Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp;", "getVersion", "()Lcom/intellij/util/text/SemVer;", "intellij.javascript.impl"})
    private static final class TimestampedVersion {
        @NotNull
        private final Timestamp timestamp;
        @Nullable
        private final SemVer version;

        public TimestampedVersion(@NotNull Timestamp timestamp, @Nullable SemVer version2) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this.timestamp = timestamp;
            this.version = version2;
        }

        @NotNull
        public final Timestamp getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final SemVer getVersion() {
            return this.version;
        }
    }
}

