/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.util.imageio.svg;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/images/util/imageio/svg/ImageInputStreamAdapter;", "Ljava/io/InputStream;", "imageInputStream", "Ljavax/imageio/stream/ImageInputStream;", "<init>", "(Ljavax/imageio/stream/ImageInputStream;)V", "closed", "", "close", "", "read", "", "b", "", "off", "len", "skip", "", "n", "markSupported", "mark", "readlimit", "reset", "intellij.platform.images"})
public final class ImageInputStreamAdapter
extends InputStream {
    @NotNull
    private final ImageInputStream imageInputStream;
    private boolean closed;

    public ImageInputStreamAdapter(@NotNull ImageInputStream imageInputStream) {
        Intrinsics.checkNotNullParameter((Object)imageInputStream, (String)"imageInputStream");
        this.imageInputStream = imageInputStream;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        return this.imageInputStream.read();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (len <= 0) {
            return 0;
        }
        return this.imageInputStream.read(b, off, (int)Math.max((long)len, 0L));
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (n <= 0L) {
            return 0L;
        }
        return this.imageInputStream.skipBytes(n);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.imageInputStream.mark();
    }

    @Override
    public void reset() {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.imageInputStream.reset();
    }
}

