/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.console.WebConsoleHistoryView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/console/ResourcesStaticServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "ResourceKind", "Companion", "intellij.javascript.debugger"})
public final class ResourcesStaticServer
extends HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String FONTS_DIR = "fonts";
    @NotNull
    private static final String PREFIX = "/a03365f2-eea1-451a-ad19-6dae9187a990/";
    @NotNull
    private static final String FRONTEND_DIR = "frontend";
    @NotNull
    private static final String ROOT = "frontend/";
    @NotNull
    private static final String MAIN = "frontend/console.html";
    @NotNull
    private static final String ICONS_DIR = "icons";
    @NotNull
    private static final Logger LOG;
    private static long lastModified;
    @NotNull
    private static final Map<String, WebConsoleHistoryView> iconIdCache;
    @NotNull
    private static final Map<WebConsoleHistoryView, Integer> consoleId;
    private static int consoleIdCounter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        ResourceKind resourceKind;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = urlDecoder.path();
        Intrinsics.checkNotNull((Object)path);
        if (!StringsKt.startsWith$default((String)path, (String)PREFIX, (boolean)false, (int)2, null)) {
            throw new IllegalStateException("prefix should have been checked by #isSupported");
        }
        String string = path.substring(38);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = new char[]{'/'};
        List payLoad = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String fileName = (String)CollectionsKt.last((List)payLoad);
        if (!PathUtil.isValidFileName((String)fileName)) {
            LOG.error("Invalid file name " + fileName);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        if (payLoad.size() == 2 && Intrinsics.areEqual(payLoad.get(0), (Object)FRONTEND_DIR)) {
            resourceKind = ResourceKind.FRONTEND_RESOURCE;
        } else if (payLoad.size() == 3 && Intrinsics.areEqual(payLoad.get(0), (Object)FRONTEND_DIR) && Intrinsics.areEqual(payLoad.get(1), (Object)ICONS_DIR)) {
            resourceKind = ResourceKind.ICON;
        } else if (payLoad.size() == 3 && Intrinsics.areEqual(payLoad.get(0), (Object)FRONTEND_DIR) && Intrinsics.areEqual(payLoad.get(1), (Object)FONTS_DIR)) {
            resourceKind = ResourceKind.FONT;
        } else {
            LOG.error("Invalid path " + path);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        ResourceKind kind = resourceKind;
        HttpRequest httpRequest = (HttpRequest)request;
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        ResourcesStaticServer.Companion.sendResource(httpRequest, channel, kind, fileName);
        return true;
    }

    static {
        Logger logger = Logger.getInstance(ResourcesStaticServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        iconIdCache = new HashMap();
        consoleId = new HashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J(\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010.2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0006\u00100\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lcom/intellij/javascript/debugger/console/ResourcesStaticServer$Companion;", "", "<init>", "()V", "FONTS_DIR", "", "PREFIX", "FRONTEND_DIR", "ROOT", "MAIN", "ICONS_DIR", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "lastModified", "", "iconIdCache", "", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "consoleId", "", "consoleIdCounter", "instance", "Lcom/intellij/javascript/debugger/console/ResourcesStaticServer;", "getInstance", "()Lcom/intellij/javascript/debugger/console/ResourcesStaticServer;", "cacheIconId", "console", "id", "cacheIconId$intellij_javascript_debugger", "clearConsoleCaches", "", "clearConsoleCaches$intellij_javascript_debugger", "getIcon", "Ljavax/swing/Icon;", "fileName", "getStaticUrl", "staticPath", "sendResource", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "kind", "Lcom/intellij/javascript/debugger/console/ResourcesStaticServer$ResourceKind;", "getFontStream", "Ljava/io/InputStream;", "getIconStream", "getMainUrl", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourcesStaticServer getInstance() {
            Object object = HttpRequestHandler.Companion.getEP_NAME().findExtension(ResourcesStaticServer.class);
            Intrinsics.checkNotNull((Object)object);
            return (ResourcesStaticServer)((Object)object);
        }

        @NotNull
        public final String cacheIconId$intellij_javascript_debugger(@NotNull WebConsoleHistoryView console, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!consoleId.containsKey(console)) {
                Map map = consoleId;
                int n = consoleIdCounter;
                consoleIdCounter = n + 1;
                Integer n2 = n;
                map.put(console, n2);
            }
            String compoundId = consoleId.get(console) + "_" + id;
            iconIdCache.put(compoundId, console);
            return "icons/" + compoundId;
        }

        public final void clearConsoleCaches$intellij_javascript_debugger(@NotNull WebConsoleHistoryView console) {
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            iconIdCache.entrySet().removeIf(arg_0 -> Companion.clearConsoleCaches$lambda$1(arg_0 -> Companion.clearConsoleCaches$lambda$0(console, arg_0), arg_0));
            consoleId.remove(console);
        }

        private final Icon getIcon(String fileName) {
            WebConsoleHistoryView webConsoleHistoryView = (WebConsoleHistoryView)iconIdCache.get(fileName);
            return webConsoleHistoryView != null ? webConsoleHistoryView.getCachedIcon$intellij_javascript_debugger(StringsKt.substringAfter$default((String)fileName, (String)"_", null, (int)2, null)) : null;
        }

        private final String getStaticUrl(String staticPath) {
            return "http://localhost:" + BuiltInServerManager.Companion.getInstance().getPort() + ResourcesStaticServer.PREFIX + staticPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendResource(HttpRequest request, Channel channel, ResourceKind kind, String fileName) {
            HttpResponse httpResponse = FileResponses.INSTANCE.prepareSend(request, channel, lastModified, fileName, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            if (httpResponse == null) {
                return;
            }
            HttpResponse response = httpResponse;
            Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)request);
            try {
                InputStream inputStream;
                Class<WebConsoleHistoryView> clazz = WebConsoleHistoryView.class;
                String string = PathUtil.getJarPathForClass(clazz);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJarPathForClass(...)");
                String jarPath = string;
                if (kind == ResourceKind.ICON) {
                    inputStream = this.getIconStream(fileName);
                } else if (kind == ResourceKind.FONT) {
                    inputStream = this.getFontStream(fileName);
                } else if (ApplicationManager.getApplication().isInternal() && !StringsKt.endsWith$default((String)jarPath, (String)".jar", (boolean)false, (int)2, null)) {
                    response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache, must-revalidate");
                    long l = lastModified;
                    lastModified = l + 1L;
                    jarPath = StringsKt.replace$default((String)jarPath, (String)"/out/classes/production/intellij.javascript.debugger", (String)"/plugins/JavaScriptDebugger/source/console/", (boolean)false, (int)4, null);
                    inputStream = Files.newInputStream(Paths.get(jarPath + ResourcesStaticServer.ROOT + fileName, new String[0]), new OpenOption[0]);
                } else {
                    inputStream = clazz.getResourceAsStream(ResourcesStaticServer.ROOT + fileName);
                }
                InputStream resourceAsStream = inputStream;
                Closeable closeable = resourceAsStream;
                Throwable throwable = null;
                try {
                    InputStream resource = (InputStream)closeable;
                    boolean bl = false;
                    if (resource == null) {
                        if (kind == ResourceKind.ICON) {
                            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)request, null, null, (int)12, null);
                        }
                        LOG.error(kind + " " + fileName + " not found, jarPath: " + PathUtil.getJarPathForClass(clazz));
                        return;
                    }
                    channel.write((Object)response);
                    if (request.method() != HttpMethod.HEAD) {
                        channel.writeAndFlush((Object)new ChunkedStream(resource));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException clazz) {
                // empty catch block
            }
            ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private final InputStream getFontStream(String fileName) {
            String jre = System.getProperty("java.home");
            Object[] objectArray = new String[]{"lib/fonts", fileName};
            Path fontPath = Paths.get(jre, (String[])objectArray);
            objectArray = new OpenOption[]{StandardOpenOption.READ};
            return Files.newInputStream(fontPath, (OpenOption[])objectArray);
        }

        private final InputStream getIconStream(String fileName) {
            Icon icon;
            switch (fileName) {
                case "node-expanded.png": {
                    icon = UIUtil.getTreeNodeIcon((boolean)true, (boolean)false, (boolean)false);
                    break;
                }
                case "node-expanded-selected.png": {
                    icon = UIUtil.getTreeNodeIcon((boolean)true, (boolean)true, (boolean)true);
                    break;
                }
                case "node-collapsed.png": {
                    icon = UIUtil.getTreeNodeIcon((boolean)false, (boolean)false, (boolean)false);
                    break;
                }
                case "node-collapsed-selected.png": {
                    icon = UIUtil.getTreeNodeIcon((boolean)false, (boolean)true, (boolean)true);
                    break;
                }
                case "error.png": {
                    icon = UIUtil.getBalloonErrorIcon();
                    break;
                }
                case "warning.png": {
                    icon = UIUtil.getBalloonWarningIcon();
                    break;
                }
                case "info.png": {
                    icon = UIUtil.getBalloonInformationIcon();
                    break;
                }
                case "prompt.png": {
                    icon = AllIcons.Debugger.PromptInputHistory;
                    break;
                }
                case "evaluationResult.png": {
                    icon = AllIcons.Debugger.EvaluationResult;
                    break;
                }
                default: {
                    icon = this.getIcon(fileName);
                    if (icon != null) break;
                    return null;
                }
            }
            Icon icon2 = icon;
            Intrinsics.checkNotNull((Object)icon2);
            Icon icon3 = icon2;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Icon scaledIcon = IconUtil.scaleByFont((Icon)icon3, null, (float)EditorColorsManager.getInstance().getGlobalScheme().getConsoleFontSize());
            BufferedImage bufferedImage = ImageUtil.createImage((ScaleContext)ScaleContext.Companion.create(), (double)scaledIcon.getIconWidth(), (double)scaledIcon.getIconHeight(), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image = bufferedImage;
            scaledIcon.paintIcon(null, image.getGraphics(), 0, 0);
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage((Image)image), StringsKt.substringAfterLast$default((String)fileName, (String)".", null, (int)2, null), output);
            byte[] data = output.toByteArray();
            return new ByteArrayInputStream(data);
        }

        @NotNull
        public final String getMainUrl() {
            return this.getStaticUrl("frontend/console.html?internal=" + ApplicationManager.getApplication().isInternal());
        }

        private static final boolean clearConsoleCaches$lambda$0(WebConsoleHistoryView $console, Map.Entry e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return Intrinsics.areEqual(e.getValue(), (Object)$console);
        }

        private static final boolean clearConsoleCaches$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/console/ResourcesStaticServer$ResourceKind;", "", "<init>", "(Ljava/lang/String;I)V", "FRONTEND_RESOURCE", "ICON", "FONT", "intellij.javascript.debugger"})
    private static final class ResourceKind
    extends Enum<ResourceKind> {
        public static final /* enum */ ResourceKind FRONTEND_RESOURCE = new ResourceKind();
        public static final /* enum */ ResourceKind ICON = new ResourceKind();
        public static final /* enum */ ResourceKind FONT = new ResourceKind();
        private static final /* synthetic */ ResourceKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResourceKind[] values() {
            return (ResourceKind[])$VALUES.clone();
        }

        public static ResourceKind valueOf(String value) {
            return Enum.valueOf(ResourceKind.class, value);
        }

        @NotNull
        public static EnumEntries<ResourceKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resourceKindArray = new ResourceKind[]{ResourceKind.FRONTEND_RESOURCE, ResourceKind.ICON, ResourceKind.FONT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

