/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class Sasl {
    private static List<String> disabledMechanisms = new ArrayList<String>();
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    private static final Logger logger;
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String BOUND_SERVER_NAME = "javax.security.sasl.bound.server.name";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String REUSE = "javax.security.sasl.reuse";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String CREDENTIALS = "javax.security.sasl.credentials";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        SaslClient saslClient = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4 == null) {
                throw new NullPointerException("Mechanism name cannot be null");
            }
            if (string4.length() == 0) continue;
            if (Sasl.isDisabled(string4)) {
                logger.log(Level.FINE, "Disabled " + string4 + " mechanism ignored");
                continue;
            }
            String string5 = "SaslClientFactory." + string4;
            Provider[] providerArray = Security.getProviders(string5);
            for (int j = 0; providerArray != null && j < providerArray.length; ++j) {
                SaslClientFactory saslClientFactory;
                String string6 = providerArray[j].getProperty(string5);
                if (string6 == null || (saslClientFactory = (SaslClientFactory)Sasl.loadFactory(providerArray[j], string6)) == null || (saslClient = saslClientFactory.createSaslClient(new String[]{stringArray[i]}, string, string2, string3, map, callbackHandler)) == null) continue;
                return saslClient;
            }
        }
        return null;
    }

    private static Object loadFactory(Provider provider, String string) throws SaslException {
        try {
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SaslException("Cannot load class " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SaslException("Cannot instantiate class " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SaslException("Cannot access class " + string, illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new SaslException("Cannot access class " + string, securityException);
        }
    }

    public static SaslServer createSaslServer(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        SaslServer saslServer = null;
        if (string == null) {
            throw new NullPointerException("Mechanism name cannot be null");
        }
        if (string.length() == 0) {
            return null;
        }
        if (Sasl.isDisabled(string)) {
            logger.log(Level.FINE, "Disabled " + string + " mechanism ignored");
            return null;
        }
        String string4 = "SaslServerFactory." + string;
        Provider[] providerArray = Security.getProviders(string4);
        for (int i = 0; providerArray != null && i < providerArray.length; ++i) {
            String string5 = providerArray[i].getProperty(string4);
            if (string5 == null) {
                throw new SaslException("Provider does not support " + string4);
            }
            SaslServerFactory saslServerFactory = (SaslServerFactory)Sasl.loadFactory(providerArray[i], string5);
            if (saslServerFactory == null || (saslServer = saslServerFactory.createSaslServer(string, string2, string3, map, callbackHandler)) == null) continue;
            return saslServer;
        }
        return null;
    }

    public static Enumeration<SaslClientFactory> getSaslClientFactories() {
        Set<Object> set = Sasl.getFactories("SaslClientFactory");
        final Iterator<Object> iterator = set.iterator();
        return new Enumeration<SaslClientFactory>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public SaslClientFactory nextElement() {
                return (SaslClientFactory)iterator.next();
            }
        };
    }

    public static Enumeration<SaslServerFactory> getSaslServerFactories() {
        Set<Object> set = Sasl.getFactories("SaslServerFactory");
        final Iterator<Object> iterator = set.iterator();
        return new Enumeration<SaslServerFactory>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public SaslServerFactory nextElement() {
                return (SaslServerFactory)iterator.next();
            }
        };
    }

    private static Set<Object> getFactories(String string) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (string == null || string.length() == 0 || string.endsWith(".")) {
            return hashSet;
        }
        Provider[] providerArray = Security.getProviders();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < providerArray.length; ++i) {
            hashSet2.clear();
            Enumeration<Object> enumeration = providerArray[i].keys();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (!string3.startsWith(string) || string3.indexOf(" ") >= 0 || hashSet2.contains(string2 = providerArray[i].getProperty(string3))) continue;
                hashSet2.add(string2);
                try {
                    Object object = Sasl.loadFactory(providerArray[i], string2);
                    if (object == null) continue;
                    hashSet.add(object);
                }
                catch (Exception exception) {}
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static boolean isDisabled(String string) {
        return disabledMechanisms.contains(string);
    }

    static {
        String string = AccessController.doPrivileged(() -> Security.getProperty("jdk.sasl.disabledMechanisms"));
        if (string != null) {
            for (String string2 : string.split("\\s*,\\s*")) {
                if (string2.isEmpty()) continue;
                disabledMechanisms.add(string2);
            }
        }
        logger = Logger.getLogger(SASL_LOGGER_NAME);
    }
}

