%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM3":  ["0xFFFFFFFFFFFFFFFF", "0x00000000FFFF0000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0xFFFFFFFFFFFFFFFF", "0x12348000FFFF0000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0xFFFFFFFFFFFFFFFF", "0x00000000FFFF0000", "0xFFFFFFFFFFFFFFFF", "0x00000000FFFF0000"],
    "XMM6":  ["0xFFFFFFFFFFFFFFFF", "0x12348000FFFF0000", "0xFFFFFFFFFFFFFFFF", "0x12348000FFFF0000"],
    "XMM7":  ["0xFFFFFFFFFFFFFFFF", "0x00000000FFFF0000", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0xFFFFFFFFFFFFFFFF", "0x12348000FFFF0000", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0xFFFFFFFFFFFFFFFF", "0x00000000FFFF0000", "0xFFFFFFFFFFFFFFFF", "0x00000000FFFF0000"],
    "XMM10": ["0xFFFFFFFFFFFFFFFF", "0x12348000FFFF0000", "0xFFFFFFFFFFFFFFFF", "0x12348000FFFF0000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]

vpackusdw xmm3, xmm0, [rdx + 32 * 1]
vpackusdw xmm4, xmm0, [rdx + 32 * 2]

vpackusdw ymm5, ymm0, [rdx + 32 * 1]
vpackusdw ymm6, ymm0, [rdx + 32 * 2]

vpackusdw xmm7, xmm0, xmm1
vpackusdw xmm8, xmm0, xmm2

vpackusdw ymm9, ymm0, ymm1
vpackusdw ymm10, ymm0, ymm2

hlt

align 32
.data:
dq 0x4142434445464748
dq 0x5152535455565758
dq 0x4142434445464748
dq 0x5152535455565758

dq 0x7FFFFFFF00000000
dq 0xFFFFFFFF80000000
dq 0x7FFFFFFF00000000
dq 0xFFFFFFFF80000000

; Values that actually fit in to 16bit unsigned
dq 0x0000FFFF00000000
dq 0x0000123400008000
dq 0x0000FFFF00000000
dq 0x0000123400008000
