/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.GraphPrintElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementPresentationManager;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 12\u00020\u0001:\u00011B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eB/\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\r\u0010\u0012J\b\u0010\u001d\u001a\u00020\nH\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\n\u0010!\u001a\u00060\nj\u0002`\"H\u0016J*\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010\n0$2\n\u0010&\u001a\u00060\nj\u0002`\"2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u001e\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020%2\n\u0010!\u001a\u00060\nj\u0002`\"H\u0002J\u001e\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020,2\n\u0010!\u001a\u00060\nj\u0002`\"H\u0002J\u001c\u0010-\u001a\u00020\u00112\u0006\u0010*\u001a\u00020%2\n\u0010&\u001a\u00060\nj\u0002`\"H\u0002J\u001c\u0010-\u001a\u00020\u00112\u0006\u0010+\u001a\u00020,2\n\u0010&\u001a\u00060\nj\u0002`\"H\u0002J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\n\u0010!\u001a\u00060\nj\u0002`\"H\u0002J\u001c\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020,2\n\u0010!\u001a\u00060\nj\u0002`\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl;", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementGenerator;", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "presentationManager", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;", "elementComparator", "Ljava/util/Comparator;", "Lcom/intellij/vcs/log/graph/api/elements/GraphElement;", "longEdgeSize", "", "visiblePartSize", "edgeWithArrowSize", "<init>", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;Ljava/util/Comparator;III)V", "graph", "showLongEdges", "", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;ZLjava/util/Comparator;)V", "cache", "Lcom/intellij/util/containers/SLRUMap;", "", "edgesInRowGenerator", "Lcom/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator;", "recommendedWidth", "getRecommendedWidth", "()I", "recommendedWidth$delegate", "Lkotlin/Lazy;", "calculateRecommendedWidth", "getPrintElements", "", "Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "rowIndex", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "createEndPositionFunction", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "visibleRowIndex", "up", "getArrowType", "Lcom/intellij/vcs/log/graph/EdgePrintElement$Type;", "edge", "normalEdge", "Lcom/intellij/vcs/log/graph/utils/NormalEdge;", "isEdgeVisibleInRow", "getSortedVisibleElementsInRow", "getAttachmentDistance", "e1", "Companion", "intellij.platform.vcs.log.graph.impl"})
@SourceDebugExtension(value={"SMAP\nPrintElementGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrintElementGeneratorImpl.kt\ncom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1878#2,2:285\n1869#2,2:287\n1880#2:289\n1878#2,3:290\n865#2,2:293\n865#2,2:295\n865#2,2:297\n*S KotlinDebug\n*F\n+ 1 PrintElementGeneratorImpl.kt\ncom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl\n*L\n131#1:285,2\n136#1:287,2\n131#1:289\n178#1:290,3\n252#1:293,2\n255#1:295,2\n259#1:297,2\n*E\n"})
public final class PrintElementGeneratorImpl
implements PrintElementGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinearGraph linearGraph;
    @NotNull
    private final PrintElementPresentationManager presentationManager;
    @NotNull
    private final Comparator<GraphElement> elementComparator;
    private final int longEdgeSize;
    private final int visiblePartSize;
    private final int edgeWithArrowSize;
    @NotNull
    private final SLRUMap<Integer, List<GraphElement>> cache;
    @NotNull
    private final EdgesInRowGenerator edgesInRowGenerator;
    @NotNull
    private final Lazy recommendedWidth$delegate;
    @NotNull
    private static final Logger LOG;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    public static final int LONG_EDGE_SIZE = 30;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int CACHE_SIZE = 100;
    private static final int SAMPLE_SIZE = 20000;
    private static final double K = 0.1;

    @VisibleForTesting
    public PrintElementGeneratorImpl(@NotNull LinearGraph linearGraph, @NotNull PrintElementPresentationManager presentationManager, @NotNull Comparator<GraphElement> elementComparator, int longEdgeSize, int visiblePartSize, int edgeWithArrowSize) {
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        Intrinsics.checkNotNullParameter((Object)presentationManager, (String)"presentationManager");
        Intrinsics.checkNotNullParameter(elementComparator, (String)"elementComparator");
        this.linearGraph = linearGraph;
        this.presentationManager = presentationManager;
        this.elementComparator = elementComparator;
        this.longEdgeSize = longEdgeSize;
        this.visiblePartSize = visiblePartSize;
        this.edgeWithArrowSize = edgeWithArrowSize;
        this.cache = new SLRUMap(100, 200);
        this.edgesInRowGenerator = new EdgesInRowGenerator(this.linearGraph);
        this.recommendedWidth$delegate = LazyKt.lazy(() -> PrintElementGeneratorImpl.recommendedWidth_delegate$lambda$0(this));
    }

    public final int getRecommendedWidth() {
        Lazy lazy = this.recommendedWidth$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementPresentationManager presentationManager, boolean showLongEdges, @NotNull Comparator<GraphElement> elementComparator) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)presentationManager, (String)"presentationManager");
        Intrinsics.checkNotNullParameter(elementComparator, (String)"elementComparator");
        this(graph, presentationManager, elementComparator, showLongEdges ? 1000 : 30, showLongEdges ? 250 : 1, showLongEdges ? 30 : Integer.MAX_VALUE);
    }

    private final int calculateRecommendedWidth() {
        int nodesCount = this.linearGraph.nodesCount();
        if (nodesCount == 0) {
            return 0;
        }
        if (nodesCount == 1) {
            return 1;
        }
        int n = Math.min(20000, nodesCount);
        double sum = 0.0;
        double sumSquares = 0.0;
        int edgesCount = 0;
        Set set = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        Set currentNormalEdges = set;
        for (int i = 0; i < n; ++i) {
            List<GraphEdge> adjacentEdges = this.linearGraph.getAdjacentEdges(i, EdgeFilter.ALL);
            int upArrows = 0;
            int downArrows = 0;
            for (GraphEdge graphEdge : adjacentEdges) {
                NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(graphEdge);
                if (normalEdge != null) {
                    boolean bl = LinearGraphUtils.isEdgeUp(graphEdge, i) ? currentNormalEdges.remove(normalEdge) : currentNormalEdges.add(normalEdge);
                    continue;
                }
                int n2 = graphEdge.getType() == GraphEdgeType.DOTTED_ARROW_UP ? upArrows++ : downArrows++;
            }
            int newEdgesCount = 0;
            for (NormalEdge e3 : currentNormalEdges) {
                Intrinsics.checkNotNull((Object)e3);
                if (this.isEdgeVisibleInRow(e3, i)) {
                    ++newEdgesCount;
                    continue;
                }
                EdgePrintElement.Type arrow = this.getArrowType(e3, i);
                if (arrow == EdgePrintElement.Type.DOWN) {
                    ++downArrows;
                    continue;
                }
                if (arrow != EdgePrintElement.Type.UP) continue;
                ++upArrows;
            }
            int n3 = Math.max(edgesCount + upArrows, newEdgesCount + downArrows);
            double weight = (double)2 / ((double)n * 1.1) * (1.0 + -0.9 * (double)i / (double)(n - 1));
            sum += (double)n3 * weight;
            sumSquares += (double)n3 * (double)n3 * weight;
            edgesCount = newEdgesCount;
        }
        double average = sum;
        double deviation = Math.sqrt(sumSquares - average * average);
        return (int)Math.round(average + deviation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<GraphPrintElement> getPrintElements(int rowIndex) {
        List result = new ArrayList();
        List nodes = new ArrayList();
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        Function1<GraphEdge, Integer> upPosition = this.createEndPositionFunction(rowIndex - 1, true);
        Function1<GraphEdge, Integer> downPosition = this.createEndPositionFunction(rowIndex + 1, false);
        Iterable $this$forEachIndexed$iv = visibleElements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphElement graphElement = (GraphElement)item$iv;
            int position = n;
            boolean bl = false;
            void var16_16 = element;
            if (var16_16 instanceof GraphNode) {
                int nodeIndex = ((GraphNode)element).getNodeIndex();
                nodes.add(new SimplePrintElementImpl(rowIndex, position, (GraphElement)element, this.presentationManager));
                Iterable $this$forEach$iv = this.linearGraph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GraphEdge edge = (GraphEdge)element$iv;
                    boolean bl2 = false;
                    EdgePrintElement.Type arrowType = this.getArrowType(edge, rowIndex);
                    Integer down = (Integer)downPosition.invoke((Object)edge);
                    Integer up = (Integer)upPosition.invoke((Object)edge);
                    if (down != null) {
                        result.add(new EdgePrintElementImpl(rowIndex, position, down, EdgePrintElement.Type.DOWN, edge, arrowType == EdgePrintElement.Type.DOWN, this.presentationManager));
                    }
                    if (up == null) continue;
                    result.add(new EdgePrintElementImpl(rowIndex, position, up, EdgePrintElement.Type.UP, edge, arrowType == EdgePrintElement.Type.UP, this.presentationManager));
                }
                continue;
            }
            if (!(var16_16 instanceof GraphEdge)) continue;
            Integer down = (Integer)downPosition.invoke((Object)element);
            Integer up = (Integer)upPosition.invoke((Object)element);
            EdgePrintElement.Type arrowType = this.getArrowType((GraphEdge)element, rowIndex);
            if (down != null) {
                result.add(new EdgePrintElementImpl(rowIndex, position, down, EdgePrintElement.Type.DOWN, (GraphEdge)element, arrowType == EdgePrintElement.Type.DOWN, this.presentationManager));
            } else if (arrowType == EdgePrintElement.Type.DOWN) {
                result.add(new TerminalEdgePrintElement(rowIndex, position, EdgePrintElement.Type.DOWN, (GraphEdge)element, this.presentationManager));
            }
            if (up != null) {
                result.add(new EdgePrintElementImpl(rowIndex, position, up, EdgePrintElement.Type.UP, (GraphEdge)element, arrowType == EdgePrintElement.Type.UP, this.presentationManager));
                continue;
            }
            if (arrowType != EdgePrintElement.Type.UP) continue;
            result.add(new TerminalEdgePrintElement(rowIndex, position, EdgePrintElement.Type.UP, (GraphEdge)element, this.presentationManager));
        }
        result.addAll(nodes);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex, boolean up) {
        if (visibleRowIndex < 0 || visibleRowIndex >= this.linearGraph.nodesCount()) {
            return createEndPositionFunction.1.INSTANCE;
        }
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex);
        HashMap toPosition = new HashMap(visibleElementsInNextRow.size());
        Iterable $this$forEachIndexed$iv = visibleElementsInNextRow;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphElement graphElement = (GraphElement)item$iv;
            int position = n;
            boolean bl = false;
            ((Map)toPosition).put(element, position);
        }
        return arg_0 -> PrintElementGeneratorImpl.createEndPositionFunction$lambda$5(toPosition, this, up, arg_0);
    }

    private final EdgePrintElement.Type getArrowType(GraphEdge edge, int rowIndex) {
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge != null) {
            return this.getArrowType(normalEdge, rowIndex);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[edge.getType().ordinal()]) {
            case 1: 
            case 2: {
                if (!LinearGraphUtils.intEqual(edge.getUpNodeIndex(), rowIndex - 1)) break;
                return EdgePrintElement.Type.DOWN;
            }
            case 3: {
                if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), rowIndex + 1)) break;
                return EdgePrintElement.Type.UP;
            }
            default: {
                LOG.error("Unknown special edge type " + edge.getType() + " at row " + rowIndex);
            }
        }
        return null;
    }

    private final EdgePrintElement.Type getArrowType(NormalEdge normalEdge, int rowIndex) {
        int edgeSize = normalEdge.down - normalEdge.up;
        int upOffset = rowIndex - normalEdge.up;
        int downOffset = normalEdge.down - rowIndex;
        if (edgeSize >= this.longEdgeSize) {
            if (upOffset == this.visiblePartSize) {
                LOG.assertTrue(downOffset != this.visiblePartSize, (Object)("Both up and down arrow at row " + rowIndex));
                return EdgePrintElement.Type.DOWN;
            }
            if (downOffset == this.visiblePartSize) {
                return EdgePrintElement.Type.UP;
            }
        }
        if (edgeSize >= this.edgeWithArrowSize) {
            if (upOffset == 1) {
                LOG.assertTrue(downOffset != 1, (Object)("Both up and down arrow at row " + rowIndex));
                return EdgePrintElement.Type.DOWN;
            }
            if (downOffset == 1) {
                return EdgePrintElement.Type.UP;
            }
        }
        return null;
    }

    private final boolean isEdgeVisibleInRow(GraphEdge edge, int visibleRowIndex) {
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return false;
        }
        NormalEdge normalEdge2 = normalEdge;
        return this.isEdgeVisibleInRow(normalEdge2, visibleRowIndex);
    }

    private final boolean isEdgeVisibleInRow(NormalEdge normalEdge, int visibleRowIndex) {
        return normalEdge.down - normalEdge.up < this.longEdgeSize || this.getAttachmentDistance(normalEdge, visibleRowIndex) <= this.visiblePartSize;
    }

    private final List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        GraphEdge it;
        Iterable $this$filterTo$iv;
        List graphElements = (List)this.cache.get((Object)rowIndex);
        if (graphElements != null) {
            return graphElements;
        }
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        result.add(this.linearGraph.getGraphNode(rowIndex));
        Set<GraphEdge> set = this.edgesInRowGenerator.getEdgesInRow(rowIndex);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getEdgesInRow(...)");
        Iterable iterable = set;
        Collection destination$iv = result;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (GraphEdge)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isEdgeVisibleInRow(it, rowIndex)) continue;
            destination$iv.add(element$iv);
        }
        if (rowIndex > 0) {
            $this$filterTo$iv = this.linearGraph.getAdjacentEdges(rowIndex - 1, EdgeFilter.SPECIAL);
            destination$iv = result;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (GraphEdge)element$iv;
                boolean bl = false;
                if (!LinearGraphUtils.isEdgeDown(it, rowIndex - 1)) continue;
                destination$iv.add(element$iv);
            }
        }
        if (rowIndex < this.linearGraph.nodesCount() - 1) {
            $this$filterTo$iv = this.linearGraph.getAdjacentEdges(rowIndex + 1, EdgeFilter.SPECIAL);
            destination$iv = result;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (GraphEdge)element$iv;
                boolean bl = false;
                if (!LinearGraphUtils.isEdgeUp(it, rowIndex + 1)) continue;
                destination$iv.add(element$iv);
            }
        }
        Collections.sort((List)result, this.elementComparator);
        this.cache.put((Object)rowIndex, result);
        return result;
    }

    private final int getAttachmentDistance(NormalEdge e1, int rowIndex) {
        return Math.min(rowIndex - e1.up, e1.down - rowIndex);
    }

    private static final int recommendedWidth_delegate$lambda$0(PrintElementGeneratorImpl this$0) {
        return this$0.calculateRecommendedWidth();
    }

    private static final Integer createEndPositionFunction$lambda$5(HashMap $toPosition, PrintElementGeneratorImpl this$0, boolean $up, GraphEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        Integer n = (Integer)$toPosition.get(edge);
        if (n == null) {
            Integer nodeIndex;
            PrintElementGeneratorImpl $this$createEndPositionFunction_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            Integer n2 = nodeIndex = $up ? edge.getUpNodeIndex() : edge.getDownNodeIndex();
            n = nodeIndex != null ? (Integer)$toPosition.get($this$createEndPositionFunction_u24lambda_u245_u24lambda_u244.linearGraph.getGraphNode(nodeIndex)) : null;
        }
        return n;
    }

    static {
        Logger logger = Logger.getInstance(PrintElementGeneratorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "VERY_LONG_EDGE_SIZE", "", "LONG_EDGE_SIZE", "VERY_LONG_EDGE_PART_SIZE", "LONG_EDGE_PART_SIZE", "CACHE_SIZE", "SAMPLE_SIZE", "K", "", "intellij.platform.vcs.log.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GraphEdgeType.values().length];
            try {
                nArray[GraphEdgeType.DOTTED_ARROW_DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphEdgeType.NOT_LOAD_COMMIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphEdgeType.DOTTED_ARROW_UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

