/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.system.OS;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DeviceIdManager {
    private static final Logger LOG = Logger.getInstance(DeviceIdManager.class);
    private static final String PREFERENCE_KEY = "device_id";
    private static final String SHARED_FILE_NAME = "PermanentDeviceId";

    @NotNull
    public static String getOrGenerateId(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        if (recorderId == null) {
            DeviceIdManager.$$$reportNull$$$0(0);
        }
        DeviceIdManager.assertAllowed(token, recorderId);
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences preferences = DeviceIdManager.getPreferences(appInfo);
        String preferenceKey = DeviceIdManager.getPreferenceKey(recorderId);
        String deviceId = preferences.get(preferenceKey, "");
        if (deviceId.isBlank()) {
            deviceId = DeviceIdManager.generateId(LocalDate.now(), DeviceIdManager.getOsCode());
            preferences.put(preferenceKey, deviceId);
            LOG.info("Generating new Device ID for '" + recorderId + "'");
        }
        if (appInfo.isVendorJetBrains() && OS.CURRENT == OS.Windows) {
            if (DeviceIdManager.isBaseRecorder(recorderId)) {
                deviceId = DeviceIdManager.syncWithSharedFile(SHARED_FILE_NAME, deviceId, preferences, preferenceKey);
            } else {
                DeviceIdManager.deleteLegacySharedFile(recorderId + "_PermanentDeviceId");
            }
        }
        String string = deviceId;
        if (string == null) {
            DeviceIdManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void assertAllowed(@Nullable DeviceIdToken token, String recorderId) throws InvalidDeviceIdTokenException {
        if (DeviceIdManager.isBaseRecorder(recorderId)) {
            if (token == null) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from unknown class");
            }
            if (!PluginManagerCoreKt.isPlatformOrJetBrainsBundled(token.getClass())) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from " + token.getClass().getName());
            }
        } else if (!DeviceIdManager.isUndefinedRecorder(recorderId) && token == null) {
            throw new InvalidDeviceIdTokenException("Cannot access device id from unknown class");
        }
    }

    private static String getPreferenceKey(String recorderId) {
        return DeviceIdManager.isBaseRecorder(recorderId) ? PREFERENCE_KEY : recorderId.toLowerCase(Locale.ROOT) + "_device_id";
    }

    private static boolean isBaseRecorder(String recorderId) {
        return "FUS".equals(recorderId);
    }

    private static boolean isUndefinedRecorder(String recorderId) {
        return "UNDEFINED".equals(recorderId);
    }

    private static String syncWithSharedFile(String fileName, String installationId, Preferences preferences, String prefKey) {
        String appdata = System.getenv("APPDATA");
        if (appdata != null) {
            try {
                Path permanentIdFile = Path.of(appdata, "JetBrains", fileName);
                try {
                    byte[] bytes = Files.readAllBytes(permanentIdFile);
                    int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
                    String fromFile = Strings.trimEnd((String)new String(bytes, offset, bytes.length - offset, StandardCharsets.UTF_8), (char)'\u0000');
                    if (!fromFile.equals(installationId) && DeviceIdManager.isValid(fromFile)) {
                        preferences.put(prefKey, fromFile);
                        return fromFile;
                    }
                }
                catch (IllegalArgumentException | NoSuchFileException exception) {
                    // empty catch block
                }
                Files.createDirectories(permanentIdFile.getParent(), new FileAttribute[0]);
                Files.writeString(permanentIdFile, (CharSequence)installationId, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return installationId;
    }

    private static boolean isValid(String id) {
        return id.length() >= 30 && id.length() <= 50 && id.chars().allMatch(c -> c == 45 || Character.isLetterOrDigit(c));
    }

    private static void deleteLegacySharedFile(String fileName) {
        String appdata = System.getenv("APPDATA");
        if (appdata != null) {
            try {
                Files.deleteIfExists(Path.of(appdata, "JetBrains", fileName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Preferences getPreferences(ApplicationInfoEx appInfo) {
        String companyName = appInfo.getShortCompanyName();
        String nodeName = companyName == null || companyName.isBlank() ? "jetbrains" : companyName.toLowerCase(Locale.ROOT);
        return Preferences.userRoot().node(nodeName);
    }

    @VisibleForTesting
    @NotNull
    public static String generateId(@NotNull LocalDate date, char osCode) {
        if (date == null) {
            DeviceIdManager.$$$reportNull$$$0(2);
        }
        LocalDate coercedDate = date.withYear(Math.min(Math.max(date.getYear(), 2000), 2099));
        String string = coercedDate.format(DateTimeFormatter.ofPattern("ddMMyy")) + osCode + String.valueOf(UUID.randomUUID());
        if (string == null) {
            DeviceIdManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static char getOsCode() {
        return switch (OS.CURRENT) {
            case OS.Windows -> '1';
            case OS.macOS -> '2';
            case OS.Linux -> '3';
            default -> '0';
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/DeviceIdManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/DeviceIdManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrGenerateId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrGenerateId";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public static interface DeviceIdToken {
    }

    public static class InvalidDeviceIdTokenException
    extends Exception {
        private InvalidDeviceIdTokenException(String message) {
            super(message);
        }
    }
}

