/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.util.ColorFilter;
import com.intellij.util.IconUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorFilterModel;
import com.jetbrains.rd.ide.model.CustomImageIconModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.ide.model.ImageIconModelId;
import com.jetbrains.rd.ide.model.ImageIconSources;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverterKt;
import com.jetbrains.rd.ui.icons.converters.ProtocolImageDataLoader;
import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Ljavax/swing/Icon;", "Lcom/jetbrains/rd/ide/model/IconModel;", "<init>", "()V", "loadIconSourcesIfNeeded", "", "model", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "icon", "Lcom/intellij/ui/icons/CachedImageIcon;", "loader", "Lcom/jetbrains/rd/ui/icons/converters/ProtocolImageDataLoader;", "cacheIconModelIfNeeded", "createIcon", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createIconForCache", "iconModel", "localIcon", "createModel", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public abstract class ImageIconConverter
implements ProtocolIconConverter<Icon, IconModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void loadIconSourcesIfNeeded(@NotNull ImageIconModel model, @NotNull CachedImageIcon icon, @NotNull ProtocolImageDataLoader loader) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
    }

    protected void cacheIconModelIfNeeded(@NotNull ImageIconModel model, @NotNull CachedImageIcon icon) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
    }

    @Nullable
    public Icon createIcon(@NotNull IconModel model, @NotNull ProtocolIconRegistry registry) {
        Icon unscaledIcon;
        ImageIconModel imageIconModel;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel iconModel = model;
        if (iconModel instanceof ImageIconModel) {
            imageIconModel = (ImageIconModel)model;
        } else if (iconModel instanceof CustomImageIconModel) {
            imageIconModel = ((CustomImageIconModel)model).getModel();
        } else {
            return null;
        }
        ImageIconModel iconModel2 = imageIconModel;
        Icon localIcon = Companion.findLocalIcon(iconModel2.getId());
        if (!(localIcon instanceof CachedImageIcon)) {
            return localIcon;
        }
        Icon result = unscaledIcon = registry.cacheIcon(iconModel2.getId().getIdentity(), arg_0 -> ImageIconConverter.createIcon$lambda$0(this, iconModel2, localIcon, arg_0));
        if (model instanceof CustomImageIconModel) {
            ColorFilterModel colorFilter;
            Float scale = ((CustomImageIconModel)model).getInitialScale();
            if (scale != null && result instanceof CachedImageIcon) {
                result = (Icon)((CachedImageIcon)result).scale(scale.floatValue());
            }
            if ((colorFilter = ((CustomImageIconModel)model).getColorFilter()) != null) {
                result = IconUtil.colorize$default((Icon)result, (Color)ColorHostKt.toColor((AbstractColor)colorFilter.getColor()), (boolean)colorFilter.getKeepGray(), (boolean)false, (int)8, null);
            }
        }
        return result;
    }

    private final CachedImageIcon createIconForCache(ImageIconModel iconModel, CachedImageIcon localIcon) {
        ProtocolImageDataLoader protocolLoader = new ProtocolImageDataLoader(iconModel.getId(), new AtomicReference<ImageIconSources>(iconModel.getImageSources()), localIcon.getOriginalLoader(), iconModel.getWidth(), iconModel.getHeight());
        CachedImageIcon icon = new CachedImageIcon((ImageDataLoader)protocolLoader);
        if (iconModel.getImageSources() == null) {
            this.loadIconSourcesIfNeeded(iconModel, icon, protocolLoader);
        }
        return icon;
    }

    @Nullable
    public IconModel createModel(@NotNull Icon icon, @NotNull ProtocolIconModelRegistry registry) {
        ColorFilterModel filterModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (!(icon instanceof CachedImageIcon)) {
            return null;
        }
        Ref.BooleanRef newModelCreated = new Ref.BooleanRef();
        IconModel model = registry.cacheModel(icon, arg_0 -> ImageIconConverter.createModel$lambda$1(newModelCreated, icon, arg_0));
        if (!(model instanceof ImageIconModel)) {
            return null;
        }
        if (registry.getForceLightModel() && ((ImageIconModel)model).getImageSources() != null) {
            model = (IconModel)new ImageIconModel(((ImageIconModel)model).getId(), ((ImageIconModel)model).getWidth(), ((ImageIconModel)model).getHeight(), null);
        }
        if (newModelCreated.element && ((ImageIconModel)model).getImageSources() == null) {
            this.cacheIconModelIfNeeded((ImageIconModel)model, (CachedImageIcon)icon);
        }
        Double scale = ((CachedImageIcon)icon).getObjScale();
        RgbImageFilterSupplier rgbImageFilterSupplier = ((CachedImageIcon)icon).getLocalFilterSupplier();
        RGBImageFilter rGBImageFilter = rgbImageFilterSupplier != null ? rgbImageFilterSupplier.getFilter() : null;
        ColorFilter colorFilter = rGBImageFilter instanceof ColorFilter ? (ColorFilter)rGBImageFilter : null;
        if (colorFilter != null) {
            ColorFilter it = colorFilter;
            boolean bl = false;
            v2 = new ColorFilterModel(ColorHostKt.toModel((Color)it.getColor()), it.getKeepGray());
        } else {
            v2 = filterModel = null;
        }
        if (scale != null || filterModel != null) {
            Double d = scale;
            return (IconModel)new CustomImageIconModel((ImageIconModel)model, d != null ? Float.valueOf((float)d.doubleValue()) : null, filterModel);
        }
        return model;
    }

    private static final Icon createIcon$lambda$0(ImageIconConverter this$0, ImageIconModel $iconModel, Icon $localIcon, long it) {
        return (Icon)this$0.createIconForCache($iconModel, (CachedImageIcon)$localIcon);
    }

    private static final IconModel createModel$lambda$1(Ref.BooleanRef $newModelCreated, Icon $icon, long identity) {
        $newModelCreated.element = true;
        return (IconModel)ImageIconConverter.Companion.createImageModel(identity, (CachedImageIcon)$icon);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter$Companion;", "", "<init>", "()V", "createImageModel", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "identity", "", "icon", "Lcom/intellij/ui/icons/CachedImageIcon;", "createImageSources", "Lcom/jetbrains/rd/ide/model/ImageIconSources;", "findLocalIcon", "Ljavax/swing/Icon;", "modelId", "Lcom/jetbrains/rd/ide/model/ImageIconModelId;", "intellij.rd.ui"})
    @SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n68#2,4:189\n68#2,4:194\n1#3:193\n1#3:208\n1617#4,9:198\n1869#4:207\n1870#4:209\n1626#4:210\n*S KotlinDebug\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter$Companion\n*L\n114#1:189,4\n149#1:194,4\n152#1:208\n152#1:198,9\n152#1:207\n152#1:209\n152#1:210\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ImageIconModel createImageModel(long identity, CachedImageIcon icon) {
            Pair coords = icon.getOriginalLoader().getCoords();
            if (coords != null) {
                String coordsPath = (String)coords.component1();
                ClassLoader classLoader = (ClassLoader)coords.component2();
                Pair pair = IconManager.Companion.getInstance().getPluginAndModuleId(classLoader);
                String pluginId = (String)pair.component1();
                String moduleId = (String)pair.component2();
                String string = icon.getExpUIPath();
                if (string == null && (string = icon.getOriginalPath()) == null) {
                    string = coordsPath;
                }
                String originalPath = string;
                boolean preloadSources = !Intrinsics.areEqual((Object)pluginId, (Object)"com.intellij") && !ImageIconConverterKt.access$getFRONTEND_PLUGINS_WITH_ICONS$p().contains(pluginId);
                ImageIconSources imageSources = preloadSources ? this.createImageSources(identity, icon) : null;
                Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("creating model for: path=" + originalPath + ", pluginId=" + pluginId + ", moduleId=" + moduleId + ", hasSources: " + (imageSources != null));
                }
                ImageIconModelId modelId = new ImageIconModelId(identity, originalPath, pluginId, moduleId);
                return new ImageIconModel(modelId, icon.getIconWidth(), icon.getIconHeight(), imageSources);
            }
            ImageIconSources imageSources = this.createImageSources(identity, icon);
            String string = icon.getExpUIPath();
            if (string == null && (string = icon.getOriginalPath()) == null) {
                string = imageSources.getOriginalPath();
            }
            String originalPath = string;
            URL uRL = icon.getUrl();
            ImageIconConverterKt.access$getLogger$p().warn("creating model without coords: originalPath=" + originalPath + ", icon.url.path=" + (uRL != null ? uRL.getPath() : null));
            ImageIconModelId id = new ImageIconModelId(identity, originalPath, null, null);
            return new ImageIconModel(id, icon.getIconWidth(), icon.getIconHeight(), imageSources);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ImageIconSources createImageSources(long identity, @NotNull CachedImageIcon icon) {
            List sources;
            CharSequence charSequence;
            String originalPath;
            Object object;
            URL url;
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            URL uRL = url = icon.getUrl();
            String effectivePath = uRL != null ? uRL.getPath() : null;
            String string = icon.getExpUIPath();
            if (string == null && (string = icon.getOriginalPath()) == null) {
                Companion $this$createImageSources_u24lambda_u241 = this;
                boolean bl = false;
                String string2 = effectivePath;
                if (string2 == null) {
                    string2 = "protocol_icon_no_path.svg";
                }
                String url2 = string2;
                ImageIconConverterKt.access$getLogger$p().warn("originalPath is null, using " + url2 + " as a fallback");
                string = url2;
            }
            if ((object = URLUtil.splitJarUrl((String)(originalPath = string))) == null || (object = (String)object.second) == null) {
                object = originalPath;
            }
            Object path = object;
            String string3 = FileUtilRt.getNameWithoutExtension((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(...)");
            String name = string3;
            CharSequence bl = FileUtilRt.getExtension((String)path);
            if (StringsKt.isBlank((CharSequence)bl)) {
                boolean bl2 = false;
                charSequence = "svg";
            } else {
                charSequence = bl;
            }
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifBlank(...)");
            String ext = (String)charSequence;
            if (effectivePath != null) {
                void $this$mapNotNullTo$iv$iv;
                String effectiveExtension = StringsKt.substringAfterLast$default((String)effectivePath, (String)".", null, (int)2, null);
                String effectiveName = StringsKt.substringBeforeLast$default((String)effectivePath, (String)".", null, (int)2, null);
                Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl3 = false;
                    logger.trace("loading sources for: path=" + (String)path + ", name=" + name + ", ext=" + ext + ", effectivePath=" + effectivePath);
                }
                Iterable $this$mapNotNull$iv = ImageDescriptorKt.createCommonImagePathTransforms((String)path);
                boolean $i$f$mapNotNull = false;
                Iterable bl3 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    IconSource it$iv$iv;
                    IconSource iconSource;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl4 = false;
                    Function2 pathTransform = (Function2)element$iv$iv;
                    boolean bl5 = false;
                    String transformedPath = (String)pathTransform.invoke((Object)effectiveName, (Object)effectiveExtension);
                    String sourceId = (String)pathTransform.invoke((Object)name, (Object)ext);
                    URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), transformedPath);
                    try {
                        byte[] bytes = TextStreamsKt.readBytes((URL)newUrl);
                        iconSource = new IconSource(sourceId, bytes);
                    }
                    catch (IOException e) {
                        ImageIconConverterKt.access$getLogger$p().trace((Throwable)e);
                        iconSource = null;
                    }
                    if (iconSource == null) continue;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                v6 = (List)destination$iv$iv;
            } else {
                v6 = sources = CollectionsKt.emptyList();
            }
            if (sources.isEmpty()) {
                ImageIconConverterKt.access$getLogger$p().error("Failed to read icon: '" + (String)path + "': " + url + ", " + icon.getOriginalLoader().getCoords());
            }
            int n = icon.getImageFlags();
            return new ImageIconSources(identity, (String)path, sources, n);
        }

        @NotNull
        public final Icon findLocalIcon(@NotNull ImageIconModelId modelId) {
            Object object;
            IconManager iconManager;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
                    iconManager = IconManager.Companion.getInstance();
                    object = modelId.getPlugin();
                    if (object == null) break block2;
                    String plugin = object;
                    boolean bl = false;
                    ClassLoader classLoader = iconManager.getClassLoader(plugin, modelId.getModule());
                    object = classLoader;
                    if (classLoader != null) break block3;
                }
                object = AllIcons.class.getClassLoader();
            }
            Object classLoader = object;
            String string = modelId.getPath();
            Intrinsics.checkNotNull((Object)classLoader);
            return iconManager.getIcon(string, (ClassLoader)classLoader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

