/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.inspections.CssInvalidCustomPropertyAtRuleDeclarationUtils;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/psi/css/inspections/fixes/CssAddRequiredPropertiesForCustomPropertyAtRuleFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.css.analysis"})
public final class CssAddRequiredPropertiesForCustomPropertyAtRuleFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("css.inspections.invalid.custom.property.at.rule.declaration.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CssElementFactory factory = CssElementFactory.getInstance(project);
        PsiElement customProperty = descriptor.getPsiElement().getParent();
        CssBlock cssBlock = (CssBlock)PsiTreeUtil.getChildOfType((PsiElement)customProperty, CssBlock.class);
        if (cssBlock != null) {
            String string = cssBlock.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            if (new Regex("\\{\\s*\\}").matches(charSequence)) {
                CssBlock cssBlock2 = factory.createBlock(CSSLanguage.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)cssBlock2, (String)"createBlock(...)");
                CssBlock newBlock = cssBlock2;
                cssBlock.replace(newBlock);
                cssBlock = (CssBlock)PsiTreeUtil.getChildOfType((PsiElement)customProperty, CssBlock.class);
            }
        }
        if (cssBlock != null) {
            PsiElement context = customProperty.getContext();
            char quote = '\"';
            if (context != null) {
                quote = CssCodeStyleSettings.getLanguageSpecificQuote(context);
            }
            ASTNode aSTNode = cssBlock.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            Map<String, String> absentProperties = CssInvalidCustomPropertyAtRuleDeclarationUtils.Companion.getAbsentDeclarations(aSTNode, quote);
            boolean isSemicolonAllowed = false;
            if (cssBlock.getLastChild() != null && Intrinsics.areEqual((Object)cssBlock.getLastChild().getText(), (Object)"}")) {
                isSemicolonAllowed = true;
            }
            for (Map.Entry<String, String> entry : absentProperties.entrySet()) {
                PsiElement psiElement;
                String propertyName = entry.getKey();
                String propertyValue = entry.getValue();
                if (isSemicolonAllowed) {
                    cssBlock.addBefore(factory.createProperty(propertyName, propertyValue, CSSLanguage.INSTANCE), cssBlock.getLastChild());
                    psiElement = cssBlock.addBefore(factory.createToken(";", CSSLanguage.INSTANCE), cssBlock.getLastChild());
                    continue;
                }
                cssBlock.addAfter(factory.createToken("\n", customProperty.getLanguage()), cssBlock.getLastChild());
                psiElement = cssBlock.addAfter(factory.createProperty(propertyName, propertyValue, customProperty.getLanguage()), cssBlock.getLastChild());
            }
        }
    }
}

