/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.simplify.TaggedLineString;
import org.locationtech.jts.simplify.TaggedLinesSimplifier;

public class TopologyPreservingSimplifier {
    private Geometry inputGeom;
    private TaggedLinesSimplifier lineSimplifier = new TaggedLinesSimplifier();
    private Map linestringMap;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        TopologyPreservingSimplifier tss = new TopologyPreservingSimplifier(geom);
        tss.setDistanceTolerance(distanceTolerance);
        return tss.getResultGeometry();
    }

    public TopologyPreservingSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.lineSimplifier.setDistanceTolerance(distanceTolerance);
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return this.inputGeom.copy();
        }
        this.linestringMap = new HashMap();
        this.inputGeom.apply(new LineStringMapBuilderFilter(this));
        this.lineSimplifier.simplify(this.linestringMap.values());
        Geometry result2 = new LineStringTransformer(this.linestringMap).transform(this.inputGeom);
        return result2;
    }

    static class LineStringMapBuilderFilter
    implements GeometryComponentFilter {
        TopologyPreservingSimplifier tps;

        LineStringMapBuilderFilter(TopologyPreservingSimplifier tps) {
            this.tps = tps;
        }

        @Override
        public void filter(Geometry geom) {
            if (geom instanceof LineString) {
                LineString line = (LineString)geom;
                if (line.isEmpty()) {
                    return;
                }
                int minSize = line.isClosed() ? 4 : 2;
                TaggedLineString taggedLine = new TaggedLineString(line, minSize);
                this.tps.linestringMap.put(line, taggedLine);
            }
        }
    }

    static class LineStringTransformer
    extends GeometryTransformer {
        private Map linestringMap;

        public LineStringTransformer(Map linestringMap) {
            this.linestringMap = linestringMap;
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            if (coords.size() == 0) {
                return null;
            }
            if (parent instanceof LineString) {
                TaggedLineString taggedLine = (TaggedLineString)this.linestringMap.get(parent);
                return this.createCoordinateSequence(taggedLine.getResultCoordinates());
            }
            return super.transformCoordinates(coords, parent);
        }
    }
}

