/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.AstUtilKt;
import org.jetbrains.yaml.ImportantSchema;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"SCHEMA_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/yaml/ImportantSchema;", "getSchema", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "detect", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.yaml.backend"})
public final class YamlFileTypeUsageDescriptorKt {
    @NotNull
    private static final Key<ImportantSchema> SCHEMA_KEY;

    @RequiresReadLock
    @NotNull
    public static final ImportantSchema getSchema(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(file);
        if (viewProvider == null) {
            return ImportantSchema.NONE;
        }
        List list = viewProvider.getAllFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
        List files = list;
        for (Object e : files) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PsiFile f = (PsiFile)e;
            if (!(f instanceof PsiFileImpl) || !Intrinsics.areEqual((Object)((PsiFileImpl)f).getFileType(), (Object)YAMLFileType.YML)) continue;
            FileElement astTree = (FileElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)f, () -> YamlFileTypeUsageDescriptorKt.getSchema$lambda$0(f));
            LighterAST lighterAST = astTree.getLighterAST();
            Intrinsics.checkNotNullExpressionValue((Object)lighterAST, (String)"getLighterAST(...)");
            return YamlFileTypeUsageDescriptorKt.detect(lighterAST);
        }
        return ImportantSchema.NONE;
    }

    private static final ImportantSchema detect(LighterAST tree) {
        Ref.BooleanRef hasApiVersion = new Ref.BooleanRef();
        Ref.BooleanRef hasKind = new Ref.BooleanRef();
        Ref.BooleanRef hasOpenapi = new Ref.BooleanRef();
        Ref.BooleanRef hasSwagger = new Ref.BooleanRef();
        Ref.BooleanRef hasServices = new Ref.BooleanRef();
        Ref.BooleanRef hasResources = new Ref.BooleanRef();
        Ref.BooleanRef hasAwsFormat = new Ref.BooleanRef();
        Ref.ObjectRef schema = new Ref.ObjectRef();
        AstUtilKt.visitTopLevelKeyPairs(tree, (Function2<? super CharSequence, ? super LighterASTNode, Boolean>)((Function2)(arg_0, arg_1) -> YamlFileTypeUsageDescriptorKt.detect$lambda$1(hasKind, hasApiVersion, hasOpenapi, hasSwagger, hasServices, hasResources, hasAwsFormat, schema, arg_0, arg_1)));
        ImportantSchema importantSchema = (ImportantSchema)((Object)schema.element);
        if (importantSchema == null) {
            importantSchema = ImportantSchema.NONE;
        }
        return importantSchema;
    }

    private static final FileElement getSchema$lambda$0(PsiFile $f) {
        return ((PsiFileImpl)$f).calcTreeElement();
    }

    private static final boolean detect$lambda$1(Ref.BooleanRef $hasKind, Ref.BooleanRef $hasApiVersion, Ref.BooleanRef $hasOpenapi, Ref.BooleanRef $hasSwagger, Ref.BooleanRef $hasServices, Ref.BooleanRef $hasResources, Ref.BooleanRef $hasAwsFormat, Ref.ObjectRef $schema, CharSequence key, LighterASTNode lighterASTNode) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)lighterASTNode, (String)"<unused var>");
        CharSequence charSequence = key;
        if (Intrinsics.areEqual((Object)charSequence, (Object)"kind")) {
            $hasKind.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"apiVersion")) {
            $hasApiVersion.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"openapi")) {
            $hasOpenapi.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"swagger")) {
            $hasSwagger.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"services")) {
            $hasServices.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"Resources")) {
            $hasResources.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"AWSTemplateFormatVersion")) {
            $hasAwsFormat.element = true;
        }
        $schema.element = $hasOpenapi.element ? ImportantSchema.OPENAPI : ($hasSwagger.element ? ImportantSchema.SWAGGER : ($hasApiVersion.element && $hasKind.element ? ImportantSchema.KUBERNETES : ($hasServices.element ? ImportantSchema.DOCKER_COMPOSE : ($hasResources.element || $hasAwsFormat.element ? ImportantSchema.CLOUD_FORMATION : null))));
        return $schema.element == null;
    }

    public static final /* synthetic */ Key access$getSCHEMA_KEY$p() {
        return SCHEMA_KEY;
    }

    static {
        Key key = Key.create((String)"YAML_USAGE_SCHEMA");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SCHEMA_KEY = key;
    }
}

