/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.UploadFilesAction;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.statistic.DeploymentActivitiesUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadAllOpenFilesAction
extends LoadFilesAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UploadAllOpenFilesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault() || FileEditorManager.getInstance((Project)e.getProject()).getOpenFiles().length <= 1) {
            e.getPresentation().setVisible(false);
        }
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected Supplier<String> getLoadHereMessage() {
        Supplier<String> supplier = WDBundle.messagePointer("action.title.upload.all.open.files.here", new Object[0]);
        if (supplier == null) {
            UploadAllOpenFilesAction.$$$reportNull$$$0(1);
        }
        return supplier;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected Supplier<String> getLoadToServerMessage(WebServerGroupingWrap wrap) {
        Supplier<String> supplier = WDBundle.messagePointer("action.title.upload.all.open.files.to", wrap.getName());
        if (supplier == null) {
            UploadAllOpenFilesAction.$$$reportNull$$$0(2);
        }
        return supplier;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected String getServerChooserTitle() {
        String string = WDBundle.message("choose.server.to.upload.to", new Object[0]);
        if (string == null) {
            UploadAllOpenFilesAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static Collection<VirtualFile> getFilesToUpload(Project project) {
        return Arrays.asList(FileEditorManager.getInstance((Project)project).getOpenFiles());
    }

    @Override
    protected void execute(final @NotNull Project project, PublishConfig publishConfig2, @NotNull Deployable server, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, final @Nullable RemoteConnection connection, Collection<VirtualFile> roots) {
        if (project == null) {
            UploadAllOpenFilesAction.$$$reportNull$$$0(4);
        }
        if (server == null) {
            UploadAllOpenFilesAction.$$$reportNull$$$0(5);
        }
        String title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
        final Collection<VirtualFile> filesToUpload = UploadAllOpenFilesAction.getFilesToUpload(project);
        AutoUploadComponent.saveDocumentsSilently(project, filesToUpload);
        TransferTask.ListBased transferTask = new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig2, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){
            private StructuredIdeActivity myActivity;

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                if (UploadFilesAction.isSpeculativeQuickUploadMode()) {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = DeploymentPathUtils.createSpeculativeUploadTransferOperations(context, filesToUpload);
                    if (resultWithErrors == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return resultWithErrors;
                }
                TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles(context, filesToUpload);
                if (resultWithErrors == null) {
                    1.$$$reportNull$$$0(1);
                }
                return resultWithErrors;
            }

            @Override
            protected void assertAllExecuted(int totalProcessed, int failed) {
                if (UploadFilesAction.isSpeculativeQuickUploadMode()) {
                    return;
                }
                super.assertAllExecuted(totalProcessed, failed);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }

            @Override
            protected void beforeTaskStarted() {
                this.myActivity = DeploymentActivitiesUsageTriggerCollector.logUploadBegan(project);
            }

            public void onFinished() {
                DeploymentActivitiesUsageTriggerCollector.logUploadFinished(this.myActivity);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadAllOpenFilesAction$1", "buildOperationsList"));
            }
        };
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig2.getTraceLevel());
        ProgressManager.getInstance().run((Task)transferTask);
    }

    @Override
    protected boolean supportConfirmation() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/UploadAllOpenFilesAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/UploadAllOpenFilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadHereMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadToServerMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerChooserTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

