/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertCastFix
extends PsiUpdateModCommandAction<JSExpression> {
    private final String type;
    @IntentionFamilyName
    @NotNull
    private final String myMessage;

    public JSInsertCastFix(String type2, @NotNull JSExpression expression) {
        if (expression == null) {
            JSInsertCastFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)expression);
        this.type = type2;
        this.myMessage = JavaScriptBundle.message(DialectDetector.isTypeScript((PsiElement)expression) ? "typescript.insert.cast.fix" : "javascript.insert.cast.fix", new Object[0]);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull JSExpression element2) {
        if (context2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(2);
        }
        return this.isAvailable(element2) ? Presentation.of((String)this.myMessage).withPriority(PriorityAction.Priority.HIGH) : null;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.myMessage;
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean isAvailable(@NotNull JSExpression startElement) {
        String shortestTypeName;
        if (startElement == null) {
            JSInsertCastFix.$$$reportNull$$$0(4);
        }
        if (startElement instanceof JSLiteralExpression) {
            String literalType;
            JSLiteralExpression literalExpression = (JSLiteralExpression)startElement;
            JSType typ = JSResolveUtil.getExpressionJSType(literalExpression);
            String string = literalType = typ == null ? null : typ.getTypeText(JSType.TypeTextFormat.CODE);
            if (JSInsertCastFix.isNumericType(this.type) && "String".equals(literalType)) {
                return JSInsertCastFix.isValidNumber(StringUtil.unquoteString((String)literalExpression.getText()));
            }
        }
        return !DialectDetector.isTypeScript((PsiElement)startElement) || !TypeScriptUtil.hasAmbientExternalModuleInQName(this.type) || !TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = this.getShortestType((PsiElement)startElement));
    }

    private static boolean isValidNumber(String text) {
        try {
            if (text.startsWith("0x") || text.startsWith("0X")) {
                Integer.parseInt(text.substring(2), 16);
            } else if (text.startsWith("0")) {
                Integer.parseInt(text, 8);
            } else {
                Double.parseDouble(text);
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull JSExpression element2, @NotNull ModPsiUpdater updater) {
        if (context2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            JSInsertCastFix.$$$reportNull$$$0(7);
        }
        SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)context2.project()).createSmartPsiElementPointer((PsiElement)element2);
        String shortenedType = this.getShortestType((PsiElement)element2);
        element2 = (JSExpression)p.getElement();
        if (element2 == null) {
            return;
        }
        if (element2 instanceof JSLiteralExpression) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)element2;
            JSType type2 = JSResolveUtil.getExpressionJSType(literalExpression);
            String literalType = type2 == null ? null : type2.getTypeText(JSType.TypeTextFormat.CODE);
            String text = literalExpression.getText();
            if ("String".equals(shortenedType) && JSInsertCastFix.isNumericType(literalType)) {
                JSInsertCastFix.replaceElementWithText((PsiElement)element2, "\"" + text + "\"");
                return;
            }
            if (JSInsertCastFix.isNumericType(shortenedType) && "String".equals(literalType)) {
                if (JSInsertCastFix.isValidNumber(text = StringUtil.unquoteString((String)text))) {
                    JSInsertCastFix.replaceElementWithText((PsiElement)element2, text);
                }
                return;
            }
        }
        String castText = JSInsertCastFix.getCast(shortenedType, element2.getText(), (PsiElement)element2);
        JSInsertCastFix.replaceElementWithText((PsiElement)element2, castText);
    }

    private static boolean isNumericType(String literalType) {
        return "Number".equals(literalType) || "int".equals(literalType) || "uint".equals(literalType);
    }

    private static void replaceElementWithText(PsiElement element2, String replacement) {
        element2.replace((PsiElement)JSPsiElementFactory.createJSExpression(replacement, element2));
    }

    @NotNull
    public static String getCast(@NotNull String type2, @NotNull String expr, @NotNull PsiElement context2) {
        DialectOptionHolder holder;
        if (type2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(8);
        }
        if (expr == null) {
            JSInsertCastFix.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(10);
        }
        if ((holder = DialectDetector.dialectOfElement(context2)) != null && holder.isTypeScript) {
            if (holder.isJSX() || JSCodeStyleSettings.getSettings((PsiElement)context2).PREFER_AS_TYPE_CAST) {
                String string = expr + " as " + type2;
                if (string == null) {
                    JSInsertCastFix.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = "<" + type2 + ">" + expr;
            if (string == null) {
                JSInsertCastFix.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = type2 + "(" + expr + ")";
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    private String getShortestType(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSInsertCastFix.$$$reportNull$$$0(14);
        }
        if (DialectDetector.isTypeScript(context2) && this.type != null) {
            return TypeScriptUtil.getShortestTypeNameInContext(this.type, context2);
        }
        return (String)ImportUtils.importAndShortenReference((String)this.type, (PsiElement)context2, (boolean)true, (boolean)true).first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCast";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getShortestType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

