/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesVfsEventsSession;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.JsEntityHelperKt;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesEntities;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u001d\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001d\u0010'\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "nodeModulesDirectoryManager", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;", "packageJsonFileManager", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;)V", "sessions", "Ljava/util/concurrent/BlockingQueue;", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesVfsEventsSession;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "registerSession", "", "session", "disposeSessions", "isRelevantEvent", "", "event", "afterFileCreated", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCreateEvent;", "beforeRenameEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "afterEarlyRenameEvent", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "afterEarlyRenameEvent$intellij_javascript_impl", "afterRenameEvent", "afterFileDeleted", "Lcom/intellij/openapi/vfs/newvfs/events/VFileDeleteEvent;", "afterFileContentChanged", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "afterDirectoryPathChanged", "afterMoveEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "afterMoveEvent$intellij_javascript_impl", "afterFileCopied", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCopyEvent;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeModulesFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesFileListener.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,198:1\n774#2:199\n865#2,2:200\n1869#2,2:204\n774#2:206\n865#2,2:207\n1#3:202\n24#4:203\n*S KotlinDebug\n*F\n+ 1 NodeModulesFileListener.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener\n*L\n24#1:199\n24#1:200,2\n83#1:204,2\n156#1:206\n156#1:207,2\n81#1:203\n*E\n"})
public final class NodeModulesFileListener
implements AsyncFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final NodeModulesDirectoryManager nodeModulesDirectoryManager;
    @NotNull
    private final PackageJsonFileManager packageJsonFileManager;
    @NotNull
    private final BlockingQueue<NodeModulesVfsEventsSession> sessions;

    public NodeModulesFileListener(@NotNull Project project, @NotNull NodeModulesDirectoryManager nodeModulesDirectoryManager, @NotNull PackageJsonFileManager packageJsonFileManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)nodeModulesDirectoryManager, (String)"nodeModulesDirectoryManager");
        Intrinsics.checkNotNullParameter((Object)packageJsonFileManager, (String)"packageJsonFileManager");
        this.project = project;
        this.nodeModulesDirectoryManager = nodeModulesDirectoryManager;
        this.packageJsonFileManager = packageJsonFileManager;
        this.sessions = new LinkedBlockingQueue();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VFileEvent it = (VFileEvent)element$iv$iv;
            boolean bl = false;
            if (!this.isRelevantEvent(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantEvents = (List)destination$iv$iv;
        if (relevantEvents.isEmpty()) {
            return null;
        }
        NodeModulesVfsEventsSession session = new NodeModulesVfsEventsSession(this.project, relevantEvents, this.nodeModulesDirectoryManager, this.packageJsonFileManager, this);
        this.registerSession(session);
        return new AsyncFileListener.ChangeApplier(relevantEvents, this, session){
            final /* synthetic */ List<VFileEvent> $relevantEvents;
            final /* synthetic */ NodeModulesFileListener this$0;
            final /* synthetic */ NodeModulesVfsEventsSession $session;
            {
                this.$relevantEvents = $relevantEvents;
                this.this$0 = $receiver;
                this.$session = $session;
            }

            public void beforeVfsChange() {
                for (VFileEvent event : this.$relevantEvents) {
                    if (event instanceof VFilePropertyChangeEvent) {
                        NodeModulesFileListener.access$beforeRenameEvent(this.this$0, (VFilePropertyChangeEvent)event);
                        VirtualFile virtualFile = ((VFilePropertyChangeEvent)event).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                        this.beforeDirectoryPathChanged(virtualFile);
                    }
                    if (!(event instanceof VFileMoveEvent)) continue;
                    VirtualFile virtualFile = ((VFileMoveEvent)event).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    this.beforeDirectoryPathChanged(virtualFile);
                }
            }

            private final void beforeDirectoryPathChanged(VirtualFile directory) {
                if (directory.isDirectory() && NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                    this.$session.storeEntitiesUnderDirectory(directory);
                }
            }

            public void afterVfsChange() {
                for (VFileEvent event : this.$relevantEvents) {
                    VFileEvent vFileEvent = event;
                    if (vFileEvent instanceof VFileDeleteEvent) {
                        NodeModulesFileListener.access$afterFileDeleted(this.this$0, (VFileDeleteEvent)event);
                        continue;
                    }
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        NodeModulesFileListener.access$afterFileContentChanged(this.this$0, (VFileContentChangeEvent)event);
                        continue;
                    }
                    if (vFileEvent instanceof VFilePropertyChangeEvent) {
                        NodeModulesFileListener.access$afterRenameEvent(this.this$0, (VFilePropertyChangeEvent)event);
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        this.$session.afterMoveEvent$intellij_javascript_impl((VFileMoveEvent)event);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCreateEvent) {
                        NodeModulesFileListener.access$afterFileCreated(this.this$0, (VFileCreateEvent)event);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileCopyEvent)) continue;
                    NodeModulesFileListener.access$afterFileCopied(this.this$0, (VFileCopyEvent)event);
                }
                NodeModulesFileListener.access$disposeSessions(this.this$0);
            }
        };
    }

    private final void registerSession(NodeModulesVfsEventsSession session) {
        NodeModulesVfsEventsSession previousSession = (NodeModulesVfsEventsSession)this.sessions.poll();
        if (previousSession != null) {
            if (Intrinsics.areEqual(previousSession.getEvents(), session.getEvents())) {
                previousSession.dispose$intellij_javascript_impl();
            } else {
                this.sessions.add(previousSession);
            }
        }
        this.sessions.add(session);
    }

    private final void disposeSessions() {
        List list;
        List it = list = (List)new ArrayList();
        boolean bl = false;
        this.sessions.drainTo(it);
        List sessions = list;
        if (sessions.size() > 1) {
            NodeModulesFileListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NodeModulesFileListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Too many " + NodeModulesVfsEventsSession.class.getSimpleName() + " registered: " + sessions.size());
        }
        Iterable $this$forEach$iv = sessions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeModulesVfsEventsSession p0 = (NodeModulesVfsEventsSession)element$iv;
            boolean bl2 = false;
            p0.dispose$intellij_javascript_impl();
        }
    }

    private final boolean isRelevantEvent(VFileEvent event) {
        VirtualFile file;
        if (event instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)event).isDirectory() || PackageJsonUtil.isPackageJsonFileName(((VFileCreateEvent)event).getChildName());
        }
        if (event instanceof VFilePropertyChangeEvent) {
            String newName;
            Object object = ((VFilePropertyChangeEvent)event).getOldValue();
            String oldName = object instanceof String ? (String)object : null;
            Object object2 = ((VFilePropertyChangeEvent)event).getNewValue();
            String string = newName = object2 instanceof String ? (String)object2 : null;
            if (!((VFilePropertyChangeEvent)event).isRename() || Intrinsics.areEqual((Object)oldName, (Object)newName)) {
                return false;
            }
            return ((VFilePropertyChangeEvent)event).getFile().isDirectory() || PackageJsonUtil.isPackageJsonFileName(oldName) || PackageJsonUtil.isPackageJsonFileName(newName);
        }
        if (event instanceof VFileCopyEvent) {
            return PackageJsonUtil.isPackageJsonFileName(((VFileCopyEvent)event).getNewChildName()) || NodeModulesDirectoryManager.isNodeModulesDirName(((VFileCopyEvent)event).getNewChildName());
        }
        if (event instanceof VFileDeleteEvent) {
            VirtualFile virtualFile = ((VFileDeleteEvent)event).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            file = virtualFile;
            if (file.isDirectory() && this.nodeModulesDirectoryManager.findUpNodeModules(file) != null) {
                return true;
            }
        }
        if (event instanceof VFileMoveEvent) {
            return ((VFileMoveEvent)event).getFile().isDirectory() || PackageJsonUtil.isPackageJsonFile(((VFileMoveEvent)event).getFile());
        }
        file = event.getFile();
        return NodeModulesDirectoryManager.isNodeModulesDir(file) || PackageJsonUtil.isPackageJsonFile(file);
    }

    private final void afterFileCreated(VFileCreateEvent event) {
        VirtualFile virtualFile = event.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        this.nodeModulesDirectoryManager.onFileCreatedOrDeleted(file);
        this.nodeModulesDirectoryManager.handleAddingPackageJson(file);
        this.nodeModulesDirectoryManager.handleAddingNodeModulesDir(file);
    }

    private final void beforeRenameEvent(VFilePropertyChangeEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        if (Intrinsics.areEqual((Object)"node_modules", (Object)event.getOldValue()) && NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            this.nodeModulesDirectoryManager.handleRemovingNodeModulesDir(file);
        }
    }

    public final void afterEarlyRenameEvent$intellij_javascript_impl(@NotNull VirtualFile directory, @NotNull NodeModulesVfsEventsSession session) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.afterDirectoryPathChanged(directory, session);
    }

    private final void afterRenameEvent(VFilePropertyChangeEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        if (Intrinsics.areEqual((Object)"node_modules", (Object)event.getOldValue())) {
            this.nodeModulesDirectoryManager.handleRemovingNodeModulesDir(file);
        }
        if (Intrinsics.areEqual((Object)"package.json", (Object)event.getOldValue())) {
            this.nodeModulesDirectoryManager.doRemovePackageJson(file, null);
        }
        this.nodeModulesDirectoryManager.handleAddingPackageJson(file);
        this.nodeModulesDirectoryManager.handleAddingNodeModulesDir(file);
    }

    private final void afterFileDeleted(VFileDeleteEvent event) {
        this.nodeModulesDirectoryManager.onFileCreatedOrDeleted(event.getFile());
        this.nodeModulesDirectoryManager.handleRemovingPackageJson(event.getFile());
        this.nodeModulesDirectoryManager.handleRemovingNodeModulesDir(event.getFile());
    }

    private final void afterFileContentChanged(VFileContentChangeEvent event) {
        this.nodeModulesDirectoryManager.handlePackageJsonContentChanged(event.getFile());
    }

    /*
     * WARNING - void declaration
     */
    private final void afterDirectoryPathChanged(VirtualFile directory, NodeModulesVfsEventsSession session) {
        void $this$filterTo$iv$iv;
        List<VirtualFile> list = this.nodeModulesDirectoryManager.getNodeModulesDirs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNodeModulesDirs(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)it, (boolean)false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List affected = (List)destination$iv$iv;
        if (!affected.isEmpty() && NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            JsEntityHelperKt.addExcludeEntities(this.project, affected);
            NodeModulesEntities nodeModulesEntities = session.getEntitiesUnderDirectoryBeforeVfsEvent(directory);
            Intrinsics.checkNotNull((Object)nodeModulesEntities);
            NodeModulesEntities previousEntities = nodeModulesEntities;
            JsEntityHelperKt.removeEntities(this.project, previousEntities);
            this.nodeModulesDirectoryManager.createLibraries(affected);
        }
    }

    public final void afterMoveEvent$intellij_javascript_impl(@NotNull VFileMoveEvent event, @NotNull NodeModulesVfsEventsSession session) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile fileOrDir = virtualFile;
        if (fileOrDir.isDirectory()) {
            if (JSProjectUtil.getBaseDirectoryForFile(this.project, fileOrDir, false) != null) {
                if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
                    this.afterDirectoryPathChanged(fileOrDir, session);
                } else {
                    this.nodeModulesDirectoryManager.requestLibrariesUpdate();
                }
            } else {
                this.nodeModulesDirectoryManager.handleRemovingNodeModulesDir(fileOrDir);
            }
        } else if (PackageJsonUtil.isPackageJsonFile(fileOrDir)) {
            this.nodeModulesDirectoryManager.doRemovePackageJson(fileOrDir, event.getOldParent());
        }
    }

    private final void afterFileCopied(VFileCopyEvent event) {
        VirtualFile newFile = event.getNewParent().findChild(event.getNewChildName());
        if (newFile != null) {
            this.nodeModulesDirectoryManager.handleAddingPackageJson(newFile);
            this.nodeModulesDirectoryManager.handleAddingNodeModulesDir(newFile);
        }
    }

    public static final /* synthetic */ void access$beforeRenameEvent(NodeModulesFileListener $this, VFilePropertyChangeEvent event) {
        $this.beforeRenameEvent(event);
    }

    public static final /* synthetic */ void access$afterFileDeleted(NodeModulesFileListener $this, VFileDeleteEvent event) {
        $this.afterFileDeleted(event);
    }

    public static final /* synthetic */ void access$afterFileContentChanged(NodeModulesFileListener $this, VFileContentChangeEvent event) {
        $this.afterFileContentChanged(event);
    }

    public static final /* synthetic */ void access$afterRenameEvent(NodeModulesFileListener $this, VFilePropertyChangeEvent event) {
        $this.afterRenameEvent(event);
    }

    public static final /* synthetic */ void access$afterFileCreated(NodeModulesFileListener $this, VFileCreateEvent event) {
        $this.afterFileCreated(event);
    }

    public static final /* synthetic */ void access$afterFileCopied(NodeModulesFileListener $this, VFileCopyEvent event) {
        $this.afterFileCopied(event);
    }

    public static final /* synthetic */ void access$disposeSessions(NodeModulesFileListener $this) {
        $this.disposeSessions();
    }
}

