/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.components;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.settings.DockerConnectionsListConfigurable;
import com.intellij.docker.ui.components.FirstItemIfEmptySelectionComboBoxModel;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.docker.utils.SingleTaskExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00056789:B5\b\u0007\u0012\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006J\u0010\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0018\u0010\u001f\u001a\u00020 2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020 H\u0016J\b\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010(\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020 H\u0002J\u0014\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000602H\u0002J\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u0013H\u0016J\u0010\u00105\u001a\u00020 2\u0006\u00104\u001a\u00020\u0013H\u0016R \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0011\u001a.\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00130\u0013 \u0010*\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00130\u00130\u0015\u00a2\u0006\u0002\b\u00140\u0012\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00000\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect;", "Lcom/intellij/ui/ComboboxWithBrowseButton;", "Lcom/intellij/ui/UserActivityProviderComponent;", "Lcom/intellij/openapi/util/CheckedDisposable;", "filter", "Lkotlin/Function1;", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "", "model", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerServerItem;", "<init>", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/ui/CollectionComboBoxModel;)V", "myServerType", "Lcom/intellij/docker/DockerCloudType;", "kotlin.jvm.PlatformType", "myChangeListeners", "", "Ljavax/swing/event/ChangeListener;", "Lorg/jetbrains/annotations/NotNull;", "", "myServerReminder", "myIsDisposed", "myScope", "Lkotlinx/coroutines/CoroutineScope;", "myAutodetectedItem", "Lkotlin/Lazy;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$AutoDetectedServerItem;", "getSelectedItem", "getSelectedServer", "selectServerInCombo", "", "name", "", "item", "isDisposed", "dispose", "fireStateChanged", "onBrowseServer", "e", "Ljava/awt/event/ActionEvent;", "onItemChosen", "onItemUnselected", "Ljava/awt/event/ItemEvent;", "editServer", "configurable", "Lcom/intellij/docker/settings/DockerConnectionsListConfigurable;", "refillModel", "getSortedServers", "", "addChangeListener", "changeListener", "removeChangeListener", "TestConnectionState", "DockerServerItem", "DockerServerItemBase", "DockerExistingServerItem", "AutoDetectedServerItem", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComboWithAutoDetect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComboWithAutoDetect.kt\ncom/intellij/docker/ui/components/DockerComboWithAutoDetect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1#2:282\n774#3:283\n865#3,2:284\n*S KotlinDebug\n*F\n+ 1 DockerComboWithAutoDetect.kt\ncom/intellij/docker/ui/components/DockerComboWithAutoDetect\n*L\n170#1:283\n170#1:284,2\n*E\n"})
public final class DockerComboWithAutoDetect
extends ComboboxWithBrowseButton
implements UserActivityProviderComponent,
CheckedDisposable {
    @NotNull
    private final Function1<RemoteServer<DockerCloudConfiguration>, Boolean> filter;
    @NotNull
    private final CollectionComboBoxModel<DockerServerItem> model;
    private final DockerCloudType myServerType;
    @NotNull
    private final List<ChangeListener> myChangeListeners;
    @Nullable
    private RemoteServer<DockerCloudConfiguration> myServerReminder;
    private volatile boolean myIsDisposed;
    @NotNull
    private final CoroutineScope myScope;
    @NotNull
    private final Lazy<AutoDetectedServerItem> myAutodetectedItem;

    @JvmOverloads
    public DockerComboWithAutoDetect(@NotNull Function1<? super RemoteServer<DockerCloudConfiguration>, Boolean> filter2, @NotNull CollectionComboBoxModel<DockerServerItem> model) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super((JComboBox)new ComboBox((ComboBoxModel)model));
        this.filter = filter2;
        this.model = model;
        this.myServerType = DockerCloudType.getInstance();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.myChangeListeners = list2;
        this.myScope = DockerMainCoroutineScopeHolder.createChildScope$default(DockerMainCoroutineScopeHolder.Companion.getInstance(), null, false, 1, null);
        this.myAutodetectedItem = LazyKt.lazy(() -> DockerComboWithAutoDetect.myAutodetectedItem$lambda$1(this));
        this.refillModel();
        this.addActionListener(this::onBrowseServer);
        this.getComboBox().setOpaque(false);
        this.getButton().setOpaque(false);
        this.getComboBox().addActionListener(this::onItemChosen);
        this.getComboBox().addItemListener(this::onItemUnselected);
        this.getComboBox().putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        this.getComboBox().setRenderer((ListCellRenderer)new ColoredListCellRenderer<DockerServerItem>(){

            protected void customizeCellRenderer(JList<? extends DockerServerItem> list2, DockerServerItem value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                DockerServerItem dockerServerItem = value;
                if (dockerServerItem != null) {
                    dockerServerItem.render((SimpleColoredComponent)this);
                }
                DockerServerItem dockerServerItem2 = value;
                this.getComboBox().setToolTipText(dockerServerItem2 != null ? dockerServerItem2.getTooltip() : null);
            }
        });
    }

    public /* synthetic */ DockerComboWithAutoDetect(Function1 function1, CollectionComboBoxModel collectionComboBoxModel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = DockerComboWithAutoDetect::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            collectionComboBoxModel = new FirstItemIfEmptySelectionComboBoxModel();
        }
        this((Function1<? super RemoteServer<DockerCloudConfiguration>, Boolean>)function1, (CollectionComboBoxModel<DockerServerItem>)collectionComboBoxModel);
    }

    @Nullable
    public final DockerServerItem getSelectedItem() {
        return (DockerServerItem)this.model.getSelectedItem();
    }

    @Nullable
    public final RemoteServer<DockerCloudConfiguration> getSelectedServer() {
        DockerServerItem dockerServerItem = this.getSelectedItem();
        return dockerServerItem != null ? dockerServerItem.getServer() : null;
    }

    public final void selectServerInCombo(@Nullable String name) {
        Object v3;
        JComboBox jComboBox;
        block1: {
            JComboBox jComboBox2 = this.getComboBox();
            List list2 = this.model.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            Iterable iterable = list2;
            jComboBox = jComboBox2;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                DockerServerItem it = (DockerServerItem)t;
                boolean bl = false;
                RemoteServer<DockerCloudConfiguration> remoteServer = it.getServer();
                if (!Intrinsics.areEqual((Object)(remoteServer != null ? remoteServer.getName() : null), (Object)name)) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        jComboBox.setSelectedItem(v3);
    }

    private final void selectServerInCombo(RemoteServer<DockerCloudConfiguration> item) {
        Object v2;
        JComboBox jComboBox;
        block1: {
            JComboBox jComboBox2 = this.getComboBox();
            List list2 = this.model.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            Iterable iterable = list2;
            jComboBox = jComboBox2;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                DockerServerItem it = (DockerServerItem)t;
                boolean bl = false;
                if (!(it.getServer() == item)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        jComboBox.setSelectedItem(v2);
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dispose() {
        this.myIsDisposed = true;
        super.dispose();
        this.myChangeListeners.clear();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.myScope, null, (int)1, null);
    }

    private final void fireStateChanged() {
        ChangeEvent event = new ChangeEvent((Object)this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    private final void onBrowseServer(ActionEvent e) {
        DockerServerItem item;
        DockerServerItem dockerServerItem = item = this.getSelectedItem();
        if (dockerServerItem != null) {
            dockerServerItem.onBrowseAction();
        } else {
            this.editServer(new DockerConnectionsListConfigurable(null, 1, null));
        }
    }

    private final void onItemChosen(ActionEvent e) {
        RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, () -> DockerComboWithAutoDetect.onItemChosen$lambda$4(this));
    }

    private final void onItemUnselected(ItemEvent e) {
        if (e.getStateChange() == 2) {
            DockerServerItem item;
            DockerServerItem dockerServerItem = item = (DockerServerItem)e.getItem();
            this.myServerReminder = dockerServerItem != null ? dockerServerItem.getServer() : null;
        }
    }

    private final boolean editServer(DockerConnectionsListConfigurable configurable) {
        boolean isOk = ShowSettingsUtil.getInstance().editConfigurable((Component)((Object)this), (Configurable)configurable);
        if (isOk) {
            this.refillModel();
            this.selectServerInCombo(configurable.getLastSelectedServer());
        }
        return isOk;
    }

    private final void refillModel() {
        this.model.removeAll();
        Set<RemoteServer<DockerCloudConfiguration>> servers = this.getSortedServers();
        if (servers.isEmpty()) {
            this.model.add(this.myAutodetectedItem.getValue());
        }
        for (RemoteServer<DockerCloudConfiguration> nextServer : servers) {
            AutoDetectedServerItem autoDetectedServerItem = InternalUtilsKt.getValueIfInitialized(this.myAutodetectedItem);
            DockerServerItem nextDockerServerItem = Intrinsics.areEqual(nextServer, autoDetectedServerItem != null ? autoDetectedServerItem.getServer() : null) ? (DockerServerItem)this.myAutodetectedItem.getValue() : (DockerServerItem)new DockerExistingServerItem(nextServer);
            this.model.add((Object)nextDockerServerItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<RemoteServer<DockerCloudConfiguration>> getSortedServers() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List list2 = RemoteServersManager.getInstance().getServers((ServerType)this.myServerType);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getServers(...)");
        Iterable iterable = list2;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> DockerComboWithAutoDetect.getSortedServers$lambda$6(DockerComboWithAutoDetect::getSortedServers$lambda$5, arg_0), StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        Iterable iterable2 = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        Function1<RemoteServer<DockerCloudConfiguration>, Boolean> predicate$iv = this.filter;
        boolean $i$f$filter = false;
        void var4_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        Intrinsics.checkNotNullParameter((Object)changeListener, (String)"changeListener");
        this.myChangeListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        Intrinsics.checkNotNullParameter((Object)changeListener, (String)"changeListener");
        this.myChangeListeners.remove(changeListener);
    }

    @JvmOverloads
    public DockerComboWithAutoDetect(@NotNull Function1<? super RemoteServer<DockerCloudConfiguration>, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        this(filter2, null, 2, null);
    }

    @JvmOverloads
    public DockerComboWithAutoDetect() {
        this(null, null, 3, null);
    }

    private static final boolean _init_$lambda$0(RemoteServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final AutoDetectedServerItem myAutodetectedItem$lambda$1(DockerComboWithAutoDetect this$0) {
        return this$0.new AutoDetectedServerItem();
    }

    private static final Object onItemChosen$lambda$4(DockerComboWithAutoDetect this$0) {
        DockerServerItem selectedItem;
        DockerServerItem dockerServerItem = selectedItem = this$0.getSelectedItem();
        if (dockerServerItem != null) {
            dockerServerItem.onItemChosen();
        }
        this$0.fireStateChanged();
        return null;
    }

    private static final String getSortedServers$lambda$5(RemoteServer it) {
        return it.getName();
    }

    private static final String getSortedServers$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$AutoDetectedServerItem;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerServerItemBase;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect;", "<init>", "(Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect;)V", "render", "", "ui", "Lcom/intellij/ui/SimpleColoredComponent;", "intellij.clouds.docker"})
    private final class AutoDetectedServerItem
    extends DockerServerItemBase {
        /*
         * WARNING - void declaration
         */
        public AutoDetectedServerItem() {
            void it;
            RemoteServer remoteServer;
            RemoteServer remoteServer2 = remoteServer = RemoteServersManager.getInstance().createServer((ServerType)DockerComboWithAutoDetect.this.myServerType);
            DockerComboWithAutoDetect dockerComboWithAutoDetect = DockerComboWithAutoDetect.this;
            AutoDetectedServerItem autoDetectedServerItem = this;
            boolean bl = false;
            RemoteServersManager.getInstance().addServer((RemoteServer)it);
            Unit unit = Unit.INSTANCE;
            RemoteServer remoteServer3 = remoteServer;
            Intrinsics.checkNotNullExpressionValue((Object)remoteServer3, (String)"also(...)");
            super((RemoteServer<DockerCloudConfiguration>)remoteServer3);
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            ui.setIcon(this.getIcon());
            ui.setToolTipText(this.getTooltip());
            TestConnectionState state = this.getTestConnectionState();
            Object[] objectArray = new Object[]{DockerComboWithAutoDetect.this.myServerType.getPresentableName()};
            ui.append(CloudBundle.message((String)"remote.server.combo.auto.detected.server", (Object[])objectArray), state instanceof TestConnectionState.Error ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerExistingServerItem;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerServerItemBase;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "render", "", "ui", "Lcom/intellij/ui/SimpleColoredComponent;", "intellij.clouds.docker"})
    private final class DockerExistingServerItem
    extends DockerServerItemBase {
        public DockerExistingServerItem(RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            super(server);
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            ui.setIcon(this.getIcon());
            ui.setToolTipText(this.getTooltip());
            ui.append(this.getServer().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u000eH&J\b\u0010\u0012\u001a\u00020\u000eH&R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerServerItem;", "", "serverName", "", "getServerName", "()Ljava/lang/String;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "tooltip", "getTooltip", "render", "", "ui", "Lcom/intellij/ui/SimpleColoredComponent;", "onItemChosen", "onBrowseAction", "intellij.clouds.docker"})
    public static interface DockerServerItem {
        @Nullable
        default public String getServerName() {
            RemoteServer<DockerCloudConfiguration> remoteServer = this.getServer();
            return remoteServer != null ? remoteServer.getName() : null;
        }

        @Nullable
        public RemoteServer<DockerCloudConfiguration> getServer();

        @Nullable
        public String getTooltip();

        public void render(@NotNull SimpleColoredComponent var1);

        public void onItemChosen();

        public void onBrowseAction();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0004R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerServerItemBase;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$DockerServerItem;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "mySingleTaskExecutor", "Lcom/intellij/docker/utils/SingleTaskExecutor;", "myTestConnectionState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "testConnectionState", "getTestConnectionState", "()Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "onItemChosen", "", "testConnection", "onBrowseAction", "setTestConnectionState", "state", "getIcon", "Ljavax/swing/Icon;", "intellij.clouds.docker"})
    private abstract class DockerServerItemBase
    implements DockerServerItem {
        @NotNull
        private final RemoteServer<DockerCloudConfiguration> server;
        @NotNull
        private final SingleTaskExecutor mySingleTaskExecutor;
        @NotNull
        private final AtomicReference<TestConnectionState> myTestConnectionState;

        public DockerServerItemBase(RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            this.server = server;
            this.mySingleTaskExecutor = new SingleTaskExecutor(DockerComboWithAutoDetect.this.myScope);
            this.myTestConnectionState = new AtomicReference<TestConnectionState.Initial>(TestConnectionState.Initial.INSTANCE);
            this.testConnection();
        }

        @Override
        @NotNull
        public RemoteServer<DockerCloudConfiguration> getServer() {
            return this.server;
        }

        @NotNull
        protected final TestConnectionState getTestConnectionState() {
            TestConnectionState testConnectionState = this.myTestConnectionState.get();
            Intrinsics.checkNotNullExpressionValue((Object)testConnectionState, (String)"get(...)");
            return testConnectionState;
        }

        @Override
        @Nullable
        public String getTooltip() {
            TestConnectionState state = this.getTestConnectionState();
            return state instanceof TestConnectionState.Error ? ((TestConnectionState.Error)state).getReason() : this.getServerName();
        }

        @Override
        public final void onItemChosen() {
            this.testConnection();
        }

        private final void testConnection() {
            this.setTestConnectionState(TestConnectionState.InProgress.INSTANCE);
            this.mySingleTaskExecutor.exec((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DockerServerItemBase this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ServerConfiguration serverConfiguration = this.this$0.getServer().getConfiguration();
                            Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
                            this.label = 1;
                            Object object2 = DockerUtils.onTemporaryAgentConnection((DockerCloudConfiguration)serverConfiguration, (Function2)new Function2<DockerAgent, Continuation<? super Unit>, Object>(null){
                                int label;

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(DockerAgent p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, arg_0 -> DockerServerItemBase.testConnection$lambda$2(this, arg_0));
        }

        @Override
        public void onBrowseAction() {
            DockerComboWithAutoDetect.this.editServer(new DockerConnectionsListConfigurable(this.getServer()));
        }

        private final void setTestConnectionState(TestConnectionState state) {
            boolean changed;
            boolean bl = changed = this.myTestConnectionState.getAndSet(state) != state;
            if (changed) {
                UIUtil.invokeLaterIfNeeded(() -> DockerServerItemBase.setTestConnectionState$lambda$3(DockerComboWithAutoDetect.this));
            }
        }

        @NotNull
        protected final Icon getIcon() {
            Icon icon;
            TestConnectionState testConnectionState = this.getTestConnectionState();
            if (testConnectionState instanceof TestConnectionState.InProgress) {
                AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                icon = (Icon)animatedIcon;
            } else if (testConnectionState instanceof TestConnectionState.Error) {
                Icon icon2 = AllIcons.Ide.FatalError;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FatalError");
            } else {
                Icon icon3 = DockerComboWithAutoDetect.this.myServerType.getIcon();
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getIcon(...)");
            }
            return icon;
        }

        private static final Unit testConnection$lambda$2(DockerServerItemBase this$0, Result $this$exec) {
            block2: {
                Throwable throwable;
                Object object = $this$exec.unbox-impl();
                if (Result.isSuccess-impl((Object)object)) {
                    Unit it = (Unit)object;
                    boolean bl = false;
                    this$0.setTestConnectionState(TestConnectionState.Success.INSTANCE);
                }
                object = $this$exec.unbox-impl();
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                if (throwable2 == null) break block2;
                Throwable it = throwable = throwable2;
                boolean bl = false;
                String string = it.getMessage();
                if (string == null) {
                    string = "";
                }
                this$0.setTestConnectionState(new TestConnectionState.Error(string));
            }
            return Unit.INSTANCE;
        }

        private static final void setTestConnectionState$lambda$3(DockerComboWithAutoDetect this$0) {
            this$0.fireStateChanged();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "", "<init>", "()V", "Initial", "InProgress", "Success", "Error", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$Error;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$InProgress;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$Initial;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$Success;", "intellij.clouds.docker"})
    private static abstract class TestConnectionState {
        private TestConnectionState() {
        }

        public /* synthetic */ TestConnectionState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$Error;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "reason", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "intellij.clouds.docker"})
        public static final class Error
        extends TestConnectionState {
            @NotNull
            private final String reason;

            public Error(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$InProgress;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "<init>", "()V", "intellij.clouds.docker"})
        public static final class InProgress
        extends TestConnectionState {
            @NotNull
            public static final InProgress INSTANCE = new InProgress();

            private InProgress() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$Initial;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "<init>", "()V", "intellij.clouds.docker"})
        public static final class Initial
        extends TestConnectionState {
            @NotNull
            public static final Initial INSTANCE = new Initial();

            private Initial() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState$Success;", "Lcom/intellij/docker/ui/components/DockerComboWithAutoDetect$TestConnectionState;", "<init>", "()V", "intellij.clouds.docker"})
        public static final class Success
        extends TestConnectionState {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
                super(null);
            }
        }
    }
}

