/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.build;

import com.github.dockerjava.api.exception.DockerClientException;
import com.intellij.docker.agent.build.ContextFolderArchive;
import com.intellij.docker.agent.build.DockerFilesToTransferCollector;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.TtySink;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/agent/build/Dockerfile;", "", "dockerFile", "Ljava/io/File;", "baseDirectory", "<init>", "(Ljava/io/File;Ljava/io/File;)V", "getDockerFile", "()Ljava/io/File;", "getBaseDirectory", "filesToTransfer", "", "getFilesToTransfer", "()Ljava/util/Set;", "filesToTransfer$delegate", "Lkotlin/Lazy;", "buildContextFolderArchive", "Lcom/intellij/docker/agent/build/ContextFolderArchive;", "tty", "Lcom/intellij/docker/agent/progress/TtySink;", "intellij.clouds.docker.agent"})
public final class Dockerfile {
    @NotNull
    private final File dockerFile;
    @NotNull
    private final File baseDirectory;
    @NotNull
    private final Lazy filesToTransfer$delegate;

    public Dockerfile(@NotNull File dockerFile, @NotNull File baseDirectory) {
        Intrinsics.checkNotNullParameter((Object)dockerFile, (String)"dockerFile");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        this.dockerFile = dockerFile;
        this.baseDirectory = baseDirectory;
        this.filesToTransfer$delegate = LazyKt.lazy(() -> Dockerfile.filesToTransfer_delegate$lambda$0(this));
    }

    @NotNull
    public final File getDockerFile() {
        return this.dockerFile;
    }

    @NotNull
    public final File getBaseDirectory() {
        return this.baseDirectory;
    }

    private final Set<File> getFilesToTransfer() {
        Lazy lazy = this.filesToTransfer$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ContextFolderArchive buildContextFolderArchive(@NotNull TtySink tty2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tty2, (String)"tty");
        DockerProgressDetailsFormat ttyFormat = new DockerProgressDetailsFormat("files");
        int total = this.getFilesToTransfer().size();
        tty2.ttyPrintln(DockerAgentBundle.Companion.message("Dockerfile.preparing.build.context.archive", new Object[0]));
        tty2.ttyPrintln(ttyFormat.toTtyString(0, total));
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String archiveNameWithOutExtension = string;
        ContextFolderArchive archive = new ContextFolderArchive(this.baseDirectory, archiveNameWithOutExtension);
        archive.createArchiveWith((Function1<? super TarArchiveOutputStream, Unit>)((Function1)arg_0 -> Dockerfile.buildContextFolderArchive$lambda$1(total, this, tty2, ttyFormat, archive, arg_0)));
        tty2.ttyCursorUp(1);
        tty2.ttyClearLine();
        tty2.ttyPrintln(ttyFormat.toTtyString(total, total));
        tty2.ttyPrintln(DockerAgentBundle.Companion.message("Dockerfile.done", new Object[0]));
        tty2.ttyPrintln("");
        return archive;
    }

    private static final Set filesToTransfer_delegate$lambda$0(Dockerfile this$0) {
        if (this$0.baseDirectory.listFiles() == null) {
            throw new DockerClientException("Failed to read build context directory: " + this$0.baseDirectory.getAbsolutePath());
        }
        return new DockerFilesToTransferCollector(this$0.baseDirectory, this$0.dockerFile).collectFiles();
    }

    private static final Unit buildContextFolderArchive$lambda$1(int $total, Dockerfile this$0, TtySink $tty, DockerProgressDetailsFormat $ttyFormat, ContextFolderArchive $archive, TarArchiveOutputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int batch = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)($total / 10), (int)1), (int)25);
        Iterator iterator = ((Iterable)this$0.getFilesToTransfer()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            File nextFile = (File)iterator.next();
            if (idx % batch == 0) {
                $tty.ttyCursorUp(1);
                $tty.ttyClearLine();
                $tty.ttyPrintln($ttyFormat.toTtyString(idx, $total));
            }
            $archive.addFileToTar(it, nextFile);
        }
        return Unit.INSTANCE;
    }
}

