/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.ui.JBColor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.repository.InstalledPyPackagedRepository;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowPanel;
import com.jetbrains.python.packaging.toolwindow.model.DisplayablePackage;
import com.jetbrains.python.packaging.toolwindow.model.ExpandResultNode;
import com.jetbrains.python.packaging.toolwindow.model.InstalledPackage;
import com.jetbrains.python.packaging.toolwindow.model.PyInvalidRepositoryViewData;
import com.jetbrains.python.packaging.toolwindow.model.PyPackagesViewData;
import com.jetbrains.python.packaging.toolwindow.packages.PyPackagingTreeGroup;
import com.jetbrains.python.packaging.toolwindow.packages.tree.PyPackagesTreeTable;
import com.jetbrains.python.packaging.toolwindow.ui.PyPackagesUiComponents;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016J,\u0010\u001a\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ$\u0010\u001e\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0016\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0002J\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010(\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\u0016\u0010*\u001a\u00020\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0016H\u0002J\u000e\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0010J\u0012\u0010/\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020'H\u0002J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0006\u00101\u001a\u00020\u0014J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0002J\u0015\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b6R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/PyPackagingTreeView;", "", "project", "Lcom/intellij/openapi/project/Project;", "container", "Ljavax/swing/JPanel;", "controller", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JPanel;Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowPanel;)V", "repositories", "", "Lcom/jetbrains/python/packaging/toolwindow/packages/PyPackagingTreeGroup;", "installedPackages", "invalidRepositories", "", "", "isSyncingTreeSelection", "", "showSearchResult", "", "installed", "", "Lcom/jetbrains/python/packaging/toolwindow/model/DisplayablePackage;", "repoData", "Lcom/jetbrains/python/packaging/toolwindow/model/PyPackagesViewData;", "resetSearch", "Lcom/jetbrains/python/packaging/toolwindow/model/InstalledPackage;", "currentSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "updatePackages", "synchronizeScrollPaneSize", "updateValidRepositories", "validRepoData", "updateExistingRepository", "repo", "items", "createNewRepository", "repository", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "cleanupRemovedRepositories", "existingRepositoryNames", "refreshInvalidRepositories", "invalid", "Lcom/jetbrains/python/packaging/toolwindow/model/PyInvalidRepositoryViewData;", "selectPackage", "packageName", "findTableForRepo", "getSelectedPackages", "collapseAll", "getRepos", "syncTreeSelection", "selectedTree", "Lcom/jetbrains/python/packaging/toolwindow/packages/tree/PyPackagesTreeTable;", "syncTreeSelection$intellij_python_community_impl", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPackagingTreeView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackagingTreeView.kt\ncom/jetbrains/python/packaging/toolwindow/PyPackagingTreeView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,229:1\n1869#2,2:230\n1563#2:232\n1634#2,2:233\n1636#2:236\n1869#2,2:237\n295#2,2:239\n360#2,7:241\n1869#2,2:248\n1056#2:250\n3301#2,10:251\n1563#2:261\n1634#2,3:262\n808#2,11:265\n1869#2,2:276\n295#2,2:278\n774#2:280\n865#2,2:281\n1869#2,2:283\n1563#2:285\n1634#2,3:286\n295#2,2:295\n1387#2:297\n1475#2,5:298\n1869#2,2:303\n1563#2:305\n1634#2,3:306\n774#2:309\n865#2,2:310\n1869#2,2:312\n1#3:235\n216#4,2:289\n216#4,2:293\n1321#5,2:291\n*S KotlinDebug\n*F\n+ 1 PyPackagingTreeView.kt\ncom/jetbrains/python/packaging/toolwindow/PyPackagingTreeView\n*L\n48#1:230,2\n62#1:232\n62#1:233,2\n62#1:236\n63#1:237,2\n71#1:239,2\n75#1:241,7\n89#1:248,2\n98#1:250\n101#1:251,10\n105#1:261\n105#1:262,3\n107#1:265,11\n113#1:276,2\n143#1:278,2\n167#1:280\n167#1:281,2\n168#1:283,2\n173#1:285\n173#1:286,3\n197#1:295,2\n206#1:297\n206#1:298,5\n210#1:303,2\n220#1:305\n220#1:306,3\n220#1:309\n220#1:310,2\n220#1:312,2\n175#1:289,2\n191#1:293,2\n188#1:291,2\n*E\n"})
public final class PyPackagingTreeView {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel container;
    @NotNull
    private final PyPackagingToolWindowPanel controller;
    @NotNull
    private final List<PyPackagingTreeGroup> repositories;
    @NotNull
    private final PyPackagingTreeGroup installedPackages;
    @NotNull
    private final Map<String, JPanel> invalidRepositories;
    private boolean isSyncingTreeSelection;

    public PyPackagingTreeView(@NotNull Project project, @NotNull JPanel container, @NotNull PyPackagingToolWindowPanel controller) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)((Object)controller), (String)"controller");
        this.project = project;
        this.container = container;
        this.controller = controller;
        this.repositories = new ArrayList();
        this.installedPackages = new PyPackagingTreeGroup(new InstalledPyPackagedRepository(), new PyPackagesTreeTable(this.project, this.controller, null, 4, null), this.container);
        this.invalidRepositories = new LinkedHashMap();
        this.installedPackages.addTo(this.container);
        this.installedPackages.expand();
        this.container.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.synchronizeScrollPaneSize();
            }
        });
        Iterable $this$forEach$iv = this.getRepos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyPackagingTreeGroup tree = (PyPackagingTreeGroup)element$iv;
            boolean bl = false;
            tree.getTree().getTree().addTreeSelectionListener(arg_0 -> PyPackagingTreeView.lambda$1$lambda$0(this, tree, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void showSearchResult(@NotNull List<? extends DisplayablePackage> installed, @NotNull List<? extends PyPackagesViewData> repoData) {
        block12: {
            int installedPackageIndex;
            block11: {
                int n;
                String exactMatchPackageName;
                String string;
                Object v1;
                PyPackagesViewData $this$firstOrNull$iv;
                block10: {
                    PyPackagingTreeGroup table;
                    Iterable $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(installed, (String)"installed");
                    Intrinsics.checkNotNullParameter(repoData, (String)"repoData");
                    this.updatePackages(installed, repoData);
                    this.installedPackages.expand();
                    this.installedPackages.updatePreferredSize();
                    this.installedPackages.updateHeaderText(installed.size());
                    Iterable $this$map$iv = this.repositories;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object v0;
                        void var14_25;
                        Collection collection;
                        block9: {
                            void repo;
                            Object item$iv$iv = iterator.next();
                            PyPackagingTreeGroup pyPackagingTreeGroup = (PyPackagingTreeGroup)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            Iterable iterable2 = repoData;
                            var14_25 = repo;
                            Iterable iterable3 = iterable2;
                            for (Object t : iterable3) {
                                PyPackagesViewData it = (PyPackagesViewData)t;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getRepository().getName(), (Object)repo.getRepositoryName())) continue;
                                v0 = t;
                                break block9;
                            }
                            v0 = null;
                        }
                        Intrinsics.checkNotNull(v0);
                        collection.add(TuplesKt.to((Object)var14_25, v0));
                    }
                    List tableToData = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = tableToData;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair $i$f$mapTo2 = (Pair)element$iv;
                        boolean bl = false;
                        table = (PyPackagingTreeGroup)$i$f$mapTo2.component1();
                        PyPackagesViewData data = (PyPackagesViewData)$i$f$mapTo2.component2();
                        table.updateHeaderText(data.getPackages().size() + data.getMoreItems());
                        table.expand();
                    }
                    this.synchronizeScrollPaneSize();
                    $this$mapTo$iv$iv = tableToData;
                    boolean $i$f$firstOrNull = false;
                    Iterator $i$f$mapTo2 = $this$firstOrNull$iv.iterator();
                    while ($i$f$mapTo2.hasNext()) {
                        Object element$iv = $i$f$mapTo2.next();
                        table = (Pair)element$iv;
                        boolean bl = false;
                        PyPackagesViewData data = (PyPackagesViewData)table.component2();
                        if (!(data.getExactMatch() != -1)) continue;
                        v1 = element$iv;
                        break block10;
                    }
                    v1 = null;
                }
                Pair pair = v1;
                if (pair != null && ($this$firstOrNull$iv = (PyPackagesViewData)pair.getSecond()) != null) {
                    PyPackagesViewData data = $this$firstOrNull$iv;
                    boolean bl = false;
                    DisplayablePackage displayablePackage = (DisplayablePackage)CollectionsKt.getOrNull(data.getPackages(), (int)data.getExactMatch());
                    string = displayablePackage != null ? displayablePackage.getName() : null;
                } else {
                    string = null;
                }
                String string2 = exactMatchPackageName = string;
                if (string2 == null) break block12;
                String packageName = string2;
                boolean bl = false;
                List<DisplayablePackage> $this$indexOfFirst$iv = this.installedPackages.getItems$intellij_python_community_impl();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<DisplayablePackage> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    DisplayablePackage item$iv;
                    DisplayablePackage it = item$iv = iterator.next();
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)packageName)) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = installedPackageIndex = -1;
            }
            if (installedPackageIndex != -1) {
                this.installedPackages.getTree().getTree().setSelectionInterval(installedPackageIndex, installedPackageIndex);
                this.installedPackages.getTree().getTable().setRowSelectionInterval(installedPackageIndex, installedPackageIndex);
            }
        }
    }

    public final void resetSearch(@NotNull List<InstalledPackage> installed, @NotNull List<? extends PyPackagesViewData> repoData, @Nullable Sdk currentSdk) {
        Intrinsics.checkNotNullParameter(installed, (String)"installed");
        Intrinsics.checkNotNullParameter(repoData, (String)"repoData");
        this.updatePackages(installed, repoData);
        this.installedPackages.expand();
        Sdk sdk2 = currentSdk;
        this.installedPackages.setSdkToHeader(sdk2 != null ? sdk2.getName() : null);
        Iterable $this$forEach$iv = this.repositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyPackagingTreeGroup it = (PyPackagingTreeGroup)element$iv;
            boolean bl = false;
            it.collapseAll();
            it.updateHeaderText(null);
        }
        this.container.scrollRectToVisible(new Rectangle(0, 0));
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePackages(List<? extends DisplayablePackage> installed, List<? extends PyPackagesViewData> repoData) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv = installed;
        boolean $i$f$sortedBy = false;
        List sortedInstalled = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DisplayablePackage it = (DisplayablePackage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (DisplayablePackage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        this.installedPackages.getTree().setItems(sortedInstalled);
        this.updateExistingRepository(this.installedPackages, sortedInstalled);
        Iterable $this$partition$iv = repoData;
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            PyPackagesViewData it = (PyPackagesViewData)element$iv;
            boolean bl = false;
            boolean bl2 = !(it instanceof PyInvalidRepositoryViewData) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List validRepoData = (List)pair.component1();
        List invalidData = (List)pair.component2();
        this.updateValidRepositories(validRepoData);
        first$iv = validRepoData;
        PyPackagingTreeView pyPackagingTreeView = this;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PyPackagesViewData pyPackagesViewData = (PyPackagesViewData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRepository().getName());
        }
        pyPackagingTreeView.cleanupRemovedRepositories((List)destination$iv$iv);
        Iterable $this$filterIsInstance$iv = invalidData;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PyInvalidRepositoryViewData)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List invalidRepoData = (List)destination$iv$iv2;
        this.refreshInvalidRepositories(invalidRepoData);
    }

    private final void synchronizeScrollPaneSize() {
        Iterable $this$forEach$iv = this.getRepos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyPackagingTreeGroup repo = (PyPackagingTreeGroup)element$iv;
            boolean bl = false;
            repo.updatePreferredSize();
        }
        this.container.revalidate();
        this.container.repaint();
    }

    private final void updateValidRepositories(List<? extends PyPackagesViewData> validRepoData) {
        for (PyPackagesViewData pyPackagesViewData : validRepoData) {
            List withExpander = pyPackagesViewData.getMoreItems() > 0 ? CollectionsKt.plus((Collection)pyPackagesViewData.getPackages(), (Iterable)CollectionsKt.listOf((Object)new ExpandResultNode(pyPackagesViewData.getMoreItems(), pyPackagesViewData.getRepository()))) : pyPackagesViewData.getPackages();
            PyPackagingTreeGroup existingRepo = this.findTableForRepo(pyPackagesViewData.getRepository());
            if (existingRepo != null) {
                this.updateExistingRepository(existingRepo, withExpander);
                continue;
            }
            this.createNewRepository(pyPackagesViewData.getRepository(), withExpander);
        }
    }

    private final void updateExistingRepository(PyPackagingTreeGroup repo, List<? extends DisplayablePackage> items) {
        Object v0;
        block2: {
            repo.removeFrom(this.container);
            Iterable $this$firstOrNull$iv = repo.getItems$intellij_python_community_impl();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DisplayablePackage it = (DisplayablePackage)element$iv;
                boolean bl = false;
                if (!repo.getTree().getItems().contains(it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        DisplayablePackage selectedPackage = v0;
        repo.setItems$intellij_python_community_impl(items);
        repo.addTo(this.container);
        if (selectedPackage != null) {
            repo.getTree().setItems(items);
        }
        this.synchronizeScrollPaneSize();
    }

    private final void createNewRepository(PyPackageRepository repository, List<? extends DisplayablePackage> items) {
        PyPackagesTreeTable newTable = new PyPackagesTreeTable(this.project, this.controller, null, 4, null);
        newTable.setItems(items);
        PyPackagingTreeGroup newTableGroup = new PyPackagingTreeGroup(repository, newTable, this.container);
        newTableGroup.setItems$intellij_python_community_impl(items);
        this.repositories.add(newTableGroup);
        newTableGroup.addTo(this.container);
        newTable.getTree().addTreeSelectionListener(arg_0 -> PyPackagingTreeView.createNewRepository$lambda$15(this, newTable, arg_0));
        this.synchronizeScrollPaneSize();
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupRemovedRepositories(List<String> existingRepositoryNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.repositories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PyPackagingTreeGroup it = (PyPackagingTreeGroup)element$iv$iv;
            boolean bl = false;
            if (!(!existingRepositoryNames.contains(it.getRepositoryName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedRepositories = (List)destination$iv$iv;
        Iterable $this$forEach$iv = removedRepositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyPackagingTreeGroup it = (PyPackagingTreeGroup)element$iv;
            boolean bl = false;
            it.removeFrom(this.container);
        }
        this.repositories.removeAll(removedRepositories);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshInvalidRepositories(List<PyInvalidRepositoryViewData> invalid) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = invalid;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PyInvalidRepositoryViewData pyInvalidRepositoryViewData = (PyInvalidRepositoryViewData)item$iv$iv;
            Collection collection2 = collection;
            boolean bl = false;
            collection2.add(it.getRepository().getName());
        }
        List invalidRepoNames = (List)collection;
        Object $this$forEach$iv = this.invalidRepositories;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = (Map.Entry)iterator.next();
            boolean bl = false;
            this.container.remove((Component)it.getValue());
        }
        this.invalidRepositories.keySet().removeIf(arg_0 -> PyPackagingTreeView.refreshInvalidRepositories$lambda$21(arg_0 -> PyPackagingTreeView.refreshInvalidRepositories$lambda$20(invalidRepoNames, arg_0), arg_0));
        $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)invalid), PyPackagingTreeView::refreshInvalidRepositories$lambda$22), arg_0 -> PyPackagingTreeView.refreshInvalidRepositories$lambda$23(this, arg_0)), PyPackagingTreeView::refreshInvalidRepositories$lambda$25);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Pair it = (Pair)e;
            boolean bl = false;
            this.invalidRepositories.put((String)it.getFirst(), (JPanel)it.getSecond());
        }
        $this$forEach$iv = this.invalidRepositories;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = iterator.next();
            boolean bl = false;
            this.container.add((Component)it.getValue());
        }
    }

    public final void selectPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        List<PyPackagingTreeGroup> repos = this.getRepos();
        for (PyPackagingTreeGroup repo : repos) {
            DisplayablePackage pkg;
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = repo.getItems$intellij_python_community_impl();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DisplayablePackage it = (DisplayablePackage)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)packageName)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((DisplayablePackage)v0 == null) continue;
            repo.getTree().selectPackage(pkg);
        }
    }

    private final PyPackagingTreeGroup findTableForRepo(PyPackageRepository repository) {
        Object v0;
        block1: {
            Iterable iterable = this.repositories;
            for (Object t : iterable) {
                PyPackagingTreeGroup it = (PyPackagingTreeGroup)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRepositoryName(), (Object)repository.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DisplayablePackage> getSelectedPackages() {
        void $this$flatMapTo$iv$iv;
        List<PyPackagingTreeGroup> repos = this.getRepos();
        Iterable $this$flatMap$iv = repos;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PyPackagingTreeGroup it = (PyPackagingTreeGroup)element$iv$iv;
            boolean bl = false;
            Sequence<DisplayablePackage> list$iv$iv = it.getTree().selectedItems();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void collapseAll() {
        Iterable $this$forEach$iv = this.getRepos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyPackagingTreeGroup it = (PyPackagingTreeGroup)element$iv;
            boolean bl = false;
            it.collapseAll();
        }
    }

    private final List<PyPackagingTreeGroup> getRepos() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.installedPackages), (Iterable)this.repositories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void syncTreeSelection$intellij_python_community_impl(@NotNull PyPackagesTreeTable selectedTree) {
        Intrinsics.checkNotNullParameter((Object)selectedTree, (String)"selectedTree");
        if (this.isSyncingTreeSelection) {
            return;
        }
        try {
            void $this$filterTo$iv$iv;
            PyPackagesTreeTable it;
            Iterable $this$mapTo$iv$iv;
            this.isSyncingTreeSelection = true;
            Iterable $this$map$iv = this.getRepos();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PyPackagingTreeGroup pyPackagingTreeGroup = (PyPackagingTreeGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((PyPackagingTreeGroup)((Object)it)).getTree());
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PyPackagesTreeTable)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)selectedTree))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyPackagesTreeTable it2 = (PyPackagesTreeTable)element$iv;
                boolean bl = false;
                it2.getTree().clearSelection();
                it2.getTable().clearSelection();
            }
        }
        finally {
            this.isSyncingTreeSelection = false;
        }
    }

    private static final void lambda$1$lambda$0(PyPackagingTreeView this$0, PyPackagingTreeGroup $tree, TreeSelectionEvent it) {
        this$0.syncTreeSelection$intellij_python_community_impl($tree.getTree());
    }

    private static final void createNewRepository$lambda$15(PyPackagingTreeView this$0, PyPackagesTreeTable $newTable, TreeSelectionEvent it) {
        this$0.syncTreeSelection$intellij_python_community_impl($newTable);
    }

    private static final boolean refreshInvalidRepositories$lambda$20(List $invalidRepoNames, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$invalidRepoNames.contains(it);
    }

    private static final boolean refreshInvalidRepositories$lambda$21(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String refreshInvalidRepositories$lambda$22(PyInvalidRepositoryViewData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRepository().getName();
    }

    private static final boolean refreshInvalidRepositories$lambda$23(PyPackagingTreeView this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.invalidRepositories.containsKey(it);
    }

    private static final Pair refreshInvalidRepositories$lambda$25(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = new Object[]{it};
        Object $this$refreshInvalidRepositories_u24lambda_u2425_u24lambda_u2424 = object = new JLabel(PyBundle.message("python.toolwindow.packages.custom.repo.invalid", (Object[])object));
        boolean bl = false;
        ((JComponent)$this$refreshInvalidRepositories_u24lambda_u2425_u24lambda_u2424).setForeground((Color)JBColor.RED);
        ((JLabel)$this$refreshInvalidRepositories_u24lambda_u2425_u24lambda_u2424).setIcon(AllIcons.General.Error);
        Object label = object;
        return TuplesKt.to((Object)it, (Object)PyPackagesUiComponents.INSTANCE.headerPanel((JLabel)label, null));
    }
}

